/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.briggy.api;

import ch.njol.skript.patterns.PatternCompiler;
import ch.njol.skript.patterns.SkriptPattern;
import ch.njol.skript.util.Timespan;
import ch.njol.util.StringUtils;
import com.shanebeestudios.briggy.api.CustomArg;
import com.shanebeestudios.briggy.api.commandapi.arguments.AngleArgument;
import com.shanebeestudios.briggy.api.commandapi.arguments.Argument;
import com.shanebeestudios.briggy.api.commandapi.arguments.BiomeArgument;
import com.shanebeestudios.briggy.api.commandapi.arguments.BlockStateArgument;
import com.shanebeestudios.briggy.api.commandapi.arguments.BooleanArgument;
import com.shanebeestudios.briggy.api.commandapi.arguments.CommandArgument;
import com.shanebeestudios.briggy.api.commandapi.arguments.DoubleArgument;
import com.shanebeestudios.briggy.api.commandapi.arguments.EnchantmentArgument;
import com.shanebeestudios.briggy.api.commandapi.arguments.EntitySelectorArgument;
import com.shanebeestudios.briggy.api.commandapi.arguments.EntityTypeArgument;
import com.shanebeestudios.briggy.api.commandapi.arguments.FloatArgument;
import com.shanebeestudios.briggy.api.commandapi.arguments.GreedyStringArgument;
import com.shanebeestudios.briggy.api.commandapi.arguments.IntegerArgument;
import com.shanebeestudios.briggy.api.commandapi.arguments.IntegerRangeArgument;
import com.shanebeestudios.briggy.api.commandapi.arguments.ItemStackArgument;
import com.shanebeestudios.briggy.api.commandapi.arguments.LocationArgument;
import com.shanebeestudios.briggy.api.commandapi.arguments.LongArgument;
import com.shanebeestudios.briggy.api.commandapi.arguments.LootTableArgument;
import com.shanebeestudios.briggy.api.commandapi.arguments.MultiLiteralArgument;
import com.shanebeestudios.briggy.api.commandapi.arguments.NamespacedKeyArgument;
import com.shanebeestudios.briggy.api.commandapi.arguments.ObjectiveArgument;
import com.shanebeestudios.briggy.api.commandapi.arguments.ParticleArgument;
import com.shanebeestudios.briggy.api.commandapi.arguments.PotionEffectArgument;
import com.shanebeestudios.briggy.api.commandapi.arguments.RecipeArgument;
import com.shanebeestudios.briggy.api.commandapi.arguments.SoundArgument;
import com.shanebeestudios.briggy.api.commandapi.arguments.StringArgument;
import com.shanebeestudios.briggy.api.commandapi.arguments.TeamArgument;
import com.shanebeestudios.briggy.api.commandapi.arguments.TextArgument;
import com.shanebeestudios.briggy.api.commandapi.arguments.TimeArgument;
import com.shanebeestudios.briggy.api.commandapi.arguments.WorldArgument;
import com.shanebeestudios.briggy.api.util.Utils;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;

public class BrigArgument {
    private static final Map<String, BrigArgument> MAP_BY_NAME = new HashMap<String, BrigArgument>();
    private static final Number[] INT_MIN_MAX = new Number[]{Integer.MIN_VALUE, Integer.MAX_VALUE};
    private static final Number[] LONG_MIN_MAX = new Number[]{Long.MIN_VALUE, Long.MAX_VALUE};
    private static final Number[] FLOAT_MIN_MAX = new Number[]{Float.valueOf(Float.MIN_VALUE), Float.valueOf(Float.MAX_VALUE)};
    private static final Number[] DOUBLE_MIN_MAX = new Number[]{Double.MIN_VALUE, Double.MAX_VALUE};
    private final String name;
    private final String pattern;
    private final SkriptPattern skriptPattern;
    private Class<? extends Argument<?>> argClass;
    private CustomArg customArg = null;

    private static void register(String name, String pattern, Class<? extends Argument<?>> argClass) {
        BrigArgument brigArgument = new BrigArgument(name, pattern, argClass);
        MAP_BY_NAME.put(name, brigArgument);
    }

    private static void register(String name, Class<? extends Argument<?>> argClass) {
        BrigArgument.register(name, name, argClass);
    }

    private static void register(String name, String pattern, CustomArg customArg) {
        BrigArgument brigArgument = new BrigArgument(name, pattern, customArg);
        MAP_BY_NAME.put(name, brigArgument);
    }

    private static void register(String name, CustomArg customArg) {
        BrigArgument.register(name, name, customArg);
    }

    public static String getPatterns() {
        ArrayList<String> patterns = new ArrayList<String>();
        for (BrigArgument value : MAP_BY_NAME.values()) {
            patterns.add(value.pattern);
        }
        Collections.sort(patterns);
        return StringUtils.join(patterns, (String)", ");
    }

    public static BrigArgument parse(String string) {
        for (BrigArgument brigArgument : MAP_BY_NAME.values()) {
            if (brigArgument.skriptPattern.match(string) == null) continue;
            return brigArgument;
        }
        return null;
    }

    public static Supplier<Iterator<BrigArgument>> getSupplier() {
        return () -> MAP_BY_NAME.values().stream().sorted(Comparator.comparing(BrigArgument::getName)).iterator();
    }

    BrigArgument(String name, String pattern, Class<? extends Argument<?>> argClass) {
        this.name = name;
        this.pattern = pattern;
        this.argClass = argClass;
        this.skriptPattern = PatternCompiler.compile((String)pattern);
    }

    BrigArgument(String name, String pattern, CustomArg customArg) {
        this.name = name;
        this.pattern = pattern;
        this.customArg = customArg;
        this.skriptPattern = PatternCompiler.compile((String)pattern);
    }

    public String toString() {
        return "BrigArg(name=" + this.name + ")";
    }

    public Number[] getMinMax() {
        if (this.argClass == IntegerArgument.class) {
            return INT_MIN_MAX;
        }
        if (this.argClass == LongArgument.class) {
            return LONG_MIN_MAX;
        }
        if (this.argClass == FloatArgument.class) {
            return FLOAT_MIN_MAX;
        }
        if (this.argClass == DoubleArgument.class) {
            return DOUBLE_MIN_MAX;
        }
        return null;
    }

    public Argument<?> getArgument(String name) {
        if (this.customArg != null) {
            return this.customArg.get(name);
        }
        if (this.argClass == MultiLiteralArgument.class) {
            return new MultiLiteralArgument(name, name);
        }
        try {
            return this.argClass.getDeclaredConstructor(String.class).newInstance(name);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public Argument<?> getIntArgument(String name, Number min, Number max) {
        if (this.customArg != null) {
            return this.customArg.get(name);
        }
        if (this.argClass == IntegerArgument.class) {
            return new IntegerArgument(name, min.intValue(), max.intValue());
        }
        if (this.argClass == LongArgument.class) {
            return new LongArgument(name, min.longValue(), max.longValue());
        }
        if (this.argClass == FloatArgument.class) {
            return new FloatArgument(name, min.floatValue(), max.floatValue());
        }
        if (this.argClass == DoubleArgument.class) {
            return new DoubleArgument(name, min.doubleValue(), max.doubleValue());
        }
        return this.getArgument(name);
    }

    public Argument<?> getMultiLit(String name, List<String> literals) {
        if (this.argClass != MultiLiteralArgument.class) {
            return null;
        }
        return new MultiLiteralArgument(name, literals.toArray(new String[0]));
    }

    public Class<? extends Argument<?>> getArgClass() {
        return this.argClass;
    }

    public String getName() {
        return this.name;
    }

    static {
        BrigArgument.register("double", DoubleArgument.class);
        BrigArgument.register("float", FloatArgument.class);
        BrigArgument.register("integer", "int[eger]", IntegerArgument.class);
        BrigArgument.register("integer range", "int[eger][ ]range", IntegerRangeArgument.class);
        BrigArgument.register("long", LongArgument.class);
        BrigArgument.register("angle", AngleArgument.class);
        BrigArgument.register("biome", BiomeArgument.class);
        BrigArgument.register("biomekey", "biome[ ]key", BiomeArgument.NamespacedKey.class);
        BrigArgument.register("block state", "block[[ ](state|data)]", BlockStateArgument.class);
        BrigArgument.register("blockpredicate", "block[ ]predicate", CustomArg.BLOCK_PREDICATE);
        BrigArgument.register("blockpos", "block[ ]pos", CustomArg.BLOCK_POS);
        BrigArgument.register("command", CommandArgument.class);
        BrigArgument.register("component", CustomArg.COMPONENT);
        BrigArgument.register("dimension", WorldArgument.class);
        BrigArgument.register("enchantment", "enchant[ment]", EnchantmentArgument.class);
        BrigArgument.register("entitytype", "entity[ ]type", EntityTypeArgument.class);
        BrigArgument.register("itemstack", "item[[ ]stack]", ItemStackArgument.class);
        BrigArgument.register("itempredicate", "item[[ ]stack][ ]predicate", CustomArg.ITEM_STACK_PREDICATE);
        BrigArgument.register("loottable", "loot[ ]table", LootTableArgument.class);
        BrigArgument.register("message", CustomArg.MESSAGE);
        BrigArgument.register("nbt", CustomArg.NBT);
        BrigArgument.register("objective", ObjectiveArgument.class);
        BrigArgument.register("particle", ParticleArgument.class);
        BrigArgument.register("potioneffect", "potion[ ]effect[[ ]type]", PotionEffectArgument.class);
        BrigArgument.register("recipe", RecipeArgument.class);
        BrigArgument.register("rotation", CustomArg.ROTATION);
        BrigArgument.register("sound", SoundArgument.class);
        BrigArgument.register("team", TeamArgument.class);
        BrigArgument.register("time", TimeArgument.class);
        BrigArgument.register("world", CustomArg.WORLD);
        BrigArgument.register("entity", EntitySelectorArgument.OneEntity.class);
        BrigArgument.register("entities", EntitySelectorArgument.ManyEntities.class);
        BrigArgument.register("player", EntitySelectorArgument.OnePlayer.class);
        BrigArgument.register("players", EntitySelectorArgument.ManyPlayers.class);
        BrigArgument.register("offlineplayer", "offline[ ]player", CustomArg.OFFLINE_PLAYER);
        BrigArgument.register("location", "loc[ation]", LocationArgument.class);
        BrigArgument.register("location 2d", "loc[ation][ ]2d", CustomArg.LOCATION2D);
        BrigArgument.register("namespaced key", "(namespaced[ ]key|mc[ ]key)", NamespacedKeyArgument.class);
        BrigArgument.register("entitydata", "entity[ ]data", CustomArg.ENTITY_DATA);
        BrigArgument.register("itemtype", "item[ ]type", CustomArg.ITEM_TYPE);
        BrigArgument.register("skriptcolor", "skript[ ]color", CustomArg.SKRIPT_COLOR);
        BrigArgument.register("timespan", "time[ ]span", CustomArg.TIME_SPAN);
        if (Utils.classInfoExistsFor(Timespan.TimePeriod.class)) {
            BrigArgument.register("timespanperiod", "time[ ]span[ ]period", CustomArg.TIME_PERIOD);
        }
        BrigArgument.register("boolean", BooleanArgument.class);
        BrigArgument.register("greedystring", "greedy[ ]string", GreedyStringArgument.class);
        BrigArgument.register("literal", "lit[eral]", MultiLiteralArgument.class);
        BrigArgument.register("text", TextArgument.class);
        BrigArgument.register("string", StringArgument.class);
    }
}

