/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.briggy.api.commandapi;

import com.shanebeestudios.briggy.api.commandapi.CommandAPIBukkitConfig;
import com.shanebeestudios.briggy.api.commandapi.InternalConfig;
import java.util.List;
import java.util.function.Function;

public abstract class InternalBukkitConfig
extends InternalConfig {
    private final String pluginName;
    private final boolean fallbackToLatestNMS;
    private final boolean skipReloadDatapacks;
    private final List<String> skipSenderProxy;
    private Class<?> nbtContainerClass;
    private Function<Object, ?> nbtContainerConstructor;

    public InternalBukkitConfig(CommandAPIBukkitConfig<? extends CommandAPIBukkitConfig<?>> config) {
        super(config);
        this.pluginName = config.pluginName;
        this.fallbackToLatestNMS = config.fallbackToLatestNMS;
        this.skipReloadDatapacks = config.skipReloadDatapacks;
        this.skipSenderProxy = config.skipSenderProxy;
        this.nbtContainerClass = config.nbtContainerClass;
        this.nbtContainerConstructor = config.nbtContainerConstructor;
    }

    public String getPluginName() {
        return this.pluginName;
    }

    public boolean fallbackToLatestNMS() {
        return this.fallbackToLatestNMS;
    }

    public boolean skipReloadDatapacks() {
        return this.skipReloadDatapacks;
    }

    public boolean shouldSkipSenderProxy(String commandName) {
        return this.skipSenderProxy.contains(commandName);
    }

    public Class<?> getNBTContainerClass() {
        return this.nbtContainerClass;
    }

    public Function<Object, ?> getNBTContainerConstructor() {
        return this.nbtContainerConstructor;
    }

    public void lateInitializeNBT(Class<?> nbtContainerClass, Function<Object, ?> nbtContainerConstructor) {
        this.nbtContainerClass = nbtContainerClass;
        this.nbtContainerConstructor = nbtContainerConstructor;
    }
}

