/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.briggy.api.commandapi.nms;

import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.tree.CommandNode;
import com.shanebeestudios.briggy.api.commandapi.CommandAPIBukkit;
import com.shanebeestudios.briggy.api.commandapi.CommandAPIHandler;
import com.shanebeestudios.briggy.api.commandapi.arguments.ArgumentSubType;
import com.shanebeestudios.briggy.api.commandapi.commandsenders.BukkitCommandSender;
import com.shanebeestudios.briggy.api.commandapi.nms.NMS;
import com.shanebeestudios.briggy.api.commandapi.wrappers.Location2D;
import com.shanebeestudios.briggy.api.commandapi.wrappers.MathOperation;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.EnumSet;
import java.util.Locale;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.arguments.AngleArgument;
import net.minecraft.commands.arguments.ColorArgument;
import net.minecraft.commands.arguments.CompoundTagArgument;
import net.minecraft.commands.arguments.DimensionArgument;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.GameProfileArgument;
import net.minecraft.commands.arguments.MessageArgument;
import net.minecraft.commands.arguments.ObjectiveArgument;
import net.minecraft.commands.arguments.ObjectiveCriteriaArgument;
import net.minecraft.commands.arguments.OperationArgument;
import net.minecraft.commands.arguments.ParticleArgument;
import net.minecraft.commands.arguments.RangeArgument;
import net.minecraft.commands.arguments.ResourceArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.commands.arguments.ScoreHolderArgument;
import net.minecraft.commands.arguments.ScoreboardSlotArgument;
import net.minecraft.commands.arguments.TeamArgument;
import net.minecraft.commands.arguments.TimeArgument;
import net.minecraft.commands.arguments.UuidArgument;
import net.minecraft.commands.arguments.blocks.BlockPredicateArgument;
import net.minecraft.commands.arguments.blocks.BlockStateArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.commands.arguments.coordinates.ColumnPosArgument;
import net.minecraft.commands.arguments.coordinates.RotationArgument;
import net.minecraft.commands.arguments.coordinates.SwizzleArgument;
import net.minecraft.commands.arguments.coordinates.Vec2Argument;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.commands.arguments.item.FunctionArgument;
import net.minecraft.commands.arguments.item.ItemArgument;
import net.minecraft.commands.arguments.item.ItemPredicateArgument;
import net.minecraft.commands.synchronization.ArgumentUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ColumnPos;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.phys.Vec3;
import org.bukkit.Axis;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.EntityType;
import org.bukkit.potion.PotionEffectType;

public abstract class NMS_Common
implements NMS<CommandSourceStack> {
    public NamespacedKey fromResourceLocation(ResourceLocation key) {
        return NamespacedKey.fromString((String)(key.getNamespace() + ":" + key.getPath()));
    }

    protected abstract CommandBuildContext getCommandBuildContext();

    @Override
    public final ArgumentType<?> _ArgumentAngle() {
        return AngleArgument.angle();
    }

    @Override
    public final ArgumentType<?> _ArgumentAxis() {
        return SwizzleArgument.swizzle();
    }

    @Override
    public final ArgumentType<?> _ArgumentBlockPredicate() {
        return BlockPredicateArgument.blockPredicate((CommandBuildContext)this.getCommandBuildContext());
    }

    @Override
    public final ArgumentType<?> _ArgumentBlockState() {
        return BlockStateArgument.block((CommandBuildContext)this.getCommandBuildContext());
    }

    @Override
    public final ArgumentType<?> _ArgumentChat() {
        return MessageArgument.message();
    }

    @Override
    public final ArgumentType<?> _ArgumentChatFormat() {
        return ColorArgument.color();
    }

    @Override
    public final ArgumentType<?> _ArgumentDimension() {
        return DimensionArgument.dimension();
    }

    @Override
    public final ArgumentType<?> _ArgumentEntity(ArgumentSubType subType) {
        return switch (subType) {
            case ArgumentSubType.ENTITYSELECTOR_MANY_ENTITIES -> EntityArgument.entities();
            case ArgumentSubType.ENTITYSELECTOR_MANY_PLAYERS -> EntityArgument.players();
            case ArgumentSubType.ENTITYSELECTOR_ONE_ENTITY -> EntityArgument.entity();
            case ArgumentSubType.ENTITYSELECTOR_ONE_PLAYER -> EntityArgument.player();
            default -> throw new IllegalArgumentException("Unexpected value: " + String.valueOf((Object)subType));
        };
    }

    @Override
    public final ArgumentType<?> _ArgumentFloatRange() {
        return RangeArgument.floatRange();
    }

    @Override
    public final ArgumentType<?> _ArgumentIntRange() {
        return RangeArgument.intRange();
    }

    @Override
    public final ArgumentType<?> _ArgumentItemPredicate() {
        return ItemPredicateArgument.itemPredicate((CommandBuildContext)this.getCommandBuildContext());
    }

    @Override
    public final ArgumentType<?> _ArgumentItemStack() {
        return ItemArgument.item((CommandBuildContext)this.getCommandBuildContext());
    }

    @Override
    public final ArgumentType<?> _ArgumentMathOperation() {
        return OperationArgument.operation();
    }

    @Override
    public final ArgumentType<?> _ArgumentMinecraftKeyRegistered() {
        return ResourceLocationArgument.id();
    }

    @Override
    public final ArgumentType<?> _ArgumentNBTCompound() {
        return CompoundTagArgument.compoundTag();
    }

    @Override
    public final ArgumentType<?> _ArgumentParticle() {
        return ParticleArgument.particle((CommandBuildContext)this.getCommandBuildContext());
    }

    @Override
    public final ArgumentType<?> _ArgumentPosition() {
        return BlockPosArgument.blockPos();
    }

    @Override
    public final ArgumentType<?> _ArgumentPosition2D() {
        return ColumnPosArgument.columnPos();
    }

    @Override
    public final ArgumentType<?> _ArgumentProfile() {
        return GameProfileArgument.gameProfile();
    }

    @Override
    public final ArgumentType<?> _ArgumentRotation() {
        return RotationArgument.rotation();
    }

    @Override
    public final ArgumentType<?> _ArgumentScoreboardCriteria() {
        return ObjectiveCriteriaArgument.criteria();
    }

    @Override
    public final ArgumentType<?> _ArgumentScoreboardObjective() {
        return ObjectiveArgument.objective();
    }

    @Override
    public final ArgumentType<?> _ArgumentScoreboardSlot() {
        return ScoreboardSlotArgument.displaySlot();
    }

    @Override
    public final ArgumentType<?> _ArgumentScoreboardTeam() {
        return TeamArgument.team();
    }

    @Override
    public final ArgumentType<?> _ArgumentScoreholder(ArgumentSubType subType) {
        return switch (subType) {
            case ArgumentSubType.SCOREHOLDER_SINGLE -> ScoreHolderArgument.scoreHolder();
            case ArgumentSubType.SCOREHOLDER_MULTIPLE -> ScoreHolderArgument.scoreHolders();
            default -> throw new IllegalArgumentException("Unexpected value: " + String.valueOf((Object)subType));
        };
    }

    @Override
    public final ArgumentType<?> _ArgumentTag() {
        return FunctionArgument.functions();
    }

    @Override
    public final ArgumentType<?> _ArgumentTime() {
        return TimeArgument.time();
    }

    @Override
    public final ArgumentType<?> _ArgumentUUID() {
        return UuidArgument.uuid();
    }

    @Override
    public final ArgumentType<?> _ArgumentVec2(boolean centerPosition) {
        return Vec2Argument.vec2((boolean)centerPosition);
    }

    @Override
    public final ArgumentType<?> _ArgumentVec3(boolean centerPosition) {
        return Vec3Argument.vec3((boolean)centerPosition);
    }

    @Override
    public final String convert(PotionEffectType potion) {
        return potion.getName().toLowerCase(Locale.ENGLISH);
    }

    @Override
    public final String convert(Sound sound) {
        return sound.getKey().toString();
    }

    @Override
    public final void createDispatcherFile(File file, CommandDispatcher<CommandSourceStack> dispatcher) throws IOException {
        Files.asCharSink((File)file, (Charset)StandardCharsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]).write((CharSequence)new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)ArgumentUtils.serializeNodeToJson(dispatcher, (CommandNode)dispatcher.getRoot())));
    }

    @Override
    public final float getAngle(CommandContext<CommandSourceStack> cmdCtx, String key) throws CommandSyntaxException {
        return AngleArgument.getAngle(cmdCtx, (String)key);
    }

    @Override
    public final EnumSet<Axis> getAxis(CommandContext<CommandSourceStack> cmdCtx, String key) {
        EnumSet<Axis> set = EnumSet.noneOf(Axis.class);
        EnumSet parsedEnumSet = SwizzleArgument.getSwizzle(cmdCtx, (String)key);
        for (Direction.Axis element : parsedEnumSet) {
            set.add(switch (element) {
                default -> throw new IncompatibleClassChangeError();
                case Direction.Axis.X -> Axis.X;
                case Direction.Axis.Y -> Axis.Y;
                case Direction.Axis.Z -> Axis.Z;
            });
        }
        return set;
    }

    @Override
    public final Predicate<Block> getBlockPredicate(CommandContext<CommandSourceStack> cmdCtx, String key) throws CommandSyntaxException {
        Predicate predicate = BlockPredicateArgument.getBlockPredicate(cmdCtx, (String)key);
        return block -> predicate.test(new BlockInWorld((LevelReader)((CommandSourceStack)cmdCtx.getSource()).getLevel(), new BlockPos(block.getX(), block.getY(), block.getZ()), true));
    }

    @Override
    public final BukkitCommandSender<? extends CommandSender> getCommandSenderFromCommandSource(CommandSourceStack css) {
        try {
            return CommandAPIBukkit.get().wrapCommandSender(css.getBukkitSender());
        }
        catch (UnsupportedOperationException e) {
            return null;
        }
    }

    @Override
    public final EntityType getEntityType(CommandContext<CommandSourceStack> cmdCtx, String key) throws CommandSyntaxException {
        return EntityType.fromName((String)net.minecraft.world.entity.EntityType.getKey((net.minecraft.world.entity.EntityType)((net.minecraft.world.entity.EntityType)ResourceArgument.getSummonableEntityType(cmdCtx, (String)key).value())).getPath());
    }

    @Override
    public final Location2D getLocation2DBlock(CommandContext<CommandSourceStack> cmdCtx, String key) throws CommandSyntaxException {
        ColumnPos blockPos = ColumnPosArgument.getColumnPos(cmdCtx, (String)key);
        return new Location2D(this.getWorldForCSS((CommandSourceStack)cmdCtx.getSource()), blockPos.x(), blockPos.z());
    }

    @Override
    public final Location getLocationBlock(CommandContext<CommandSourceStack> cmdCtx, String key) throws CommandSyntaxException {
        BlockPos blockPos = BlockPosArgument.getSpawnablePos(cmdCtx, (String)key);
        return new Location(this.getWorldForCSS((CommandSourceStack)cmdCtx.getSource()), (double)blockPos.getX(), (double)blockPos.getY(), (double)blockPos.getZ());
    }

    @Override
    public final Location getLocationPrecise(CommandContext<CommandSourceStack> cmdCtx, String key) throws CommandSyntaxException {
        Vec3 vecPos = Vec3Argument.getCoordinates(cmdCtx, (String)key).getPosition((CommandSourceStack)cmdCtx.getSource());
        return new Location(this.getWorldForCSS((CommandSourceStack)cmdCtx.getSource()), vecPos.x(), vecPos.y(), vecPos.z());
    }

    @Override
    public final MathOperation getMathOperation(CommandContext<CommandSourceStack> cmdCtx, String key) throws CommandSyntaxException {
        OperationArgument.getOperation(cmdCtx, (String)key);
        return MathOperation.fromString(CommandAPIHandler.getRawArgumentInput(cmdCtx, key));
    }

    @Override
    public final <NBTContainer> Object getNBTCompound(CommandContext<CommandSourceStack> cmdCtx, String key, Function<Object, NBTContainer> nbtContainerConstructor) {
        return nbtContainerConstructor.apply(CompoundTagArgument.getCompoundTag(cmdCtx, (String)key));
    }

    @Override
    public final String getObjectiveCriteria(CommandContext<CommandSourceStack> cmdCtx, String key) {
        return ObjectiveCriteriaArgument.getCriteria(cmdCtx, (String)key).getName();
    }

    @Override
    public final int getTime(CommandContext<CommandSourceStack> cmdCtx, String key) {
        return (Integer)cmdCtx.getArgument(key, Integer.class);
    }

    @Override
    public final UUID getUUID(CommandContext<CommandSourceStack> cmdCtx, String key) {
        return UuidArgument.getUuid(cmdCtx, (String)key);
    }
}

