/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.briggy.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.log.ErrorQuality;
import ch.njol.skript.registrations.Classes;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import com.shanebeestudios.briggy.api.commandapi.arguments.Argument;
import com.shanebeestudios.briggy.api.commandapi.arguments.ArgumentSuggestions;
import com.shanebeestudios.briggy.api.event.BrigCommandArgumentsEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Argument Suggestions")
@Description(value={"Set the suggestions for an argument.", "Will accept any object, but strings are the best way to go.", "For args you can use a number (the position of the argument) or a string (name of the argument), see examples.", "NOTE: This expression is not dynamic, meaning if variables/expressions are used, they wont update."})
@Examples(value={"brig command /spawn <string>:", "\targuments:", "\t\tset suggestions of arg 1 to all worlds", "\ttrigger:", "\t\tteleport player to spawn of world({_string})", "", "brig command /setnick <name:string>:", "\targuments:", "\t\tset suggestions of \"name\" argument to \"<put your nick here>\"", "\ttrigger:", "\t\tset display name of player to {_name}"})
@Since(value={"1.0.0"})
public class ExprArgSuggestions
extends SimpleExpression<Object> {
    private Expression<?> arg;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        if (!this.getParser().isCurrentEvent(BrigCommandArgumentsEvent.class)) {
            Skript.error((String)"Brig arg suggestions can only be set in a brig command 'arguments' section.", (ErrorQuality)ErrorQuality.SEMANTIC_ERROR);
            return false;
        }
        this.arg = exprs[0];
        return true;
    }

    @Nullable
    protected Object[] get(Event event) {
        return null;
    }

    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{Object[].class});
        }
        return null;
    }

    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        if (!(event instanceof BrigCommandArgumentsEvent)) {
            return;
        }
        BrigCommandArgumentsEvent brigEvent = (BrigCommandArgumentsEvent)event;
        Map<String, Argument<?>> arguments = brigEvent.getBrigCommand().getArgumentMap();
        List<Argument<?>> argumentList = brigEvent.getBrigCommand().getArguments();
        for (Object object : this.arg.getArray(event)) {
            Number numberArg;
            int i;
            Argument<?> argument = null;
            if (object instanceof String) {
                String stringArg = (String)object;
                argument = arguments.get(stringArg);
            } else if (object instanceof Number && (i = (numberArg = (Number)object).intValue()) <= argumentList.size()) {
                argument = argumentList.get(i - 1);
            }
            if (argument == null) continue;
            ArrayList<String> stringSuggestions = new ArrayList<String>();
            for (Object value : delta) {
                if (value instanceof String) {
                    String string = (String)value;
                    stringSuggestions.add(string);
                    continue;
                }
                stringSuggestions.add(Classes.toString((Object)value));
            }
            if (stringSuggestions.size() <= 0) continue;
            argument.includeSuggestions(ArgumentSuggestions.strings(stringSuggestions));
        }
    }

    public boolean isSingle() {
        return false;
    }

    @NotNull
    public Class<?> getReturnType() {
        return Object.class;
    }

    @NotNull
    public String toString(@Nullable Event e, boolean d) {
        return "suggestions of argument " + this.arg.toString(e, d);
    }

    static {
        Skript.registerExpression(ExprArgSuggestions.class, Object.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"suggestions of arg[ument][s] %strings/numbers%", "suggestions of %strings/numbers% arg[ument][s]"});
    }
}

