/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.briggy.skript.expressions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.shanebeestudios.briggy.api.commandapi.wrappers.IntegerRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="IntegerRange - Low/High")
@Description(value={"Get the low/high point of an integer range."})
@Examples(value={"set {_low} to low range of {_intrange}", "set {_high} to high range of {_intrange}", "set {_ints::} to integers between {_low} and {_high}"})
@Since(value={"1.0.0"})
public class ExprIntegerRange
extends SimplePropertyExpression<IntegerRange, Number> {
    private boolean high;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.high = parseResult.hasTag("high");
        return super.init(exprs, matchedPattern, isDelayed, parseResult);
    }

    @Nullable
    public Number convert(IntegerRange integerRange) {
        return this.high ? integerRange.getUpperBound() : integerRange.getLowerBound();
    }

    @NotNull
    public Class<? extends Number> getReturnType() {
        return Number.class;
    }

    @NotNull
    protected String getPropertyName() {
        return (this.high ? "high" : "low") + " range";
    }

    static {
        ExprIntegerRange.register(ExprIntegerRange.class, Number.class, (String)"(low|:high) range", (String)"intrange");
    }
}

