/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.briggy;

import ch.njol.skript.Skript;
import ch.njol.skript.SkriptAddon;
import ch.njol.skript.util.Version;
import com.shanebeestudios.briggy.api.commandapi.CommandAPI;
import com.shanebeestudios.briggy.api.commandapi.CommandAPIPaperConfig;
import com.shanebeestudios.briggy.api.commandapi.exceptions.UnsupportedVersionException;
import com.shanebeestudios.briggy.api.util.Utils;
import com.shanebeestudios.briggy.metrics.bukkit.Metrics;
import com.shanebeestudios.briggy.metrics.charts.SimplePie;
import com.shanebeestudios.skbee.SkBee;
import com.shanebeestudios.skbee.api.nbt.NBTApi;
import com.shanebeestudios.skbee.api.nbt.NBTContainer;
import com.shanebeestudios.skbee.api.nbt.utils.MinecraftVersion;
import com.shanebeestudios.skbee.config.Config;
import io.papermc.paper.plugin.lifecycle.event.LifecycleEventOwner;
import java.io.IOException;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public class SkBriggy
extends JavaPlugin {
    private static SkBriggy INSTANCE;
    private static boolean commandApiCanLoad;
    public static boolean HAS_SKBEE_COMPONENT;
    public static boolean HAS_SKBEE_NBT;

    public void onLoad() {
        try {
            CommandAPIPaperConfig config = (CommandAPIPaperConfig)new CommandAPIPaperConfig((LifecycleEventOwner)this).silentLogs(true);
            if (Bukkit.getPluginManager().getPlugin("SkBee") != null && MinecraftVersion.getVersion() != MinecraftVersion.UNKNOWN) {
                config.initializeNBTAPI(NBTContainer.class, NBTContainer::new);
            }
            CommandAPI.onLoad(config.verboseOutput(false));
            commandApiCanLoad = true;
        }
        catch (UnsupportedVersionException ignore) {
            commandApiCanLoad = false;
        }
    }

    public void onEnable() {
        INSTANCE = this;
        PluginManager pluginManager = Bukkit.getPluginManager();
        if (!commandApiCanLoad) {
            Utils.log("&eIt appears the CommandAPI is not available on your server version.");
            Utils.log("&eThis is not a bug.");
            Utils.log("&eThis addon will be updated when CommandAPI supports your server version.");
            Utils.log("&ePlugin will disable!");
            pluginManager.disablePlugin((Plugin)this);
            return;
        }
        long start = System.currentTimeMillis();
        Utils.log("Starting up SkBriggy!!!");
        if (Skript.getVersion().isSmallerThan(new Version(new int[]{2, 7}))) {
            Utils.log("&cOutdated Skript Version: &e" + String.valueOf(Skript.getVersion()) + " &cplugin will disable.");
            Utils.log("&eSkript 2.7+ is required for SkBriggy to run.");
            pluginManager.disablePlugin((Plugin)this);
            return;
        }
        Plugin skBeePlugin = pluginManager.getPlugin("SkBee");
        if (skBeePlugin != null && skBeePlugin.isEnabled() && skBeePlugin instanceof SkBee) {
            SkBee skBee = (SkBee)skBeePlugin;
            Config skBeeConfig = skBee.getPluginConfig();
            if (skBeeConfig.ELEMENTS_TEXT_COMPONENT) {
                HAS_SKBEE_COMPONENT = true;
                Utils.log("&5SkBee Text Components &asuccessfully hooked");
            }
            if (skBeeConfig.ELEMENTS_NBT && NBTApi.isEnabled()) {
                HAS_SKBEE_NBT = true;
                Utils.log("&5SkBee NBT Compounds &asuccessfully hooked");
            }
        }
        if (Skript.isAcceptRegistrations()) {
            SkriptAddon skriptAddon = Skript.registerAddon((JavaPlugin)this);
            try {
                skriptAddon.loadClasses("com.shanebeestudios.briggy.skript", new String[0]);
                skriptAddon.setLanguageFileDirectory("lang");
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        } else {
            Utils.log("&cSkript isn't accepting registrations?!?!?");
        }
        String version = this.getDescription().getVersion();
        if (version.contains("-")) {
            Utils.log("&eThis is a BETA build, things may not work as expected, please report any bugs on GitHub");
            Utils.log("&ehttps://github.com/ShaneBeee/SkBriggy/issues");
        }
        this.registerMetrics();
        CommandAPI.onEnable();
        long finish = System.currentTimeMillis() - start;
        Utils.log("Finished loading in &b" + finish + "ms");
    }

    private void registerMetrics() {
        Metrics metrics = new Metrics((Plugin)this, 24320);
        metrics.addCustomChart(new SimplePie("skript_version", () -> Skript.getVersion().toString()));
    }

    public void onDisable() {
        CommandAPI.onDisable();
        INSTANCE = null;
    }

    public static SkBriggy getInstance() {
        return INSTANCE;
    }
}

