/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.briggy.api;

import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.bukkitutil.EntityUtils;
import ch.njol.skript.entity.EntityData;
import ch.njol.skript.lang.ParseContext;
import ch.njol.skript.util.SkriptColor;
import ch.njol.skript.util.Timespan;
import com.destroystokyo.paper.profile.PlayerProfile;
import com.shanebeestudios.briggy.SkBriggy;
import com.shanebeestudios.briggy.api.commandapi.arguments.Argument;
import com.shanebeestudios.briggy.api.commandapi.arguments.ArgumentSuggestions;
import com.shanebeestudios.briggy.api.commandapi.arguments.BlockPredicateArgument;
import com.shanebeestudios.briggy.api.commandapi.arguments.ChatArgument;
import com.shanebeestudios.briggy.api.commandapi.arguments.ChatComponentArgument;
import com.shanebeestudios.briggy.api.commandapi.arguments.CustomArgument;
import com.shanebeestudios.briggy.api.commandapi.arguments.EntityTypeArgument;
import com.shanebeestudios.briggy.api.commandapi.arguments.ItemStackPredicateArgument;
import com.shanebeestudios.briggy.api.commandapi.arguments.Location2DArgument;
import com.shanebeestudios.briggy.api.commandapi.arguments.LocationArgument;
import com.shanebeestudios.briggy.api.commandapi.arguments.LocationType;
import com.shanebeestudios.briggy.api.commandapi.arguments.NBTCompoundArgument;
import com.shanebeestudios.briggy.api.commandapi.arguments.PlayerProfileArgument;
import com.shanebeestudios.briggy.api.commandapi.arguments.RotationArgument;
import com.shanebeestudios.briggy.api.commandapi.arguments.StringArgument;
import com.shanebeestudios.briggy.api.commandapi.wrappers.Location2D;
import com.shanebeestudios.briggy.api.commandapi.wrappers.Rotation;
import com.shanebeestudios.briggy.api.wrapper.BlockPredicate;
import com.shanebeestudios.briggy.api.wrapper.ItemStackPredicate;
import com.shanebeestudios.skbee.api.nbt.NBTApi;
import com.shanebeestudios.skbee.api.wrapper.ComponentWrapper;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import net.kyori.adventure.chat.SignedMessage;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.entity.EntityType;
import org.bukkit.generator.WorldInfo;

public abstract class CustomArg {
    private static final List<String> MATERIAL_NAMES = Arrays.stream(Material.values()).filter(material -> !material.isLegacy()).map(mat -> mat.getKey().getKey()).toList();
    private static final World MAIN_WORLD = (World)Bukkit.getWorlds().getFirst();
    private static final List<String> DEFAULT_TIMESPANS = List.of("10s", "5m", "1h", "3d");
    static final CustomArg MESSAGE = new CustomArg(){

        @Override
        Argument<?> get(String name) {
            return new CustomArgument<Object, SignedMessage>(new ChatArgument(name), info -> {
                Component component = ((SignedMessage)info.currentInput()).unsignedContent();
                if (component == null) {
                    return null;
                }
                if (SkBriggy.HAS_SKBEE_COMPONENT) {
                    return ComponentWrapper.fromComponent((Component)component);
                }
                return LegacyComponentSerializer.legacySection().serialize(component);
            });
        }
    };
    static final CustomArg BLOCK_POS = new CustomArg(){

        @Override
        Argument<?> get(String name) {
            return new LocationArgument(name, LocationType.BLOCK_POSITION);
        }
    };
    static final CustomArg BLOCK_PREDICATE = new CustomArg(){

        @Override
        Argument<?> get(String name) {
            return new CustomArgument<BlockPredicate, Predicate>(new BlockPredicateArgument(name), info -> new BlockPredicate((Predicate)info.currentInput()));
        }
    };
    static final CustomArg COMPONENT = new CustomArg(){

        @Override
        Argument<?> get(String name) {
            return new CustomArgument<Object, Component>(new ChatComponentArgument(name), info -> {
                Component component = (Component)info.currentInput();
                if (SkBriggy.HAS_SKBEE_COMPONENT) {
                    return ComponentWrapper.fromComponent((Component)component);
                }
                return LegacyComponentSerializer.legacySection().serialize(component);
            });
        }
    };
    static final CustomArg ENTITY_DATA = new CustomArg(){

        @Override
        Argument<?> get(String name) {
            return new CustomArgument<EntityData, EntityType>(new EntityTypeArgument(name), info -> EntityUtils.toSkriptEntityData((EntityType)((EntityType)info.currentInput())));
        }
    };
    static final CustomArg ITEM_STACK_PREDICATE = new CustomArg(){

        @Override
        Argument<?> get(String name) {
            return new CustomArgument<ItemStackPredicate, Predicate>(new ItemStackPredicateArgument(name), info -> new ItemStackPredicate((Predicate)info.currentInput()));
        }
    };
    static final CustomArg ITEM_TYPE = new CustomArg(){

        @Override
        Argument<?> get(String name) {
            return (Argument)new CustomArgument<ItemType, String>(new StringArgument(name), info -> {
                Material material = Material.getMaterial((String)info.input().toUpperCase(Locale.ROOT));
                if (material == null) {
                    throw CustomArgument.CustomArgumentException.fromString("Unknown item type '" + info.input() + "'");
                }
                return new ItemType(material);
            }).includeSuggestions(ArgumentSuggestions.strings((String[])MATERIAL_NAMES.toArray(String[]::new)));
        }
    };
    static final CustomArg LOCATION2D = new CustomArg(){

        @Override
        Argument<?> get(String name) {
            return new CustomArgument<Location, Location2D>(new Location2DArgument(name), info -> {
                Location2D loc2d = (Location2D)((Object)((Object)info.currentInput()));
                return new Location(loc2d.getWorld(), loc2d.getX(), 0.0, loc2d.getZ());
            });
        }
    };
    static final CustomArg NBT = new CustomArg(){

        @Override
        Argument<?> get(String name) {
            return new CustomArgument(new NBTCompoundArgument(name), info -> {
                String nbtString = info.input();
                if (SkBriggy.HAS_SKBEE_NBT) {
                    return NBTApi.validateNBT((String)nbtString);
                }
                return nbtString;
            });
        }
    };
    static final CustomArg OFFLINE_PLAYER = new CustomArg(){

        @Override
        Argument<?> get(String name) {
            return new CustomArgument<OfflinePlayer, List>(new PlayerProfileArgument(name), info -> {
                PlayerProfile playerProfile = (PlayerProfile)((List)info.currentInput()).getFirst();
                if (playerProfile == null || playerProfile.getName() == null) {
                    return null;
                }
                return Bukkit.getOfflinePlayer((String)playerProfile.getName());
            });
        }
    };
    static final CustomArg ROTATION = new CustomArg(){

        @Override
        Argument<?> get(String name) {
            return new CustomArgument<Location, Rotation>(new RotationArgument(name), info -> {
                Rotation rotation = (Rotation)info.currentInput();
                return new Location(MAIN_WORLD, 0.0, 0.0, 0.0, rotation.getNormalizedYaw(), rotation.getNormalizedPitch());
            });
        }
    };
    static final CustomArg SKRIPT_COLOR = new CustomArg(){

        @Override
        Argument<?> get(String name) {
            return (Argument)new CustomArgument<SkriptColor, String>(new StringArgument(name), info -> {
                SkriptColor skriptColor = SkriptColor.fromName((String)info.input().replace("_", " "));
                if (skriptColor == null) {
                    throw CustomArgument.CustomArgumentException.fromString("Unknown skript color '" + info.input() + "'");
                }
                return skriptColor;
            }).replaceSuggestions(ArgumentSuggestions.strings((String[])Arrays.stream(SkriptColor.values()).map(skriptColor -> skriptColor.getName().replace(" ", "_")).toArray(String[]::new)));
        }
    };
    static final CustomArg TIME_SPAN = new CustomArg(){

        @Override
        Argument<?> get(String name) {
            return (Argument)new CustomArgument<Timespan, String>(new StringArgument(name), info -> {
                Timespan parse = Timespan.parse((String)info.input(), (ParseContext)ParseContext.COMMAND);
                if (parse == null) {
                    throw CustomArgument.CustomArgumentException.fromString("Unknown timespan '" + info.input() + "'");
                }
                return parse;
            }).replaceSuggestions(ArgumentSuggestions.stringCollectionAsync(info -> CompletableFuture.supplyAsync(() -> {
                String arg = info.currentArg();
                if (arg.matches("\\d+(.\\d+)?")) {
                    return List.of(arg + "s", arg + "m", arg + "h", arg + "d", arg + "w", arg + "mo", arg + "y");
                }
                if (arg.matches("\\d+\\.")) {
                    return List.of(arg + "0s", arg + "0m", arg + "0h", arg + "0d", arg + "0w", arg + "0mo", arg + "0y");
                }
                return DEFAULT_TIMESPANS;
            })));
        }
    };
    static final CustomArg TIME_PERIOD = new CustomArg(){

        @Override
        Argument<?> get(String name) {
            return (Argument)new CustomArgument<Timespan.TimePeriod, String>(new StringArgument(name), info -> {
                try {
                    return Timespan.TimePeriod.valueOf((String)info.input().toUpperCase(Locale.ROOT));
                }
                catch (Exception e) {
                    throw CustomArgument.CustomArgumentException.fromString("Unknown time period '" + info.input() + "'");
                }
            }).replaceSuggestions(ArgumentSuggestions.strings((String[])Arrays.stream(Timespan.TimePeriod.values()).map(timePeriod -> timePeriod.name().toLowerCase(Locale.ROOT)).toArray(String[]::new)));
        }
    };
    static final CustomArg WORLD = new CustomArg(){

        Argument<World> get(String name) {
            return (Argument)new CustomArgument<World, String>(new StringArgument(name), info -> {
                World world = Bukkit.getWorld((String)info.input());
                if (world == null) {
                    throw CustomArgument.CustomArgumentException.fromString("Unknown world '" + info.input() + "'");
                }
                return world;
            }).includeSuggestions(ArgumentSuggestions.stringCollectionAsync(commandSenderSuggestionInfo -> CompletableFuture.supplyAsync(() -> Bukkit.getWorlds().stream().map(WorldInfo::getName).toList())));
        }
    };

    abstract Argument<?> get(String var1);
}

