/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.briggy.api.commandapi;

import com.shanebeestudios.briggy.api.commandapi.CommandAPI;
import com.shanebeestudios.briggy.api.commandapi.CommandAPIConfig;
import com.shanebeestudios.briggy.api.commandapi.CommandAPIHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;

public abstract class CommandAPIBukkitConfig<T extends CommandAPIBukkitConfig<T>>
extends CommandAPIConfig<T> {
    String pluginName;
    boolean fallbackToLatestNMS = false;
    boolean skipReloadDatapacks = true;
    List<String> skipSenderProxy = new ArrayList<String>();
    Class<?> nbtContainerClass = null;
    Function<Object, ?> nbtContainerConstructor = null;

    public CommandAPIBukkitConfig(String pluginName) {
        this.pluginName = pluginName;
        super.setNamespace(pluginName.toLowerCase());
    }

    public T fallbackToLatestNMS(boolean fallbackToLatestNMS) {
        this.fallbackToLatestNMS = fallbackToLatestNMS;
        return (T)this.instance();
    }

    public T addSkipSenderProxy(String ... names) {
        this.skipSenderProxy.addAll(List.of(names));
        return (T)this.instance();
    }

    public T addSkipSenderProxy(List<String> names) {
        this.skipSenderProxy.addAll(names);
        return (T)this.instance();
    }

    public <NBT> T initializeNBTAPI(Class<NBT> nbtContainerClass, Function<Object, NBT> nbtContainerConstructor) {
        this.nbtContainerClass = nbtContainerClass;
        this.nbtContainerConstructor = nbtContainerConstructor;
        return (T)this.instance();
    }

    @Override
    public T setNamespace(String namespace) {
        if (namespace == null) {
            throw new NullPointerException("Default namespace can't be null!");
        }
        if (namespace.isEmpty()) {
            CommandAPI.logNormal("Did not set namespace to an empty value! Namespace '" + this.namespace + "' is used as the default namespace!");
            return (T)this.instance();
        }
        if (!CommandAPIHandler.NAMESPACE_PATTERN.matcher(namespace).matches()) {
            CommandAPI.logNormal("Did not set namespace to the provided '" + namespace + "' namespace because only 0-9, a-z, underscores, periods and hyphens are allowed!");
            return (T)this.instance();
        }
        return (T)((CommandAPIBukkitConfig)super.setNamespace(namespace));
    }

    @Override
    public abstract T instance();
}

