/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.briggy.api.commandapi.arguments;

import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.shanebeestudios.briggy.api.commandapi.CommandAPIBukkit;
import com.shanebeestudios.briggy.api.commandapi.arguments.CommandAPIArgumentType;
import com.shanebeestudios.briggy.api.commandapi.arguments.LocationType;
import com.shanebeestudios.briggy.api.commandapi.arguments.SafeOverrideableArgument;
import com.shanebeestudios.briggy.api.commandapi.executors.CommandArguments;
import org.bukkit.Location;

public class LocationArgument
extends SafeOverrideableArgument<Location, Location> {
    private final boolean isPrecise;

    public LocationArgument(String nodeName) {
        this(nodeName, LocationType.PRECISE_POSITION);
    }

    public LocationArgument(String nodeName, LocationType type) {
        this(nodeName, type, true);
    }

    public LocationArgument(String nodeName, LocationType type, boolean centerPosition) {
        super(nodeName, type == LocationType.BLOCK_POSITION ? CommandAPIBukkit.get().getNMS()._ArgumentPosition() : CommandAPIBukkit.get().getNMS()._ArgumentVec3(centerPosition), type == LocationType.BLOCK_POSITION ? l -> l.getBlockX() + " " + l.getBlockY() + " " + l.getBlockZ() : l -> l.getX() + " " + l.getY() + " " + l.getZ());
        this.isPrecise = type == LocationType.PRECISE_POSITION;
    }

    public LocationType getLocationType() {
        return this.isPrecise ? LocationType.PRECISE_POSITION : LocationType.BLOCK_POSITION;
    }

    @Override
    public Class<Location> getPrimitiveType() {
        return Location.class;
    }

    @Override
    public CommandAPIArgumentType getArgumentType() {
        return CommandAPIArgumentType.LOCATION;
    }

    @Override
    public <CommandSourceStack> Location parseArgument(CommandContext<CommandSourceStack> cmdCtx, String key, CommandArguments previousArgs) throws CommandSyntaxException {
        return this.isPrecise ? CommandAPIBukkit.get().getNMS().getLocationPrecise(cmdCtx, key) : CommandAPIBukkit.get().getNMS().getLocationBlock(cmdCtx, key);
    }
}

