/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.briggy.api.util;

import ch.njol.skript.registrations.Classes;
import ch.njol.util.StringUtils;
import com.shanebeestudios.briggy.api.commandapi.wrappers.CommandResult;
import com.shanebeestudios.briggy.api.commandapi.wrappers.ComplexRecipeImpl;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Keyed;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.inventory.Recipe;
import org.bukkit.scoreboard.Team;

public class ObjectConverter {
    private static final boolean HAS_TEAMS = Classes.getExactClassInfo(Team.class) != null;
    private static final boolean HAS_KEYS = Classes.getExactClassInfo(NamespacedKey.class) != null;

    public static Object[] convert(List<Object> objects) {
        ArrayList<Object> toReturn = new ArrayList<Object>();
        for (Object object : objects) {
            toReturn.add(ObjectConverter.convert(object));
        }
        return toReturn.toArray(new Object[0]);
    }

    public static Object convert(Object object) {
        if (object instanceof Sound) {
            Sound sound = (Sound)object;
            return sound.getKey().toString();
        }
        if (object instanceof ComplexRecipeImpl) {
            ComplexRecipeImpl complexRecipe = (ComplexRecipeImpl)object;
            Recipe recipe = complexRecipe.recipe();
            if (recipe instanceof Keyed) {
                Keyed keyed = (Keyed)recipe;
                NamespacedKey namespacedKey = keyed.getKey();
                if (HAS_KEYS) {
                    return namespacedKey;
                }
                return namespacedKey.toString();
            }
            return recipe.toString();
        }
        if (object instanceof Team) {
            Team team = (Team)object;
            if (HAS_TEAMS) {
                return team;
            }
            return team.getName();
        }
        if (object instanceof NamespacedKey) {
            NamespacedKey key = (NamespacedKey)object;
            if (HAS_KEYS) {
                return key;
            }
            return key.toString();
        }
        if (object instanceof CommandResult) {
            CommandResult commandResult = (CommandResult)object;
            String command = commandResult.command().getName();
            String args = StringUtils.join((Object[])commandResult.args(), (String)" ");
            return command + " " + args;
        }
        return object;
    }
}

