/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.briggy.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.log.ErrorQuality;
import ch.njol.skript.registrations.Classes;
import ch.njol.util.Kleenean;
import com.shanebeestudios.briggy.SkBriggy;
import com.shanebeestudios.briggy.api.commandapi.BukkitStringTooltip;
import com.shanebeestudios.briggy.api.commandapi.StringTooltip;
import com.shanebeestudios.briggy.api.event.BrigCommandSuggestEvent;
import com.shanebeestudios.skbee.api.wrapper.ComponentWrapper;
import net.kyori.adventure.text.ComponentLike;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;

@Name(value="Apply Suggestion")
@Description(value={"Apply a suggestion with tooltip or list of suggestions to an argument.", "This is used only in the argument registration section of a brig command and the suggestions section of a big command tree."})
@Examples(value={"register string arg \"world\":", "\tapply suggestion all worlds", "register string arg \"homes\" using:", "\tapply suggestions indexes of {homes::%uuid of player%::*}", "register string arg \"homes\" using:", "\tloop {homes::%uuid of player%::*}:", "\t\tapply suggestion loop-index with tooltip loop-value", "register string arg \"gamemode\":", "\tapply suggestion \"0\" with tooltip \"survival\"", "\tapply suggestion \"1\" with tooltip \"creative\"", "\tapply suggestion \"2\" with tooltip \"adventure\"", "\tapply suggestion \"3\" with tooltip \"spectator\""})
@Since(value={"1.0.0"})
public class EffApplySuggestion
extends Effect {
    private static final boolean HAS_COMP = SkBriggy.HAS_SKBEE_COMPONENT;
    private int pattern;
    private Expression<String> suggestion;
    private Expression<Object> tooltip;
    private Expression<Object> objects;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        if (!this.getParser().isCurrentEvent(BrigCommandSuggestEvent.class)) {
            Skript.error((String)"A suggestion can only be applied in a 'register argument' or 'suggestions' section.", (ErrorQuality)ErrorQuality.SEMANTIC_ERROR);
            return false;
        }
        this.pattern = matchedPattern;
        if (matchedPattern == 0) {
            this.suggestion = exprs[0];
            this.tooltip = exprs[1];
        } else {
            this.objects = exprs[0];
        }
        return true;
    }

    protected void execute(Event event) {
        if (!(event instanceof BrigCommandSuggestEvent)) {
            return;
        }
        BrigCommandSuggestEvent suggestEvent = (BrigCommandSuggestEvent)event;
        if (this.pattern == 0) {
            StringTooltip stringTooltip;
            String suggestion = (String)this.suggestion.getSingle((Event)suggestEvent);
            Object tooltip = this.tooltip.getSingle((Event)suggestEvent);
            if (suggestion == null || tooltip == null) {
                return;
            }
            if (HAS_COMP && tooltip instanceof ComponentWrapper) {
                ComponentWrapper component = (ComponentWrapper)tooltip;
                stringTooltip = BukkitStringTooltip.ofAdventureComponent(suggestion, (ComponentLike)component.getComponent());
            } else if (tooltip instanceof String) {
                String string = (String)tooltip;
                stringTooltip = BukkitStringTooltip.ofString(suggestion, string);
            } else {
                stringTooltip = BukkitStringTooltip.ofString(suggestion, Classes.toString((Object)tooltip));
            }
            suggestEvent.addSuggestion(stringTooltip);
        } else {
            for (Object object : this.objects.getArray((Event)suggestEvent)) {
                String s;
                String string = object instanceof String ? (s = (String)object) : Classes.toString((Object)object);
                StringTooltip tooltip = BukkitStringTooltip.none(string);
                suggestEvent.addSuggestion(tooltip);
            }
        }
    }

    @NotNull
    public String toString(Event e, boolean d) {
        if (this.pattern == 0) {
            return "apply suggestion " + this.suggestion.toString(e, d) + " with tooltip " + this.tooltip.toString(e, d);
        }
        return "apply suggestions " + this.objects.toString(e, d);
    }

    static {
        Skript.registerEffect(EffApplySuggestion.class, (String[])new String[]{"apply suggestion %string% with tooltip %~object%", "apply suggestion[s] %~objects%"});
    }
}

