/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.briggy.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.log.ErrorQuality;
import ch.njol.util.Kleenean;
import com.shanebeestudios.briggy.api.event.BrigCommandSuggestEvent;
import com.shanebeestudios.briggy.api.event.BrigCommandTriggerEvent;
import com.shanebeestudios.briggy.api.event.BrigTreeTriggerEvent;
import com.shanebeestudios.briggy.api.util.ObjectConverter;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;

@Name(value="Brig Command Arg")
@Description(value={"Represents the arguments in a Brig Command. These works the same way as Skript's `arg` and `arg-1`.", "Since command args create local variables at runtime, these are virtually useless.", "These can be used in both the `register argument` and `trigger` sections."})
@Examples(value={"brig command /i <item> <int>:", "\ttrigger:", "\t\tgive brig-arg-2 of brig-arg-1 to player"})
@Since(value={"1.0.0"})
public class ExprBrigArg
extends SimpleExpression<Object> {
    private Literal<Number> argNum;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        if (!this.getParser().isCurrentEvent(new Class[]{BrigCommandTriggerEvent.class, BrigCommandSuggestEvent.class, BrigTreeTriggerEvent.class})) {
            Skript.error((String)"'brig-arg' can only be used in a brig command 'trigger' and 'register arg' sections.", (ErrorQuality)ErrorQuality.SEMANTIC_ERROR);
            return false;
        }
        this.argNum = (Literal)exprs[0];
        return true;
    }

    protected Object[] get(Event event) {
        Object[] args;
        if (event instanceof BrigCommandTriggerEvent) {
            BrigCommandTriggerEvent triggerEvent = (BrigCommandTriggerEvent)event;
            args = triggerEvent.getArgs();
        } else if (event instanceof BrigCommandSuggestEvent) {
            BrigCommandSuggestEvent suggestEvent = (BrigCommandSuggestEvent)event;
            args = suggestEvent.getBrigArgs();
        } else if (event instanceof BrigTreeTriggerEvent) {
            BrigTreeTriggerEvent treeEvent = (BrigTreeTriggerEvent)event;
            args = treeEvent.getArgs();
        } else {
            return null;
        }
        ArrayList<Object> objects = new ArrayList<Object>();
        int i = ((Number)this.argNum.getSingle()).intValue();
        if (args.length >= i) {
            Object arg = args[i - 1];
            if (arg instanceof List) {
                List list = (List)arg;
                objects.addAll(list);
            } else {
                objects.add(arg);
            }
        }
        return ObjectConverter.convert(objects);
    }

    public boolean isSingle() {
        return true;
    }

    @NotNull
    public Class<?> getReturnType() {
        return Object.class;
    }

    @NotNull
    public String toString(Event e, boolean d) {
        return "brig-arg-" + this.argNum.toString(e, d);
    }

    static {
        Skript.registerExpression(ExprBrigArg.class, Object.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"brig-arg-%*number%"});
    }
}

