/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.briggy.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import com.shanebeestudios.briggy.api.wrapper.BlockPredicate;
import com.shanebeestudios.briggy.api.wrapper.ItemStackPredicate;
import java.util.function.Predicate;
import org.bukkit.block.Block;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Predicate - Filter")
@Description(value={"Represents a item/block predicate for filtering objects."})
@Examples(value={"# /destroy minecraft:short_grass 10", "# /destroy #minecraft:stairs 50", "brig command /destroy <b:blockpredicate> [<rad:int>]:", "\ttrigger:", "\t\tif {_rad} is not set:", "\t\t\tset {_rad} to 5", "\t\tloop ((blocks in radius {_rad} around target block) that match block predicate {_b}):", "\t\t\tbreak loop-block", "", "# /remove @a #minecraft:swords", "# /remove @a #minecraft:swords{Damage:0}", "brig command /remove <players> <i:itempredicate>:", "\ttrigger:", "\t\tloop {_players::*}:", "\t\t\tremove ((items in loop-value's inventory) that match item predicate {_i}) from inventory of loop-value"})
@Since(value={"1.3.0"})
public class ExprPredicateFilter
extends SimpleExpression<Object> {
    private int pattern;
    private Expression<ItemStack> itemStacks;
    private Expression<Block> blocks;
    private Expression<Predicate<?>> predicate;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.pattern = matchedPattern;
        if (matchedPattern == 0) {
            this.itemStacks = exprs[0];
        } else {
            this.blocks = exprs[0];
        }
        this.predicate = exprs[1];
        return true;
    }

    @Nullable
    protected Object[] get(Event event) {
        if (this.predicate == null) {
            return null;
        }
        Predicate predicate = (Predicate)this.predicate.getSingle(event);
        if (predicate == null) {
            return null;
        }
        if (this.pattern == 0 && predicate instanceof ItemStackPredicate) {
            ItemStackPredicate itemStackPredicate = (ItemStackPredicate)predicate;
            return this.itemStacks.stream(event).filter(itemStackPredicate).toArray();
        }
        if (this.pattern == 1 && predicate instanceof BlockPredicate) {
            BlockPredicate blockPredicate = (BlockPredicate)predicate;
            return this.blocks.stream(event).filter(blockPredicate).toArray();
        }
        return null;
    }

    public boolean isSingle() {
        return false;
    }

    @NotNull
    public Class<?> getReturnType() {
        return this.pattern == 0 ? ItemStack.class : Block.class;
    }

    @NotNull
    public String toString(@Nullable Event e, boolean d) {
        String message = "%s that match %s predicate %s";
        String object = this.pattern == 0 ? this.itemStacks.toString(e, d) : this.blocks.toString(e, d);
        String type = this.pattern == 0 ? "item" : "block";
        return String.format(message, object, type, this.predicate.toString(e, d));
    }

    static {
        Skript.registerExpression(ExprPredicateFilter.class, Object.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"%itemstacks% (that|which) match item[[ ]stack] predicate %predicate%", "%blocks% (that|which) match block predicate %predicate%"});
    }
}

