/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.briggy.skript.sections;

import ch.njol.skript.Skript;
import ch.njol.skript.config.SectionNode;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.EffectSection;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.Trigger;
import ch.njol.skript.lang.TriggerItem;
import ch.njol.skript.log.ErrorQuality;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.util.LiteralUtils;
import ch.njol.skript.variables.Variables;
import ch.njol.util.Kleenean;
import com.shanebeestudios.briggy.api.BrigArgument;
import com.shanebeestudios.briggy.api.BrigCommand;
import com.shanebeestudios.briggy.api.commandapi.BukkitStringTooltip;
import com.shanebeestudios.briggy.api.commandapi.IStringTooltip;
import com.shanebeestudios.briggy.api.commandapi.StringTooltip;
import com.shanebeestudios.briggy.api.commandapi.arguments.Argument;
import com.shanebeestudios.briggy.api.commandapi.arguments.ArgumentSuggestions;
import com.shanebeestudios.briggy.api.commandapi.arguments.GreedyStringArgument;
import com.shanebeestudios.briggy.api.commandapi.arguments.MultiLiteralArgument;
import com.shanebeestudios.briggy.api.event.BrigCommandArgumentsEvent;
import com.shanebeestudios.briggy.api.event.BrigCommandSuggestEvent;
import com.shanebeestudios.briggy.api.util.ObjectConverter;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.bukkit.command.CommandSender;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Register Argument")
@Description(value={"Register an argument for a brig command.", "\nWithin this section you can apply suggestions with tooltips.", "The section itself will run when a player types a command, thus variables CAN be used and the [event-]player", "will be the player typing the command.", "Local variables will be created for the previously typed args, and can be used in this section. See examples.", "\n`brigarg` = Type of argument. See Brig Argument Type for more details.", "\n`string` = Name of the argument. (Used for local variables and how it shows in game)", "\n`%objects`% = Suggestions for this argument. (If object is not a string, Skript will stringify it)", "\n`min/max` = The min/max range of a number (long/int/float/double) argument."})
@Examples(value={"register string arg \"world\" using all worlds", "register string arg \"world\":", "\tapply suggestion all worlds", "register string arg \"homes\" using indexes of {homes::%uuid of player%::*}", "register string arg \"homes\" using:", "\tapply suggestions indexes of {homes::%uuid of player%::*}", "register string arg \"homes\" using:", "\tloop {homes::%uuid of player%::*}:", "\t\tapply suggestion loop-index with tooltip loop-value", "register string arg \"gamemode\":", "\tapply suggestion \"0\" with tooltip \"survival\"", "\tapply suggestion \"1\" with tooltip \"creative\"", "\tapply suggestion \"2\" with tooltip \"adventure\"", "\tapply suggestion \"3\" with tooltip \"spectator\"", "", "brig command /breaky:", "\targuments:", "\t\tregister string arg named \"type\" using \"bacon\", \"eggs\" and \"toast\"", "\t\tregister string arg named \"style\":", "\t\t\tif brig-arg-1 = \"bacon\": # Brig-Args can be used here", "\t\t\t\tapply suggestion \"crispy\" with tooltip \"nice and crispy\"", "\t\t\t\tapply suggestion \"soft\" with tooltip \"ewww\"", "\t\t\telse if {_type} = \"eggs\": # Local variables of the previous arg are also created", "\t\t\t\tapply suggestion \"sunny_side_up\" with tooltip \"facing the sun\"", "\t\t\t\tapply suggestion \"scrambled\" with tooltip \"all mixed up\"", "\t\t\t\tapply suggestion \"soft_boiled\" with tooltip \"swimmin for a short time\"", "\t\t\t\tapply suggestion \"hard_boiled\" with tooltip \"eww, thats nasty bitch\"", "\t\t\telse if {_type} = \"toast\":", "\t\t\t\tapply suggestion \"light\" with tooltip \"just a touch of heat\"", "\t\t\t\tapply suggestion \"medium\" with tooltip \"well that sounds perfect\"", "\t\t\t\tapply suggestion \"dark\" with tooltip \"nice and crisy\"", "\t\t\t\tapply suggestion \"burnt\" with tooltip \"now ya done an fucked er up\""})
@Since(value={"1.0.0"})
public class SecRegisterArg
extends EffectSection {
    private int pattern;
    private boolean optional;
    private Literal<BrigArgument> brigArg;
    private Expression<String> argument;
    private Trigger trigger;
    private Expression<?> suggestions;
    private Expression<Number> min;
    private Expression<Number> max;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult, SectionNode sectionNode, List<TriggerItem> triggerItems) {
        if (!this.getParser().isCurrentEvent(BrigCommandArgumentsEvent.class)) {
            Skript.error((String)"A brig arg can only be registered in a brig command 'arguments' section.", (ErrorQuality)ErrorQuality.SEMANTIC_ERROR);
            return false;
        }
        this.pattern = matchedPattern;
        this.optional = parseResult.hasTag("optional");
        this.brigArg = (Literal)exprs[0];
        this.argument = exprs[1];
        if (matchedPattern == 1) {
            this.suggestions = exprs[2];
        } else if (matchedPattern == 2) {
            this.min = exprs[2];
            this.max = exprs[3];
        }
        if (sectionNode != null) {
            if (((BrigArgument)this.brigArg.getSingle()).getArgClass() == MultiLiteralArgument.class) {
                Skript.error((String)"Literal arguments do not support using a section. Just use this as an effect!");
                return false;
            }
            AtomicBoolean delayed = new AtomicBoolean(false);
            Runnable afterLoading = () -> delayed.set(!this.getParser().getHasDelayBefore().isFalse());
            this.trigger = this.loadCode(sectionNode, "argument registration", afterLoading, new Class[]{BrigCommandSuggestEvent.class});
            if (delayed.get()) {
                Skript.error((String)"Delays can't be within an Argument Registration section.");
                return false;
            }
        }
        if (matchedPattern == 1 && LiteralUtils.hasUnparsedLiteral(this.suggestions)) {
            return LiteralUtils.canInitSafely((Expression[])new Expression[]{this.suggestions});
        }
        return true;
    }

    @Nullable
    protected TriggerItem walk(Event event) {
        Object localVars = Variables.copyLocalVariables((Event)event);
        BrigCommandArgumentsEvent brigCommandEvent = (BrigCommandArgumentsEvent)event;
        BrigCommand brigCommand = brigCommandEvent.getBrigCommand();
        String arg = (String)this.argument.getSingle(event);
        BrigArgument brigArg = (BrigArgument)this.brigArg.getSingle();
        Argument<?> argument = null;
        if (this.pattern > 1) {
            Number[] minMax = brigArg.getMinMax();
            if (minMax != null) {
                Number min = this.min != null && this.min.getSingle(event) != null ? (Number)((Number)this.min.getSingle(event)) : (Number)minMax[0];
                Number max = this.max != null && this.max.getSingle(event) != null ? (Number)((Number)this.max.getSingle(event)) : (Number)minMax[1];
                argument = brigArg.getIntArgument(arg, min, max);
            }
        } else if (brigArg.getArgClass() == MultiLiteralArgument.class) {
            ArrayList<String> literals = new ArrayList<String>();
            if (this.pattern == 1 && this.suggestions != null) {
                for (Object object : this.suggestions.getArray(event)) {
                    if (object instanceof String) {
                        String string = (String)object;
                        literals.add(string);
                        continue;
                    }
                    literals.add(Classes.toString((Object)object));
                }
            } else {
                literals.add(arg);
            }
            argument = brigArg.getMultiLit(arg, literals);
        } else {
            argument = brigArg.getArgument(arg);
        }
        if (argument == null) {
            return super.walk(event, false);
        }
        List<Argument<?>> brigArgs = brigCommand.getArguments();
        if (!brigArgs.isEmpty() && brigArgs.get(brigArgs.size() - 1) instanceof GreedyStringArgument) {
            Skript.error((String)"You cannot register another argument after a 'greedystring' arg.");
            return super.walk(event, false);
        }
        if (this.trigger != null) {
            argument.includeSuggestions(ArgumentSuggestions.stringsWithTooltips(info -> {
                BrigCommandSuggestEvent suggestEvent = new BrigCommandSuggestEvent();
                Variables.setLocalVariables((Event)suggestEvent, (Object)localVars);
                ArrayList args = new ArrayList();
                info.previousArgs().argsMap().forEach((string, object) -> {
                    args.add(object);
                    Variables.setVariable((String)string, (Object)ObjectConverter.convert(object), (Event)suggestEvent, (boolean)true);
                });
                suggestEvent.setBrigArgs(args.toArray());
                brigCommandEvent.setSender((CommandSender)info.sender());
                if (this.suggestions != null) {
                    for (Object object2 : this.suggestions.getArray((Event)brigCommandEvent)) {
                        String s;
                        String string2 = object2 instanceof String ? (s = (String)object2) : Classes.toString((Object)object2);
                        suggestEvent.addSuggestion(string2);
                    }
                }
                TriggerItem.walk((TriggerItem)this.trigger, (Event)suggestEvent);
                Variables.setLocalVariables((Event)event, (Object)Variables.copyLocalVariables((Event)suggestEvent));
                Variables.removeLocals((Event)suggestEvent);
                return suggestEvent.getSuggestions().toArray(new IStringTooltip[0]);
            }));
        } else if (this.pattern == 1 && this.suggestions != null) {
            argument.includeSuggestions(ArgumentSuggestions.stringsWithTooltips(info -> {
                ArrayList<StringTooltip> suggestions = new ArrayList<StringTooltip>();
                brigCommandEvent.setSender((CommandSender)info.sender());
                for (Object suggestion : this.suggestions.getArray((Event)brigCommandEvent)) {
                    String s;
                    String string = suggestion instanceof String ? (s = (String)suggestion) : Classes.toString((Object)suggestion);
                    suggestions.add(BukkitStringTooltip.none(string));
                }
                return suggestions.toArray(new IStringTooltip[0]);
            }));
        }
        argument.setOptional(this.optional);
        brigCommand.addArgument(arg, argument);
        return super.walk(event, false);
    }

    @NotNull
    public String toString(@Nullable Event e, boolean d) {
        String optional = this.optional ? "optional " : "";
        String start = "register " + optional + this.brigArg.toString(e, d) + " named " + this.argument.toString(e, d);
        return start + (String)(switch (this.pattern) {
            case 1 -> " with suggestions " + this.suggestions.toString(e, d);
            case 2 -> " with min " + this.min.toString(e, d) + " and max " + this.max.toString(e, d);
            default -> "";
        });
    }

    static {
        String base = "register [:optional] %*brigarg% arg[ument] [(named|with name)] %string%";
        Skript.registerSection(SecRegisterArg.class, (String[])new String[]{base, base + " (with suggestions|using) %objects%", base + " with [min %-number%] [and] [with] [max %-number%]"});
    }
}

