/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.briggy.skript.sections;

import ch.njol.skript.Skript;
import ch.njol.skript.config.Node;
import ch.njol.skript.config.SectionNode;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.Section;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.Trigger;
import ch.njol.skript.lang.TriggerItem;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.util.LiteralUtils;
import ch.njol.skript.variables.Variables;
import ch.njol.util.Kleenean;
import com.shanebeestudios.briggy.api.BrigArgument;
import com.shanebeestudios.briggy.api.commandapi.CommandTree;
import com.shanebeestudios.briggy.api.commandapi.IStringTooltip;
import com.shanebeestudios.briggy.api.commandapi.arguments.Argument;
import com.shanebeestudios.briggy.api.commandapi.arguments.ArgumentSuggestions;
import com.shanebeestudios.briggy.api.commandapi.arguments.MultiLiteralArgument;
import com.shanebeestudios.briggy.api.commandapi.executors.ExecutorType;
import com.shanebeestudios.briggy.api.event.BrigCommandSuggestEvent;
import com.shanebeestudios.briggy.api.event.BrigTreeSubCommandEvent;
import com.shanebeestudios.briggy.api.event.BrigTreeTriggerEvent;
import com.shanebeestudios.briggy.api.util.ObjectConverter;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.skriptlang.skript.lang.entry.EntryContainer;
import org.skriptlang.skript.lang.entry.EntryValidator;

@Name(value="CommandTree - SubCommand")
@Description(value={"Register a sub command in a command tree.", "A sub command is just an argument that can have its own sub commands and triggers.", "See [**SkBriggy Wiki**](https://github.com/ShaneBeee/SkBriggy/wiki/Command-Tree) for more detailed info.", "**Notes**:", "- A `greedy string` arg always has to be last, you cannot register another subcommand within it.", "- Optionals are a little funny, you cannot have a required subcommand within an optional subcommand.", "- Min/Max can only be used on number subcommands.", "- The name/id you choose for your subcommand will automatically be made into a local variable.", "- List arg types (ie: players/entities) will create list variables. DO NOT repeat names. See examples.", "", "**Entries/Sections**:", "`permission` = Each subcommand can have its own permission.", "`suggestions` = You can apply suggestions (with tooltips) to a subcommand. See `apply suggestion` effect, and examples.", "`register arg` = Register another subcommand within this one. Supports multiple.", "`trigger` = Like any other command, this is what will execute when the command is run."})
@Examples(value={"# Example with optional arg that can be bypassed", "brig command tree /legamemode:", "\tliteral arg \"gamemode\" using \"adventure\", \"creative\", \"spectator\", \"survival\":", "\t\t# When optional, the trigger will still run but the arg is ignored", "\t\toptional players arg \"players\":", "\t\t\ttrigger:", "\t\t\t\t# if the player arg is not used, we will default to the command sender", "\t\t\t\tset {_players::*} to {_players::*} ? player", "\t\t\t\tset {_gamemode} to {_gamemode} parsed as gamemode", "\t\t\t\tset gamemode of {_players::*} to {_gamemode}", "", "# Example similar to above but using 2 different triggers", "brig command tree /spawn:", "\tworld arg \"world\":", "\t\ttrigger:", "\t\t\tteleport player to spawn of {_world}", "\t# if the argument isn't entered, this will execute", "\ttrigger:", "\t\tteleport player to spawn of world of player", "", "# Example showing off suggestions with tooltips", "brig command tree /lewarp:", "\tstring arg \"warp\":", "\t\tsuggestions:", "\t\t\tloop {warps::*}:", "\t\t\t\tset {_s} to \"&7x: &b%x coord of loop-value% &7y: &b%y coord of loop-value% &7z: &b%z coord of loop-value% &7world: &a%world of loop-value%\"", "\t\t\t\tapply suggestion loop-index with tooltip {_s}", "\t\ttrigger:", "\t\t\tif {warps::%{_warp}%} is set:", "\t\t\t\tteleport player to {warps::%{_warp}%}", "\t\t\telse:", "\t\t\t\tsend \"No warp available for %{_warp}%\"", "", "brig command tree /leban:", "\tdescription: &bThis allows you to ban players", "\tusages: /leban &7<&bplayers&7> &7<&btimespan&7>", "\tplayers arg \"players\":", "\t\tint arg \"time\":", "\t\t\tstring arg \"span\" using \"minutes\", \"hours\", \"days\":", "\t\t\t\t# When optional, the trigger will still run but the arg is ignored", "\t\t\t\toptional greedy string arg \"reason\":", "\t\t\t\t\ttrigger:", "\t\t\t\t\t\tset {_timespan} to \"%{_time}% %{_span}%\" parsed as timespan", "\t\t\t\t\t\tset {_reason} to {_reason} ? \"Unknown Reason\"", "\t\t\t\t\t\tban {_players::*} due to \"&c\" + {_reason} for {_timespan}", "\t\t\t\t\t\tkick {_players::*} due to \"&c\" + {_reason}"})
@Since(value={"1.4.0"})
public class SecSubCommand
extends Section {
    private static final EntryValidator.EntryValidatorBuilder VALIDATOR = EntryValidator.builder();
    private int pattern;
    private boolean optional;
    private Literal<BrigArgument> brigArg;
    private Literal<String> commandName;
    private Expression<?> suggestions;
    private Expression<Number> min;
    private Expression<Number> max;
    private String permission;
    private final List<Section> sections = new ArrayList<Section>();
    private Trigger suggestionsTrigger;
    private Trigger trigger;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult, SectionNode sectionNode, List<TriggerItem> triggerItems) {
        EntryContainer container = VALIDATOR.build().validate(sectionNode);
        if (container == null) {
            return false;
        }
        this.pattern = matchedPattern;
        for (Node node : container.getUnhandledNodes()) {
            if (!(node instanceof SectionNode)) continue;
            SectionNode sectionNode1 = (SectionNode)node;
            if (node.getKey() == null) continue;
            Section parse = Section.parse((String)node.getKey(), (String)("Invalid section: " + node.getKey()), (SectionNode)sectionNode1, null);
            if (parse == null) {
                return false;
            }
            this.sections.add(parse);
        }
        this.permission = (String)container.getOptional("permission", String.class, false);
        SectionNode suggestions = (SectionNode)container.getOptional("suggestions", SectionNode.class, false);
        this.suggestionsTrigger = suggestions != null ? this.loadCode(suggestions, "suggestions", new Class[]{BrigCommandSuggestEvent.class}) : null;
        SectionNode trigger = (SectionNode)container.getOptional("trigger", SectionNode.class, false);
        this.trigger = trigger != null ? this.loadCode(trigger, "trigger", new Class[]{BrigTreeTriggerEvent.class}) : null;
        this.optional = parseResult.hasTag("optional");
        if (this.optional && !this.sections.isEmpty()) {
            boolean subIsRequired = false;
            for (Section section : this.sections) {
                if (!(section instanceof SecSubCommand)) continue;
                SecSubCommand sub = (SecSubCommand)section;
                if (sub.optional) continue;
                subIsRequired = true;
            }
            if (subIsRequired) {
                Skript.error((String)"An optional subcommand cannot contain a required subcommand.");
                return false;
            }
        }
        this.brigArg = (Literal)exprs[0];
        if (((BrigArgument)this.brigArg.getSingle()).getName().equalsIgnoreCase("greedystring") && !this.sections.isEmpty()) {
            Skript.error((String)"A greedy string cannot have other subcommands after it.");
            return false;
        }
        this.commandName = (Literal)exprs[1];
        if (matchedPattern == 1) {
            this.suggestions = LiteralUtils.defendExpression(exprs[2]);
        } else if (matchedPattern == 2) {
            this.min = exprs[2];
            this.max = exprs[3];
            if (((BrigArgument)this.brigArg.getSingle()).getMinMax() == null) {
                Skript.error((String)"Min/Max can only be used on number subcommands.");
                return false;
            }
        }
        return true;
    }

    @Nullable
    protected TriggerItem walk(Event event) {
        if (!(event instanceof BrigTreeSubCommandEvent)) {
            return null;
        }
        BrigTreeSubCommandEvent subCommandEvent = (BrigTreeSubCommandEvent)event;
        Object localVars = Variables.copyLocalVariables((Event)event);
        BrigArgument brigArg = (BrigArgument)this.brigArg.getSingle();
        String commandName = (String)this.commandName.getSingle();
        Argument<?> command = null;
        if (this.pattern > 1) {
            Number[] minMax = brigArg.getMinMax();
            if (minMax != null) {
                Object min = this.min != null && this.min.getSingle(event) != null ? (Number)this.min.getSingle(event) : minMax[0];
                Number max = this.max != null && this.max.getSingle(event) != null ? (Number)((Number)this.max.getSingle(event)) : (Number)minMax[1];
                command = brigArg.getIntArgument(commandName, (Number)min, max);
            }
        } else {
            ArrayList<String> literals = new ArrayList<String>();
            if (this.pattern == 1 && this.suggestions != null) {
                for (Object object : this.suggestions.getArray(event)) {
                    if (object instanceof String) {
                        String string = (String)object;
                        literals.add(string);
                        continue;
                    }
                    literals.add(Classes.toString((Object)object));
                }
            }
            if (brigArg.getArgClass() == MultiLiteralArgument.class) {
                if (literals.isEmpty()) {
                    literals.add(commandName);
                }
                command = brigArg.getMultiLit(commandName, literals);
            } else {
                command = brigArg.getArgument(commandName);
                if (!literals.isEmpty()) {
                    command.includeSuggestions(ArgumentSuggestions.strings(literals));
                }
            }
        }
        if (command == null) {
            return super.walk(event, false);
        }
        command.setOptional(this.optional);
        if (this.permission != null) {
            command.withPermission(this.permission);
        }
        if (this.suggestionsTrigger != null) {
            command.includeSuggestions(ArgumentSuggestions.stringsWithTooltips(info -> {
                BrigCommandSuggestEvent suggestEvent = new BrigCommandSuggestEvent();
                Variables.setLocalVariables((Event)suggestEvent, (Object)localVars);
                ArrayList brigArgs = new ArrayList();
                info.previousArgs().argsMap().forEach((string, object) -> {
                    brigArgs.add(object);
                    Variables.setVariable((String)string, (Object)ObjectConverter.convert(object), (Event)suggestEvent, (boolean)true);
                });
                suggestEvent.setBrigArgs(brigArgs.toArray());
                suggestEvent.setCommandSender((CommandSender)info.sender());
                if (this.suggestions != null) {
                    for (Object object2 : this.suggestions.getArray(event)) {
                        String s;
                        String string2 = object2 instanceof String ? (s = (String)object2) : Classes.toString((Object)object2);
                        suggestEvent.addSuggestion(string2);
                    }
                }
                TriggerItem.walk((TriggerItem)this.suggestionsTrigger, (Event)suggestEvent);
                Variables.setLocalVariables((Event)event, (Object)Variables.copyLocalVariables((Event)suggestEvent));
                Variables.removeLocals((Event)suggestEvent);
                return suggestEvent.getSuggestions().toArray(new IStringTooltip[0]);
            }));
        }
        boolean hasSubCommand = false;
        for (Section section : this.sections) {
            hasSubCommand = true;
            Section.walk((TriggerItem)section, (Event)new BrigTreeSubCommandEvent(command));
        }
        if (this.trigger != null) {
            command.executes(executerInfo -> {
                BrigTreeTriggerEvent brigTreeTriggerEvent = new BrigTreeTriggerEvent(executerInfo);
                executerInfo.args().argsMap().forEach((argName, argObject) -> {
                    if (argObject instanceof List) {
                        List arrayList = (List)argObject;
                        for (int i = 0; i < arrayList.size(); ++i) {
                            Object convert = ObjectConverter.convert(arrayList.get(i));
                            Variables.setVariable((String)(argName + "::" + i), (Object)convert, (Event)brigTreeTriggerEvent, (boolean)true);
                        }
                    } else {
                        Object convert = ObjectConverter.convert(argObject);
                        Variables.setVariable((String)argName, (Object)convert, (Event)brigTreeTriggerEvent, (boolean)true);
                    }
                });
                this.trigger.execute((Event)brigTreeTriggerEvent);
            }, new ExecutorType[0]);
        } else if (!hasSubCommand) {
            Skript.error((String)"SubCommand must have at least a subcommand or a trigger.");
            return null;
        }
        CommandTree commandTree = subCommandEvent.getCommandTree();
        Argument<?> argument = subCommandEvent.getArgument();
        if (commandTree != null) {
            commandTree.then(command);
        } else if (argument != null) {
            argument.then(command);
        }
        return super.walk(event, false);
    }

    @NotNull
    public String toString(Event e, boolean d) {
        String opt = this.optional ? "optional " : "";
        String suggestions = this.pattern == 1 ? " with suggestions " + this.suggestions.toString(e, d) : "";
        String minmax = this.pattern == 2 ? " with min " + this.min.toString(e, d) + " and max " + this.max.toString(e, d) : "";
        return opt + this.brigArg.toString(e, d) + " arg " + this.commandName.toString(e, d) + suggestions + minmax;
    }

    static {
        VALIDATOR.addEntry("permission", null, true).addSection("suggestions", true).addSection("register arg section", true).addSection("trigger", true).unexpectedNodeTester(node -> {
            SectionNode sectionNode;
            String key;
            return !(node instanceof SectionNode) || (key = (sectionNode = (SectionNode)node).getKey()) == null || !key.contains("arg") || !key.contains("\"");
        }).build();
        String base = "[:optional] %*brigarg% arg[ument] [(named|with (name|id))] %*string%";
        Skript.registerSection(SecSubCommand.class, (String[])new String[]{base, base + " (with suggestions|using) %objects%", base + " with [min %-number%] [and] [with] [max %-number%]"});
    }
}

