/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.briggy.skript.structures;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.Skript;
import ch.njol.skript.config.SectionNode;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptEvent;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.Trigger;
import ch.njol.skript.lang.TriggerItem;
import ch.njol.skript.lang.VariableString;
import ch.njol.skript.lang.util.SimpleEvent;
import ch.njol.skript.test.runner.TestMode;
import ch.njol.skript.util.Utils;
import ch.njol.util.StringUtils;
import com.shanebeestudios.briggy.SkBriggy;
import com.shanebeestudios.briggy.api.BrigArgument;
import com.shanebeestudios.briggy.api.BrigCommand;
import com.shanebeestudios.briggy.api.commandapi.CommandAPI;
import com.shanebeestudios.briggy.api.commandapi.arguments.Argument;
import com.shanebeestudios.briggy.api.commandapi.arguments.GreedyStringArgument;
import com.shanebeestudios.briggy.api.commandapi.arguments.MultiLiteralArgument;
import com.shanebeestudios.briggy.api.event.BrigCommandArgumentsEvent;
import com.shanebeestudios.briggy.api.event.BrigCommandTriggerEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.skriptlang.skript.lang.entry.EntryContainer;
import org.skriptlang.skript.lang.entry.EntryData;
import org.skriptlang.skript.lang.entry.EntryValidator;
import org.skriptlang.skript.lang.entry.KeyValueEntryData;
import org.skriptlang.skript.lang.entry.util.VariableStringEntryData;
import org.skriptlang.skript.lang.script.Script;
import org.skriptlang.skript.lang.structure.Structure;

@Name(value="Brig Command")
@Description(value={"Register a new Brigadier command.", "See wiki for more details on registering: [**SkBriggy Wiki**](https://github.com/ShaneBeee/SkBriggy/wiki/Registering-New-Command)", "", "Command Format:", "`brig command /namespace:commandName <brigArgType> [<brigArgType>] <argName:brigArgType> [<argName:brigArgType>]:`", "`namespace` = The namespace of a command. (Optional, defaults to \"minecraft:\")", "`commandName` = Represents the command itself, ex: '/mycommand'.", "`brigArgType` = Represents a brig argument type.", "- While some may match Skript types, this doesn't actually support Skript types.", "`argName` = The name of the arg, which will be used to create a local variable for the arg.", "- In some cases this will show when typing out a command in game.", "- If this isn't set a local variable will be created using the type (see examples).", "", "Just like Skript commands, wrapping your arg in `[]` makes it optional. Do note at this time there is no support for defaults.", "", "Entries and Sections:", "`permission:` = Just like Skript, the permission the player will require for this command.", "`description:` = Just like Skript, this is a string that will be used in the help command.", "`arguments:` = Section for registering arguments. See `Register Argument` effect.", "`trigger:` = Section, just like Skript, for executing your code in the command.", "", "Event Values:", "`[event-]sender` = The sender (console/player/entity) who ran the command or the sender used in Minecraft's `/execute as <sender>` command.", "`[event-]world` = World of the sender, or default world if sender is console, or world used in Minecraft's `/execute in <world>` command."})
@Examples(value={"brig command /move <player> <location>:", "\ttrigger:", "\t\tteleport {_player} to {_location}", "", "brig command /move <p1:player> <p2:player>:", "\ttrigger:", "\t\tteleport {_p1} to {_p2}", "", "brig command /i <item> [<amount:int>]:", "\ttrigger:", "\t\tset {_amount} to 1 if {_amount} isn't set", "\t\tgive {_amount} of {_item} to player", "", "brig command /coolserver:party:", "\tpermission: coolserver.party", "\ttrigger:", "\t\tteleport all players to spawn of world \"world_party\""})
@Since(value={"1.0.0"})
public class StructBrigCommand
extends Structure {
    private static final SkBriggy PLUGIN = SkBriggy.getInstance();
    private static final Pattern ALIASES_PATTERN = Pattern.compile("\\s*,\\s*");
    private static final Pattern ARGUMENT_PATTERN = Pattern.compile("\\[?<.*?>]?");
    private EntryContainer entryContainer;
    private String command;
    private String argString;

    public boolean init(Literal<?>[] args, int matchedPattern, SkriptParser.ParseResult parseResult, EntryContainer entryContainer) {
        this.entryContainer = entryContainer;
        String[] split = ((MatchResult)parseResult.regexes.getFirst()).group().split(" ", 2);
        this.command = split[0];
        this.argString = split.length > 1 ? split[1] : null;
        return true;
    }

    public boolean load() {
        Script currentScript = this.getParser().getCurrentScript();
        this.getParser().setCurrentEvent("BrigCommandArguments", new Class[]{BrigCommandArgumentsEvent.class});
        BrigCommand brigCommand = new BrigCommand(this.command);
        if (!this.parseArgs(brigCommand)) {
            return false;
        }
        SectionNode argNode = (SectionNode)this.entryContainer.getOptional("arguments", SectionNode.class, false);
        if (argNode != null) {
            Trigger argTrigger = new Trigger(currentScript, "briggy command /" + this.command, (SkriptEvent)new SimpleEvent(), (List)ScriptLoader.loadItems((SectionNode)argNode));
            Trigger.walk((TriggerItem)argTrigger, (Event)new BrigCommandArgumentsEvent(brigCommand));
        }
        String permission = (String)this.entryContainer.getOptional("permission", String.class, false);
        brigCommand.setPermission(permission);
        String description = (String)this.entryContainer.getOptional("description", String.class, true);
        assert (description != null);
        description = Utils.replaceEnglishChatStyles((String)description);
        brigCommand.setDescription(description);
        VariableString usage = (VariableString)this.entryContainer.getOptional("usage", VariableString.class, false);
        if (usage != null && usage.isSimple()) {
            String string = usage.toString(null);
            brigCommand.setUsage(string);
        }
        List aliases = (List)this.entryContainer.get("aliases", true);
        brigCommand.setAliases(aliases);
        this.getParser().setCurrentEvent("BrigCommandTrigger", new Class[]{BrigCommandTriggerEvent.class});
        SectionNode triggerNode = (SectionNode)this.entryContainer.get("trigger", SectionNode.class, false);
        Trigger trigger = new Trigger(currentScript, "briggy command /" + this.command, (SkriptEvent)new SimpleEvent(), (List)ScriptLoader.loadItems((SectionNode)triggerNode));
        trigger.setLineNumber(triggerNode.getLine());
        brigCommand.addExecution(trigger);
        if (TestMode.ENABLED) {
            brigCommand.build();
        } else {
            Bukkit.getScheduler().runTaskLater((Plugin)PLUGIN, brigCommand::build, 0L);
        }
        this.getParser().deleteCurrentEvent();
        return true;
    }

    private boolean parseArgs(BrigCommand brigCommand) {
        int arg2;
        int opt2;
        if (this.argString == null) {
            return true;
        }
        int argLength = this.argString.length();
        int opt1 = StringUtils.count((String)this.argString, (char)'[', (int)0, (int)argLength);
        if (opt1 != (opt2 = StringUtils.count((String)this.argString, (char)']', (int)0, (int)argLength))) {
            Skript.error((String)"Invalid placement of [] around arguments.");
            return false;
        }
        int arg1 = StringUtils.count((String)this.argString, (char)'<', (int)0, (int)argLength);
        if (arg1 != (arg2 = StringUtils.count((String)this.argString, (char)'>', (int)0, (int)argLength))) {
            Skript.error((String)"Invalid placement of <> around arguments.");
            return false;
        }
        ArrayList<String> args = new ArrayList<String>();
        Matcher matcher = ARGUMENT_PATTERN.matcher(this.argString);
        while (matcher.find()) {
            args.add(matcher.group());
        }
        for (String arg : args) {
            String type;
            Object name;
            boolean optional = false;
            if (arg.startsWith("[") && arg.endsWith("]")) {
                optional = true;
                arg = arg.replace("[", "").replace("]", "");
            }
            if ((arg = arg.replace("<", "").replace(">", "")).contains(":")) {
                String[] split = arg.split(":");
                name = split[0];
                type = split[1];
            } else {
                name = arg;
                type = arg;
            }
            BrigArgument brigArgument = BrigArgument.parse(type);
            if (brigArgument == null) {
                Skript.error((String)("Invalid brig argument type '" + type + "'"));
                return false;
            }
            if (brigArgument.getArgClass() == MultiLiteralArgument.class) {
                Skript.error((String)("<" + arg + "> arguments cannot be used in a command. You can use them in the arguments section instead."));
                return false;
            }
            Map<String, Argument<?>> registeredArgs = brigCommand.getArgumentMap();
            if (registeredArgs.containsKey(name)) {
                for (int i = 2; i < 50; ++i) {
                    String testname = (String)name + i;
                    if (registeredArgs.containsKey(testname)) continue;
                    name = testname;
                    break;
                }
            }
            Argument<?> argument = brigArgument.getArgument((String)name);
            argument.setOptional(optional);
            List<Argument<?>> brigArgs = brigCommand.getArguments();
            if (!brigArgs.isEmpty() && brigArgs.getLast() instanceof GreedyStringArgument) {
                Skript.error((String)"You cannot place another arg after a <greedystring> arg.");
                return false;
            }
            brigCommand.addArgument((String)name, argument);
        }
        return true;
    }

    public void unload() {
        CommandAPI.unregister(this.command, true);
    }

    @NotNull
    public String toString(@Nullable Event e, boolean d) {
        return "briggy command";
    }

    static {
        EntryValidator entryValidator = EntryValidator.builder().addEntry("permission", null, true).addEntry("description", "SkBriggy Command", true).addEntryData((EntryData)new VariableStringEntryData("usage", null, true)).addEntryData((EntryData)new KeyValueEntryData<List<String>>("aliases", new ArrayList(), true){

            protected List<String> getValue(String value) {
                ArrayList<String> aliases = new ArrayList<String>(Arrays.asList(ALIASES_PATTERN.split(value = value.replace("/", ""))));
                if (((String)aliases.getFirst()).isEmpty()) {
                    return null;
                }
                return aliases;
            }
        }).addSection("arguments", true).addSection("trigger", false).build();
        Skript.registerStructure(StructBrigCommand.class, (EntryValidator)entryValidator, (String[])new String[]{"brig[(gy|adier)] command /<.+>"});
    }
}

