/*
 * Decompiled with CFR 0.152.
 */
package fr.tylwen.satyria.dynashop;

import fr.tylwen.satyria.dynashop.command.DynaShopCommand;
import fr.tylwen.satyria.dynashop.config.DataConfig;
import fr.tylwen.satyria.dynashop.config.LangConfig;
import fr.tylwen.satyria.dynashop.data.ShopConfigManager;
import fr.tylwen.satyria.dynashop.data.cache.CacheManager;
import fr.tylwen.satyria.dynashop.data.cache.LimitCacheEntry;
import fr.tylwen.satyria.dynashop.data.param.DynaShopType;
import fr.tylwen.satyria.dynashop.data.storage.FlatFileStorageManager;
import fr.tylwen.satyria.dynashop.data.storage.MySQLStorageManager;
import fr.tylwen.satyria.dynashop.data.storage.StorageManager;
import fr.tylwen.satyria.dynashop.data.storage.database.BatchDatabaseUpdater;
import fr.tylwen.satyria.dynashop.hook.DynaShopExpansion;
import fr.tylwen.satyria.dynashop.hook.ShopGUIPlusHook;
import fr.tylwen.satyria.dynashop.libs.bstats.bukkit.Metrics;
import fr.tylwen.satyria.dynashop.libs.bstats.charts.AdvancedPie;
import fr.tylwen.satyria.dynashop.libs.nbtapi.NBT;
import fr.tylwen.satyria.dynashop.listener.DynaShopListener;
import fr.tylwen.satyria.dynashop.listener.ShopItemPlaceholderListener;
import fr.tylwen.satyria.dynashop.price.DynamicPrice;
import fr.tylwen.satyria.dynashop.price.PriceRecipe;
import fr.tylwen.satyria.dynashop.price.PriceStock;
import fr.tylwen.satyria.dynashop.system.InflationManager;
import fr.tylwen.satyria.dynashop.system.TaxService;
import fr.tylwen.satyria.dynashop.system.TransactionLimiter;
import fr.tylwen.satyria.dynashop.task.WaitForShopsTask;
import fr.tylwen.satyria.dynashop.utils.PriceFormatter;
import fr.tylwen.satyria.dynashop.web.MarketWebServer;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import net.brcdev.shopgui.ShopGuiPlusApi;
import net.brcdev.shopgui.shop.Shop;
import net.brcdev.shopgui.shop.item.ShopItem;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitTask;

public class DynaShopPlugin
extends JavaPlugin {
    private static DynaShopPlugin instance;
    private ShopGUIPlusHook shopGUIPlusHook;
    private YamlConfiguration configMain;
    private YamlConfiguration configLang;
    private StorageManager storageManager;
    private BatchDatabaseUpdater batchDatabaseUpdater;
    private ShopConfigManager shopConfigManager;
    private PriceRecipe priceRecipe;
    private PriceStock priceStock;
    private DataConfig dataConfig;
    private LangConfig langConfig;
    private Logger logger;
    private DynaShopListener dynaShopListener;
    private ShopItemPlaceholderListener shopItemPlaceholderListener;
    private DynaShopExpansion placeholderExpansion;
    private TransactionLimiter transactionLimiter;
    private TaxService taxService;
    private InflationManager inflationManager;
    private PriceFormatter priceFormatter;
    private int dynamicPricesTaskId;
    private int waitForShopsTaskId;
    private MarketWebServer webServer;
    private int webServerPort = 7070;
    private String cacheMode;
    private CacheManager<String, DynamicPrice> priceCache;
    private CacheManager<String, List<ItemStack>> recipeCache;
    private CacheManager<String, Double> calculatedPriceCache;
    private CacheManager<String, Integer> stockCache;
    private CacheManager<String, Map<String, String>> displayPriceCache;
    private CacheManager<String, LimitCacheEntry> limitCache;

    public static DynaShopPlugin getInstance() {
        return instance;
    }

    public DynaShopListener getDynaShopListener() {
        return this.dynaShopListener;
    }

    public ShopItemPlaceholderListener getShopItemPlaceholderListener() {
        return this.shopItemPlaceholderListener;
    }

    public YamlConfiguration getConfigMain() {
        return this.configMain;
    }

    public YamlConfiguration getConfigLang() {
        return this.configLang;
    }

    public PriceFormatter getPriceFormatter() {
        return this.priceFormatter;
    }

    public BatchDatabaseUpdater getBatchDatabaseUpdater() {
        return this.batchDatabaseUpdater;
    }

    public ShopConfigManager getShopConfigManager() {
        return this.shopConfigManager;
    }

    public PriceRecipe getPriceRecipe() {
        return this.priceRecipe;
    }

    public DataConfig getDataConfig() {
        return this.dataConfig;
    }

    public LangConfig getLangConfig() {
        return this.langConfig;
    }

    public PriceStock getPriceStock() {
        return this.priceStock;
    }

    public void setDynamicPricesTaskId(int id) {
        this.dynamicPricesTaskId = id;
    }

    public int getDynamicPricesTaskId() {
        return this.dynamicPricesTaskId;
    }

    public int getWaitForShopsTaskId() {
        return this.waitForShopsTaskId;
    }

    public void setWaitForShopsTaskId(int taskId) {
        this.waitForShopsTaskId = taskId;
    }

    public DynaShopExpansion getPlaceholderExpansion() {
        return this.placeholderExpansion;
    }

    public TransactionLimiter getTransactionLimiter() {
        return this.transactionLimiter;
    }

    public TaxService getTaxService() {
        return this.taxService;
    }

    public InflationManager getInflationManager() {
        return this.inflationManager;
    }

    public void reloadConfigAndCacheMode() {
        this.reloadConfig();
        this.cacheMode = this.getConfig().getString("cache.mode", "full");
    }

    public boolean isRealTimeMode() {
        return "realtime".equalsIgnoreCase(this.cacheMode);
    }

    public MarketWebServer getWebServer() {
        return this.webServer;
    }

    public StorageManager getStorageManager() {
        return this.storageManager;
    }

    public static String getLimitCacheKey(UUID playerUuid, String shopId, String itemId, boolean isBuy) {
        return String.valueOf(playerUuid) + ":" + shopId + ":" + itemId + ":" + (isBuy ? "buy" : "sell");
    }

    public void onEnable() {
        instance = this;
        this.logger = this.getLogger();
        this.init();
        this.initCache();
        this.initTranslation();
        this.hookIntoShopGUIPlus();
        if (this.getServer().getPluginManager().getPlugin("PlaceholderAPI") != null) {
            this.placeholderExpansion = new DynaShopExpansion(this);
            this.placeholderExpansion.register();
            this.getLogger().info("Placeholders enregistr\u00e9s avec PlaceholderAPI !");
        }
        if (!NBT.preloadApi()) {
            this.getLogger().warning("NBT-API wasn't initialized properly, disabling the plugin");
            this.getPluginLoader().disablePlugin((Plugin)this);
            return;
        }
        this.storageManager.initialize();
        this.batchDatabaseUpdater = new BatchDatabaseUpdater(this);
        this.transactionLimiter = new TransactionLimiter(this);
        this.getServer().getPluginManager().registerEvents((Listener)this.dynaShopListener, (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)this.shopItemPlaceholderListener, (Plugin)this);
        boolean webServerEnabled = this.getConfig().getBoolean("web-dashboard.enabled", false);
        if (webServerEnabled) {
            this.webServerPort = this.getConfig().getInt("web-dashboard.port", 7070);
            this.webServer = new MarketWebServer(this, this.webServerPort);
            this.webServer.start();
            this.info("Dashboard web d\u00e9marr\u00e9 sur le port " + this.webServerPort);
        }
        this.getCommand("dynashop").setExecutor((CommandExecutor)new DynaShopCommand(this));
        WaitForShopsTask waitTask = new WaitForShopsTask(this);
        BukkitTask task = this.getServer().getScheduler().runTaskTimer((Plugin)this, (Runnable)waitTask, 0L, 100L);
        waitTask.setSelfTask(task);
        this.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)this, () -> {
            int daysToKeep = this.getConfig().getInt("history.retention-days", 30);
            this.storageManager.purgeOldPriceHistory(daysToKeep);
        }, 216000L, 1728000L);
        Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)this, this::flushAllCachesToStorage, 6000L, 6000L);
        this.getLogger().info("DynaShop activ\u00e9 avec succ\u00e8s !");
    }

    private void init() {
        this.generateFiles();
        this.priceCache = new CacheManager(this, "priceCache", 5L, TimeUnit.MINUTES, 10);
        this.recipeCache = new CacheManager(this, "recipeCache", 10L, TimeUnit.MINUTES, 5);
        this.calculatedPriceCache = new CacheManager(this, "calculatedPriceCache", 5L, TimeUnit.MINUTES, 10);
        this.stockCache = new CacheManager(this, "stockCache", 5L, TimeUnit.MINUTES, 5);
        this.displayPriceCache = new CacheManager(this, "displayPriceCache", 2L, TimeUnit.MINUTES, 20);
        this.limitCache = new CacheManager(this, "limitCache", 5L, TimeUnit.MINUTES, 10);
        this.shopConfigManager = new ShopConfigManager(this);
        this.dataConfig = new DataConfig((FileConfiguration)this.configMain);
        this.langConfig = new LangConfig((FileConfiguration)this.configLang);
        this.dynaShopListener = new DynaShopListener(this);
        this.shopItemPlaceholderListener = new ShopItemPlaceholderListener(this);
        this.priceRecipe = new PriceRecipe(this);
        this.priceStock = new PriceStock(this);
        this.storageManager = this.dataConfig.getDatabaseType().equalsIgnoreCase("flatfile") ? new FlatFileStorageManager(this) : new MySQLStorageManager(this);
        this.taxService = new TaxService(this);
        this.inflationManager = new InflationManager(this);
        this.priceFormatter = new PriceFormatter(this);
    }

    private void initCache() {
        this.cacheMode = this.getConfig().getString("cache.mode", "full");
        int priceDuration = this.configMain.getInt("cache.durations.price", 30);
        int displayDuration = this.configMain.getInt("cache.durations.display", 10);
        int recipeDuration = this.configMain.getInt("cache.durations.recipe", 300);
        int stockDuration = this.configMain.getInt("cache.durations.stock", 20);
        int calculatedDuration = this.configMain.getInt("cache.durations.calculated", 60);
        int limitDuration = this.configMain.getInt("cache.durations.limit", 30);
        if (this.cacheMode.equalsIgnoreCase("realtime")) {
            priceDuration = 5;
            displayDuration = 1;
            stockDuration = 5;
            calculatedDuration = 10;
            limitDuration = 5;
        }
        this.priceCache = new CacheManager(this, "PriceCache", priceDuration, TimeUnit.SECONDS, 10);
        this.recipeCache = new CacheManager(this, "RecipeCache", recipeDuration, TimeUnit.SECONDS, 5);
        this.calculatedPriceCache = new CacheManager(this, "CalculatedPriceCache", calculatedDuration, TimeUnit.SECONDS, 5);
        this.stockCache = new CacheManager(this, "StockCache", stockDuration, TimeUnit.SECONDS, 10);
        this.displayPriceCache = new CacheManager(this, "DisplayPriceCache", displayDuration, TimeUnit.SECONDS, 15);
        this.limitCache = new CacheManager(this, "LimitCache", limitDuration, TimeUnit.SECONDS, 10);
    }

    public CacheManager<String, DynamicPrice> getPriceCache() {
        return this.priceCache;
    }

    public CacheManager<String, List<ItemStack>> getRecipeCache() {
        return this.recipeCache;
    }

    public CacheManager<String, Double> getCalculatedPriceCache() {
        return this.calculatedPriceCache;
    }

    public CacheManager<String, Integer> getStockCache() {
        return this.stockCache;
    }

    public CacheManager<String, Map<String, String>> getDisplayPriceCache() {
        return this.displayPriceCache;
    }

    public CacheManager<String, LimitCacheEntry> getLimitCache() {
        return this.limitCache;
    }

    public void invalidatePriceCache(String shopId, String itemId, Player player) {
        String baseKey = shopId + ":" + itemId;
        if (player != null) {
            String playerKey = baseKey + ":" + player.getUniqueId().toString();
            this.priceCache.invalidate(playerKey);
            this.displayPriceCache.invalidate(playerKey);
        }
        this.priceCache.invalidateWithPrefix(baseKey);
        this.calculatedPriceCache.invalidateWithPrefix(baseKey);
        this.displayPriceCache.invalidateWithPrefix(baseKey);
        this.limitCache.invalidateWithPrefix(baseKey);
        this.stockCache.invalidateWithPrefix(baseKey);
        if (this.getShopConfigManager().getTypeDynaShop(shopId, itemId) == DynaShopType.RECIPE) {
            this.recipeCache.invalidate(baseKey);
        }
        this.debug("Cache invalid\u00e9 pour " + baseKey);
    }

    public void load() {
        this.generateFiles();
        this.dataConfig = new DataConfig((FileConfiguration)this.configMain);
        this.langConfig = new LangConfig((FileConfiguration)this.configLang);
        this.reloadConfigAndCacheMode();
        if (this.taxService != null) {
            this.taxService.loadConfig();
        }
    }

    private void generateFiles() {
        this.saveDefaultConfig();
        File configLangFile = new File(this.getDataFolder(), "lang.yml");
        if (!configLangFile.exists()) {
            this.saveResource("lang.yml", false);
        }
        this.configLang = YamlConfiguration.loadConfiguration((File)configLangFile);
        File configFile = new File(this.getDataFolder(), "config.yml");
        if (!configFile.exists()) {
            this.saveResource("config.yml", false);
        }
        this.configMain = YamlConfiguration.loadConfiguration((File)configFile);
    }

    public void initTranslation() {
        File[] files;
        File translationsDir = new File(this.getDataFolder(), "translations");
        if (!translationsDir.exists()) {
            translationsDir.mkdirs();
            this.saveResource("translations/translations_en.yml", false);
            this.saveResource("translations/translations_fr.yml", false);
        }
        if ((files = translationsDir.listFiles((dir, name) -> name.endsWith(".yml"))) != null) {
            for (File file : files) {
                String fileName = file.getName();
                String locale = "default";
                locale = fileName.startsWith("translations_") && fileName.endsWith(".yml") ? fileName.substring("translations_".length(), fileName.length() - 4) : fileName.replace(".yml", "");
                this.info("fileName" + fileName + " locale: " + locale);
                this.getShopConfigManager().loadTranslationFile(locale, "translations/" + fileName);
            }
        }
    }

    public void setupMetrics() {
        Metrics metrics = new Metrics(this, 25992);
        HashMap cachedStatsMap = new HashMap();
        long[] lastUpdate = new long[]{0L};
        long updatePeriod = 900000L;
        metrics.addCustomChart(new AdvancedPie("type_dynashop_used", () -> {
            long currentTime = System.currentTimeMillis();
            if (currentTime - lastUpdate[0] > 900000L || cachedStatsMap.isEmpty()) {
                this.getServer().getScheduler().runTaskAsynchronously((Plugin)this, () -> {
                    HashMap<String, Integer> newMap = new HashMap<String, Integer>();
                    try {
                        for (Shop shop : ShopGuiPlusApi.getPlugin().getShopManager().getShops()) {
                            for (ShopItem item : shop.getShopItems()) {
                                DynaShopType typeDynaShop = this.shopConfigManager.getTypeDynaShop(shop.getId(), item.getId());
                                String typeName = typeDynaShop.name();
                                newMap.put(typeName, newMap.getOrDefault(typeName, 0) + 1);
                            }
                        }
                        Map map = cachedStatsMap;
                        synchronized (map) {
                            cachedStatsMap.clear();
                            cachedStatsMap.putAll(newMap);
                            lastUpdate[0] = currentTime;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                });
            }
            Map map = cachedStatsMap;
            synchronized (map) {
                return new HashMap(cachedStatsMap);
            }
        }));
    }

    public void reloadData() {
        if (this.storageManager != null) {
            this.flushAllCachesToStorage();
        }
        if (this.batchDatabaseUpdater != null) {
            this.batchDatabaseUpdater.shutdown();
        }
        if (this.storageManager != null) {
            this.storageManager.shutdown();
        }
        this.storageManager = this.dataConfig.getDatabaseType().equalsIgnoreCase("flatfile") ? new FlatFileStorageManager(this) : new MySQLStorageManager(this);
        this.batchDatabaseUpdater = new BatchDatabaseUpdater(this);
        this.transactionLimiter = new TransactionLimiter(this);
        this.initCache();
        this.storageManager.initialize();
        this.getShopConfigManager().initPricesFromShopConfigs();
        this.getStorageManager().cleanupStockTable();
        this.getLogger().info("DynaShop database reloaded successfully.");
    }

    public void flushAllCachesToStorage() {
        this.getLogger().fine("Sauvegarde p\u00e9riodique du cache vers le stockage...");
        for (String key : this.priceCache.keySet()) {
            String[] parts;
            DynamicPrice price = this.priceCache.getIfPresent(key);
            if (price == null || (parts = key.split(":")).length != 2) continue;
            String shopId = parts[0];
            String itemId = parts[1];
            this.storageManager.savePrice(shopId, itemId, price.getBuyPrice(), price.getSellPrice(), price.getStock());
        }
    }

    public void onDisable() {
        if (this.dynamicPricesTaskId != 0) {
            this.getServer().getScheduler().cancelTask(this.dynamicPricesTaskId);
            this.getLogger().info("T\u00e2che DynamicPricesTask annul\u00e9e (ID: " + this.dynamicPricesTaskId + ")");
        }
        if (this.waitForShopsTaskId != 0) {
            this.getServer().getScheduler().cancelTask(this.waitForShopsTaskId);
            this.getLogger().info("T\u00e2che WaitForShopsTask annul\u00e9e (ID: " + this.waitForShopsTaskId + ")");
        }
        if (this.batchDatabaseUpdater != null) {
            this.batchDatabaseUpdater.shutdown();
        }
        if (this.transactionLimiter != null) {
            this.transactionLimiter.shutdown();
        }
        if (this.shopItemPlaceholderListener != null) {
            this.shopItemPlaceholderListener.shutdown();
        }
        if (this.webServer != null) {
            this.webServer.stop();
        }
        if (this.storageManager != null) {
            this.flushAllCachesToStorage();
            this.storageManager.shutdown();
        }
        this.priceCache.clear();
        this.recipeCache.clear();
        this.calculatedPriceCache.clear();
        this.stockCache.clear();
        this.displayPriceCache.clear();
        this.limitCache.clear();
    }

    private void hookIntoShopGUIPlus() {
        if (Bukkit.getPluginManager().getPlugin("ShopGUIPlus") != null) {
            this.shopGUIPlusHook = new ShopGUIPlusHook(this);
            Bukkit.getPluginManager().registerEvents((Listener)this.shopGUIPlusHook, (Plugin)this);
            this.getLogger().info("ShopGUI+ detected.");
        } else {
            this.getLogger().warning("ShopGUI+ not found.");
        }
    }

    public void severe(String string) {
        this.logger.severe(string);
    }

    public void warning(String string) {
        this.logger.warning(string);
    }

    public void info(String string) {
        this.logger.info(string);
    }

    public void debug(String string) {
        if (this.getConfigMain().getBoolean("debug", false)) {
            this.logger.fine(string);
        }
    }
}

