/*
 * Decompiled with CFR 0.152.
 */
package fr.tylwen.satyria.dynashop.command;

import fr.tylwen.satyria.dynashop.DynaShopPlugin;
import fr.tylwen.satyria.dynashop.command.InflationSubCommand;
import fr.tylwen.satyria.dynashop.command.LimitSubCommand;
import fr.tylwen.satyria.dynashop.command.ReloadSubCommand;
import fr.tylwen.satyria.dynashop.command.SubCommand;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;

public class DynaShopCommand
implements CommandExecutor {
    private final DynaShopPlugin plugin;
    private final Map<String, SubCommand> subCommands = new HashMap<String, SubCommand>();

    public DynaShopCommand(DynaShopPlugin plugin) {
        this.plugin = plugin;
        this.registerSubCommand(new ReloadSubCommand(plugin));
        this.registerSubCommand(new InflationSubCommand(plugin));
        this.registerSubCommand(new LimitSubCommand(plugin));
    }

    private void registerSubCommand(SubCommand subCommand) {
        this.subCommands.put(subCommand.getName().toLowerCase(), subCommand);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length == 0) {
            sender.sendMessage("\u00a7eDynaShop Plugin - Version " + this.plugin.getDescription().getVersion());
            sender.sendMessage("\u00a7eUtilisez /dynashop help pour la liste des commandes.");
            return true;
        }
        String subCommandName = args[0].toLowerCase();
        if (subCommandName.equals("help")) {
            this.showHelp(sender);
            return true;
        }
        if (args.length >= 1 && subCommandName.equals("purgehistory")) {
            int days = args.length >= 2 ? Integer.parseInt(args[1]) : 30;
            sender.sendMessage("\u00a7aSuppression des donn\u00e9es d'historique plus anciennes que " + days + " jours...");
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
                this.plugin.getStorageManager().purgeOldPriceHistory(days);
                Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> sender.sendMessage("\u00a7aNettoyage termin\u00e9!"));
            });
            return true;
        }
        SubCommand subCommand = this.subCommands.get(subCommandName);
        if (subCommand == null) {
            sender.sendMessage("\u00a7cCommande inconnue. Utilisez /dynashop help pour la liste des commandes.");
            return true;
        }
        if (!subCommand.getPermission().isEmpty() && !sender.hasPermission(subCommand.getPermission())) {
            sender.sendMessage("\u00a7cVous n'avez pas la permission d'utiliser cette commande.");
            return true;
        }
        String[] subArgs = new String[args.length - 1];
        System.arraycopy(args, 1, subArgs, 0, args.length - 1);
        return subCommand.execute(sender, subArgs);
    }

    private void showHelp(CommandSender sender) {
        sender.sendMessage("\u00a7e--- DynaShop Commands ---");
        for (SubCommand subCommand : this.subCommands.values()) {
            if (!subCommand.getPermission().isEmpty() && !sender.hasPermission(subCommand.getPermission())) continue;
            sender.sendMessage("\u00a7e" + subCommand.getUsage() + " \u00a77- " + subCommand.getDescription());
        }
    }
}

