/*
 * Decompiled with CFR 0.152.
 */
package fr.tylwen.satyria.dynashop.command;

import fr.tylwen.satyria.dynashop.DynaShopPlugin;
import fr.tylwen.satyria.dynashop.command.SubCommand;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.bukkit.command.CommandSender;

public class InflationSubCommand
implements SubCommand {
    private final DynaShopPlugin plugin;

    public InflationSubCommand(DynaShopPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public boolean execute(CommandSender sender, String[] args) {
        String subCommand;
        if (this.plugin.getInflationManager() == null) {
            sender.sendMessage("\u00a7cLe syst\u00e8me d'inflation n'est pas disponible.");
            return true;
        }
        if (args.length == 0) {
            sender.sendMessage("\u00a7c" + this.getUsage());
            return true;
        }
        switch (subCommand = args[0].toLowerCase()) {
            case "info": {
                double factor = this.plugin.getInflationManager().getInflationFactor();
                String status = this.plugin.getInflationManager().isEnabled() ? "\u00a7aactiv\u00e9e" : "\u00a7cd\u00e9sactiv\u00e9e";
                sender.sendMessage("\u00a7e--- Information sur l'inflation ---");
                sender.sendMessage("\u00a77Status: " + status);
                sender.sendMessage("\u00a77Facteur actuel: \u00a7e" + String.format("%.4f", factor) + "x");
                sender.sendMessage("\u00a77Dernier ajustement: \u00a7e" + new SimpleDateFormat("dd/MM/yyyy HH:mm:ss").format(new Date(this.plugin.getStorageManager().getLastInflationUpdate())));
                break;
            }
            case "enable": {
                if (!this.plugin.getInflationManager().isEnabled()) {
                    this.plugin.getInflationManager().setEnabled(true);
                    sender.sendMessage("\u00a7aLe syst\u00e8me d'inflation a \u00e9t\u00e9 activ\u00e9.");
                    break;
                }
                sender.sendMessage("\u00a7cLe syst\u00e8me d'inflation est d\u00e9j\u00e0 actif.");
                break;
            }
            case "disable": {
                if (this.plugin.getInflationManager().isEnabled()) {
                    this.plugin.getInflationManager().setEnabled(false);
                    sender.sendMessage("\u00a7aLe syst\u00e8me d'inflation a \u00e9t\u00e9 d\u00e9sactiv\u00e9.");
                    break;
                }
                sender.sendMessage("\u00a7cLe syst\u00e8me d'inflation est d\u00e9j\u00e0 inactif.");
                break;
            }
            case "reset": {
                this.plugin.getInflationManager().resetInflation();
                sender.sendMessage("\u00a7aLe facteur d'inflation a \u00e9t\u00e9 r\u00e9initialis\u00e9 \u00e0 1.0.");
                break;
            }
            case "update": {
                this.plugin.getInflationManager().updateInflation();
                sender.sendMessage("\u00a7aL'inflation a \u00e9t\u00e9 mise \u00e0 jour manuellement.");
                break;
            }
            default: {
                sender.sendMessage("\u00a7c" + this.getUsage());
            }
        }
        return true;
    }

    @Override
    public String getName() {
        return "inflation";
    }

    @Override
    public String getPermission() {
        return "dynashop.admin";
    }

    @Override
    public String getDescription() {
        return "G\u00e8re le syst\u00e8me d'inflation";
    }

    @Override
    public String getUsage() {
        return "/dynashop inflation [info|enable|disable|reset|update]";
    }
}

