/*
 * Decompiled with CFR 0.152.
 */
package fr.tylwen.satyria.dynashop.command;

import fr.tylwen.satyria.dynashop.DynaShopPlugin;
import fr.tylwen.satyria.dynashop.command.SubCommand;
import fr.tylwen.satyria.dynashop.data.cache.LimitCacheEntry;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class LimitSubCommand
implements SubCommand {
    private final DynaShopPlugin plugin;

    public LimitSubCommand(DynaShopPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public boolean execute(CommandSender sender, String[] args) {
        String subCommand;
        if (args.length < 1) {
            this.showUsage(sender);
            return true;
        }
        switch (subCommand = args[0].toLowerCase()) {
            case "reset": {
                return this.handleResetCommand(sender, args);
            }
            case "info": {
                return this.handleInfoCommand(sender, args);
            }
            case "resetall": {
                return this.handleResetAllCommand(sender, args);
            }
        }
        this.showUsage(sender);
        return true;
    }

    private boolean handleResetCommand(CommandSender sender, String[] args) {
        if (args.length < 2) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /dynashop limit reset <joueur> [shopID] [itemID]");
            return true;
        }
        Player target = Bukkit.getPlayer((String)args[1]);
        if (target == null) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Joueur non trouv\u00e9.");
            return true;
        }
        if (args.length >= 4) {
            String shopID = args[2];
            String itemID = args[3];
            this.plugin.getTransactionLimiter().resetLimits(target, shopID, itemID).thenAccept(success -> {
                if (Boolean.TRUE.equals(success)) {
                    sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Limites r\u00e9initialis\u00e9es pour " + target.getName() + " sur " + shopID + ":" + itemID);
                } else {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "Erreur lors de la r\u00e9initialisation des limites.");
                }
            });
        } else {
            this.plugin.getTransactionLimiter().resetAllLimits(target.getUniqueId()).thenAccept(count -> sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Toutes les limites de " + target.getName() + " ont \u00e9t\u00e9 r\u00e9initialis\u00e9es (" + count + " entr\u00e9es affect\u00e9es)."));
        }
        return true;
    }

    private boolean handleInfoCommand(CommandSender sender, String[] args) {
        if (args.length < 2) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /dynashop limit info <joueur> [shopID] [itemID]");
            return true;
        }
        Player target = Bukkit.getPlayer((String)args[1]);
        if (target == null) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Joueur non trouv\u00e9.");
            return true;
        }
        if (args.length >= 4) {
            String shopID = args[2];
            String itemID = args[3];
            LimitCacheEntry buyLimit = this.plugin.getTransactionLimiter().getTransactionLimit(target, shopID, itemID, true);
            if (buyLimit != null && buyLimit.getLimit() > 0) {
                sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Limites d'achat pour " + target.getName() + " sur " + shopID + ":" + itemID + ":");
                sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "  Limite totale: " + String.valueOf(ChatColor.WHITE) + buyLimit.baseLimit);
                sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "  Restant: " + String.valueOf(ChatColor.WHITE) + buyLimit.remaining);
                if (buyLimit.nextAvailable > 0L) {
                    String formattedTime = this.formatTime(buyLimit.nextAvailable / 1000L);
                    sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "  Prochain reset dans: " + String.valueOf(ChatColor.WHITE) + formattedTime);
                } else {
                    sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "  Prochain reset: " + String.valueOf(ChatColor.WHITE) + "Disponible");
                }
            } else {
                sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Aucune limite d'achat d\u00e9finie pour " + shopID + ":" + itemID);
            }
            LimitCacheEntry sellLimit = this.plugin.getTransactionLimiter().getTransactionLimit(target, shopID, itemID, false);
            if (sellLimit != null && sellLimit.getLimit() > 0) {
                sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Limites de vente pour " + target.getName() + " sur " + shopID + ":" + itemID + ":");
                sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "  Limite totale: " + String.valueOf(ChatColor.WHITE) + sellLimit.baseLimit);
                sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "  Restant: " + String.valueOf(ChatColor.WHITE) + sellLimit.remaining);
                if (sellLimit.nextAvailable > 0L) {
                    String formattedTime = this.formatTime(sellLimit.nextAvailable / 1000L);
                    sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "  Prochain reset dans: " + String.valueOf(ChatColor.WHITE) + formattedTime);
                } else {
                    sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "  Prochain reset: " + String.valueOf(ChatColor.WHITE) + "Disponible");
                }
            } else {
                sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Aucune limite de vente d\u00e9finie pour " + shopID + ":" + itemID);
            }
        } else {
            this.plugin.getTransactionLimiter().getStatistics().thenAccept(stats -> {
                sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Statistiques globales pour " + target.getName() + ":");
                if (stats.containsKey("total_records")) {
                    sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "  Transactions totales: " + String.valueOf(ChatColor.WHITE) + String.valueOf(stats.get("total_records")));
                }
                if (stats.containsKey("count_buy")) {
                    sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "  Achats: " + String.valueOf(ChatColor.WHITE) + String.valueOf(stats.get("count_buy")));
                }
                if (stats.containsKey("count_sell")) {
                    sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "  Ventes: " + String.valueOf(ChatColor.WHITE) + String.valueOf(stats.get("count_sell")));
                }
                if (stats.containsKey("oldest_record")) {
                    sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "  Plus ancienne transaction: " + String.valueOf(ChatColor.WHITE) + String.valueOf(stats.get("oldest_record")));
                }
            });
        }
        return true;
    }

    private boolean handleResetAllCommand(CommandSender sender, String[] args) {
        if (args.length < 2) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /dynashop limit resetall <all|joueur>");
            return true;
        }
        String target = args[1].toLowerCase();
        if ("all".equals(target)) {
            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "R\u00e9initialisation de toutes les limites pour tous les joueurs...");
            this.plugin.getTransactionLimiter().resetAllLimits();
            sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Toutes les limites ont \u00e9t\u00e9 r\u00e9initialis\u00e9es.");
        } else {
            Player targetPlayer = Bukkit.getPlayer((String)target);
            if (targetPlayer == null) {
                UUID targetUUID = null;
                try {
                    targetUUID = UUID.fromString(target);
                }
                catch (IllegalArgumentException e) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "Joueur non trouv\u00e9.");
                    return true;
                }
                UUID finalUUID = targetUUID;
                this.plugin.getTransactionLimiter().resetAllLimits(finalUUID).thenAccept(count -> sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Toutes les limites du joueur UUID:" + String.valueOf(finalUUID) + " ont \u00e9t\u00e9 r\u00e9initialis\u00e9es (" + count + " entr\u00e9es affect\u00e9es)."));
            } else {
                this.plugin.getTransactionLimiter().resetAllLimits(targetPlayer.getUniqueId()).thenAccept(count -> sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Toutes les limites de " + targetPlayer.getName() + " ont \u00e9t\u00e9 r\u00e9initialis\u00e9es (" + count + " entr\u00e9es affect\u00e9es)."));
            }
        }
        return true;
    }

    private void showUsage(CommandSender sender) {
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "=== Commandes de gestion des limites ===");
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/dynashop limit reset <joueur> [shopID] [itemID]" + String.valueOf(ChatColor.GRAY) + " - R\u00e9initialise les limites");
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/dynashop limit info <joueur> [shopID] [itemID]" + String.valueOf(ChatColor.GRAY) + " - Affiche les informations sur les limites");
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/dynashop limit resetall <all|joueur>" + String.valueOf(ChatColor.GRAY) + " - R\u00e9initialise toutes les limites");
    }

    private String formatTime(long seconds) {
        if (seconds < 60L) {
            return seconds + " secondes";
        }
        if (seconds < 3600L) {
            return seconds / 60L + " minutes " + seconds % 60L + " secondes";
        }
        if (seconds < 86400L) {
            return seconds / 3600L + " heures " + seconds % 3600L / 60L + " minutes";
        }
        return seconds / 86400L + " jours " + seconds % 86400L / 3600L + " heures";
    }

    @Override
    public String getName() {
        return "limit";
    }

    @Override
    public String getPermission() {
        return "dynashop.admin.limit";
    }

    @Override
    public String getDescription() {
        return "G\u00e8re les limites de transaction des joueurs";
    }

    @Override
    public String getUsage() {
        return "/dynashop limit [reset|info|resetall] <joueur> [shopID] [itemID]";
    }
}

