/*
 * Decompiled with CFR 0.152.
 */
package fr.tylwen.satyria.dynashop.compatibility;

import fr.tylwen.satyria.dynashop.DynaShopPlugin;
import fr.tylwen.satyria.dynashop.compatibility.ItemNameProvider;
import fr.tylwen.satyria.dynashop.compatibility.ItemNameProviderFallback;
import fr.tylwen.satyria.dynashop.compatibility.versions.ItemNameProvider_1_16;
import fr.tylwen.satyria.dynashop.compatibility.versions.ItemNameProvider_1_17;
import fr.tylwen.satyria.dynashop.compatibility.versions.ItemNameProvider_1_18;
import fr.tylwen.satyria.dynashop.compatibility.versions.ItemNameProvider_1_19;
import fr.tylwen.satyria.dynashop.compatibility.versions.ItemNameProvider_1_20;
import fr.tylwen.satyria.dynashop.compatibility.versions.ItemNameProvider_1_21;
import fr.tylwen.satyria.dynashop.libs.nbtapi.utils.MinecraftVersion;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class ItemNameManager {
    private static ItemNameProvider provider;
    private static final Logger logger;

    public static String getLocalizedName(ItemStack item, Player player) {
        if (item == null) {
            return "Item inconnu";
        }
        try {
            String name = provider.getLocalizedName(item, player);
            DynaShopPlugin.getInstance().info("Nom localis\u00e9 r\u00e9cup\u00e9r\u00e9: " + name);
            return name != null ? name : ItemNameManager.formatMaterialName(item.getType().name());
        }
        catch (Exception e) {
            logger.warning("[DynaShopGUI+] Erreur lors de la r\u00e9cup\u00e9ration du nom localis\u00e9: " + e.getMessage());
            return ItemNameManager.formatMaterialName(item.getType().name());
        }
    }

    private static String formatMaterialName(String materialName) {
        String[] words = materialName.toLowerCase().split("_");
        StringBuilder result = new StringBuilder();
        for (String word : words) {
            if (word.isEmpty()) continue;
            result.append(Character.toUpperCase(word.charAt(0))).append(word.substring(1)).append(" ");
        }
        return result.toString().trim();
    }

    static {
        logger = Bukkit.getLogger();
        String version = MinecraftVersion.getVersion().getPackageName();
        DynaShopPlugin.getInstance().info(version);
        if (version != null) {
            try {
                if (version.startsWith("v1_21_")) {
                    provider = new ItemNameProvider_1_21();
                } else if (version.startsWith("v1_20_")) {
                    provider = new ItemNameProvider_1_20();
                } else if (version.startsWith("v1_19_")) {
                    provider = new ItemNameProvider_1_19();
                } else if (version.startsWith("v1_18_")) {
                    provider = new ItemNameProvider_1_18();
                } else if (version.startsWith("v1_17_")) {
                    provider = new ItemNameProvider_1_17();
                } else if (version.startsWith("v1_16_")) {
                    provider = new ItemNameProvider_1_16();
                }
            }
            catch (Exception e) {
                logger.warning("[DynaShopGUI+] Erreur lors de la d\u00e9tection du fournisseur de noms d'items: " + e.getMessage());
            }
        }
        if (provider == null) {
            provider = new ItemNameProviderFallback();
            logger.warning("[DynaShopGUI+] Aucun fournisseur de noms d'items compatible trouv\u00e9. Utilisation du fallback.");
        } else {
            logger.info("[DynaShopGUI+] Utilisation du fournisseur: " + provider.getClass().getSimpleName());
        }
    }
}

