/*
 * Decompiled with CFR 0.152.
 */
package fr.tylwen.satyria.dynashop.compatibility;

import fr.tylwen.satyria.dynashop.compatibility.ItemNameProvider;
import java.lang.reflect.Method;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ItemNameProviderFallback
implements ItemNameProvider {
    @Override
    public String getLocalizedName(ItemStack item, Player player) {
        if (item.hasItemMeta()) {
            ItemMeta meta = item.getItemMeta();
            if (meta != null && meta.hasDisplayName()) {
                return ChatColor.stripColor((String)meta.getDisplayName());
            }
            try {
                String localizedName;
                Method getLocalizedNameMethod = ItemMeta.class.getMethod("getLocalizedName", new Class[0]);
                if (getLocalizedNameMethod != null && (localizedName = (String)getLocalizedNameMethod.invoke((Object)meta, new Object[0])) != null && !localizedName.isEmpty()) {
                    return localizedName;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        String materialName = item.getType().name();
        return this.formatMaterialName(materialName);
    }

    @Override
    public boolean isCompatible() {
        return true;
    }

    private String formatMaterialName(String materialName) {
        String[] words = materialName.toLowerCase().split("_");
        StringBuilder result = new StringBuilder();
        for (String word : words) {
            if (word.isEmpty()) continue;
            result.append(Character.toUpperCase(word.charAt(0))).append(word.substring(1)).append(" ");
        }
        return result.toString().trim();
    }
}

