/*
 * Decompiled with CFR 0.152.
 */
package fr.tylwen.satyria.dynashop.compatibility.versions;

import fr.tylwen.satyria.dynashop.compatibility.ItemNameProvider;
import java.lang.reflect.Method;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class ItemNameProvider_1_19
implements ItemNameProvider {
    private static final String[] POSSIBLE_VERSIONS = new String[]{"v1_19_R1", "v1_19_R2", "v1_19_R3"};
    private String detectedVersion = this.detectServerVersion();
    private Class<?> craftItemStackClass;
    private Class<?> nmsItemStackClass;
    private Method asNMSCopyMethod;
    private Method getNameMethod;
    private Method getStringMethod;

    public ItemNameProvider_1_19() {
        if (this.detectedVersion != null) {
            try {
                this.craftItemStackClass = Class.forName("org.bukkit.craftbukkit." + this.detectedVersion + ".inventory.CraftItemStack");
                this.nmsItemStackClass = Class.forName("net.minecraft.server." + this.detectedVersion + ".ItemStack");
                this.asNMSCopyMethod = this.craftItemStackClass.getMethod("asNMSCopy", ItemStack.class);
                this.getNameMethod = this.nmsItemStackClass.getMethod("getName", new Class[0]);
                Class<?> iChatBaseComponentClass = Class.forName("net.minecraft.server." + this.detectedVersion + ".IChatBaseComponent");
                this.getStringMethod = iChatBaseComponentClass.getMethod("getString", new Class[0]);
                Bukkit.getLogger().info("[DynaShopGUI+] Version 1.19 d\u00e9tect\u00e9e: " + this.detectedVersion);
            }
            catch (Exception e) {
                Bukkit.getLogger().warning("[DynaShopGUI+] \u00c9chec du chargement du fournisseur 1.19: " + e.getMessage());
            }
        }
    }

    private String detectServerVersion() {
        try {
            Class serverClass = Bukkit.getServer().getClass();
            String packageName = serverClass.getPackage().getName();
            return packageName.substring(packageName.lastIndexOf(46) + 1);
        }
        catch (Exception e) {
            for (String version : POSSIBLE_VERSIONS) {
                try {
                    Class.forName("org.bukkit.craftbukkit." + version + ".CraftServer");
                    return version;
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
            }
            return null;
        }
    }

    @Override
    public String getLocalizedName(ItemStack item, Player player) {
        try {
            Object nmsItem = this.asNMSCopyMethod.invoke(null, item);
            Object nameComponent = this.getNameMethod.invoke(nmsItem, new Object[0]);
            return (String)this.getStringMethod.invoke(nameComponent, new Object[0]);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public boolean isCompatible() {
        return this.detectedVersion != null && this.craftItemStackClass != null && this.nmsItemStackClass != null;
    }
}

