/*
 * Decompiled with CFR 0.152.
 */
package fr.tylwen.satyria.dynashop.compatibility.versions;

import fr.tylwen.satyria.dynashop.compatibility.ItemNameProvider;
import fr.tylwen.satyria.dynashop.libs.nbtapi.utils.MinecraftVersion;
import java.lang.reflect.Method;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class ItemNameProvider_1_20
implements ItemNameProvider {
    private String detectedVersion = MinecraftVersion.getVersion().getPackageName();
    private Class<?> craftItemStackClass;
    private Method asNMSCopyMethod;
    private Method getItemMethod;
    private Method getDescriptionMethod;
    private Method getStringMethod;

    public ItemNameProvider_1_20() {
        if (this.detectedVersion != null) {
            try {
                this.craftItemStackClass = Class.forName("org.bukkit.craftbukkit." + this.detectedVersion + ".inventory.CraftItemStack");
                this.asNMSCopyMethod = this.craftItemStackClass.getMethod("asNMSCopy", ItemStack.class);
                Class<?> nmsItemStackClass = this.asNMSCopyMethod.getReturnType();
                this.getItemMethod = nmsItemStackClass.getMethod("getItem", new Class[0]);
                Class<?> nmsItemClass = this.getItemMethod.getReturnType();
                this.getDescriptionMethod = nmsItemClass.getMethod("getDescription", new Class[0]);
                Class<?> componentClass = this.getDescriptionMethod.getReturnType();
                this.getStringMethod = componentClass.getMethod("getString", new Class[0]);
            }
            catch (Exception e) {
                Bukkit.getLogger().warning("[DynaShopGUI+] \u00c9chec du chargement du fournisseur 1.20: " + e.getMessage());
            }
        }
    }

    @Override
    public String getLocalizedName(ItemStack item, Player player) {
        if (!this.isCompatible() || item == null) {
            return null;
        }
        try {
            Object nmsItemStack = this.asNMSCopyMethod.invoke(null, item);
            Object nmsItem = this.getItemMethod.invoke(nmsItemStack, new Object[0]);
            Object nameComponent = this.getDescriptionMethod.invoke(nmsItem, new Object[0]);
            return (String)this.getStringMethod.invoke(nameComponent, new Object[0]);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public boolean isCompatible() {
        return this.detectedVersion != null && this.craftItemStackClass != null && this.asNMSCopyMethod != null && this.getItemMethod != null && this.getDescriptionMethod != null && this.getStringMethod != null;
    }
}

