/*
 * Decompiled with CFR 0.152.
 */
package fr.tylwen.satyria.dynashop.config;

import org.bukkit.configuration.file.FileConfiguration;

public class DataConfig {
    private final FileConfiguration config;
    private final String databaseType;
    private final String databaseHost;
    private final int databasePort;
    private final String databaseName;
    private final String databaseUsername;
    private final String databasePassword;
    private final String databaseTablePrefix;
    private final int dynamicPriceDuration;
    private final long guiRefreshDefaultItems;
    private final long guiRefreshCriticalItems;
    private final double priceMinMultiply;
    private final double priceMaxMultiply;
    private final double priceMin;
    private final double priceMax;
    private final double priceMargin;
    private final double buyGrowthRate;
    private final double buyDecayRate;
    private final double sellGrowthRate;
    private final double sellDecayRate;
    private final double priceIncrease;
    private final double priceDecrease;
    private final int stockMin;
    private final int stockMax;
    private final double stockBuyModifier;
    private final double stockSellModifier;
    private final double shapedValue;
    private final double shapelessValue;
    private final double furnaceValue;
    private final double stonecutterValue;

    public DataConfig(FileConfiguration config) {
        this.config = config;
        this.databaseType = config.getString("database.type", "flatfile").toLowerCase();
        this.databaseHost = config.getString("database.mysql.host", "localhost");
        this.databasePort = config.getInt("database.mysql.port", 3306);
        this.databaseName = config.getString("database.mysql.name", "dynashop");
        this.databaseUsername = config.getString("database.mysql.username", "root");
        this.databasePassword = config.getString("database.mysql.password", "");
        this.databaseTablePrefix = config.getString("database.table-prefix", "dynashop");
        this.dynamicPriceDuration = config.getInt("time-period", 5);
        this.priceMinMultiply = config.getDouble("default.price-min-multiply", 0.5);
        this.priceMaxMultiply = config.getDouble("default.price-max-multiply", 2.0);
        this.priceMin = config.getDouble("default.price-min", 0.01);
        this.priceMax = config.getDouble("default.price-max", 1000.0);
        this.priceMargin = config.getDouble("default.price-margin", 0.1);
        this.buyGrowthRate = config.getDouble("default.buy-growth-rate", 1.00005);
        this.buyDecayRate = config.getDouble("default.buy-decay-rate", 0.99998);
        this.sellGrowthRate = config.getDouble("default.sell-growth-rate", 1.00002);
        this.sellDecayRate = config.getDouble("default.sell-decay-rate", 0.99995);
        this.priceIncrease = config.getDouble("default.price-increase", 1.001);
        this.priceDecrease = config.getDouble("default.price-decrease", 0.999);
        this.stockMin = config.getInt("default.stock-min", 0);
        this.stockMax = config.getInt("default.stock-max", Integer.MAX_VALUE);
        this.stockBuyModifier = config.getDouble("default.stock-buy-modifier", 0.5);
        this.stockSellModifier = config.getDouble("default.stock-sell-modifier", 2.0);
        this.shapedValue = config.getDouble("recipe.shaped", 1.0);
        this.shapelessValue = config.getDouble("recipe.shapeless", 1.0);
        this.furnaceValue = config.getDouble("recipe.furnace", 1.0);
        this.stonecutterValue = config.getDouble("recipe.stonecutter", 1.0);
        this.guiRefreshDefaultItems = config.getLong("gui.refresh.default-items", 1000L);
        this.guiRefreshCriticalItems = config.getLong("gui.refresh.critical-items", 300L);
    }

    public String getDatabaseType() {
        return this.databaseType;
    }

    public String getDatabaseHost() {
        return this.databaseHost;
    }

    public int getDatabasePort() {
        return this.databasePort;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getDatabaseUsername() {
        return this.databaseUsername;
    }

    public String getDatabasePassword() {
        return this.databasePassword;
    }

    public String getDatabaseTablePrefix() {
        return this.databaseTablePrefix;
    }

    public int getDynamicPriceDuration() {
        return this.dynamicPriceDuration;
    }

    public double getPriceMinMultiply() {
        return this.priceMinMultiply;
    }

    public double getPriceMaxMultiply() {
        return this.priceMaxMultiply;
    }

    public double getPriceMin() {
        return this.priceMin;
    }

    public double getPriceMax() {
        return this.priceMax;
    }

    public double getPriceMargin() {
        return this.priceMargin;
    }

    public double getBuyGrowthRate() {
        return this.buyGrowthRate;
    }

    public double getBuyDecayRate() {
        return this.buyDecayRate;
    }

    public double getSellGrowthRate() {
        return this.sellGrowthRate;
    }

    public double getSellDecayRate() {
        return this.sellDecayRate;
    }

    public double getPriceIncrease() {
        return this.priceIncrease;
    }

    public double getPriceDecrease() {
        return this.priceDecrease;
    }

    public int getStockMin() {
        return this.stockMin;
    }

    public int getStockMax() {
        return this.stockMax;
    }

    public double getStockBuyModifier() {
        return this.stockBuyModifier;
    }

    public double getStockSellModifier() {
        return this.stockSellModifier;
    }

    public double getShapedValue() {
        return this.shapedValue;
    }

    public double getShapelessValue() {
        return this.shapelessValue;
    }

    public double getFurnaceValue() {
        return this.furnaceValue;
    }

    public double getStonecutterValue() {
        return this.config.getDouble("recipe.stonecutter", 1.0);
    }

    public double getSmithingValue() {
        return this.config.getDouble("recipe.smithing", 1.0);
    }

    public long getGuiRefreshDefaultItems() {
        return this.guiRefreshDefaultItems;
    }

    public long getGuiRefreshCriticalItems() {
        return this.guiRefreshCriticalItems;
    }
}

