/*
 * Decompiled with CFR 0.152.
 */
package fr.tylwen.satyria.dynashop.data;

import fr.tylwen.satyria.dynashop.DynaShopPlugin;
import fr.tylwen.satyria.dynashop.compatibility.ItemNameManager;
import fr.tylwen.satyria.dynashop.data.ItemPriceData;
import fr.tylwen.satyria.dynashop.data.ShopFile;
import fr.tylwen.satyria.dynashop.data.cache.CacheManager;
import fr.tylwen.satyria.dynashop.data.param.DynaShopType;
import fr.tylwen.satyria.dynashop.data.param.RecipeType;
import fr.tylwen.satyria.dynashop.libs.nbtapi.NBT;
import fr.tylwen.satyria.dynashop.price.DynamicPrice;
import java.io.File;
import java.lang.invoke.CallSite;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import net.brcdev.shopgui.ShopGuiPlusApi;
import net.brcdev.shopgui.shop.Shop;
import net.brcdev.shopgui.shop.item.ShopItem;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class ShopConfigManager {
    private final DynaShopPlugin plugin;
    private final File shopConfigFolder;
    private final Map<ShopItem, DynamicPrice> priceMap = new HashMap<ShopItem, DynamicPrice>();
    private CacheManager<String, YamlConfiguration> shopConfigCache;
    private CacheManager<String, ConfigurationSection> sectionCache;
    private CacheManager<String, RecipeType> recipeTypeCache;
    private CacheManager<String, YamlConfiguration> translationsCache;

    public ShopConfigManager(DynaShopPlugin plugin) {
        this.plugin = plugin;
        this.shopConfigFolder = new File(Bukkit.getPluginManager().getPlugin("ShopGUIPlus").getDataFolder(), "shops/");
        this.shopConfigCache = new CacheManager(plugin, "ShopConfigCache", 1L, TimeUnit.DAYS, 5);
        this.sectionCache = new CacheManager(plugin, "SectionCache", 1L, TimeUnit.DAYS, 10);
        this.recipeTypeCache = new CacheManager(plugin, "RecipeTypeCache", 1L, TimeUnit.DAYS, 5);
        this.translationsCache = new CacheManager(plugin, "TranslationsCache", 1L, TimeUnit.DAYS, 5);
    }

    public YamlConfiguration getShopConfig(String shopID) {
        return this.shopConfigCache.get(shopID, () -> {
            File shopFile = ShopFile.getFileByShopID(shopID);
            if (shopFile == null || !shopFile.exists()) {
                return new YamlConfiguration();
            }
            return YamlConfiguration.loadConfiguration((File)shopFile);
        });
    }

    public Set<String> getShops() {
        HashSet<String> shopIds = new HashSet<String>();
        try {
            Set shops = ShopGuiPlusApi.getPlugin().getShopManager().getShops();
            for (Shop shop : shops) {
                shopIds.add(shop.getId());
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Erreur lors de la r\u00e9cup\u00e9ration des shops: " + e.getMessage());
            e.printStackTrace();
        }
        return shopIds;
    }

    public Set<String> getShopItems(String shopId) {
        HashSet<String> itemIds = new HashSet<String>();
        try {
            Shop shop = ShopGuiPlusApi.getPlugin().getShopManager().getShopById(shopId);
            if (shop != null) {
                List shopItems = shop.getShopItems();
                for (ShopItem item : shopItems) {
                    itemIds.add(item.getId());
                }
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Erreur lors de la r\u00e9cup\u00e9ration des items du shop " + shopId + ": " + e.getMessage());
            e.printStackTrace();
        }
        return itemIds;
    }

    public ConfigurationSection getCachedSection(String shopID, String itemID, String section) {
        String cacheKey = shopID + ":" + itemID + ":" + section;
        return this.sectionCache.get(cacheKey, () -> {
            YamlConfiguration config = this.getShopConfig(shopID);
            ConfigurationSection shopSection = config.getConfigurationSection(shopID);
            if (shopSection == null) {
                return null;
            }
            ConfigurationSection itemsSection = shopSection.getConfigurationSection("items");
            if (itemsSection == null) {
                return null;
            }
            ConfigurationSection itemSection = itemsSection.getConfigurationSection(itemID);
            if (itemSection == null) {
                return null;
            }
            String[] sectionParts = section.split("\\.");
            ConfigurationSection currentSection = itemSection;
            for (int i = 0; i < sectionParts.length; ++i) {
                String sectionPart = sectionParts[i];
                if ((currentSection = this.findSectionIgnoreCase(currentSection, sectionPart)) == null) {
                    return null;
                }
                if (i != sectionParts.length - 1) continue;
                return currentSection;
            }
            return null;
        });
    }

    public boolean hasSection(String shopID, String itemID, String section) {
        return this.getCachedSection(shopID, itemID, section) != null;
    }

    public void reloadCache() {
        this.shopConfigCache.clear();
        this.sectionCache.clear();
        this.recipeTypeCache.clear();
        File shopDir = this.getShopDirectory();
        if (shopDir != null && shopDir.exists()) {
            ShopFile.loadShopFiles(shopDir);
            for (String shopID : ShopFile.getAllShopIDs()) {
                this.getShopConfig(shopID);
            }
        }
        this.translationsCache.clear();
        this.plugin.initTranslation();
    }

    public void initPricesFromShopConfigs() {
        File shopDir = this.getShopDirectory();
        if (shopDir == null || !shopDir.exists()) {
            return;
        }
        this.plugin.getStorageManager().loadAllPrices();
        ShopFile.loadShopFiles(shopDir);
        for (File file : ShopFile.getShopFiles()) {
            this.processShopFile(file);
        }
    }

    public File getShopDirectory() {
        return this.shopConfigFolder;
    }

    private void processShopFile(File file) {
        YamlConfiguration cfg = YamlConfiguration.loadConfiguration((File)file);
        for (String shopKey : cfg.getKeys(false)) {
            ConfigurationSection shopSec = cfg.getConfigurationSection(shopKey);
            if (shopSec == null) continue;
            this.processShopSection(shopKey, shopSec);
        }
    }

    private void processShopSection(String shopKey, ConfigurationSection shopSec) {
        ConfigurationSection itemsSec = shopSec.getConfigurationSection("items");
        if (itemsSec == null) {
            return;
        }
        Shop shop = ShopGuiPlusApi.getPlugin().getShopManager().getShopById(shopKey);
        if (shop == null) {
            return;
        }
        for (String key : itemsSec.getKeys(false)) {
            this.processItem(shop, key, itemsSec.getConfigurationSection(key));
        }
    }

    private void processItem(Shop shop, String key, ConfigurationSection itemSec) {
        if (itemSec == null) {
            return;
        }
        ShopItem item = shop.getShopItems().stream().filter(i -> i.getId().equals(key)).findFirst().orElse(null);
        if (item == null) {
            return;
        }
        DynaShopType typeGeneral = this.getTypeDynaShop(shop.getId(), item.getId());
        if (!itemSec.isConfigurationSection("buyDynamic") && !itemSec.isConfigurationSection("sellDynamic") && typeGeneral != DynaShopType.STATIC_STOCK) {
            if (this.plugin.getStorageManager().itemExists(shop.getId(), item.getId())) {
                this.plugin.getStorageManager().deleteItem(shop.getId(), item.getId());
            }
            this.priceMap.remove(item);
            return;
        }
        DynamicPrice price = this.createDynamicPrice(itemSec);
        DynaShopType typeBuy = this.getTypeDynaShop(shop.getId(), item.getId(), "buy");
        DynaShopType typeSell = this.getTypeDynaShop(shop.getId(), item.getId(), "sell");
        price.setDynaShopType(typeGeneral);
        price.setBuyTypeDynaShop(typeBuy);
        price.setSellTypeDynaShop(typeSell);
        this.priceMap.put(item, price);
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            if (!this.plugin.getStorageManager().itemExists(shop.getId(), item.getId())) {
                if (price.getBuyPrice() > 0.0) {
                    this.plugin.getStorageManager().saveBuyPrice(shop.getId(), item.getId(), price.getBuyPrice());
                }
                if (price.getSellPrice() > 0.0) {
                    this.plugin.getStorageManager().saveSellPrice(shop.getId(), item.getId(), price.getSellPrice());
                }
                if ((typeGeneral == DynaShopType.STATIC_STOCK || typeGeneral == DynaShopType.STOCK) && price.getStock() > 0) {
                    this.plugin.getStorageManager().saveStock(shop.getId(), item.getId(), price.getStock());
                }
            }
        });
    }

    private DynamicPrice createDynamicPrice(ConfigurationSection itemSec) {
        double baseSell;
        double baseBuy;
        double minBuy = baseBuy = itemSec.getDouble("buyPrice", -1.0);
        double maxBuy = baseBuy;
        double growthBuy = 1.0;
        double decayBuy = 1.0;
        if (itemSec.isConfigurationSection("buyDynamic")) {
            ConfigurationSection bp = itemSec.getConfigurationSection("buyDynamic");
            minBuy = bp.getDouble("min", 0.0);
            maxBuy = bp.getDouble("max", Double.MAX_VALUE);
            growthBuy = bp.getDouble("growth", 1.05);
            decayBuy = bp.getDouble("decay", 0.98);
        }
        double minSell = baseSell = itemSec.getDouble("sellPrice", -1.0);
        double maxSell = baseSell;
        double growthSell = 1.0;
        double decaySell = 1.0;
        if (itemSec.isConfigurationSection("sellDynamic")) {
            ConfigurationSection sp = itemSec.getConfigurationSection("sellDynamic");
            minSell = sp.getDouble("min", 0.0);
            maxSell = sp.getDouble("max", Double.MAX_VALUE);
            growthSell = sp.getDouble("growth", 1.02);
            decaySell = sp.getDouble("decay", 0.95);
        }
        int stock = 0;
        int minStock = 0;
        int maxStock = Integer.MAX_VALUE;
        double buyModifier = 1.0;
        double sellModifier = 1.0;
        if (itemSec.isConfigurationSection("stock")) {
            ConfigurationSection stockSec = itemSec.getConfigurationSection("stock");
            stock = stockSec.getInt("base", 0);
            minStock = stockSec.getInt("min", 0);
            maxStock = stockSec.getInt("max", Integer.MAX_VALUE);
            buyModifier = stockSec.getDouble("buyModifier", 0.5);
            sellModifier = stockSec.getDouble("sellModifier", 2.0);
        }
        return new DynamicPrice(baseBuy, baseSell, minBuy, maxBuy, minSell, maxSell, growthBuy, decayBuy, growthSell, decaySell, stock, minStock, maxStock, buyModifier, sellModifier);
    }

    public boolean hasDynamicSection(String shopID, String itemID) {
        return this.hasBuyDynamicSection(shopID, itemID) || this.hasSellDynamicSection(shopID, itemID);
    }

    public boolean hasBuyDynamicSection(String shopID, String itemID) {
        return this.hasSection(shopID, itemID, "buyDynamic");
    }

    public boolean hasSellDynamicSection(String shopID, String itemID) {
        return this.hasSection(shopID, itemID, "sellDynamic");
    }

    public boolean hasStockSection(String shopID, String itemID) {
        return this.hasSection(shopID, itemID, "stock");
    }

    public boolean hasRecipeSection(String shopID, String itemID) {
        return this.hasSection(shopID, itemID, "recipe");
    }

    public boolean hasRecipeType(String shopID, String itemID) {
        return this.hasSection(shopID, itemID, "recipe.type");
    }

    public boolean hasRecipePattern(String shopID, String itemID) {
        YamlConfiguration config = this.getShopConfig(shopID);
        if (config == null) {
            return false;
        }
        String path = shopID + ".items." + itemID + ".recipe.pattern";
        return config.isList(path) && !config.getStringList(path).isEmpty();
    }

    public boolean hasRecipeIngredients(String shopID, String itemID) {
        return this.hasSection(shopID, itemID, "recipe.ingredients");
    }

    public boolean hasDynaShopSection(String shopID, String itemID) {
        return this.hasSection(shopID, itemID, "typeDynaShop");
    }

    public DynaShopType resolveTypeDynaShop(String shopID, String itemID, boolean isBuy) {
        return this.getTypeDynaShop(shopID, itemID, isBuy ? "buy" : "sell");
    }

    public DynaShopType getTypeDynaShop(String shopID, String itemID, String priceType) {
        String key = priceType.equalsIgnoreCase("buy") ? "dynaShop.buyType" : "dynaShop.sellType";
        Optional<String> typeOpt = this.getItemValue(shopID, itemID, key, String.class);
        if (typeOpt.isPresent()) {
            try {
                return DynaShopType.valueOf(typeOpt.get().toUpperCase());
            }
            catch (IllegalArgumentException e) {
                return DynaShopType.NONE;
            }
        }
        return this.getTypeDynaShop(shopID, itemID);
    }

    public DynaShopType getTypeDynaShop(String shopID, String itemID) {
        String type = this.getItemValue(shopID, itemID, "typeDynaShop", String.class).orElse("NONE");
        try {
            return DynaShopType.valueOf(type.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            return DynaShopType.NONE;
        }
    }

    public DynaShopType getRealTypeDynaShop(String shopId, String itemId, String priceType) {
        HashSet<CallSite> visited = new HashSet<CallSite>();
        String key = shopId + ":" + itemId;
        visited.add((CallSite)((Object)key));
        DynaShopType type = this.getTypeDynaShop(shopId, itemId, priceType);
        while (type == DynaShopType.LINK) {
            String linkedItemRef = this.getItemValue(shopId, itemId, "link", String.class).orElse(null);
            if (linkedItemRef == null || !linkedItemRef.contains(":")) {
                return type;
            }
            String[] parts = linkedItemRef.split(":");
            if (parts.length != 2) {
                return type;
            }
            String linkedShopId = parts[0];
            String linkedItemId = parts[1];
            String linkedKey = linkedShopId + ":" + linkedItemId;
            if (visited.contains(linkedKey)) {
                return type;
            }
            visited.add((CallSite)((Object)linkedKey));
            shopId = linkedShopId;
            itemId = linkedItemId;
            type = this.getTypeDynaShop(shopId, itemId, priceType);
        }
        return type;
    }

    public Map<String, DynaShopType> getAllTypeDynaShop(String shopID, String itemID) {
        HashMap<String, DynaShopType> types = new HashMap<String, DynaShopType>();
        types.put("buy", this.getTypeDynaShop(shopID, itemID, "buy"));
        types.put("sell", this.getTypeDynaShop(shopID, itemID, "sell"));
        return types;
    }

    public RecipeType getTypeRecipe(String shopID, String itemID) {
        String key = shopID + ":" + itemID;
        return this.recipeTypeCache.get(key, () -> {
            String type = this.getItemValue(shopID, itemID, "recipe.type", String.class).orElse("NONE");
            try {
                return RecipeType.valueOf(type.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                return RecipeType.NONE;
            }
        });
    }

    public <T> Optional<T> getItemValue(String shopID, String itemID, String key, Class<T> type) {
        YamlConfiguration config = this.getShopConfig(shopID);
        ConfigurationSection shopSection = config.getConfigurationSection(shopID);
        if (shopSection == null && (shopSection = this.findSectionIgnoreCase((ConfigurationSection)config, shopID)) == null) {
            return Optional.empty();
        }
        ConfigurationSection itemsSection = shopSection.getConfigurationSection("items");
        if (itemsSection == null && (itemsSection = this.findSectionIgnoreCase(shopSection, "items")) == null) {
            return Optional.empty();
        }
        ConfigurationSection itemSection = itemsSection.getConfigurationSection(itemID);
        if (itemSection == null && (itemSection = this.findSectionIgnoreCase(itemsSection, itemID)) == null) {
            return Optional.empty();
        }
        String[] keyParts = key.split("\\.");
        ConfigurationSection currentSection = itemSection;
        for (int i = 0; i < keyParts.length - 1; ++i) {
            String keyPart = keyParts[i];
            if ((currentSection = currentSection.getConfigurationSection(keyPart)) != null || (currentSection = this.findSectionIgnoreCase(currentSection, keyPart)) != null) continue;
            return Optional.empty();
        }
        String finalKey = keyParts[keyParts.length - 1];
        String actualKey = this.findKeyIgnoreCase(currentSection, finalKey);
        if (actualKey == null) {
            return Optional.empty();
        }
        if (type == Double.class) {
            double value = currentSection.getDouble(actualKey, -1.0);
            return value >= 0.0 ? Optional.of(type.cast(value)) : Optional.empty();
        }
        if (type == Integer.class) {
            int value = currentSection.getInt(actualKey, -1);
            return value >= 0 ? Optional.of(type.cast(value)) : Optional.empty();
        }
        if (type == Boolean.class) {
            boolean value = currentSection.getBoolean(actualKey, false);
            return Optional.of(type.cast(value));
        }
        if (type == String.class) {
            String value = currentSection.getString(actualKey, null);
            return value != null ? Optional.of(type.cast(value)) : Optional.empty();
        }
        return Optional.empty();
    }

    public String getItemCategory(String shopId, String itemId) {
        String shopCategory;
        Optional<String> categoryFromItem = this.getItemValue(shopId, itemId, "category", String.class);
        if (categoryFromItem.isPresent()) {
            return categoryFromItem.get();
        }
        YamlConfiguration config = this.getShopConfig(shopId);
        ConfigurationSection shopSection = config.getConfigurationSection(shopId);
        if (shopSection != null && (shopCategory = shopSection.getString("category")) != null && !shopCategory.isEmpty()) {
            return shopCategory;
        }
        return shopId;
    }

    private ConfigurationSection findSectionIgnoreCase(ConfigurationSection parent, String sectionName) {
        if (parent == null) {
            return null;
        }
        for (String key : parent.getKeys(false)) {
            if (!key.equalsIgnoreCase(sectionName)) continue;
            return parent.getConfigurationSection(key);
        }
        return null;
    }

    private String findKeyIgnoreCase(ConfigurationSection section, String keyName) {
        if (section == null) {
            return null;
        }
        for (String key : section.getKeys(false)) {
            if (!key.equalsIgnoreCase(keyName)) continue;
            return key;
        }
        return null;
    }

    public ItemPriceData getItemAllValues(String shopID, String itemID) {
        ConfigurationSection stock;
        ConfigurationSection sellDynamic;
        ItemPriceData itemPriceData = new ItemPriceData();
        String cacheKey = shopID + ":" + itemID;
        ConfigurationSection itemSection = this.sectionCache.get(cacheKey, () -> {
            YamlConfiguration config = this.getShopConfig(shopID);
            ConfigurationSection shopSection = config.getConfigurationSection(shopID);
            if (shopSection == null && (shopSection = this.findSectionIgnoreCase((ConfigurationSection)config, shopID)) == null) {
                return null;
            }
            ConfigurationSection itemsSection = shopSection.getConfigurationSection("items");
            if (itemsSection == null && (itemsSection = this.findSectionIgnoreCase(shopSection, "items")) == null) {
                return null;
            }
            ConfigurationSection section = itemsSection.getConfigurationSection(itemID);
            if (section == null) {
                section = this.findSectionIgnoreCase(itemsSection, itemID);
            }
            return section;
        });
        if (itemSection == null) {
            return itemPriceData;
        }
        itemPriceData.buyPrice = this.getOptionalDouble(itemSection, "buyPrice");
        itemPriceData.sellPrice = this.getOptionalDouble(itemSection, "sellPrice");
        ConfigurationSection buyDynamic = this.findSectionIgnoreCase(itemSection, "buyDynamic");
        if (buyDynamic != null) {
            itemPriceData.minBuy = this.getOptionalDouble(buyDynamic, "min");
            itemPriceData.maxBuy = this.getOptionalDouble(buyDynamic, "max");
            itemPriceData.growthBuy = this.getOptionalDouble(buyDynamic, "growth");
            itemPriceData.decayBuy = this.getOptionalDouble(buyDynamic, "decay");
            itemPriceData.minBuyLink = this.getOptionalString(buyDynamic, "minLink");
            itemPriceData.maxBuyLink = this.getOptionalString(buyDynamic, "maxLink");
        }
        if ((sellDynamic = this.findSectionIgnoreCase(itemSection, "sellDynamic")) != null) {
            itemPriceData.minSell = this.getOptionalDouble(sellDynamic, "min");
            itemPriceData.maxSell = this.getOptionalDouble(sellDynamic, "max");
            itemPriceData.growthSell = this.getOptionalDouble(sellDynamic, "growth");
            itemPriceData.decaySell = this.getOptionalDouble(sellDynamic, "decay");
            itemPriceData.minSellLink = this.getOptionalString(sellDynamic, "minLink");
            itemPriceData.maxSellLink = this.getOptionalString(sellDynamic, "maxLink");
        }
        if ((stock = this.findSectionIgnoreCase(itemSection, "stock")) != null) {
            itemPriceData.stock = this.getOptionalInt(stock, "base");
            itemPriceData.minStock = this.getOptionalInt(stock, "min");
            itemPriceData.maxStock = this.getOptionalInt(stock, "max");
            itemPriceData.stockBuyModifier = this.getOptionalDouble(stock, "buyModifier");
            itemPriceData.stockSellModifier = this.getOptionalDouble(stock, "sellModifier");
        }
        return itemPriceData;
    }

    private Optional<Double> getOptionalDouble(ConfigurationSection section, String key) {
        if (section == null) {
            return Optional.empty();
        }
        String actualKey = this.findKeyIgnoreCase(section, key);
        if (actualKey == null) {
            return Optional.empty();
        }
        if (!section.contains(actualKey)) {
            return Optional.empty();
        }
        double value = section.getDouble(actualKey);
        return Optional.of(value);
    }

    private Optional<Integer> getOptionalInt(ConfigurationSection section, String key) {
        if (section == null) {
            return Optional.empty();
        }
        String actualKey = this.findKeyIgnoreCase(section, key);
        if (actualKey == null) {
            return Optional.empty();
        }
        if (!section.contains(actualKey)) {
            return Optional.empty();
        }
        int value = section.getInt(actualKey);
        return Optional.of(value);
    }

    private Optional<String> getOptionalString(ConfigurationSection section, String key) {
        if (section == null) {
            return Optional.empty();
        }
        String actualKey = this.findKeyIgnoreCase(section, key);
        if (actualKey == null) {
            return Optional.empty();
        }
        if (!section.contains(actualKey)) {
            return Optional.empty();
        }
        String value = section.getString(actualKey);
        return value != null && !value.isEmpty() ? Optional.of(value) : Optional.empty();
    }

    public ConfigurationSection getSection(String shopID, String itemID, String section) {
        YamlConfiguration config = this.getShopConfig(shopID);
        ConfigurationSection shopSection = config.getConfigurationSection(shopID);
        ConfigurationSection itemsSection = shopSection.getConfigurationSection("items");
        if (itemsSection == null) {
            return null;
        }
        ConfigurationSection itemSection = itemsSection.getConfigurationSection(itemID);
        if (itemSection == null) {
            return null;
        }
        return itemSection.getConfigurationSection(section);
    }

    public boolean shopItemExists(String shopId, String itemId) {
        Shop shop = ShopGuiPlusApi.getPlugin().getShopManager().getShopById(shopId);
        if (shop == null) {
            return false;
        }
        ShopItem shopItem = shop.getShopItem(itemId);
        return shopItem != null;
    }

    public void loadTranslationFile(String locale, String fileName) {
        File file = new File(this.plugin.getDataFolder(), fileName);
        if (!file.exists()) {
            DynaShopPlugin.getInstance().info("Translation file for locale '" + locale + "' not found, creating default.");
            this.plugin.saveResource(fileName, false);
        }
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
        this.translationsCache.put(locale, config);
        DynaShopPlugin.getInstance().info("Translation file for locale '" + locale + "' loaded successfully.");
    }

    public String getTranslatedMaterialName(String materialName, String locale) {
        YamlConfiguration translations = this.translationsCache.get(locale, () -> null);
        if (translations == null) {
            DynaShopPlugin.getInstance().info("Translation file for locale '" + locale + "' not loaded.");
            return null;
        }
        return translations.getString(materialName, null);
    }

    public String getItemName(Player player, String shopId, String itemId) {
        String localizedName;
        String displayName;
        Shop shop = ShopGuiPlusApi.getPlugin().getShopManager().getShopById(shopId);
        if (shop == null) {
            return itemId;
        }
        ShopItem shopItem = shop.getShopItem(itemId);
        if (shopItem == null) {
            return itemId;
        }
        if (shopItem.getItem().hasItemMeta() && shopItem.getItem().getItemMeta() != null && (displayName = shopItem.getItem().getItemMeta().getDisplayName()) != null && !displayName.isEmpty()) {
            return ChatColor.stripColor((String)displayName);
        }
        try {
            String nbtName = NBT.getComponents(shopItem.getItem(), nbt -> {
                String jsonName;
                if (nbt.hasTag("minecraft:item_name") && (jsonName = nbt.getString("minecraft:item_name")) != null && !jsonName.isEmpty()) {
                    try {
                        if (jsonName.contains("\"text\":")) {
                            return jsonName.replaceAll(".*\"text\":\"([^\"]+)\".*", "$1");
                        }
                    }
                    catch (Exception e) {
                        this.plugin.getLogger().warning("Erreur lors du parsing du nom JSON: " + e.getMessage());
                    }
                }
                return null;
            });
            if (nbtName != null && !nbtName.isEmpty()) {
                return nbtName;
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Erreur lors de l'acc\u00e8s aux NBT data avec NBTAPI: " + e.getMessage());
        }
        if (player != null && player.getLocale() != null) {
            String locale = player.getLocale().split("_")[0];
            String translated = this.getTranslatedMaterialName(shopItem.getItem().getType().name(), locale);
            if (translated != null && !translated.isEmpty()) {
                return translated;
            }
        }
        if (player != null && (localizedName = ItemNameManager.getLocalizedName(shopItem.getItem(), player)) != null && !localizedName.isEmpty()) {
            return localizedName;
        }
        return this.formatMaterialName(shopItem.getItem().getType().name());
    }

    public String getItemNameWithLocale(String shopId, String itemId, String locale) {
        String displayName;
        Shop shop = ShopGuiPlusApi.getPlugin().getShopManager().getShopById(shopId);
        if (shop == null) {
            return itemId;
        }
        ShopItem shopItem = shop.getShopItem(itemId);
        if (shopItem == null || shopItem.getItem() == null) {
            return itemId;
        }
        if (shopItem.getItem().hasItemMeta() && shopItem.getItem().getItemMeta() != null && (displayName = shopItem.getItem().getItemMeta().getDisplayName()) != null && !displayName.isEmpty()) {
            return ChatColor.stripColor((String)displayName);
        }
        try {
            String nbtName = NBT.getComponents(shopItem.getItem(), nbt -> {
                String jsonName;
                if (nbt.hasTag("minecraft:item_name") && (jsonName = nbt.getString("minecraft:item_name")) != null && !jsonName.isEmpty()) {
                    try {
                        if (jsonName.contains("\"text\":")) {
                            return jsonName.replaceAll(".*\"text\":\"([^\"]+)\".*", "$1");
                        }
                    }
                    catch (Exception e) {
                        this.plugin.getLogger().warning("Erreur lors du parsing du nom JSON: " + e.getMessage());
                    }
                }
                return null;
            });
            if (nbtName != null && !nbtName.isEmpty()) {
                if (shopItem.getItem().getItemMeta() != null && shopItem.getItem().getItemMeta().hasEnchants()) {
                    StringBuilder nameWithEnchantments = new StringBuilder(nbtName);
                    shopItem.getItem().getItemMeta().getEnchants().forEach((enchantment, level) -> nameWithEnchantments.append(" ").append(enchantment.getKey().getKey()).append(" ").append(level));
                    nbtName = nameWithEnchantments.toString();
                }
                if (shopItem.getItem().getType() == Material.POTION || shopItem.getItem().getType() == Material.SPLASH_POTION || shopItem.getItem().getType() == Material.LINGERING_POTION) {
                    // empty if block
                }
                return nbtName;
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Erreur lors de l'acc\u00e8s aux NBT data avec NBTAPI: " + e.getMessage());
        }
        String translated = this.getTranslatedMaterialName(shopItem.getItem().getType().name(), locale);
        if (translated != null && !translated.isEmpty()) {
            ConfigurationSection potionSection;
            if (shopItem.getItem().getItemMeta() != null && shopItem.getItem().getItemMeta().hasEnchants()) {
                StringBuilder nameWithEnchantments = new StringBuilder(translated);
                shopItem.getItem().getItemMeta().getEnchants().forEach((enchantment, level) -> nameWithEnchantments.append(" ").append(enchantment.getKey().getKey()).append(" ").append(level));
                translated = nameWithEnchantments.toString();
            }
            if ((shopItem.getItem().getType() == Material.POTION || shopItem.getItem().getType() == Material.SPLASH_POTION || shopItem.getItem().getType() == Material.LINGERING_POTION) && this.hasSection(shopId, itemId, "item.potion") && (potionSection = this.getSection(shopId, itemId, "item.potion")) != null) {
                String potionType = potionSection.getString("type", "");
                int level2 = potionSection.getInt("level", 1);
                boolean extended = potionSection.getBoolean("extended", false);
                StringBuilder nameBuilder = new StringBuilder();
                nameBuilder.append("Potion de ");
                nameBuilder.append(" ").append(this.translatePotionType(potionType, locale));
                if (level2 > 1) {
                    nameBuilder.append(" ").append(this.toRomanNumeral(level2));
                }
                if (shopItem.getItem().getType() == Material.SPLASH_POTION) {
                    nameBuilder.append(" ").append("jetable");
                } else if (shopItem.getItem().getType() == Material.LINGERING_POTION) {
                    nameBuilder.append(" ").append("persistante");
                }
                if (extended) {
                    nameBuilder.append(" ").append("(Dur\u00e9e prolong\u00e9e)");
                }
                translated = nameBuilder.toString();
            }
            return translated;
        }
        return this.formatMaterialName(shopItem.getItem().getType().name());
    }

    private String translatePotionType(String type, String locale) {
        String key = "POTION_TYPE_" + type;
        String translated = this.getTranslatedMaterialName(key, locale);
        if (translated != null && !translated.isEmpty()) {
            return translated;
        }
        return this.formatPotionType(type);
    }

    private String formatPotionType(String type) {
        String[] words = type.toLowerCase().split("_");
        StringBuilder result = new StringBuilder();
        for (String word : words) {
            if (word.isEmpty()) continue;
            result.append(Character.toUpperCase(word.charAt(0))).append(word.substring(1)).append(" ");
        }
        return result.toString().trim();
    }

    private String toRomanNumeral(int number) {
        switch (number) {
            case 1: {
                return "I";
            }
            case 2: {
                return "II";
            }
            case 3: {
                return "III";
            }
            case 4: {
                return "IV";
            }
            case 5: {
                return "V";
            }
        }
        return String.valueOf(number);
    }

    private String formatMaterialName(String materialName) {
        String[] words = materialName.toLowerCase().split("_");
        StringBuilder result = new StringBuilder();
        for (String word : words) {
            if (word.isEmpty()) continue;
            result.append(Character.toUpperCase(word.charAt(0))).append(word.substring(1)).append(" ");
        }
        return result.toString().trim();
    }
}

