/*
 * Decompiled with CFR 0.152.
 */
package fr.tylwen.satyria.dynashop.data;

import fr.tylwen.satyria.dynashop.DynaShopPlugin;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.configuration.file.YamlConfiguration;

public class ShopFile {
    private static final Map<String, File> shopIDToFile = new HashMap<String, File>();
    private static final Map<File, String> fileToShopID = new HashMap<File, String>();

    public static void loadShopFiles(File shopFolder) {
        if (!shopFolder.exists() || !shopFolder.isDirectory()) {
            return;
        }
        for (File file : shopFolder.listFiles((dir, name) -> name.endsWith(".yml"))) {
            YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
            for (String shopID : config.getKeys(false)) {
                shopIDToFile.put(shopID, file);
                fileToShopID.put(file, shopID);
            }
        }
    }

    public static File getFileByShopID(String shopID) {
        return shopIDToFile.get(shopID);
    }

    public static String getShopIDByFile(File file) {
        return fileToShopID.get(file);
    }

    public static boolean shopIDExists(String shopID) {
        return shopIDToFile.containsKey(shopID);
    }

    public static boolean fileExists(File file) {
        return fileToShopID.containsKey(file);
    }

    public static File[] getShopFiles(File shopFolder) {
        if (!shopFolder.exists() || !shopFolder.isDirectory()) {
            return new File[0];
        }
        return shopFolder.listFiles((dir, name) -> name.endsWith(".yml"));
    }

    public static File[] getShopFiles() {
        return ShopFile.getShopFiles(DynaShopPlugin.getInstance().getShopConfigManager().getShopDirectory());
    }

    public static String[] getAllShopIDs() {
        return shopIDToFile.keySet().toArray(new String[0]);
    }
}

