/*
 * Decompiled with CFR 0.152.
 */
package fr.tylwen.satyria.dynashop.data.cache;

import fr.tylwen.satyria.dynashop.DynaShopPlugin;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class CacheManager<K, V> {
    private final Map<K, CacheEntry<V>> cache = new ConcurrentHashMap<K, CacheEntry<V>>();
    private final Map<K, CacheEntry<V>> hotCache = new ConcurrentHashMap<K, CacheEntry<V>>();
    private final Map<K, Integer> accessCount = new ConcurrentHashMap<K, Integer>();
    private final long cacheDuration;
    private final TimeUnit timeUnit;
    private final int promotionThreshold;

    public CacheManager(DynaShopPlugin plugin, String cacheType, long duration, TimeUnit timeUnit, int promotionThreshold) {
        this.cacheDuration = duration;
        this.timeUnit = timeUnit;
        this.promotionThreshold = promotionThreshold;
        Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)plugin, this::cleanup, 1200L, 1200L);
    }

    public V get(K key, Supplier<V> loader) {
        CacheEntry<V> hotEntry = this.hotCache.get(key);
        if (hotEntry != null && !hotEntry.isExpired()) {
            this.accessCount.merge(key, 1, Integer::sum);
            return hotEntry.getValue();
        }
        CacheEntry<V> entry = this.cache.get(key);
        if (entry != null && !entry.isExpired()) {
            int count = this.accessCount.merge(key, 1, Integer::sum);
            if (count >= this.promotionThreshold) {
                this.hotCache.put(key, entry);
                this.cache.remove(key);
            }
            return entry.getValue();
        }
        V value = loader.get();
        CacheEntry<V> newEntry = new CacheEntry<V>(value, this.cacheDuration, this.timeUnit);
        if (this.accessCount.getOrDefault(key, 0) >= this.promotionThreshold) {
            this.hotCache.put(key, newEntry);
        } else {
            this.cache.put(key, newEntry);
        }
        return value;
    }

    public V getIfPresent(K key) {
        CacheEntry<V> entry = this.hotCache.get(key);
        if (entry != null && !entry.isExpired()) {
            return entry.getValue();
        }
        entry = this.cache.get(key);
        if (entry != null && !entry.isExpired()) {
            return entry.getValue();
        }
        return null;
    }

    public Set<K> keySet() {
        return this.cache.keySet();
    }

    public void put(K key, V value) {
        CacheEntry<V> entry = new CacheEntry<V>(value, this.cacheDuration, this.timeUnit);
        if (this.accessCount.getOrDefault(key, 0) >= this.promotionThreshold) {
            this.hotCache.put(key, entry);
        } else {
            this.cache.put(key, entry);
        }
    }

    public void invalidate(K key) {
        this.cache.remove(key);
        this.hotCache.remove(key);
    }

    public void invalidateWithPrefix(String prefix) {
        this.cache.keySet().removeIf(k -> k.toString().startsWith(prefix));
        this.hotCache.keySet().removeIf(k -> k.toString().startsWith(prefix));
    }

    public void cleanup() {
        long now = System.currentTimeMillis();
        this.cache.entrySet().removeIf(entry -> ((CacheEntry)entry.getValue()).isExpired(now));
        this.hotCache.entrySet().removeIf(entry -> ((CacheEntry)entry.getValue()).isExpired(now));
        this.accessCount.entrySet().removeIf(entry -> !this.cache.containsKey(entry.getKey()) && !this.hotCache.containsKey(entry.getKey()));
    }

    public void clear() {
        this.cache.clear();
        this.hotCache.clear();
        this.accessCount.clear();
    }

    private static class CacheEntry<V> {
        private final V value;
        private final long expirationTime;

        CacheEntry(V value, long duration, TimeUnit timeUnit) {
            this.value = value;
            this.expirationTime = System.currentTimeMillis() + timeUnit.toMillis(duration);
        }

        V getValue() {
            return this.value;
        }

        boolean isExpired() {
            return this.isExpired(System.currentTimeMillis());
        }

        boolean isExpired(long now) {
            return now > this.expirationTime;
        }
    }
}

