/*
 * Decompiled with CFR 0.152.
 */
package fr.tylwen.satyria.dynashop.data.cache;

import fr.tylwen.satyria.dynashop.DynaShopPlugin;
import fr.tylwen.satyria.dynashop.system.TransactionLimiter;
import java.util.UUID;

public class LimitCacheEntry {
    final DynaShopPlugin plugin = DynaShopPlugin.getInstance();
    public UUID playerUuid;
    public String shopId;
    public String itemId;
    public boolean isBuy;
    public int baseLimit;
    public int cooldown;
    public int remaining;
    public long nextAvailable;

    public LimitCacheEntry(UUID playerUuid, String shopId, String itemId, boolean isBuy, int baseLimit, int cooldown, int remaining, long nextAvailable) {
        this.playerUuid = playerUuid;
        this.shopId = shopId;
        this.itemId = itemId;
        this.isBuy = isBuy;
        this.baseLimit = baseLimit;
        this.cooldown = cooldown;
        this.remaining = remaining;
        this.nextAvailable = nextAvailable;
    }

    public LimitCacheEntry() {
    }

    public int getLimit() {
        return this.baseLimit;
    }

    public int getCooldown() {
        return this.cooldown;
    }

    public TransactionLimiter.LimitPeriod getPeriodEquivalent() {
        if (this.cooldown >= 31536000) {
            return TransactionLimiter.LimitPeriod.FOREVER;
        }
        if (this.cooldown >= 2592000) {
            return TransactionLimiter.LimitPeriod.MONTHLY;
        }
        if (this.cooldown >= 604800) {
            return TransactionLimiter.LimitPeriod.WEEKLY;
        }
        if (this.cooldown >= 86400) {
            return TransactionLimiter.LimitPeriod.DAILY;
        }
        return TransactionLimiter.LimitPeriod.NONE;
    }
}

