/*
 * Decompiled with CFR 0.152.
 */
package fr.tylwen.satyria.dynashop.data.model;

import java.time.LocalDateTime;
import java.util.UUID;

public class TransactionRecord {
    private UUID playerUuid;
    private String playerName;
    private String shopId;
    private String itemId;
    private String itemName;
    private boolean isBuy;
    private int quantity;
    private double unitPrice;
    private double totalPrice;
    private LocalDateTime timestamp;
    private long id;

    public TransactionRecord(UUID playerUuid, String shopId, String itemId, boolean isBuy, int quantity, LocalDateTime timestamp) {
        this.playerUuid = playerUuid;
        this.shopId = shopId;
        this.itemId = itemId;
        this.isBuy = isBuy;
        this.quantity = quantity;
        this.timestamp = timestamp;
    }

    public TransactionRecord(UUID playerUuid, String playerName, String shopId, String itemId, String itemName, boolean isBuy, int quantity, double unitPrice, LocalDateTime timestamp) {
        this(playerUuid, shopId, itemId, isBuy, quantity, timestamp);
        this.playerName = playerName;
        this.itemName = itemName;
        this.unitPrice = unitPrice;
        this.totalPrice = unitPrice * (double)quantity;
    }

    public TransactionRecord() {
    }

    public UUID getPlayerUuid() {
        return this.playerUuid;
    }

    public void setPlayerUuid(UUID playerUuid) {
        this.playerUuid = playerUuid;
    }

    public String getPlayerName() {
        return this.playerName;
    }

    public void setPlayerName(String playerName) {
        this.playerName = playerName;
    }

    public String getShopId() {
        return this.shopId;
    }

    public void setShopId(String shopId) {
        this.shopId = shopId;
    }

    public String getItemId() {
        return this.itemId;
    }

    public void setItemId(String itemId) {
        this.itemId = itemId;
    }

    public String getItemName() {
        return this.itemName;
    }

    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    public boolean isBuy() {
        return this.isBuy;
    }

    public void setBuy(boolean buy) {
        this.isBuy = buy;
    }

    public int getQuantity() {
        return this.quantity;
    }

    public void setQuantity(int quantity) {
        this.quantity = quantity;
        if (this.unitPrice > 0.0) {
            this.totalPrice = this.unitPrice * (double)quantity;
        }
    }

    public double getUnitPrice() {
        return this.unitPrice;
    }

    public void setUnitPrice(double unitPrice) {
        this.unitPrice = unitPrice;
        this.totalPrice = unitPrice * (double)this.quantity;
    }

    public double getTotalPrice() {
        return this.totalPrice;
    }

    public void setTotalPrice(double totalPrice) {
        this.totalPrice = totalPrice;
    }

    public LocalDateTime getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(LocalDateTime timestamp) {
        this.timestamp = timestamp;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String toString() {
        return "TransactionRecord{player=" + String.valueOf(this.playerName != null ? this.playerName : this.playerUuid) + ", shop='" + this.shopId + "', item='" + (this.itemName != null ? this.itemName : this.itemId) + "', " + (this.isBuy ? "achat" : "vente") + ", quantit\u00e9=" + this.quantity + ", prix=" + String.valueOf(this.unitPrice > 0.0 ? Double.valueOf(this.unitPrice) : "N/A") + ", date=" + String.valueOf(this.timestamp) + "}";
    }
}

