/*
 * Decompiled with CFR 0.152.
 */
package fr.tylwen.satyria.dynashop.data.storage;

import com.google.gson.reflect.TypeToken;
import fr.tylwen.satyria.dynashop.DynaShopPlugin;
import fr.tylwen.satyria.dynashop.data.model.TransactionRecord;
import fr.tylwen.satyria.dynashop.data.param.DynaShopType;
import fr.tylwen.satyria.dynashop.data.storage.JsonStorage;
import fr.tylwen.satyria.dynashop.data.storage.PriceDataManager;
import fr.tylwen.satyria.dynashop.data.storage.PriceHistoryDataManager;
import fr.tylwen.satyria.dynashop.data.storage.StockDataManager;
import fr.tylwen.satyria.dynashop.data.storage.StorageManager;
import fr.tylwen.satyria.dynashop.price.DynamicPrice;
import fr.tylwen.satyria.dynashop.system.chart.PriceHistory;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.StandardCopyOption;
import java.time.DayOfWeek;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.brcdev.shopgui.ShopGuiPlusApi;
import net.brcdev.shopgui.shop.Shop;
import net.brcdev.shopgui.shop.item.ShopItem;
import org.bukkit.Bukkit;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class FlatFileStorageManager
implements StorageManager {
    private final DynaShopPlugin plugin;
    private final File baseFolder;
    private final PriceDataManager priceManager;
    private final StockDataManager stockManager;
    private final LimitTrackingManager limitManager;
    private final PriceHistoryDataManager historyManager;
    private final MetadataManager metadataManager;
    private ScheduledExecutorService scheduler;
    private final Map<String, Object> metrics = new ConcurrentHashMap<String, Object>();
    private boolean scheduledSave = false;

    public FlatFileStorageManager(DynaShopPlugin plugin) {
        this.plugin = plugin;
        this.baseFolder = new File(plugin.getDataFolder(), "data");
        if (!this.baseFolder.exists()) {
            this.baseFolder.mkdirs();
        }
        this.priceManager = new PriceDataManager(new File(this.baseFolder, "prices.json"));
        this.stockManager = new StockDataManager(new File(this.baseFolder, "stocks.json"));
        this.limitManager = new LimitTrackingManager(new File(this.baseFolder, "limit"));
        this.historyManager = new PriceHistoryDataManager(new File(this.baseFolder, "history"));
        this.metadataManager = new MetadataManager(new File(this.baseFolder, "metadata.json"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initialize() {
        if (!this.baseFolder.exists()) {
            this.baseFolder.mkdirs();
        }
        File lockFile = new File(this.baseFolder, "storage.lock");
        try {
            boolean lockCreated;
            if (lockFile.exists()) {
                this.plugin.getLogger().warning("D\u00e9tection d'un arr\u00eat anormal pr\u00e9c\u00e9dent. R\u00e9cup\u00e9ration des donn\u00e9es...");
                this.tryRecoverDataFiles();
            }
            if (!(lockCreated = lockFile.createNewFile())) {
                this.plugin.getLogger().warning("Impossible de cr\u00e9er le fichier de verrouillage. Un autre processus utilise peut-\u00eatre le stockage.");
            }
            CountDownLatch initLatch = new CountDownLatch(5);
            this.plugin.getLogger().info("Chargement des donn\u00e9es de prix...");
            try {
                this.priceManager.load();
                this.plugin.getLogger().info("Donn\u00e9es de prix charg\u00e9es: " + this.priceManager.getAll().size() + " \u00e9l\u00e9ments");
            }
            catch (Exception e) {
                this.plugin.getLogger().severe("Erreur lors du chargement des prix: " + e.getMessage());
            }
            finally {
                initLatch.countDown();
            }
            this.plugin.getLogger().info("Chargement des donn\u00e9es de stock...");
            try {
                this.stockManager.load();
                this.plugin.getLogger().info("Donn\u00e9es de stock charg\u00e9es: " + this.stockManager.getAll().size() + " \u00e9l\u00e9ments");
            }
            catch (Exception e) {
                this.plugin.getLogger().severe("Erreur lors du chargement des stocks: " + e.getMessage());
            }
            finally {
                initLatch.countDown();
            }
            this.plugin.getLogger().info("Chargement des limites de transactions...");
            try {
                this.limitManager.load();
            }
            catch (Exception e) {
                this.plugin.getLogger().severe("Erreur lors du chargement des limites: " + e.getMessage());
            }
            finally {
                initLatch.countDown();
            }
            this.plugin.getLogger().info("Chargement de l'historique des prix...");
            try {
                this.historyManager.load();
            }
            catch (Exception e) {
                this.plugin.getLogger().severe("Erreur lors du chargement de l'historique: " + e.getMessage());
            }
            finally {
                initLatch.countDown();
            }
            this.plugin.getLogger().info("Chargement des m\u00e9tadonn\u00e9es...");
            try {
                this.metadataManager.load();
            }
            catch (Exception e) {
                this.plugin.getLogger().severe("Erreur lors du chargement des m\u00e9tadonn\u00e9es: " + e.getMessage());
            }
            finally {
                initLatch.countDown();
            }
            boolean allLoaded = initLatch.await(15L, TimeUnit.SECONDS);
            if (!allLoaded) {
                this.plugin.getLogger().warning("D\u00e9lai d'attente d\u00e9pass\u00e9 lors du chargement des donn\u00e9es. Continuons avec les donn\u00e9es partiellement charg\u00e9es.");
            }
            this.validateDataIntegrity();
            this.scheduler = Executors.newScheduledThreadPool(1);
            this.scheduler.scheduleWithFixedDelay(this::saveAll, 2L, 2L, TimeUnit.MINUTES);
            this.plugin.getLogger().info("Syst\u00e8me de stockage FlatFile initialis\u00e9 avec succ\u00e8s");
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Erreur lors de l'initialisation du stockage: " + e.getMessage());
            e.printStackTrace();
            try {
                if (this.priceManager.getAll().isEmpty()) {
                    this.plugin.getLogger().warning("Tentative de r\u00e9cup\u00e9ration d'urgence des donn\u00e9es de prix...");
                    this.priceManager.load();
                }
                if (this.stockManager.getAll().isEmpty()) {
                    this.plugin.getLogger().warning("Tentative de r\u00e9cup\u00e9ration d'urgence des donn\u00e9es de stock...");
                    this.stockManager.load();
                }
            }
            catch (Exception ex) {
                this.plugin.getLogger().severe("\u00c9chec de la r\u00e9cup\u00e9ration d'urgence: " + ex.getMessage());
            }
        }
        finally {
            try {
                try {
                    Files.deleteIfExists(lockFile.toPath());
                }
                catch (IOException e) {
                    this.plugin.getLogger().warning("Failed to delete lock file: " + e.getMessage());
                }
            }
            catch (Exception exception) {}
        }
    }

    private void tryRecoverDataFiles() {
        try {
            File stocksBackup;
            File pricesBackup = new File(this.baseFolder, "prices.json.bak");
            if (pricesBackup.exists() && pricesBackup.length() > 0L) {
                File pricesFile = new File(this.baseFolder, "prices.json");
                Files.copy(pricesBackup.toPath(), pricesFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                this.plugin.getLogger().info("Fichier de prix restaur\u00e9 depuis la sauvegarde");
            }
            if ((stocksBackup = new File(this.baseFolder, "stocks.json.bak")).exists() && stocksBackup.length() > 0L) {
                File stocksFile = new File(this.baseFolder, "stocks.json");
                Files.copy(stocksBackup.toPath(), stocksFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                this.plugin.getLogger().info("Fichier de stocks restaur\u00e9 depuis la sauvegarde");
            }
        }
        catch (IOException e) {
            this.plugin.getLogger().warning("Erreur lors de la r\u00e9cup\u00e9ration des fichiers: " + e.getMessage());
        }
    }

    private void validateDataIntegrity() {
        Map<String, DynamicPrice> prices = this.priceManager.getAll();
        Map<String, Integer> stocks = this.stockManager.getAll();
        this.plugin.getLogger().info("V\u00e9rification des donn\u00e9es: " + prices.size() + " prix et " + stocks.size() + " stocks charg\u00e9s");
        if (prices.isEmpty() && !stocks.isEmpty()) {
            this.plugin.getLogger().warning("Anomalie d\u00e9tect\u00e9e: des stocks existent mais aucun prix n'est charg\u00e9!");
        }
        for (Map.Entry<String, DynamicPrice> entry : prices.entrySet()) {
            String key = entry.getKey();
            DynamicPrice price = entry.getValue();
            Integer stock = stocks.get(key);
            if (stock == null || price.getStock() == stock.intValue()) continue;
            this.plugin.getLogger().warning("Incoh\u00e9rence d\u00e9tect\u00e9e pour " + key + ": stock dans prix=" + price.getStock() + ", stock s\u00e9par\u00e9=" + stock);
            price.setStock(stock);
        }
    }

    @Override
    public void shutdown() {
        this.plugin.getLogger().info("Arr\u00eat du syst\u00e8me de stockage FlatFile...");
        if (this.scheduler != null && !this.scheduler.isShutdown()) {
            this.scheduler.shutdown();
            try {
                if (!this.scheduler.awaitTermination(10L, TimeUnit.SECONDS)) {
                    this.scheduler.shutdownNow();
                }
            }
            catch (InterruptedException e) {
                this.scheduler.shutdownNow();
                Thread.currentThread().interrupt();
            }
        }
        this.saveAll();
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        try {
            Files.deleteIfExists(new File(this.baseFolder, "storage.lock").toPath());
        }
        catch (IOException e) {
            this.plugin.getLogger().warning("Impossible de supprimer le fichier de verrouillage: " + e.getMessage());
        }
        this.plugin.getLogger().info("Syst\u00e8me de stockage FlatFile arr\u00eat\u00e9 avec succ\u00e8s");
    }

    public void saveAll() {
        try {
            File pricesFile = new File(this.baseFolder, "prices.json");
            File pricesBackup = new File(this.baseFolder, "prices.json.bak");
            if (pricesFile.exists()) {
                Files.copy(pricesFile.toPath(), pricesBackup.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            File stocksFile = new File(this.baseFolder, "stocks.json");
            File stocksBackup = new File(this.baseFolder, "stocks.json.bak");
            if (stocksFile.exists()) {
                Files.copy(stocksFile.toPath(), stocksBackup.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            this.priceManager.save();
            this.stockManager.save();
            this.limitManager.save();
            this.historyManager.save();
            this.metadataManager.save();
            this.metadataManager.set("lastSave", System.currentTimeMillis());
            this.metadataManager.save();
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Erreur lors de la sauvegarde des donn\u00e9es: " + e.getMessage());
        }
    }

    @Override
    public Optional<DynamicPrice> getPrices(String shopId, String itemId) {
        String key = this.getItemKey(shopId, itemId);
        DynamicPrice price = this.priceManager.get(key);
        Integer stock = this.stockManager.get(key);
        if (price == null && stock == null) {
            return Optional.empty();
        }
        if (price == null) {
            price = new DynamicPrice(-1.0, -1.0, stock);
        } else if (stock != null) {
            price.setStock(stock);
        }
        return Optional.of(price);
    }

    @Override
    public Optional<Double> getBuyPrice(String shopId, String itemId) {
        String key = this.getItemKey(shopId, itemId);
        DynamicPrice price = this.priceManager.get(key);
        return price != null ? Optional.of(price.getBuyPrice()) : Optional.of(-1.0);
    }

    @Override
    public Optional<Double> getSellPrice(String shopId, String itemId) {
        String key = this.getItemKey(shopId, itemId);
        DynamicPrice price = this.priceManager.get(key);
        return price != null ? Optional.of(price.getSellPrice()) : Optional.of(-1.0);
    }

    @Override
    public Optional<Integer> getStock(String shopId, String itemId) {
        String key = this.getItemKey(shopId, itemId);
        Integer stock = this.stockManager.get(key);
        return stock != null ? Optional.of(stock) : Optional.of(-1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void savePrice(String shopId, String itemId, double buyPrice, double sellPrice, int stock) {
        String key = this.getItemKey(shopId, itemId);
        FlatFileStorageManager flatFileStorageManager = this;
        synchronized (flatFileStorageManager) {
            DynamicPrice newPrice;
            DynamicPrice existingPrice = this.priceManager.get(key);
            if (existingPrice == null) {
                try {
                    ItemStack itemStack = ShopGuiPlusApi.getPlugin().getShopManager().getShopById(shopId).getShopItem(itemId).getItem();
                    DynaShopType type = this.plugin.getShopConfigManager().getTypeDynaShop(shopId, itemId);
                    DynaShopType buyType = this.plugin.getShopConfigManager().resolveTypeDynaShop(shopId, itemId, true);
                    DynaShopType sellType = this.plugin.getShopConfigManager().resolveTypeDynaShop(shopId, itemId, false);
                    newPrice = this.plugin.getDynaShopListener().getOrLoadPrice(null, shopId, itemId, itemStack, new HashSet<String>(), new HashMap<String, DynamicPrice>());
                    newPrice.setBuyPrice(buyPrice);
                    newPrice.setSellPrice(sellPrice);
                    newPrice.setStock(stock);
                    newPrice.setDynaShopType(type);
                    newPrice.setBuyTypeDynaShop(buyType);
                    newPrice.setSellTypeDynaShop(sellType);
                }
                catch (Exception e) {
                    newPrice = new DynamicPrice(buyPrice, sellPrice, stock);
                }
            } else {
                newPrice = new DynamicPrice(buyPrice, sellPrice, existingPrice.getMinBuyPrice(), existingPrice.getMaxBuyPrice(), existingPrice.getMinSellPrice(), existingPrice.getMaxSellPrice(), existingPrice.getGrowthBuy(), existingPrice.getDecayBuy(), existingPrice.getGrowthSell(), existingPrice.getDecaySell(), stock, existingPrice.getMinStock(), existingPrice.getMaxStock(), existingPrice.getStockBuyModifier(), existingPrice.getStockSellModifier());
                newPrice.setDynaShopType(existingPrice.getDynaShopType());
                newPrice.setBuyTypeDynaShop(existingPrice.getBuyTypeDynaShop());
                newPrice.setSellTypeDynaShop(existingPrice.getSellTypeDynaShop());
            }
            this.priceManager.set(key, newPrice);
            this.stockManager.set(key, stock);
            if (!this.scheduledSave) {
                this.scheduledSave = true;
                Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)this.plugin, () -> {
                    FlatFileStorageManager flatFileStorageManager = this;
                    synchronized (flatFileStorageManager) {
                        this.priceManager.save();
                        this.stockManager.save();
                        this.scheduledSave = false;
                    }
                }, 20L);
            }
        }
    }

    @Override
    public void saveBuyPrice(String shopId, String itemId, double price) {
        Optional<DynamicPrice> existingPrice = this.getPrices(shopId, itemId);
        double sellPrice = existingPrice.map(DynamicPrice::getSellPrice).orElse(-1.0);
        int stock = existingPrice.map(DynamicPrice::getStock).orElse(-1);
        this.savePrice(shopId, itemId, price, sellPrice, stock);
    }

    @Override
    public void saveSellPrice(String shopId, String itemId, double price) {
        Optional<DynamicPrice> existingPrice = this.getPrices(shopId, itemId);
        double buyPrice = existingPrice.map(DynamicPrice::getBuyPrice).orElse(-1.0);
        int stock = existingPrice.map(DynamicPrice::getStock).orElse(-1);
        this.savePrice(shopId, itemId, buyPrice, price, stock);
    }

    @Override
    public void saveStock(String shopId, String itemId, int stock) {
        Optional<DynamicPrice> existingPrice = this.getPrices(shopId, itemId);
        double buyPrice = existingPrice.map(DynamicPrice::getBuyPrice).orElse(-1.0);
        double sellPrice = existingPrice.map(DynamicPrice::getSellPrice).orElse(-1.0);
        this.savePrice(shopId, itemId, buyPrice, sellPrice, stock);
    }

    @Override
    public void deleteStock(String shopId, String itemId) {
        String key = this.getItemKey(shopId, itemId);
        this.stockManager.remove(key);
    }

    @Override
    public void cleanupStockTable() {
        Map<String, Integer> allStocks = this.stockManager.getAll();
        for (String key : new HashSet<String>(allStocks.keySet())) {
            String shopId = key.split(":")[0];
            String itemId = key.split(":")[1];
            DynaShopType typeDynaShop = this.plugin.getShopConfigManager().getTypeDynaShop(shopId, itemId);
            if (typeDynaShop == DynaShopType.STOCK || typeDynaShop == DynaShopType.STATIC_STOCK) continue;
            this.stockManager.remove(key);
        }
    }

    @Override
    public void deleteItem(String shopId, String itemId) {
        String key = this.getItemKey(shopId, itemId);
        this.priceManager.remove(key);
        this.stockManager.remove(key);
    }

    @Override
    public boolean itemExists(String shopId, String itemId) {
        String key = this.getItemKey(shopId, itemId);
        return this.priceManager.get(key) != null || this.stockManager.get(key) != null;
    }

    @Override
    public Map<ShopItem, DynamicPrice> loadAllPrices() {
        HashMap<ShopItem, DynamicPrice> result = new HashMap<ShopItem, DynamicPrice>();
        for (Map.Entry<String, DynamicPrice> entry : this.priceManager.getAll().entrySet()) {
            try {
                ShopItem shopItem;
                String[] parts = entry.getKey().split(":");
                if (parts.length != 2) continue;
                String shopId = parts[0];
                String itemId = parts[1];
                Shop shop = ShopGuiPlusApi.getPlugin().getShopManager().getShopById(shopId);
                if (shop == null || (shopItem = shop.getShopItem(itemId)) == null) continue;
                result.put(shopItem, entry.getValue());
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Erreur lors de la conversion de la cl\u00e9 " + entry.getKey() + " en ShopItem: " + e.getMessage());
            }
        }
        return result;
    }

    @Override
    public void saveTransactionsBatch(List<TransactionRecord> transactions) {
        if (transactions == null || transactions.isEmpty()) {
            return;
        }
        for (TransactionRecord record : transactions) {
            this.limitManager.addTransaction(record.getPlayerUuid(), record.getShopId(), record.getItemId(), record.isBuy(), record.getQuantity(), record.getTimestamp());
        }
        this.metrics.merge("total_records", transactions.size(), (oldValue, newValue) -> {
            if (oldValue instanceof Integer) {
                Integer oldInt = (Integer)oldValue;
                if (newValue instanceof Integer) {
                    Integer newInt = (Integer)newValue;
                    return oldInt + newInt;
                }
            }
            return newValue;
        });
        try {
            this.limitManager.save();
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Erreur lors de la sauvegarde des transactions: " + e.getMessage());
            e.printStackTrace();
        }
    }

    @Override
    public int getUsedAmount(UUID playerUuid, String shopId, String itemId, boolean isBuy, LocalDateTime since) {
        return this.limitManager.getUsedAmount(playerUuid, shopId, itemId, isBuy, since);
    }

    @Override
    public Optional<LocalDateTime> getLastTransactionTime(UUID playerUuid, String shopId, String itemId, boolean isBuy) {
        return this.limitManager.getLastTransactionTime(playerUuid, shopId, itemId, isBuy);
    }

    @Override
    public boolean resetLimits(UUID playerUuid, String shopId, String itemId) {
        return this.limitManager.resetLimits(playerUuid, shopId, itemId);
    }

    @Override
    public boolean resetAllLimits(UUID playerUuid) {
        return this.limitManager.resetAllLimits(playerUuid);
    }

    @Override
    public boolean resetAllLimits() {
        return this.limitManager.resetAllLimits();
    }

    @Override
    public void cleanupExpiredTransactions() {
        LocalDateTime now = LocalDateTime.now();
        int daysToKeep = this.plugin.getConfig().getInt("history.transaction-retention-days", 365);
        LocalDateTime cutoffDate = now.minusDays(daysToKeep);
        this.limitManager.cleanupExpiredLimits(cutoffDate);
    }

    @Override
    public PriceHistory getPriceHistory(String shopId, String itemId) {
        return this.historyManager.getPriceHistory(shopId, itemId);
    }

    @Override
    public List<PriceHistory.PriceDataPoint> getAggregatedPriceHistory(String shopId, String itemId, int interval, LocalDateTime startTime, int maxPoints) {
        List<PriceHistory.PriceDataPoint> aggregatedPoints = new ArrayList<PriceHistory.PriceDataPoint>();
        PriceHistory history = this.historyManager.getPriceHistory(shopId, itemId);
        if (history == null || history.getDataPoints().isEmpty()) {
            return aggregatedPoints;
        }
        List<PriceHistory.PriceDataPoint> points = new ArrayList<PriceHistory.PriceDataPoint>(history.getDataPoints());
        if (startTime != null) {
            points = points.stream().filter(p -> p.getTimestamp().isAfter(startTime)).toList();
        }
        HashMap<String, List> groupedPoints = new HashMap<String, List>();
        for (PriceHistory.PriceDataPoint priceDataPoint : points) {
            LocalDateTime truncatedTime = this.truncateToInterval(priceDataPoint.getTimestamp(), interval);
            String key = truncatedTime.toString();
            groupedPoints.computeIfAbsent(key, k -> new ArrayList()).add(priceDataPoint);
        }
        for (Map.Entry entry : groupedPoints.entrySet()) {
            List group = (List)entry.getValue();
            if (group.isEmpty()) continue;
            LocalDateTime timestamp = LocalDateTime.parse((CharSequence)entry.getKey());
            double openBuy = ((PriceHistory.PriceDataPoint)group.get(0)).getOpenBuyPrice();
            double closeBuy = ((PriceHistory.PriceDataPoint)group.get(group.size() - 1)).getCloseBuyPrice();
            double highBuy = group.stream().mapToDouble(PriceHistory.PriceDataPoint::getHighBuyPrice).max().orElse(0.0);
            double lowBuy = group.stream().mapToDouble(PriceHistory.PriceDataPoint::getLowBuyPrice).filter(p -> p > 0.0).min().orElse(0.0);
            double openSell = ((PriceHistory.PriceDataPoint)group.get(0)).getOpenSellPrice();
            double closeSell = ((PriceHistory.PriceDataPoint)group.get(group.size() - 1)).getCloseSellPrice();
            double highSell = group.stream().mapToDouble(PriceHistory.PriceDataPoint::getHighSellPrice).max().orElse(0.0);
            double lowSell = group.stream().mapToDouble(PriceHistory.PriceDataPoint::getLowSellPrice).filter(p -> p > 0.0).min().orElse(0.0);
            double volume = group.stream().mapToDouble(PriceHistory.PriceDataPoint::getVolume).sum();
            PriceHistory.PriceDataPoint aggregatedPoint = new PriceHistory.PriceDataPoint(timestamp, openBuy, closeBuy, highBuy, lowBuy, openSell, closeSell, highSell, lowSell, volume);
            aggregatedPoints.add(aggregatedPoint);
        }
        aggregatedPoints.sort(Comparator.comparing(PriceHistory.PriceDataPoint::getTimestamp));
        if (aggregatedPoints.size() > maxPoints) {
            aggregatedPoints = aggregatedPoints.subList(Math.max(0, aggregatedPoints.size() - maxPoints), aggregatedPoints.size());
        }
        return aggregatedPoints;
    }

    private LocalDateTime truncateToInterval(LocalDateTime dateTime, int intervalMinutes) {
        int totalMinutes = dateTime.getHour() * 60 + dateTime.getMinute();
        int truncatedMinutes = totalMinutes / intervalMinutes * intervalMinutes;
        return dateTime.withHour(truncatedMinutes / 60).withMinute(truncatedMinutes % 60).withSecond(0).withNano(0);
    }

    @Override
    public void savePriceDataPoint(String shopId, String itemId, PriceHistory.PriceDataPoint dataPoint, int intervalMinutes) {
        PriceHistory history = this.historyManager.getPriceHistory(shopId, itemId);
        List<PriceHistory.PriceDataPoint> dataPoints = history.getDataPoints();
        if (dataPoints.isEmpty()) {
            history.addDataPoint(dataPoint);
            this.historyManager.savePriceHistory(history);
            return;
        }
        PriceHistory.PriceDataPoint lastPoint = dataPoints.get(dataPoints.size() - 1);
        if (lastPoint.getTimestamp().plusMinutes(intervalMinutes).isAfter(dataPoint.getTimestamp())) {
            double openBuy = lastPoint.getOpenBuyPrice();
            double closeBuy = dataPoint.getCloseBuyPrice();
            double highBuy = Math.max(lastPoint.getHighBuyPrice(), dataPoint.getHighBuyPrice());
            double lowBuy = Math.min(lastPoint.getLowBuyPrice() > 0.0 ? lastPoint.getLowBuyPrice() : Double.MAX_VALUE, dataPoint.getLowBuyPrice() > 0.0 ? dataPoint.getLowBuyPrice() : Double.MAX_VALUE);
            if (lowBuy == Double.MAX_VALUE) {
                lowBuy = dataPoint.getLowBuyPrice() > 0.0 ? dataPoint.getLowBuyPrice() : 0.0;
            }
            double openSell = lastPoint.getOpenSellPrice();
            double closeSell = dataPoint.getCloseSellPrice();
            double highSell = Math.max(lastPoint.getHighSellPrice(), dataPoint.getHighSellPrice());
            double lowSell = Math.min(lastPoint.getLowSellPrice() > 0.0 ? lastPoint.getLowSellPrice() : Double.MAX_VALUE, dataPoint.getLowSellPrice() > 0.0 ? dataPoint.getLowSellPrice() : Double.MAX_VALUE);
            if (lowSell == Double.MAX_VALUE) {
                lowSell = dataPoint.getLowSellPrice() > 0.0 ? dataPoint.getLowSellPrice() : 0.0;
            }
            double volume = lastPoint.getVolume() + dataPoint.getVolume();
            PriceHistory.PriceDataPoint updatedPoint = new PriceHistory.PriceDataPoint(lastPoint.getTimestamp(), openBuy, closeBuy, highBuy, lowBuy, openSell, closeSell, highSell, lowSell, volume);
            history.updateDataPoint(dataPoints.size() - 1, updatedPoint);
        } else {
            history.addDataPoint(dataPoint);
        }
        this.historyManager.savePriceHistory(history);
    }

    @Override
    public void purgeOldPriceHistory(int daysToKeep) {
        LocalDateTime cutoffDate = LocalDateTime.now().minusDays(daysToKeep);
        this.historyManager.purgeOldData(cutoffDate);
    }

    @Override
    public double getInflationFactor() {
        String value = this.metadataManager.getValue("inflation_factor");
        if (value != null) {
            try {
                return Double.parseDouble(value);
            }
            catch (NumberFormatException e) {
                return 1.0;
            }
        }
        return 1.0;
    }

    @Override
    public long getLastInflationUpdate() {
        String value = this.metadataManager.getValue("last_inflation_update");
        if (value != null) {
            try {
                return Long.parseLong(value);
            }
            catch (NumberFormatException e) {
                return System.currentTimeMillis();
            }
        }
        return System.currentTimeMillis();
    }

    @Override
    public void saveInflationData(double factor, long timestamp) {
        this.metadataManager.setValue("inflation_factor", String.valueOf(factor));
        this.metadataManager.setValue("last_inflation_update", String.valueOf(timestamp));
        this.metadataManager.save();
    }

    @Override
    public <T> CompletableFuture<T> executeAsync(StorageManager.DatabaseOperation<T> operation) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return operation.execute();
            }
            catch (Exception e) {
                this.plugin.getLogger().severe("Erreur lors de l'ex\u00e9cution d'une op\u00e9ration asynchrone: " + e.getMessage());
                throw new RuntimeException(e);
            }
        });
    }

    @Override
    public Map<String, Object> getStatistics() {
        HashMap<String, Object> stats = new HashMap<String, Object>(this.metrics);
        stats.putAll(this.limitManager.getStatistics());
        stats.put("stored_items", this.priceManager.getAll().size());
        stats.put("stored_stocks", this.stockManager.getAll().size());
        stats.put("stored_histories", this.historyManager.getAll().size());
        return stats;
    }

    private String getItemKey(String shopId, String itemId) {
        return shopId + ":" + itemId;
    }

    private static class LimitTrackingManager {
        private final File baseFolder;
        private final Map<UUID, PlayerLimits> playerLimits = new HashMap<UUID, PlayerLimits>();
        private final String timeReference;

        public LimitTrackingManager(File baseFolder) {
            File playerLimitFolder;
            if (!baseFolder.exists()) {
                baseFolder.mkdirs();
            }
            if (!(playerLimitFolder = new File(baseFolder, "player")).exists()) {
                playerLimitFolder.mkdirs();
            }
            this.baseFolder = playerLimitFolder;
            this.timeReference = DynaShopPlugin.getInstance().getConfig().getString("limit.time-reference", "first");
        }

        public void load() {
            this.playerLimits.clear();
            File[] playerFiles = this.baseFolder.listFiles((dir, name) -> name.endsWith(".json"));
            if (playerFiles == null) {
                return;
            }
            for (File file : playerFiles) {
                try {
                    String fileName = file.getName();
                    UUID playerId = UUID.fromString(fileName.substring(0, fileName.length() - 5));
                    PlayerLimits limits = JsonStorage.loadFromFile(file, new TypeToken<PlayerLimits>(this){}.getType(), new PlayerLimits());
                    if (limits == null) continue;
                    this.playerLimits.put(playerId, limits);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        public void save() {
            for (Map.Entry<UUID, PlayerLimits> entry : this.playerLimits.entrySet()) {
                try {
                    UUID playerId = entry.getKey();
                    PlayerLimits limits = entry.getValue();
                    if (limits.isEmpty()) continue;
                    File playerFile = new File(this.baseFolder, playerId.toString() + ".json");
                    JsonStorage.saveToFile(playerFile, limits);
                }
                catch (IOException e) {
                    DynaShopPlugin.getInstance().severe("Erreur lors de la sauvegarde des limites pour le joueur " + String.valueOf(entry.getKey()) + ": " + e.getMessage());
                }
            }
        }

        public void addTransaction(UUID playerId, String shopId, String itemId, boolean isBuy, int amount, LocalDateTime timestamp) {
            PlayerLimits limits = this.playerLimits.computeIfAbsent(playerId, k -> new PlayerLimits());
            limits.updateLimit(shopId, itemId, isBuy, amount, timestamp);
        }

        public int getUsedAmount(UUID playerId, String shopId, String itemId, boolean isBuy, LocalDateTime since) {
            PlayerLimits limits = this.playerLimits.get(playerId);
            if (limits == null) {
                return 0;
            }
            return limits.getUsedAmount(shopId, itemId, isBuy, since);
        }

        public Optional<LocalDateTime> getLastTransactionTime(UUID playerId, String shopId, String itemId, boolean isBuy) {
            PlayerLimits limits = this.playerLimits.get(playerId);
            if (limits == null) {
                return Optional.empty();
            }
            return limits.getLastActivityTime(shopId, itemId, isBuy, this.timeReference);
        }

        public boolean resetLimits(UUID playerId, String shopId, String itemId) {
            PlayerLimits limits = this.playerLimits.get(playerId);
            if (limits == null) {
                return false;
            }
            return limits.resetLimits(shopId, itemId);
        }

        public boolean resetAllLimits(UUID playerId) {
            this.playerLimits.remove(playerId);
            File playerFile = new File(this.baseFolder, playerId.toString() + ".json");
            try {
                Files.delete(playerFile.toPath());
                return true;
            }
            catch (NoSuchFileException e) {
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }

        public boolean resetAllLimits() {
            this.playerLimits.clear();
            File[] playerFiles = this.baseFolder.listFiles((dir, name) -> name.endsWith(".json"));
            if (playerFiles == null) {
                return false;
            }
            boolean success = true;
            for (File file : playerFiles) {
                try {
                    Files.delete(file.toPath());
                }
                catch (Exception e) {
                    success = false;
                }
            }
            return success;
        }

        public void cleanupExpiredLimits(LocalDateTime cutoffDate) {
            for (PlayerLimits limits : this.playerLimits.values()) {
                limits.removeExpiredLimits(cutoffDate);
            }
            this.playerLimits.entrySet().removeIf(entry -> ((PlayerLimits)entry.getValue()).isEmpty());
        }

        public Map<String, Object> getStatistics() {
            HashMap<String, Object> stats = new HashMap<String, Object>();
            int totalBuyLimits = 0;
            int totalSellLimits = 0;
            for (PlayerLimits limits : this.playerLimits.values()) {
                totalBuyLimits += limits.getBuyLimitsCount();
                totalSellLimits += limits.getSellLimitsCount();
            }
            stats.put("total_records", totalBuyLimits + totalSellLimits);
            stats.put("count_buy", totalBuyLimits);
            stats.put("count_sell", totalSellLimits);
            stats.put("player_count", this.playerLimits.size());
            return stats;
        }

        private static class PlayerLimits {
            private Map<String, ItemLimit> buyLimits = new HashMap<String, ItemLimit>();
            private Map<String, ItemLimit> sellLimits = new HashMap<String, ItemLimit>();

            private PlayerLimits() {
            }

            public void updateLimit(String shopId, String itemId, boolean isBuy, int amount, LocalDateTime timestamp) {
                String key = shopId + ":" + itemId;
                Map<String, ItemLimit> limitsMap = isBuy ? this.buyLimits : this.sellLimits;
                ItemLimit limit = limitsMap.computeIfAbsent(key, k -> new ItemLimit());
                limit.addAmount(amount, timestamp);
            }

            public int getUsedAmount(String shopId, String itemId, boolean isBuy, LocalDateTime since) {
                String key;
                Map<String, ItemLimit> limitsMap = isBuy ? this.buyLimits : this.sellLimits;
                ItemLimit limit = limitsMap.get(key = shopId + ":" + itemId);
                if (limit == null) {
                    return 0;
                }
                return limit.getAmountSince(since);
            }

            public Optional<LocalDateTime> getLastActivityTime(String shopId, String itemId, boolean isBuy, String timeReference) {
                String key;
                Map<String, ItemLimit> limitsMap = isBuy ? this.buyLimits : this.sellLimits;
                ItemLimit limit = limitsMap.get(key = shopId + ":" + itemId);
                if (limit == null) {
                    return Optional.empty();
                }
                return Optional.of(limit.getLastTransactionTime(timeReference));
            }

            public boolean resetLimits(String shopId, String itemId) {
                String key = shopId + ":" + itemId;
                boolean removed1 = this.buyLimits.remove(key) != null;
                boolean removed2 = this.sellLimits.remove(key) != null;
                return removed1 || removed2;
            }

            public void removeExpiredLimits(LocalDateTime cutoffDate) {
                this.buyLimits.entrySet().removeIf(entry -> ((ItemLimit)entry.getValue()).isExpired(cutoffDate));
                this.sellLimits.entrySet().removeIf(entry -> ((ItemLimit)entry.getValue()).isExpired(cutoffDate));
            }

            public boolean isEmpty() {
                return this.buyLimits.isEmpty() && this.sellLimits.isEmpty();
            }

            public int getBuyLimitsCount() {
                return this.buyLimits.size();
            }

            public int getSellLimitsCount() {
                return this.sellLimits.size();
            }

            private static class ItemLimit {
                private int totalAmount = 0;
                private LocalDateTime lastUpdated;
                private Map<LocalDateTime, Integer> dailyAmounts = new HashMap<LocalDateTime, Integer>();
                private Map<LocalDateTime, Integer> weeklyAmounts = new HashMap<LocalDateTime, Integer>();
                private Map<LocalDateTime, Integer> monthlyAmounts = new HashMap<LocalDateTime, Integer>();
                private List<TransactionEntry> transactions = new ArrayList<TransactionEntry>();

                public ItemLimit() {
                    this.lastUpdated = LocalDateTime.now();
                }

                public void addAmount(int amount, LocalDateTime timestamp) {
                    this.totalAmount += amount;
                    this.lastUpdated = timestamp;
                    this.transactions.add(new TransactionEntry(timestamp, amount));
                    LocalDateTime today = timestamp.truncatedTo(ChronoUnit.DAYS);
                    LocalDateTime thisWeek = timestamp.with(TemporalAdjusters.previousOrSame(DayOfWeek.MONDAY)).truncatedTo(ChronoUnit.DAYS);
                    LocalDateTime thisMonth = timestamp.withDayOfMonth(1).truncatedTo(ChronoUnit.DAYS);
                    this.dailyAmounts.merge(today, amount, Integer::sum);
                    this.weeklyAmounts.merge(thisWeek, amount, Integer::sum);
                    this.monthlyAmounts.merge(thisMonth, amount, Integer::sum);
                }

                public int getAmountSince(LocalDateTime since) {
                    return this.transactions.stream().filter(entry -> entry.timestamp.isEqual(since) || entry.timestamp.isAfter(since)).mapToInt(entry -> entry.amount).sum();
                }

                public LocalDateTime getLastTransactionTime(String timeReference) {
                    if (this.transactions.isEmpty()) {
                        return this.lastUpdated;
                    }
                    if ("first".equalsIgnoreCase(timeReference)) {
                        return this.transactions.stream().map(entry -> entry.timestamp).min(LocalDateTime::compareTo).orElse(this.lastUpdated);
                    }
                    return this.transactions.stream().map(entry -> entry.timestamp).max(LocalDateTime::compareTo).orElse(this.lastUpdated);
                }

                public boolean isExpired(LocalDateTime cutoffDate) {
                    return this.lastUpdated.isBefore(cutoffDate);
                }

                private static class TransactionEntry {
                    private final LocalDateTime timestamp;
                    private final int amount;

                    public TransactionEntry(LocalDateTime timestamp, int amount) {
                        this.timestamp = timestamp;
                        this.amount = amount;
                    }
                }
            }
        }
    }

    private static class MetadataManager {
        private final File file;
        private Map<String, String> metadata = new HashMap<String, String>();

        public MetadataManager(File file) {
            this.file = file;
        }

        public void set(String string, long timeMillis) {
            this.metadata.put(string, String.valueOf(timeMillis));
        }

        public void load() {
            try {
                this.metadata = JsonStorage.loadFromFile(this.file, new TypeToken<Map<String, String>>(this){}.getType(), new HashMap());
            }
            catch (Exception e) {
                this.metadata = new HashMap<String, String>();
            }
        }

        public void save() {
            CompletableFuture.runAsync(() -> {
                try {
                    JsonStorage.saveToFile(this.file, this.metadata);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
        }

        public String getValue(String key) {
            return this.metadata.get(key);
        }

        public void setValue(String key, String value) {
            this.metadata.put(key, value);
        }
    }
}

