/*
 * Decompiled with CFR 0.152.
 */
package fr.tylwen.satyria.dynashop.data.storage;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

public class JsonStorage {
    private static final Gson gson = JsonStorage.createGson();

    private static Gson createGson() {
        return new GsonBuilder().setPrettyPrinting().registerTypeAdapter((Type)((Object)LocalDateTime.class), new LocalDateTimeAdapter()).create();
    }

    public static <T> void saveToFile(File file, T data) throws IOException {
        try (FileWriter writer = new FileWriter(file);){
            gson.toJson(data, (Appendable)writer);
        }
    }

    public static <T> T loadFromFile(File file, Type type, T defaultValue) throws IOException {
        if (!file.exists()) {
            return defaultValue;
        }
        try (FileReader reader = new FileReader(file);){
            Object data = gson.fromJson((Reader)reader, type);
            Object t = data != null ? data : defaultValue;
            return t;
        }
    }

    private static class LocalDateTimeAdapter
    extends TypeAdapter<LocalDateTime> {
        private static final DateTimeFormatter formatter = DateTimeFormatter.ISO_LOCAL_DATE_TIME;

        private LocalDateTimeAdapter() {
        }

        @Override
        public void write(JsonWriter out, LocalDateTime value) throws IOException {
            if (value == null) {
                out.nullValue();
            } else {
                out.value(formatter.format(value));
            }
        }

        @Override
        public LocalDateTime read(JsonReader in) throws IOException {
            String dateString = in.nextString();
            if (dateString == null || dateString.isEmpty()) {
                return null;
            }
            return LocalDateTime.parse(dateString, formatter);
        }
    }
}

