/*
 * Decompiled with CFR 0.152.
 */
package fr.tylwen.satyria.dynashop.data.storage;

import fr.tylwen.satyria.dynashop.DynaShopPlugin;
import fr.tylwen.satyria.dynashop.config.DataConfig;
import fr.tylwen.satyria.dynashop.data.model.TransactionRecord;
import fr.tylwen.satyria.dynashop.data.param.DynaShopType;
import fr.tylwen.satyria.dynashop.data.storage.StorageManager;
import fr.tylwen.satyria.dynashop.libs.hikari.HikariConfig;
import fr.tylwen.satyria.dynashop.libs.hikari.HikariDataSource;
import fr.tylwen.satyria.dynashop.price.DynamicPrice;
import fr.tylwen.satyria.dynashop.system.chart.PriceHistory;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.DayOfWeek;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import net.brcdev.shopgui.ShopGuiPlusApi;
import net.brcdev.shopgui.shop.Shop;
import net.brcdev.shopgui.shop.item.ShopItem;

public class MySQLStorageManager
implements StorageManager {
    private final DynaShopPlugin plugin;
    private final DataConfig dataConfig;
    private HikariDataSource dataSource;
    private boolean isInitialized = false;
    private final ExecutorService databaseExecutor = Executors.newSingleThreadExecutor();
    private final String timeReference;
    private static final int RETRY_LIMIT = 3;
    private static final int RETRY_DELAY_MS = 1000;

    public MySQLStorageManager(DynaShopPlugin plugin) {
        this.plugin = plugin;
        this.dataConfig = plugin.getDataConfig();
        this.timeReference = plugin.getConfig().getString("limit.time-reference", "first");
    }

    @Override
    public void initialize() {
        if (this.isInitialized && this.dataSource != null && !this.dataSource.isClosed()) {
            return;
        }
        this.closeDataSource();
        try {
            HikariConfig config = new HikariConfig();
            this.setupMySQLConnection(config);
            config.setMaximumPoolSize(10);
            config.setMinimumIdle(5);
            config.setConnectionTimeout(30000L);
            config.setIdleTimeout(60000L);
            config.setMaxLifetime(1800000L);
            config.setConnectionTestQuery("SELECT 1");
            config.setPoolName("DynaShopHikariPool");
            this.dataSource = new HikariDataSource(config);
            this.isInitialized = true;
            this.createTables();
            this.migrateFromOldSchema();
            this.plugin.getLogger().info("MySQL connection established successfully");
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Failed to initialize MySQL database: " + e.getMessage());
            e.printStackTrace();
        }
    }

    @Override
    public void shutdown() {
        this.closeDataSource();
        if (this.databaseExecutor != null && !this.databaseExecutor.isShutdown()) {
            this.databaseExecutor.shutdown();
            try {
                if (!this.databaseExecutor.awaitTermination(5L, TimeUnit.SECONDS)) {
                    this.databaseExecutor.shutdownNow();
                }
            }
            catch (InterruptedException e) {
                this.databaseExecutor.shutdownNow();
                Thread.currentThread().interrupt();
            }
        }
        this.plugin.getLogger().info("MySQL connection closed");
    }

    private void setupMySQLConnection(HikariConfig config) {
        String host = this.dataConfig.getDatabaseHost();
        int port = this.dataConfig.getDatabasePort();
        String name = this.dataConfig.getDatabaseName();
        String username = this.dataConfig.getDatabaseUsername();
        String password = this.dataConfig.getDatabasePassword();
        config.setJdbcUrl("jdbc:mysql://" + host + ":" + port + "/" + name + "?useSSL=false&autoReconnect=true&useUnicode=true&characterEncoding=UTF-8");
        config.setDriverClassName("com.mysql.jdbc.Driver");
        config.setUsername(username);
        config.setPassword(password);
        config.addDataSourceProperty("cachePrepStmts", "true");
        config.addDataSourceProperty("prepStmtCacheSize", "250");
        config.addDataSourceProperty("prepStmtCacheSqlLimit", "2048");
        config.addDataSourceProperty("useServerPrepStmts", "true");
        config.addDataSourceProperty("useLocalSessionState", "true");
        config.addDataSourceProperty("rewriteBatchedStatements", "true");
        config.addDataSourceProperty("cacheResultSetMetadata", "true");
        config.addDataSourceProperty("cacheServerConfiguration", "true");
        config.addDataSourceProperty("elideSetAutoCommits", "true");
        config.addDataSourceProperty("maintainTimeStats", "false");
    }

    private void createTables() {
        String tablePrefix = this.dataConfig.getDatabaseTablePrefix();
        String createBuyPriceTableSQL = "CREATE TABLE IF NOT EXISTS " + tablePrefix + "_buy_prices (shopID VARCHAR(255) NOT NULL, itemID VARCHAR(255) NOT NULL, price DOUBLE NOT NULL, PRIMARY KEY (shopID, itemID))";
        String createSellPriceTableSQL = "CREATE TABLE IF NOT EXISTS " + tablePrefix + "_sell_prices (shopID VARCHAR(255) NOT NULL, itemID VARCHAR(255) NOT NULL, price DOUBLE NOT NULL, PRIMARY KEY (shopID, itemID))";
        String createStockTableSQL = "CREATE TABLE IF NOT EXISTS " + tablePrefix + "_stock (shopID VARCHAR(255) NOT NULL, itemID VARCHAR(255) NOT NULL, stock INT DEFAULT -1, PRIMARY KEY (shopID, itemID))";
        String[] transactionTables = new String[]{tablePrefix + "_transaction_limits", tablePrefix + "_tx_daily", tablePrefix + "_tx_weekly", tablePrefix + "_tx_monthly", tablePrefix + "_tx_yearly", tablePrefix + "_tx_forever"};
        String transactionTableStructure = "player_uuid VARCHAR(36) NOT NULL, shop_id VARCHAR(100) NOT NULL, item_id VARCHAR(100) NOT NULL, transaction_type VARCHAR(10) NOT NULL, amount INT NOT NULL, transaction_time TIMESTAMP NOT NULL, PRIMARY KEY (player_uuid, shop_id, item_id, transaction_type, transaction_time)";
        String createMetadataTableSQL = "CREATE TABLE IF NOT EXISTS " + tablePrefix + "_metadata (meta_key VARCHAR(50) PRIMARY KEY, value TEXT NOT NULL)";
        String createPriceHistoryTableSQL = "CREATE TABLE IF NOT EXISTS " + tablePrefix + "_price_history (id INT AUTO_INCREMENT PRIMARY KEY, shop_id VARCHAR(100) NOT NULL, item_id VARCHAR(100) NOT NULL, timestamp TIMESTAMP NOT NULL, open_buy_price DOUBLE NOT NULL DEFAULT 0, close_buy_price DOUBLE NOT NULL DEFAULT 0, high_buy_price DOUBLE NOT NULL DEFAULT 0, low_buy_price DOUBLE NOT NULL DEFAULT 0, open_sell_price DOUBLE NOT NULL DEFAULT 0, close_sell_price DOUBLE NOT NULL DEFAULT 0, high_sell_price DOUBLE NOT NULL DEFAULT 0, low_sell_price DOUBLE NOT NULL DEFAULT 0, volume DOUBLE NOT NULL DEFAULT 0, INDEX (shop_id, item_id))";
        this.executeUpdate(createBuyPriceTableSQL, new Object[0]);
        this.executeUpdate(createSellPriceTableSQL, new Object[0]);
        this.executeUpdate(createStockTableSQL, new Object[0]);
        this.executeUpdate(createMetadataTableSQL, new Object[0]);
        this.executeUpdate(createPriceHistoryTableSQL, new Object[0]);
        for (String tableName : transactionTables) {
            String createTransactionTableSQL = "CREATE TABLE IF NOT EXISTS " + tableName + " (" + transactionTableStructure + ")";
            this.executeUpdate(createTransactionTableSQL, new Object[0]);
        }
        try {
            StringBuilder viewSQLBuilder = new StringBuilder("CREATE OR REPLACE VIEW " + tablePrefix + "_transactions_view AS ");
            for (int i = 0; i < transactionTables.length; ++i) {
                if (i > 0) {
                    viewSQLBuilder.append(" UNION ALL ");
                }
                viewSQLBuilder.append("SELECT * FROM ").append(transactionTables[i]);
            }
            String viewSQL = viewSQLBuilder.toString();
            this.executeUpdate(viewSQL, new Object[0]);
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Note: Unable to create transactions view: " + e.getMessage());
        }
        this.createPricesView(tablePrefix);
        this.executeUpdate("CREATE INDEX IF NOT EXISTS idx_price_history_shop_item ON " + tablePrefix + "_price_history (shop_id, item_id)", new Object[0]);
        for (String tableName : transactionTables) {
            this.executeUpdate("CREATE INDEX IF NOT EXISTS " + tableName + "_time_idx ON " + tableName + " (transaction_time)", new Object[0]);
            this.executeUpdate("CREATE INDEX IF NOT EXISTS " + tableName + "_player_idx ON " + tableName + " (player_uuid)", new Object[0]);
            this.executeUpdate("CREATE INDEX IF NOT EXISTS " + tableName + "_lookup_idx ON " + tableName + " (player_uuid, shop_id, item_id, transaction_type)", new Object[0]);
        }
    }

    private void createPricesView(String tablePrefix) {
        try {
            String viewSQL = "CREATE OR REPLACE VIEW " + tablePrefix + "_items AS SELECT all_items.shopID, all_items.itemID, COALESCE(b.price, -1) AS buyPrice, COALESCE(sell.price, -1) AS sellPrice, COALESCE(s.stock, -1) AS stock FROM (   SELECT DISTINCT shopID, itemID FROM " + tablePrefix + "_buy_prices    UNION    SELECT DISTINCT shopID, itemID FROM " + tablePrefix + "_sell_prices    UNION    SELECT DISTINCT shopID, itemID FROM " + tablePrefix + "_stock) as all_items LEFT JOIN " + tablePrefix + "_stock s ON all_items.shopID = s.shopID AND all_items.itemID = s.itemID LEFT JOIN " + tablePrefix + "_buy_prices b ON all_items.shopID = b.shopID AND all_items.itemID = b.itemID LEFT JOIN " + tablePrefix + "_sell_prices sell ON all_items.shopID = sell.shopID AND all_items.itemID = sell.itemID";
            this.executeUpdate(viewSQL, new Object[0]);
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Note: Unable to create prices view: " + e.getMessage());
        }
    }

    private void migrateFromOldSchema() {
        String tablePrefix = this.dataConfig.getDatabaseTablePrefix();
        boolean oldTableExists = this.executeQuery("SELECT COUNT(*) FROM information_schema.tables WHERE table_name = ?", rs -> rs.next() && rs.getInt(1) > 0, tablePrefix + "_prices").orElse(false);
        if (oldTableExists) {
            this.executeUpdate("INSERT INTO " + tablePrefix + "_buy_prices (shopID, itemID, price) SELECT shopID, itemID, buyPrice FROM " + tablePrefix + "_prices WHERE buyPrice >= 0", new Object[0]);
            this.executeUpdate("INSERT INTO " + tablePrefix + "_sell_prices (shopID, itemID, price) SELECT shopID, itemID, sellPrice FROM " + tablePrefix + "_prices WHERE sellPrice >= 0", new Object[0]);
            this.executeUpdate("INSERT INTO " + tablePrefix + "_stock (shopID, itemID, stock) SELECT shopID, itemID, stock FROM " + tablePrefix + "_prices", new Object[0]);
            this.executeUpdate("RENAME TABLE " + tablePrefix + "_prices TO " + tablePrefix + "_prices_old", new Object[0]);
            this.executeUpdate("DROP TABLE " + tablePrefix + "_prices_old", new Object[0]);
            this.plugin.getLogger().info("Migration des donn\u00e9es de prix vers le nouveau sch\u00e9ma r\u00e9ussie!");
        }
    }

    private Connection getConnection() throws SQLException {
        if (!this.isInitialized || this.dataSource == null || this.dataSource.isClosed()) {
            this.initialize();
        }
        return this.dataSource.getConnection();
    }

    private void closeDataSource() {
        try {
            if (this.dataSource != null && !this.dataSource.isClosed()) {
                this.dataSource.close();
                this.dataSource = null;
            }
            this.isInitialized = false;
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Failed to close database connection: " + e.getMessage());
            e.printStackTrace();
        }
    }

    /*
     * Exception decompiling
     */
    private <T> Optional<T> executeQuery(String sql, ResultSetProcessor<T> processor, Object ... params) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private int executeUpdate(String sql, Object ... params) {
        for (int attempt = 0; attempt < 3; ++attempt) {
            try (Connection conn = this.getConnection();){
                int n;
                block19: {
                    PreparedStatement stmt222 = conn.prepareStatement(sql);
                    try {
                        for (int i = 0; i < params.length; ++i) {
                            stmt222.setObject(i + 1, params[i]);
                        }
                        n = stmt222.executeUpdate();
                        if (stmt222 == null) break block19;
                    }
                    catch (Throwable throwable) {
                        if (stmt222 != null) {
                            try {
                                stmt222.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    stmt222.close();
                }
                return n;
            }
            catch (SQLException e) {
                this.handleSQLException(e, attempt);
                if (attempt == 2) {
                    this.plugin.getLogger().severe("Failed to execute update after 3 attempts: " + sql);
                    return 0;
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
                continue;
            }
        }
        return 0;
    }

    private void handleSQLException(SQLException e, int attempt) {
        if (attempt < 2) {
            this.plugin.getLogger().warning("SQL error (attempt " + (attempt + 1) + "/3): " + e.getMessage());
        } else {
            this.plugin.getLogger().severe("Critical SQL error: " + e.getMessage());
            e.printStackTrace();
        }
        if (this.isConnectionError(e)) {
            this.plugin.getLogger().info("Attempting to reconnect to the database...");
            this.closeDataSource();
            this.initialize();
        }
    }

    private boolean isConnectionError(SQLException e) {
        String message = e.getMessage().toLowerCase();
        return message.contains("closed") || message.contains("terminated") || message.contains("gone away") || message.contains("timeout") || message.contains("refused") || message.contains("communication") || message.contains("link failure");
    }

    @Override
    public <T> CompletableFuture<T> executeAsync(StorageManager.DatabaseOperation<T> operation) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return operation.execute();
            }
            catch (Exception e) {
                this.plugin.getLogger().log(Level.SEVERE, "Error during asynchronous execution", e);
                throw new RuntimeException(e);
            }
        }, this.databaseExecutor);
    }

    @Override
    public Optional<DynamicPrice> getPrices(String shopId, String itemId) {
        String tablePrefix = this.dataConfig.getDatabaseTablePrefix();
        String sql = "SELECT buyPrice, sellPrice, stock FROM " + tablePrefix + "_items WHERE shopID = ? AND itemID = ?";
        return this.executeQuery(sql, rs -> {
            if (rs.next()) {
                double buyPrice = rs.getDouble("buyPrice");
                double sellPrice = rs.getDouble("sellPrice");
                int stock = rs.getInt("stock");
                return new DynamicPrice(buyPrice >= 0.0 ? buyPrice : -1.0, sellPrice >= 0.0 ? sellPrice : -1.0, stock);
            }
            return null;
        }, shopId, itemId);
    }

    @Override
    public Optional<Double> getBuyPrice(String shopId, String itemId) {
        String tablePrefix = this.dataConfig.getDatabaseTablePrefix();
        String sql = "SELECT price FROM " + tablePrefix + "_buy_prices WHERE shopID = ? AND itemID = ?";
        return this.executeQuery(sql, rs -> {
            if (rs.next()) {
                return rs.getDouble("price");
            }
            return -1.0;
        }, shopId, itemId).filter(price -> price >= 0.0);
    }

    @Override
    public Optional<Double> getSellPrice(String shopId, String itemId) {
        String tablePrefix = this.dataConfig.getDatabaseTablePrefix();
        String sql = "SELECT price FROM " + tablePrefix + "_sell_prices WHERE shopID = ? AND itemID = ?";
        return this.executeQuery(sql, rs -> {
            if (rs.next()) {
                return rs.getDouble("price");
            }
            return -1.0;
        }, shopId, itemId).filter(price -> price >= 0.0);
    }

    @Override
    public Optional<Integer> getStock(String shopId, String itemId) {
        String tablePrefix = this.dataConfig.getDatabaseTablePrefix();
        String sql = "SELECT stock FROM " + tablePrefix + "_stock WHERE shopID = ? AND itemID = ?";
        return this.executeQuery(sql, rs -> {
            if (rs.next()) {
                return rs.getInt("stock") >= 0 ? rs.getInt("stock") : -1;
            }
            return -1;
        }, shopId, itemId);
    }

    @Override
    public void savePrice(String shopId, String itemId, double buyPrice, double sellPrice, int stock) {
        String tablePrefix = this.dataConfig.getDatabaseTablePrefix();
        if (stock >= 0) {
            String sql = "REPLACE INTO " + tablePrefix + "_stock (shopID, itemID, stock) VALUES (?, ?, ?)";
            this.executeUpdate(sql, shopId, itemId, stock);
        } else {
            String deleteSQL = "DELETE FROM " + tablePrefix + "_stock WHERE shopID = ? AND itemID = ?";
            this.executeUpdate(deleteSQL, shopId, itemId);
        }
        if (buyPrice >= 0.0) {
            String buySQL = "REPLACE INTO " + tablePrefix + "_buy_prices (shopID, itemID, price) VALUES (?, ?, ?)";
            this.executeUpdate(buySQL, shopId, itemId, buyPrice);
        } else {
            String deleteBuySQL = "DELETE FROM " + tablePrefix + "_buy_prices WHERE shopID = ? AND itemID = ?";
            this.executeUpdate(deleteBuySQL, shopId, itemId);
        }
        if (sellPrice >= 0.0) {
            String sellSQL = "REPLACE INTO " + tablePrefix + "_sell_prices (shopID, itemID, price) VALUES (?, ?, ?)";
            this.executeUpdate(sellSQL, shopId, itemId, sellPrice);
        } else {
            String deleteSellSQL = "DELETE FROM " + tablePrefix + "_sell_prices WHERE shopID = ? AND itemID = ?";
            this.executeUpdate(deleteSellSQL, shopId, itemId);
        }
    }

    @Override
    public void saveBuyPrice(String shopId, String itemId, double buyPrice) {
        String tablePrefix = this.dataConfig.getDatabaseTablePrefix();
        if (buyPrice >= 0.0) {
            String buySQL = "REPLACE INTO " + tablePrefix + "_buy_prices (shopID, itemID, price) VALUES (?, ?, ?)";
            this.executeUpdate(buySQL, shopId, itemId, buyPrice);
        } else {
            String deleteBuySQL = "DELETE FROM " + tablePrefix + "_buy_prices WHERE shopID = ? AND itemID = ?";
            this.executeUpdate(deleteBuySQL, shopId, itemId);
        }
    }

    @Override
    public void saveSellPrice(String shopId, String itemId, double sellPrice) {
        String tablePrefix = this.dataConfig.getDatabaseTablePrefix();
        if (sellPrice >= 0.0) {
            String sellSQL = "REPLACE INTO " + tablePrefix + "_sell_prices (shopID, itemID, price) VALUES (?, ?, ?)";
            this.executeUpdate(sellSQL, shopId, itemId, sellPrice);
        } else {
            String deleteSellSQL = "DELETE FROM " + tablePrefix + "_sell_prices WHERE shopID = ? AND itemID = ?";
            this.executeUpdate(deleteSellSQL, shopId, itemId);
        }
    }

    @Override
    public void saveStock(String shopId, String itemId, int stock) {
        String tablePrefix = this.dataConfig.getDatabaseTablePrefix();
        if (stock >= 0) {
            String sql = "REPLACE INTO " + tablePrefix + "_stock (shopID, itemID, stock) VALUES (?, ?, ?)";
            this.executeUpdate(sql, shopId, itemId, stock);
        } else {
            String deleteSQL = "DELETE FROM " + tablePrefix + "_stock WHERE shopID = ? AND itemID = ?";
            this.executeUpdate(deleteSQL, shopId, itemId);
        }
    }

    @Override
    public void deleteStock(String shopId, String itemId) {
        String tablePrefix = this.dataConfig.getDatabaseTablePrefix();
        String sql = "DELETE FROM " + tablePrefix + "_stock WHERE shopID = ? AND itemID = ?";
        this.executeUpdate(sql, shopId, itemId);
    }

    @Override
    public void cleanupStockTable() {
        String tablePrefix = this.dataConfig.getDatabaseTablePrefix();
        String sql = "SELECT shopID, itemID FROM " + tablePrefix + "_stock";
        this.executeQuery(sql, rs -> {
            while (rs.next()) {
                String shopId = rs.getString("shopID");
                String itemId = rs.getString("itemID");
                DynaShopType typeDynaShop = this.plugin.getShopConfigManager().getTypeDynaShop(shopId, itemId);
                if (typeDynaShop == DynaShopType.STOCK || typeDynaShop == DynaShopType.STATIC_STOCK) continue;
                this.deleteStock(shopId, itemId);
            }
            return null;
        }, new Object[0]);
    }

    @Override
    public void deleteItem(String shopId, String itemId) {
        String tablePrefix = this.dataConfig.getDatabaseTablePrefix();
        String deleteBuySQL = "DELETE FROM " + tablePrefix + "_buy_prices WHERE shopID = ? AND itemID = ?";
        this.executeUpdate(deleteBuySQL, shopId, itemId);
        String deleteSellSQL = "DELETE FROM " + tablePrefix + "_sell_prices WHERE shopID = ? AND itemID = ?";
        this.executeUpdate(deleteSellSQL, shopId, itemId);
        String deleteStockSQL = "DELETE FROM " + tablePrefix + "_stock WHERE shopID = ? AND itemID = ?";
        this.executeUpdate(deleteStockSQL, shopId, itemId);
    }

    @Override
    public boolean itemExists(String shopId, String itemId) {
        String tablePrefix = this.dataConfig.getDatabaseTablePrefix();
        String sql = "SELECT COUNT(*) FROM " + tablePrefix + "_items WHERE shopID = ? AND itemID = ?";
        return this.executeQuery(sql, rs -> {
            if (rs.next()) {
                return rs.getInt(1) > 0;
            }
            return false;
        }, shopId, itemId).orElse(false);
    }

    @Override
    public Map<ShopItem, DynamicPrice> loadAllPrices() {
        HashMap<ShopItem, DynamicPrice> priceMap = new HashMap<ShopItem, DynamicPrice>();
        String tablePrefix = this.dataConfig.getDatabaseTablePrefix();
        String sql = "SELECT shopID, itemID, buyPrice, sellPrice, stock FROM " + tablePrefix + "_items";
        this.executeQuery(sql, rs -> {
            while (rs.next()) {
                ShopItem item;
                String shopId = rs.getString("shopID");
                String itemId = rs.getString("itemID");
                double buyPrice = rs.getDouble("buyPrice");
                double sellPrice = rs.getDouble("sellPrice");
                int stock = rs.getInt("stock");
                Shop shop = ShopGuiPlusApi.getPlugin().getShopManager().getShopById(shopId);
                if (shop == null || (item = (ShopItem)shop.getShopItems().stream().filter(i -> i.getId().equals(itemId)).findFirst().orElse(null)) == null) continue;
                DynamicPrice price = new DynamicPrice(buyPrice, sellPrice, stock);
                priceMap.put(item, price);
            }
            return null;
        }, new Object[0]);
        return priceMap;
    }

    @Override
    public void saveTransactionsBatch(List<TransactionRecord> transactions) {
        if (transactions.isEmpty()) {
            return;
        }
        try (Connection conn = this.getConnection();){
            conn.setAutoCommit(false);
            try {
                for (TransactionRecord record : transactions) {
                    String tableName = this.getAppropriateTransactionTable(record);
                    String transactionType = record.isBuy() ? "BUY" : "SELL";
                    String sql = "INSERT INTO " + tableName + " (player_uuid, shop_id, item_id, transaction_type, amount, transaction_time) VALUES (?, ?, ?, ?, ?, ?) ON DUPLICATE KEY UPDATE amount = amount + ?, transaction_time = VALUES(transaction_time)";
                    PreparedStatement stmt = conn.prepareStatement(sql);
                    try {
                        stmt.setString(1, record.getPlayerUuid().toString());
                        stmt.setString(2, record.getShopId());
                        stmt.setString(3, record.getItemId());
                        stmt.setString(4, transactionType);
                        stmt.setInt(5, record.getQuantity());
                        stmt.setTimestamp(6, Timestamp.valueOf(record.getTimestamp()));
                        stmt.setInt(7, record.getQuantity());
                        stmt.executeUpdate();
                    }
                    finally {
                        if (stmt == null) continue;
                        stmt.close();
                    }
                }
                conn.commit();
            }
            catch (SQLException e) {
                conn.rollback();
                throw e;
            }
            finally {
                conn.setAutoCommit(true);
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("Error saving transactions: " + e.getMessage());
        }
    }

    private String getAppropriateTransactionTable(TransactionRecord record) {
        String tablePrefix = this.dataConfig.getDatabaseTablePrefix();
        LocalDateTime now = LocalDateTime.now();
        LocalDateTime timestamp = record.getTimestamp();
        if (timestamp.isAfter(now.minusDays(1L))) {
            return tablePrefix + "_tx_daily";
        }
        if (timestamp.isAfter(now.minusWeeks(1L))) {
            return tablePrefix + "_tx_weekly";
        }
        if (timestamp.isAfter(now.minusMonths(1L))) {
            return tablePrefix + "_tx_monthly";
        }
        if (timestamp.isAfter(now.minusYears(1L))) {
            return tablePrefix + "_tx_yearly";
        }
        return tablePrefix + "_tx_forever";
    }

    @Override
    public int getUsedAmount(UUID playerUuid, String shopId, String itemId, boolean isBuy, LocalDateTime since) {
        String tablePrefix = this.dataConfig.getDatabaseTablePrefix();
        String transactionType = isBuy ? "BUY" : "SELL";
        String sql = "SELECT COALESCE(SUM(amount), 0) AS total FROM " + tablePrefix + "_transactions_view WHERE player_uuid = ? AND shop_id = ? AND item_id = ? AND transaction_type = ? AND transaction_time >= ?";
        return this.executeQuery(sql, rs -> {
            if (rs.next()) {
                return rs.getInt("total");
            }
            return 0;
        }, playerUuid.toString(), shopId, itemId, transactionType, Timestamp.valueOf(since)).orElse(0);
    }

    @Override
    public Optional<LocalDateTime> getLastTransactionTime(UUID playerUuid, String shopId, String itemId, boolean isBuy) {
        String transactionType;
        String tablePrefix = this.dataConfig.getDatabaseTablePrefix();
        String string = transactionType = isBuy ? "BUY" : "SELL";
        if (this.timeReference.equalsIgnoreCase("last")) {
            String sql = "SELECT MAX(transaction_time) AS latest FROM " + tablePrefix + "_transactions_view WHERE player_uuid = ? AND shop_id = ? AND item_id = ? AND transaction_type = ?";
            return this.executeQuery(sql, rs -> {
                if (rs.next() && rs.getTimestamp("latest") != null) {
                    return rs.getTimestamp("latest").toLocalDateTime();
                }
                return null;
            }, playerUuid.toString(), shopId, itemId, transactionType);
        }
        String sql = "SELECT MIN(transaction_time) AS earliest FROM " + tablePrefix + "_transactions_view WHERE player_uuid = ? AND shop_id = ? AND item_id = ? AND transaction_type = ?";
        return this.executeQuery(sql, rs -> {
            if (rs.next() && rs.getTimestamp("earliest") != null) {
                return rs.getTimestamp("earliest").toLocalDateTime();
            }
            return null;
        }, playerUuid.toString(), shopId, itemId, transactionType);
    }

    @Override
    public boolean resetLimits(UUID playerUuid, String shopId, String itemId) {
        String[] transactionTables = this.getTransactionTables();
        boolean success = true;
        try (Connection conn = this.getConnection();){
            for (String table : transactionTables) {
                String sql = "DELETE FROM " + table + " WHERE player_uuid = ? AND shop_id = ? AND item_id = ?";
                try (PreparedStatement stmt = conn.prepareStatement(sql);){
                    stmt.setString(1, playerUuid.toString());
                    stmt.setString(2, shopId);
                    stmt.setString(3, itemId);
                    stmt.executeUpdate();
                }
                catch (SQLException e) {
                    success = false;
                    this.plugin.getLogger().warning("Error resetting limits: " + e.getMessage());
                }
            }
        }
        catch (SQLException e) {
            success = false;
            this.plugin.getLogger().warning("Connection error while resetting limits: " + e.getMessage());
        }
        return success;
    }

    @Override
    public boolean resetAllLimits(UUID playerUuid) {
        String[] transactionTables = this.getTransactionTables();
        boolean success = true;
        try (Connection conn = this.getConnection();){
            for (String table : transactionTables) {
                String sql = "DELETE FROM " + table + " WHERE player_uuid = ?";
                try (PreparedStatement stmt = conn.prepareStatement(sql);){
                    stmt.setString(1, playerUuid.toString());
                    stmt.executeUpdate();
                }
                catch (SQLException e) {
                    success = false;
                    this.plugin.getLogger().warning("Error resetting all limits: " + e.getMessage());
                }
            }
        }
        catch (SQLException e) {
            success = false;
            this.plugin.getLogger().warning("Connection error while resetting all limits: " + e.getMessage());
        }
        return success;
    }

    @Override
    public boolean resetAllLimits() {
        String[] transactionTables = this.getTransactionTables();
        boolean success = true;
        try (Connection conn = this.getConnection();){
            for (String table : transactionTables) {
                String sql = "TRUNCATE TABLE " + table;
                try (PreparedStatement stmt = conn.prepareStatement(sql);){
                    stmt.executeUpdate();
                }
                catch (SQLException e) {
                    success = false;
                    this.plugin.getLogger().warning("Error resetting all limits for all players: " + e.getMessage());
                }
            }
        }
        catch (SQLException e) {
            success = false;
            this.plugin.getLogger().warning("Connection error while resetting all limits for all players: " + e.getMessage());
        }
        return success;
    }

    @Override
    public void cleanupExpiredTransactions() {
        LocalDateTime now = LocalDateTime.now();
        this.cleanupTable(this.dataConfig.getDatabaseTablePrefix() + "_tx_daily", now.truncatedTo(ChronoUnit.DAYS));
        this.cleanupTable(this.dataConfig.getDatabaseTablePrefix() + "_tx_weekly", now.with(TemporalAdjusters.previousOrSame(DayOfWeek.MONDAY)).truncatedTo(ChronoUnit.DAYS));
        this.cleanupTable(this.dataConfig.getDatabaseTablePrefix() + "_tx_monthly", now.withDayOfMonth(1).truncatedTo(ChronoUnit.DAYS));
        this.cleanupTable(this.dataConfig.getDatabaseTablePrefix() + "_tx_yearly", now.withDayOfYear(1).truncatedTo(ChronoUnit.DAYS));
    }

    private void cleanupTable(String tableName, LocalDateTime cutoffDate) {
        String sql = "DELETE FROM " + tableName + " WHERE transaction_time < ?";
        try (Connection conn = this.getConnection();
             PreparedStatement stmt = conn.prepareStatement(sql);){
            stmt.setTimestamp(1, Timestamp.valueOf(cutoffDate));
            int deleted = stmt.executeUpdate();
            if (deleted > 0) {
                this.plugin.getLogger().info("Cleanup of " + tableName + ": " + deleted + " entries deleted");
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().warning("Error cleaning up " + tableName + ": " + e.getMessage());
        }
    }

    private String[] getTransactionTables() {
        String tablePrefix = this.dataConfig.getDatabaseTablePrefix();
        return new String[]{tablePrefix + "_transaction_limits", tablePrefix + "_tx_daily", tablePrefix + "_tx_weekly", tablePrefix + "_tx_monthly", tablePrefix + "_tx_yearly", tablePrefix + "_tx_forever"};
    }

    @Override
    public PriceHistory getPriceHistory(String shopId, String itemId) {
        PriceHistory history = new PriceHistory(shopId, itemId);
        String tablePrefix = this.dataConfig.getDatabaseTablePrefix();
        String sql = "SELECT timestamp, open_buy_price, close_buy_price, high_buy_price, low_buy_price, open_sell_price, close_sell_price, high_sell_price, low_sell_price, volume FROM " + tablePrefix + "_price_history WHERE shop_id = ? AND item_id = ? ORDER BY timestamp DESC LIMIT " + new PriceHistory(shopId, itemId).getMaxDataPoints();
        this.executeQuery(sql, rs -> {
            while (rs.next()) {
                LocalDateTime timestamp = rs.getTimestamp("timestamp").toLocalDateTime();
                double openBuyPrice = rs.getDouble("open_buy_price");
                double closeBuyPrice = rs.getDouble("close_buy_price");
                double highBuyPrice = rs.getDouble("high_buy_price");
                double lowBuyPrice = rs.getDouble("low_buy_price");
                double openSellPrice = rs.getDouble("open_sell_price");
                double closeSellPrice = rs.getDouble("close_sell_price");
                double highSellPrice = rs.getDouble("high_sell_price");
                double lowSellPrice = rs.getDouble("low_sell_price");
                double volume = rs.getDouble("volume");
                PriceHistory.PriceDataPoint point = new PriceHistory.PriceDataPoint(timestamp, openBuyPrice, closeBuyPrice, highBuyPrice, lowBuyPrice, openSellPrice, closeSellPrice, highSellPrice, lowSellPrice, volume);
                history.addDataPoint(point);
            }
            return null;
        }, shopId, itemId);
        return history;
    }

    @Override
    public List<PriceHistory.PriceDataPoint> getAggregatedPriceHistory(String shopId, String itemId, int interval, LocalDateTime startTime, int maxPoints) {
        ArrayList<PriceHistory.PriceDataPoint> aggregatedPoints = new ArrayList<PriceHistory.PriceDataPoint>();
        String tablePrefix = this.dataConfig.getDatabaseTablePrefix();
        try (Connection conn = this.getConnection();){
            int paramIndex = 1;
            String sql = "WITH intervals AS (  SELECT     DATE_FORMAT(DATE_ADD('1970-01-01 00:00:00', INTERVAL FLOOR(UNIX_TIMESTAMP(timestamp) / (? * 60)) * (? * 60) SECOND), '%Y-%m-%d %H:%i:00') AS interval_start,     MIN(open_buy_price) AS first_open_buy,     MAX(high_buy_price) AS max_high_buy,     MIN(low_buy_price) AS min_low_buy,     MAX(close_buy_price) AS last_close_buy,     MIN(open_sell_price) AS first_open_sell,     MAX(high_sell_price) AS max_high_sell,     MIN(low_sell_price) AS min_low_sell,     MAX(close_sell_price) AS last_close_sell,     SUM(volume) AS total_volume   FROM " + tablePrefix + "_price_history   WHERE shop_id = ? AND item_id = ? " + (startTime != null ? " AND timestamp > ? " : "") + "  GROUP BY interval_start   ORDER BY interval_start DESC   LIMIT ?) SELECT * FROM intervals ORDER BY interval_start ASC";
            PreparedStatement stmt = conn.prepareStatement(sql);
            stmt.setInt(paramIndex++, interval);
            stmt.setInt(paramIndex++, interval);
            stmt.setString(paramIndex++, shopId);
            stmt.setString(paramIndex++, itemId);
            if (startTime != null) {
                stmt.setTimestamp(paramIndex++, Timestamp.valueOf(startTime));
            }
            stmt.setInt(paramIndex, maxPoints);
            ResultSet rs = stmt.executeQuery();
            while (rs.next()) {
                LocalDateTime timestamp = rs.getTimestamp("interval_start").toLocalDateTime();
                double openBuy = rs.getDouble("first_open_buy");
                double highBuy = rs.getDouble("max_high_buy");
                double lowBuy = rs.getDouble("min_low_buy");
                double closeBuy = rs.getDouble("last_close_buy");
                double openSell = rs.getDouble("first_open_sell");
                double highSell = rs.getDouble("max_high_sell");
                double lowSell = rs.getDouble("min_low_sell");
                double closeSell = rs.getDouble("last_close_sell");
                double volume = rs.getDouble("total_volume");
                PriceHistory.PriceDataPoint point = new PriceHistory.PriceDataPoint(timestamp, openBuy, closeBuy, highBuy, lowBuy, openSell, closeSell, highSell, lowSell, volume);
                aggregatedPoints.add(point);
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("Erreur lors de la r\u00e9cup\u00e9ration de l'historique agr\u00e9g\u00e9: " + e.getMessage());
        }
        return aggregatedPoints;
    }

    @Override
    public void savePriceDataPoint(String shopId, String itemId, PriceHistory.PriceDataPoint point, int intervalMinutes) {
        String tablePrefix = this.dataConfig.getDatabaseTablePrefix();
        LocalDateTime truncatedTimestamp = point.getTimestamp().withSecond(0).withNano(0).minusMinutes(point.getTimestamp().getMinute() % intervalMinutes);
        String sql = "INSERT INTO " + tablePrefix + "_price_history (shop_id, item_id, timestamp, open_buy_price, close_buy_price, high_buy_price, low_buy_price, open_sell_price, close_sell_price, high_sell_price, low_sell_price, volume) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        try (Connection conn = this.getConnection();
             PreparedStatement stmt = conn.prepareStatement(sql);){
            stmt.setString(1, shopId);
            stmt.setString(2, itemId);
            stmt.setTimestamp(3, Timestamp.valueOf(truncatedTimestamp));
            stmt.setDouble(4, point.getOpenBuyPrice());
            stmt.setDouble(5, point.getCloseBuyPrice());
            stmt.setDouble(6, point.getHighBuyPrice());
            stmt.setDouble(7, point.getLowBuyPrice());
            stmt.setDouble(8, point.getOpenSellPrice());
            stmt.setDouble(9, point.getCloseSellPrice());
            stmt.setDouble(10, point.getHighSellPrice());
            stmt.setDouble(11, point.getLowSellPrice());
            stmt.setDouble(12, point.getVolume());
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("Error saving price history point: " + e.getMessage());
        }
    }

    @Override
    public void purgeOldPriceHistory(int daysToKeep) {
        String tablePrefix = this.dataConfig.getDatabaseTablePrefix();
        LocalDateTime cutoff = LocalDateTime.now().minusDays(daysToKeep);
        String sql = "DELETE FROM " + tablePrefix + "_price_history WHERE timestamp < ?";
        try (Connection conn = this.getConnection();
             PreparedStatement stmt = conn.prepareStatement(sql);){
            stmt.setTimestamp(1, Timestamp.valueOf(cutoff));
            int rowsDeleted = stmt.executeUpdate();
            this.plugin.getLogger().info("Price history purge: " + rowsDeleted + " entries deleted");
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("Error purging price history: " + e.getMessage());
        }
    }

    @Override
    public double getInflationFactor() {
        String tablePrefix = this.dataConfig.getDatabaseTablePrefix();
        String sql = "SELECT value FROM " + tablePrefix + "_metadata WHERE meta_key = 'inflation_factor'";
        return this.executeQuery(sql, rs -> {
            if (rs.next()) {
                try {
                    return Double.parseDouble(rs.getString("value"));
                }
                catch (NumberFormatException e) {
                    return 1.0;
                }
            }
            return 1.0;
        }, new Object[0]).orElse(1.0);
    }

    @Override
    public long getLastInflationUpdate() {
        String tablePrefix = this.dataConfig.getDatabaseTablePrefix();
        String sql = "SELECT value FROM " + tablePrefix + "_metadata WHERE meta_key = 'last_inflation_update'";
        return this.executeQuery(sql, rs -> {
            if (rs.next()) {
                try {
                    return Long.parseLong(rs.getString("value"));
                }
                catch (NumberFormatException e) {
                    return System.currentTimeMillis();
                }
            }
            return System.currentTimeMillis();
        }, new Object[0]).orElse(System.currentTimeMillis());
    }

    @Override
    public void saveInflationData(double factor, long timestamp) {
        String tablePrefix = this.dataConfig.getDatabaseTablePrefix();
        try (Connection conn = this.getConnection();){
            PreparedStatement createStmt = conn.prepareStatement("CREATE TABLE IF NOT EXISTS " + tablePrefix + "_metadata (meta_key VARCHAR(50) PRIMARY KEY, value TEXT NOT NULL)");
            createStmt.executeUpdate();
            PreparedStatement factorStmt = conn.prepareStatement("INSERT INTO " + tablePrefix + "_metadata (meta_key, value) VALUES ('inflation_factor', ?) ON DUPLICATE KEY UPDATE value = ?");
            factorStmt.setString(1, String.valueOf(factor));
            factorStmt.setString(2, String.valueOf(factor));
            factorStmt.executeUpdate();
            PreparedStatement timeStmt = conn.prepareStatement("INSERT INTO " + tablePrefix + "_metadata (meta_key, value) VALUES ('last_inflation_update', ?) ON DUPLICATE KEY UPDATE value = ?");
            timeStmt.setString(1, String.valueOf(timestamp));
            timeStmt.setString(2, String.valueOf(timestamp));
            timeStmt.executeUpdate();
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("Error saving inflation data: " + e.getMessage());
        }
    }

    @Override
    public Map<String, Object> getStatistics() {
        HashMap<String, Object> stats = new HashMap<String, Object>();
        String tablePrefix = this.dataConfig.getDatabaseTablePrefix();
        try (Connection conn = this.getConnection();){
            String pricesSql = "SELECT COUNT(*) AS total FROM " + tablePrefix + "_items";
            try (PreparedStatement stmt = conn.prepareStatement(pricesSql);
                 ResultSet rs = stmt.executeQuery();){
                if (rs.next()) {
                    stats.put("total_prices", rs.getInt("total"));
                }
            }
            String txSql = "SELECT COUNT(*) AS total FROM " + tablePrefix + "_transactions_view";
            try (PreparedStatement stmt = conn.prepareStatement(txSql);
                 ResultSet rs = stmt.executeQuery();){
                if (rs.next()) {
                    stats.put("total_records", rs.getInt("total"));
                }
            }
            String typeSql = "SELECT transaction_type, COUNT(*) AS count FROM " + tablePrefix + "_transactions_view GROUP BY transaction_type";
            try (PreparedStatement stmt = conn.prepareStatement(typeSql);
                 ResultSet rs = stmt.executeQuery();){
                while (rs.next()) {
                    stats.put("count_" + rs.getString("transaction_type").toLowerCase(), rs.getInt("count"));
                }
            }
            String oldestSql = "SELECT MIN(transaction_time) AS oldest FROM " + tablePrefix + "_transactions_view";
            try (PreparedStatement stmt = conn.prepareStatement(oldestSql);
                 ResultSet rs = stmt.executeQuery();){
                if (rs.next() && rs.getTimestamp("oldest") != null) {
                    stats.put("oldest_record", rs.getTimestamp("oldest").toString());
                }
            }
            String sizeSql = "SELECT 'stock' AS table_name, COUNT(*) AS row_count FROM " + tablePrefix + "_stock UNION ALL SELECT 'buy_prices', COUNT(*) FROM " + tablePrefix + "_buy_prices UNION ALL SELECT 'sell_prices', COUNT(*) FROM " + tablePrefix + "_sell_prices UNION ALL SELECT 'price_history', COUNT(*) FROM " + tablePrefix + "_price_history";
            try (PreparedStatement stmt = conn.prepareStatement(sizeSql);
                 ResultSet rs = stmt.executeQuery();){
                while (rs.next()) {
                    stats.put("table_" + rs.getString("table_name") + "_count", rs.getInt("row_count"));
                }
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("Error retrieving statistics: " + e.getMessage());
        }
        return stats;
    }

    @FunctionalInterface
    private static interface ResultSetProcessor<T> {
        public T process(ResultSet var1) throws SQLException;
    }
}

