/*
 * Decompiled with CFR 0.152.
 */
package fr.tylwen.satyria.dynashop.data.storage;

import com.google.gson.reflect.TypeToken;
import fr.tylwen.satyria.dynashop.data.storage.JsonStorage;
import fr.tylwen.satyria.dynashop.price.DynamicPrice;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public class PriceDataManager {
    private final File file;
    private Map<String, DynamicPrice> prices = new HashMap<String, DynamicPrice>();

    public PriceDataManager(File file) {
        this.file = file;
    }

    public void load() {
        try {
            Type type = new TypeToken<Map<String, DynamicPrice>>(this){}.getType();
            this.prices = JsonStorage.loadFromFile(this.file, type, new HashMap());
        }
        catch (Exception e) {
            this.prices = new HashMap<String, DynamicPrice>();
        }
    }

    public void save() {
        CompletableFuture.runAsync(() -> {
            try {
                JsonStorage.saveToFile(this.file, this.prices);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        });
    }

    public DynamicPrice get(String key) {
        return this.prices.get(key);
    }

    public void set(String key, DynamicPrice price) {
        this.prices.put(key, price);
    }

    public Map<String, DynamicPrice> getAll() {
        return this.prices;
    }

    public void remove(String key) {
        this.prices.remove(key);
        this.save();
    }
}

