/*
 * Decompiled with CFR 0.152.
 */
package fr.tylwen.satyria.dynashop.data.storage;

import com.google.gson.reflect.TypeToken;
import fr.tylwen.satyria.dynashop.data.storage.JsonStorage;
import fr.tylwen.satyria.dynashop.system.chart.PriceHistory;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;

public class PriceHistoryDataManager {
    private final File baseFolder;
    private final Map<String, PriceHistory> historyCache = new ConcurrentHashMap<String, PriceHistory>();

    public PriceHistoryDataManager(File baseFolder) {
        this.baseFolder = baseFolder;
        if (!baseFolder.exists()) {
            baseFolder.mkdirs();
        }
    }

    public void load() {
        File[] shopFolders = this.baseFolder.listFiles(File::isDirectory);
        if (shopFolders == null) {
            return;
        }
        for (File shopFolder : shopFolders) {
            String shopId = shopFolder.getName();
            File[] itemFiles = shopFolder.listFiles(f -> f.isFile() && f.getName().endsWith(".json"));
            if (itemFiles == null) continue;
            for (File itemFile : itemFiles) {
                String itemId = itemFile.getName().replace(".json", "");
                try {
                    Type type = new TypeToken<List<PriceHistory.PriceDataPoint>>(this){}.getType();
                    List dataPoints = JsonStorage.loadFromFile(itemFile, type, new ArrayList());
                    PriceHistory history = new PriceHistory(shopId, itemId);
                    history.setDataPoints(dataPoints);
                    String key = this.getHistoryKey(shopId, itemId);
                    this.historyCache.put(key, history);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public void save() {
        CompletableFuture.runAsync(() -> {
            for (Map.Entry<String, PriceHistory> entry : this.historyCache.entrySet()) {
                String[] parts = entry.getKey().split(":");
                if (parts.length != 2) continue;
                String shopId = parts[0];
                String itemId = parts[1];
                File shopFolder = new File(this.baseFolder, shopId);
                if (!shopFolder.exists()) {
                    shopFolder.mkdirs();
                }
                File itemFile = new File(shopFolder, itemId + ".json");
                try {
                    JsonStorage.saveToFile(itemFile, entry.getValue().getDataPoints());
                }
                catch (IOException iOException) {}
            }
        });
    }

    public PriceHistory getPriceHistory(String shopId, String itemId) {
        String key = this.getHistoryKey(shopId, itemId);
        PriceHistory history = this.historyCache.get(key);
        if (history == null) {
            history = new PriceHistory(shopId, itemId);
            this.historyCache.put(key, history);
        }
        return history;
    }

    public void getAll(String shopId, String itemId, Consumer<PriceHistory> callback) {
        CompletableFuture.runAsync(() -> {
            PriceHistory history = this.getPriceHistory(shopId, itemId);
            callback.accept(history);
        });
    }

    public Map<String, PriceHistory> getAll() {
        return new HashMap<String, PriceHistory>(this.historyCache);
    }

    public void addDataPoint(String shopId, String itemId, PriceHistory.PriceDataPoint dataPoint) {
        PriceHistory history = this.getPriceHistory(shopId, itemId);
        history.getDataPoints().add(dataPoint);
    }

    public void purgeOldHistory(int daysToKeep) {
        LocalDateTime cutoff = LocalDateTime.now().minusDays(daysToKeep);
        this.purgeOldData(cutoff);
    }

    public void purgeOldData(LocalDateTime cutoff) {
        for (PriceHistory history : this.historyCache.values()) {
            List<PriceHistory.PriceDataPoint> dataPoints = history.getDataPoints();
            ArrayList<PriceHistory.PriceDataPoint> filtered = new ArrayList<PriceHistory.PriceDataPoint>();
            for (PriceHistory.PriceDataPoint point : dataPoints) {
                if (!point.getTimestamp().isAfter(cutoff)) continue;
                filtered.add(point);
            }
            if (filtered.size() >= dataPoints.size()) continue;
            history.setDataPoints(filtered);
        }
    }

    private String getHistoryKey(String shopId, String itemId) {
        return shopId + ":" + itemId;
    }

    public void savePriceHistory(PriceHistory history) {
        String key = this.getHistoryKey(history.getShopId(), history.getItemId());
        this.historyCache.put(key, history);
        CompletableFuture.runAsync(() -> {
            File shopFolder = new File(this.baseFolder, history.getShopId());
            if (!shopFolder.exists()) {
                shopFolder.mkdirs();
            }
            File itemFile = new File(shopFolder, history.getItemId() + ".json");
            try {
                JsonStorage.saveToFile(itemFile, history.getDataPoints());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        });
    }
}

