/*
 * Decompiled with CFR 0.152.
 */
package fr.tylwen.satyria.dynashop.data.storage;

import com.google.gson.reflect.TypeToken;
import fr.tylwen.satyria.dynashop.data.storage.JsonStorage;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public class StockDataManager {
    private final File file;
    private Map<String, Integer> stock = new HashMap<String, Integer>();
    private final Object lock = new Object();

    public StockDataManager(File file) {
        this.file = file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() {
        Object object = this.lock;
        synchronized (object) {
            try {
                Map loadedData;
                this.stock = this.file.exists() ? ((loadedData = (Map)JsonStorage.loadFromFile(this.file, new TypeToken<Map<String, Integer>>(this){}.getType(), new HashMap())) != null ? Collections.synchronizedMap(new HashMap(loadedData)) : Collections.synchronizedMap(new HashMap())) : Collections.synchronizedMap(new HashMap());
            }
            catch (Exception e) {
                this.stock = Collections.synchronizedMap(new HashMap());
            }
        }
    }

    public void save() {
        CompletableFuture.runAsync(() -> {
            Object object = this.lock;
            synchronized (object) {
                try {
                    HashMap<String, Integer> stockCopy = new HashMap<String, Integer>(this.stock);
                    JsonStorage.saveToFile(this.file, stockCopy);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer get(String key) {
        Object object = this.lock;
        synchronized (object) {
            return this.stock.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(String key, Integer value) {
        Object object = this.lock;
        synchronized (object) {
            this.stock.put(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Integer> getAll() {
        Object object = this.lock;
        synchronized (object) {
            return new HashMap<String, Integer>(this.stock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String key) {
        Object object = this.lock;
        synchronized (object) {
            this.stock.remove(key);
        }
    }
}

