/*
 * Decompiled with CFR 0.152.
 */
package fr.tylwen.satyria.dynashop.data.storage;

import fr.tylwen.satyria.dynashop.data.model.TransactionRecord;
import fr.tylwen.satyria.dynashop.price.DynamicPrice;
import fr.tylwen.satyria.dynashop.system.chart.PriceHistory;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.brcdev.shopgui.shop.item.ShopItem;

public interface StorageManager {
    public void initialize();

    public void shutdown();

    public Optional<DynamicPrice> getPrices(String var1, String var2);

    public Optional<Double> getBuyPrice(String var1, String var2);

    public Optional<Double> getSellPrice(String var1, String var2);

    public Optional<Integer> getStock(String var1, String var2);

    public void savePrice(String var1, String var2, double var3, double var5, int var7);

    public void saveBuyPrice(String var1, String var2, double var3);

    public void saveSellPrice(String var1, String var2, double var3);

    public void saveStock(String var1, String var2, int var3);

    public void deleteStock(String var1, String var2);

    public void cleanupStockTable();

    public void deleteItem(String var1, String var2);

    public boolean itemExists(String var1, String var2);

    public Map<ShopItem, DynamicPrice> loadAllPrices();

    public void saveTransactionsBatch(List<TransactionRecord> var1);

    public int getUsedAmount(UUID var1, String var2, String var3, boolean var4, LocalDateTime var5);

    public Optional<LocalDateTime> getLastTransactionTime(UUID var1, String var2, String var3, boolean var4);

    public boolean resetLimits(UUID var1, String var2, String var3);

    public boolean resetAllLimits(UUID var1);

    public boolean resetAllLimits();

    public void cleanupExpiredTransactions();

    public PriceHistory getPriceHistory(String var1, String var2);

    public List<PriceHistory.PriceDataPoint> getAggregatedPriceHistory(String var1, String var2, int var3, LocalDateTime var4, int var5);

    public void savePriceDataPoint(String var1, String var2, PriceHistory.PriceDataPoint var3, int var4);

    public void purgeOldPriceHistory(int var1);

    public double getInflationFactor();

    public long getLastInflationUpdate();

    public void saveInflationData(double var1, long var3);

    public <T> CompletableFuture<T> executeAsync(DatabaseOperation<T> var1);

    public Map<String, Object> getStatistics();

    @FunctionalInterface
    public static interface DatabaseOperation<T> {
        public T execute() throws Exception;
    }
}

