/*
 * Decompiled with CFR 0.152.
 */
package fr.tylwen.satyria.dynashop.data.storage.database;

import fr.tylwen.satyria.dynashop.DynaShopPlugin;
import fr.tylwen.satyria.dynashop.data.param.DynaShopType;
import fr.tylwen.satyria.dynashop.price.DynamicPrice;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;

public class BatchDatabaseUpdater {
    private final Map<String, DynamicPrice> pendingUpdates = new ConcurrentHashMap<String, DynamicPrice>();
    private final DynaShopPlugin plugin;
    private final Thread backgroundThread;
    private final AtomicBoolean running = new AtomicBoolean(true);

    public BatchDatabaseUpdater(DynaShopPlugin plugin) {
        this.plugin = plugin;
        this.backgroundThread = new Thread(() -> {
            while (this.running.get()) {
                try {
                    this.flushUpdates();
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    break;
                }
                catch (Exception e) {
                    plugin.getLogger().severe("Error updating prices: " + e.getMessage());
                }
            }
        });
        this.backgroundThread.setDaemon(true);
        this.backgroundThread.setName("DynaShop-DBUpdater");
        this.backgroundThread.start();
    }

    public void queueUpdate(String shopID, String itemID, DynamicPrice price, boolean immediate) {
        String key = shopID + ":" + itemID;
        this.pendingUpdates.put(key, price);
        if (immediate || price.getDynaShopType() == DynaShopType.RECIPE) {
            this.flushUpdates();
        }
        DynaShopPlugin.getInstance().invalidatePriceCache(shopID, itemID, null);
    }

    public void queuePriceUpdate(String shopID, String itemID, double buyPrice, double sellPrice) {
        String key = shopID + ":" + itemID;
        DynamicPrice price = this.pendingUpdates.computeIfAbsent(key, k -> {
            Optional<Integer> stockOptional = this.plugin.getStorageManager().getStock(shopID, itemID);
            int stock = stockOptional.orElse(0);
            return new DynamicPrice(buyPrice, sellPrice, stock);
        });
        price.setBuyPrice(buyPrice);
        price.setSellPrice(sellPrice);
        this.pendingUpdates.put(key, price);
    }

    public void queueStockUpdate(String shopID, String itemID, int stock) {
        String key = shopID + ":" + itemID;
        DynamicPrice price = this.pendingUpdates.computeIfAbsent(key, k -> {
            Optional<DynamicPrice> priceOptional = this.plugin.getStorageManager().getPrices(shopID, itemID);
            return priceOptional.orElse(new DynamicPrice(0.0, 0.0, stock));
        });
        price.setStock(stock);
        this.pendingUpdates.put(key, price);
    }

    private void flushUpdates() {
        if (this.pendingUpdates.isEmpty()) {
            return;
        }
        HashMap<String, DynamicPrice> updates = new HashMap<String, DynamicPrice>(this.pendingUpdates);
        this.pendingUpdates.clear();
        for (Map.Entry entry : updates.entrySet()) {
            String[] parts = ((String)entry.getKey()).split(":");
            if (parts.length != 2) continue;
            String shopID = parts[0];
            String itemID = parts[1];
            DynamicPrice price = (DynamicPrice)entry.getValue();
            try {
                this.plugin.getStorageManager().savePrice(shopID, itemID, price.getBuyPrice(), price.getSellPrice(), price.getStock());
            }
            catch (Exception e) {
                this.plugin.getLogger().severe("Erreur lors de la mise \u00e0 jour du prix pour " + shopID + ":" + itemID + ": " + e.getMessage());
                this.pendingUpdates.put(shopID + ":" + itemID, price);
            }
        }
    }

    public void shutdown() {
        this.running.set(false);
        this.backgroundThread.interrupt();
        try {
            this.backgroundThread.join(5000L);
        }
        catch (InterruptedException e) {
            this.plugin.getLogger().warning("Interrupted while waiting for database updater to finish");
            Thread.currentThread().interrupt();
        }
        if (this.backgroundThread.isAlive()) {
            this.plugin.getLogger().warning("Database updater thread did not terminate gracefully");
            this.flushUpdates();
        }
    }
}

