/*
 * Decompiled with CFR 0.152.
 */
package fr.tylwen.satyria.dynashop.data.storage.limit;

import com.google.gson.reflect.TypeToken;
import fr.tylwen.satyria.dynashop.data.cache.LimitCacheEntry;
import fr.tylwen.satyria.dynashop.data.storage.JsonStorage;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public class LimitDataManager {
    private final File file;
    private Map<String, LimitCacheEntry> cache = new HashMap<String, LimitCacheEntry>();

    public LimitDataManager(File file) {
        this.file = file;
    }

    public void load() {
        try {
            Type type = new TypeToken<Map<String, LimitCacheEntry>>(this){}.getType();
            this.cache = JsonStorage.loadFromFile(this.file, type, new HashMap());
        }
        catch (Exception e) {
            this.cache = new HashMap<String, LimitCacheEntry>();
        }
    }

    public void save() {
        CompletableFuture.runAsync(() -> {
            try {
                JsonStorage.saveToFile(this.file, this.cache);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        });
    }

    public LimitCacheEntry get(String key) {
        return this.cache.get(key);
    }

    public void set(String key, LimitCacheEntry value) {
        this.cache.put(key, value);
    }

    public Map<String, LimitCacheEntry> getAll() {
        return this.cache;
    }
}

