/*
 * Decompiled with CFR 0.152.
 */
package fr.tylwen.satyria.dynashop.hook;

import fr.tylwen.satyria.dynashop.DynaShopPlugin;
import fr.tylwen.satyria.dynashop.data.ShopConfigManager;
import fr.tylwen.satyria.dynashop.data.cache.LimitCacheEntry;
import fr.tylwen.satyria.dynashop.data.storage.StorageManager;
import fr.tylwen.satyria.dynashop.listener.ShopItemPlaceholderListener;
import fr.tylwen.satyria.dynashop.price.PriceRecipe;
import fr.tylwen.satyria.dynashop.system.TransactionLimiter;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.HashSet;
import java.util.Optional;
import me.clip.placeholderapi.PlaceholderAPI;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import net.brcdev.shopgui.ShopGuiPlusApi;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class DynaShopExpansion
extends PlaceholderExpansion {
    private final DynaShopPlugin plugin;
    private final StorageManager storageManager;
    private final ShopConfigManager shopConfigManager;
    private final PriceRecipe priceRecipe;

    public DynaShopExpansion(DynaShopPlugin plugin) {
        this.plugin = plugin;
        this.shopConfigManager = plugin.getShopConfigManager();
        this.priceRecipe = plugin.getPriceRecipe();
        this.storageManager = plugin.getStorageManager();
    }

    public String getIdentifier() {
        return "dynashop";
    }

    public String getAuthor() {
        return "Tylwen";
    }

    public String getVersion() {
        return this.plugin.getDescription().getVersion();
    }

    public boolean persist() {
        return true;
    }

    public boolean canRegister() {
        return true;
    }

    public boolean register() {
        boolean registered = super.register();
        if (registered) {
            this.plugin.getLogger().info("Placeholders DynaShop enregistr\u00e9s avec succ\u00e8s");
        }
        return registered;
    }

    public String onRequest(OfflinePlayer player, String identifier) {
        LimitCacheEntry limit;
        String itemID;
        String shopID;
        String[] parts;
        String itemId;
        String shopId;
        ShopItemPlaceholderListener listener;
        Player p;
        if (identifier.equals("current_buy") && player instanceof Player) {
            p = (Player)player;
            listener = this.plugin.getShopItemPlaceholderListener();
            shopId = listener.getCurrentShopId(p);
            itemId = listener.getCurrentItemId(p);
            if (shopId != null && itemId != null) {
                String buyPrice = this.plugin.getPriceFormatter().getPriceByType(shopId, itemId, "buy");
                String buyMinPrice = this.plugin.getPriceFormatter().getPriceByType(shopId, itemId, "buy_min");
                String buyMaxPrice = this.plugin.getPriceFormatter().getPriceByType(shopId, itemId, "buy_max");
                if (buyPrice != null && buyMinPrice != null && buyMaxPrice != null) {
                    return String.format("%s (%s - %s)", buyPrice, buyMinPrice, buyMaxPrice);
                }
                if (buyPrice != null) {
                    return buyPrice;
                }
                return "N/A";
            }
        }
        if (identifier.equals("current_buyPrice") && player instanceof Player) {
            p = (Player)player;
            listener = this.plugin.getShopItemPlaceholderListener();
            if (listener == null) {
                this.plugin.getLogger().warning("ShopItemPlaceholderListener est null dans DynaShopExpansion.onRequest()");
                return "N/A";
            }
            shopId = listener.getCurrentShopId(p);
            itemId = listener.getCurrentItemId(p);
            if (shopId != null && itemId != null) {
                String price = this.plugin.getPriceFormatter().getPriceByType(shopId, itemId, "buy");
                return price != null ? price : "N/A";
            }
            return "N/A";
        }
        if (identifier.equals("current_buyMinPrice") && player instanceof Player) {
            p = (Player)player;
            listener = this.plugin.getShopItemPlaceholderListener();
            if (listener == null) {
                this.plugin.getLogger().warning("ShopItemPlaceholderListener est null dans DynaShopExpansion.onRequest()");
                return "N/A";
            }
            shopId = listener.getCurrentShopId(p);
            itemId = listener.getCurrentItemId(p);
            if (shopId != null && itemId != null) {
                String price = this.plugin.getPriceFormatter().getPriceByType(shopId, itemId, "buy_min");
                return price != null ? price : "N/A";
            }
            return "N/A";
        }
        if (identifier.equals("current_buyMaxPrice") && player instanceof Player) {
            p = (Player)player;
            listener = this.plugin.getShopItemPlaceholderListener();
            if (listener == null) {
                this.plugin.getLogger().warning("ShopItemPlaceholderListener est null dans DynaShopExpansion.onRequest()");
                return "N/A";
            }
            shopId = listener.getCurrentShopId(p);
            itemId = listener.getCurrentItemId(p);
            if (shopId != null && itemId != null) {
                String price = this.plugin.getPriceFormatter().getPriceByType(shopId, itemId, "buy_max");
                return price != null ? price : "N/A";
            }
            return "N/A";
        }
        if (identifier.equals("current_sell") && player instanceof Player) {
            p = (Player)player;
            listener = this.plugin.getShopItemPlaceholderListener();
            shopId = listener.getCurrentShopId(p);
            itemId = listener.getCurrentItemId(p);
            if (shopId != null && itemId != null) {
                String sellPrice = this.plugin.getPriceFormatter().getPriceByType(shopId, itemId, "sell");
                String sellMinPrice = this.plugin.getPriceFormatter().getPriceByType(shopId, itemId, "sell_min");
                String sellMaxPrice = this.plugin.getPriceFormatter().getPriceByType(shopId, itemId, "sell_max");
                if (sellPrice != null && sellMinPrice != null && sellMaxPrice != null) {
                    return String.format("%s (%s - %s)", sellPrice, sellMinPrice, sellMaxPrice);
                }
                if (sellPrice != null) {
                    return sellPrice;
                }
                return "N/A";
            }
        }
        if (identifier.equals("current_sellPrice") && player instanceof Player) {
            p = (Player)player;
            listener = this.plugin.getShopItemPlaceholderListener();
            if (listener == null) {
                this.plugin.getLogger().warning("ShopItemPlaceholderListener est null dans DynaShopExpansion.onRequest()");
                return "N/A";
            }
            shopId = listener.getCurrentShopId(p);
            itemId = listener.getCurrentItemId(p);
            if (shopId != null && itemId != null) {
                String price = this.plugin.getPriceFormatter().getPriceByType(shopId, itemId, "sell");
                return price != null ? price : "N/A";
            }
            return "N/A";
        }
        if (identifier.equals("current_sellMinPrice") && player instanceof Player) {
            p = (Player)player;
            listener = this.plugin.getShopItemPlaceholderListener();
            if (listener == null) {
                this.plugin.getLogger().warning("ShopItemPlaceholderListener est null dans DynaShopExpansion.onRequest()");
                return "N/A";
            }
            shopId = listener.getCurrentShopId(p);
            itemId = listener.getCurrentItemId(p);
            if (shopId != null && itemId != null) {
                String price = this.plugin.getPriceFormatter().getPriceByType(shopId, itemId, "sell_min");
                return price != null ? price : "N/A";
            }
            return "N/A";
        }
        if (identifier.equals("current_sellMaxPrice") && player instanceof Player) {
            p = (Player)player;
            listener = this.plugin.getShopItemPlaceholderListener();
            if (listener == null) {
                this.plugin.getLogger().warning("ShopItemPlaceholderListener est null dans DynaShopExpansion.onRequest()");
                return "N/A";
            }
            shopId = listener.getCurrentShopId(p);
            itemId = listener.getCurrentItemId(p);
            if (shopId != null && itemId != null) {
                String price = this.plugin.getPriceFormatter().getPriceByType(shopId, itemId, "sell_max");
                return price != null ? price : "N/A";
            }
            return "N/A";
        }
        if (identifier.startsWith("buy_price")) {
            parts = identifier.substring(10).split(":");
            if (parts.length != 2) {
                return null;
            }
            shopID = parts[0].replace("-", "_").replace(" ", "_");
            boolean useRecipe = this.shopConfigManager.getItemValue(shopID, itemID = parts[1].replace("-", "_").replace(" ", "_"), "useRecipe", Boolean.class).orElse(false);
            if (useRecipe) {
                ItemStack itemStack = ShopGuiPlusApi.getShop((String)shopID).getShopItem(itemID).getItem();
                if (itemStack != null) {
                    double recipeBuyPrice = this.priceRecipe.calculatePrice(shopID, itemID, itemStack, "buyPrice", new HashSet<String>());
                    return String.valueOf(recipeBuyPrice);
                }
                return "N/A";
            }
            Optional<Double> buyPrice = this.storageManager.getBuyPrice(shopID, itemID);
            if (buyPrice.isPresent()) {
                return String.valueOf(buyPrice.get());
            }
            Optional<Double> configBuyPrice = this.shopConfigManager.getItemValue(shopID, itemID, "buyPrice", Double.class);
            if (configBuyPrice.isPresent()) {
                return String.valueOf(configBuyPrice.get());
            }
            return "N/A";
        }
        if (identifier.startsWith("sell_price")) {
            parts = identifier.substring(11).split(":");
            if (parts.length != 2) {
                return null;
            }
            shopID = parts[0].replace("-", "_").replace(" ", "_");
            boolean useRecipe = this.shopConfigManager.getItemValue(shopID, itemID = parts[1].replace("-", "_").replace(" ", "_"), "useRecipe", Boolean.class).orElse(false);
            if (useRecipe) {
                ItemStack itemStack = ShopGuiPlusApi.getShop((String)shopID).getShopItem(itemID).getItem();
                if (itemStack != null) {
                    double recipeSellPrice = this.priceRecipe.calculatePrice(shopID, itemID, itemStack, "sellPrice", new HashSet<String>());
                    return String.valueOf(recipeSellPrice);
                }
                return "N/A";
            }
            Optional<Double> sellPrice = this.storageManager.getSellPrice(shopID, itemID);
            if (sellPrice.isPresent()) {
                return String.valueOf(sellPrice.get());
            }
            Optional<Double> configSellPrice = this.shopConfigManager.getItemValue(shopID, itemID, "sellPrice", Double.class);
            if (configSellPrice.isPresent()) {
                return String.valueOf(configSellPrice.get());
            }
            return "N/A";
        }
        if (identifier.startsWith("buy_min_price")) {
            parts = identifier.substring(15).split(":");
            if (parts.length != 2) {
                return null;
            }
            shopID = parts[0];
            itemID = parts[1];
            boolean useRecipe = this.shopConfigManager.getItemValue(shopID, itemID, "useRecipe", Boolean.class).orElse(false);
            if (useRecipe) {
                ItemStack itemStack = ShopGuiPlusApi.getShop((String)shopID).getShopItem(itemID).getItem();
                if (itemStack != null) {
                    double recipeMinBuyPrice = this.priceRecipe.calculatePrice(shopID, itemID, itemStack, "buyDynamic.min", new HashSet<String>());
                    return String.valueOf(recipeMinBuyPrice);
                }
                return "N/A";
            }
            Optional<Double> minBuyPrice = this.shopConfigManager.getItemValue(shopID, itemID, "minBuy", Double.class);
            if (minBuyPrice.isPresent()) {
                return String.valueOf(minBuyPrice.get());
            }
            return "N/A";
        }
        if (identifier.startsWith("buy_max_price")) {
            parts = identifier.substring(15).split(":");
            if (parts.length != 2) {
                return null;
            }
            shopID = parts[0];
            itemID = parts[1];
            boolean useRecipe = this.shopConfigManager.getItemValue(shopID, itemID, "useRecipe", Boolean.class).orElse(false);
            if (useRecipe) {
                ItemStack itemStack = ShopGuiPlusApi.getShop((String)shopID).getShopItem(itemID).getItem();
                if (itemStack != null) {
                    double recipeMaxBuyPrice = this.priceRecipe.calculatePrice(shopID, itemID, itemStack, "buyDynamic.max", new HashSet<String>());
                    return String.valueOf(recipeMaxBuyPrice);
                }
                return "N/A";
            }
            Optional<Double> maxBuyPrice = this.shopConfigManager.getItemValue(shopID, itemID, "maxBuy", Double.class);
            if (maxBuyPrice.isPresent()) {
                return String.valueOf(maxBuyPrice.get());
            }
            return "N/A";
        }
        if (identifier.startsWith("sell_min_price")) {
            parts = identifier.substring(16).split(":");
            if (parts.length != 2) {
                return null;
            }
            shopID = parts[0];
            itemID = parts[1];
            boolean useRecipe = this.shopConfigManager.getItemValue(shopID, itemID, "useRecipe", Boolean.class).orElse(false);
            if (useRecipe) {
                ItemStack itemStack = ShopGuiPlusApi.getShop((String)shopID).getShopItem(itemID).getItem();
                if (itemStack != null) {
                    double recipeMinSellPrice = this.priceRecipe.calculatePrice(shopID, itemID, itemStack, "sellDynamic.min", new HashSet<String>());
                    return String.valueOf(recipeMinSellPrice);
                }
                return "N/A";
            }
            Optional<Double> minSellPrice = this.shopConfigManager.getItemValue(shopID, itemID, "minSell", Double.class);
            if (minSellPrice.isPresent()) {
                return String.valueOf(minSellPrice.get());
            }
            return "N/A";
        }
        if (identifier.startsWith("sell_max_price")) {
            parts = identifier.substring(16).split(":");
            if (parts.length != 2) {
                return null;
            }
            shopID = parts[0];
            itemID = parts[1];
            boolean useRecipe = this.shopConfigManager.getItemValue(shopID, itemID, "useRecipe", Boolean.class).orElse(false);
            if (useRecipe) {
                ItemStack itemStack = ShopGuiPlusApi.getShop((String)shopID).getShopItem(itemID).getItem();
                if (itemStack != null) {
                    double recipeMaxSellPrice = this.priceRecipe.calculatePrice(shopID, itemID, itemStack, "sellDynamic.max", new HashSet<String>());
                    return String.valueOf(recipeMaxSellPrice);
                }
                return "N/A";
            }
            Optional<Double> maxSellPrice = this.shopConfigManager.getItemValue(shopID, itemID, "maxSell", Double.class);
            if (maxSellPrice.isPresent()) {
                return String.valueOf(maxSellPrice.get());
            }
            return "N/A";
        }
        if (identifier.startsWith("limit_buy_remaining_")) {
            parts = identifier.substring("limit_buy_remaining_".length()).split(":");
            if (parts.length != 2) {
                return null;
            }
            shopID = parts[0];
            itemID = parts[1];
            if (!(player instanceof Player)) {
                return "N/A";
            }
            limit = this.plugin.getTransactionLimiter().getTransactionLimit((Player)player, shopID, itemID, true);
            if (limit != null && limit.baseLimit > 0) {
                return String.valueOf(limit.remaining);
            }
            return this.plugin.getLangConfig().getPlaceholderNoLimit();
        }
        if (identifier.startsWith("limit_sell_remaining_")) {
            parts = identifier.substring("limit_sell_remaining_".length()).split(":");
            if (parts.length != 2) {
                return null;
            }
            shopID = parts[0];
            itemID = parts[1];
            if (!(player instanceof Player)) {
                return "N/A";
            }
            limit = this.plugin.getTransactionLimiter().getTransactionLimit((Player)player, shopID, itemID, false);
            if (limit != null && limit.baseLimit > 0) {
                return String.valueOf(limit.remaining);
            }
            return this.plugin.getLangConfig().getPlaceholderNoLimit();
        }
        if (player != null) {
            String itemInfo;
            String[] parts2;
            if (identifier.startsWith("buy_limit_") && (parts2 = (itemInfo = identifier.substring("buy_limit_".length())).split("_")).length == 2) {
                shopId = parts2[0];
                itemId = parts2[1];
                LimitCacheEntry limit2 = this.plugin.getTransactionLimiter().getTransactionLimit((Player)player, shopId, itemId, true);
                if (limit2 == null || limit2.baseLimit <= 0) {
                    return this.plugin.getLangConfig().getPlaceholderNoLimit();
                }
                try {
                    return String.valueOf(limit2.remaining);
                }
                catch (Exception e) {
                    return "N/A";
                }
            }
            if (identifier.startsWith("sell_limit_") && (parts2 = (itemInfo = identifier.substring("sell_limit_".length())).split("_")).length == 2) {
                shopId = parts2[0];
                itemId = parts2[1];
                LimitCacheEntry limit3 = this.plugin.getTransactionLimiter().getTransactionLimit((Player)player, shopId, itemId, false);
                if (limit3 == null || limit3.baseLimit <= 0) {
                    return this.plugin.getLangConfig().getPlaceholderNoLimit();
                }
                try {
                    return String.valueOf(limit3.remaining);
                }
                catch (Exception e) {
                    return "N/A";
                }
            }
            if (identifier.startsWith("next_buy_reset_") && (parts2 = (itemInfo = identifier.substring("next_buy_reset_".length())).split("_")).length == 2) {
                shopId = parts2[0];
                itemId = parts2[1];
                LimitCacheEntry limit4 = this.plugin.getTransactionLimiter().getTransactionLimit((Player)player, shopId, itemId, true);
                if (limit4 == null || limit4.baseLimit <= 0) {
                    return this.plugin.getLangConfig().getPlaceholderNoLimit();
                }
                try {
                    return this.formatTimeRemaining(limit4.nextAvailable, limit4);
                }
                catch (Exception e) {
                    return "N/A";
                }
            }
            if (identifier.startsWith("next_sell_reset_") && (parts2 = (itemInfo = identifier.substring("next_sell_reset_".length())).split("_")).length == 2) {
                shopId = parts2[0];
                itemId = parts2[1];
                LimitCacheEntry limit5 = this.plugin.getTransactionLimiter().getTransactionLimit((Player)player, shopId, itemId, false);
                if (limit5 == null || limit5.baseLimit <= 0) {
                    return this.plugin.getLangConfig().getPlaceholderNoLimit();
                }
                try {
                    return this.formatTimeRemaining(limit5.nextAvailable, limit5);
                }
                catch (Exception e) {
                    return "N/A";
                }
            }
        }
        return null;
    }

    private String formatTimeRemaining(long millisRemaining, LimitCacheEntry limit) {
        if (millisRemaining <= 0L) {
            return this.plugin.getLangConfig().getPlaceholderNoLimit();
        }
        TransactionLimiter.LimitPeriod period = this.getPeriodForCooldown(limit.cooldown);
        if (period != TransactionLimiter.LimitPeriod.NONE) {
            LocalDateTime resetTime = LocalDateTime.now().plus(millisRemaining, ChronoUnit.MILLIS);
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("dd.MM.yyyy HH:mm:ss");
            return resetTime.format(formatter);
        }
        long secondsRemaining = millisRemaining / 1000L;
        long hours = secondsRemaining / 3600L;
        long minutes = secondsRemaining % 3600L / 60L;
        long seconds = secondsRemaining % 60L;
        if (hours > 0L) {
            return String.format("%02dh %02dm %02ds", hours, minutes, seconds);
        }
        if (minutes > 0L) {
            return String.format("%02dm %02ds", minutes, seconds);
        }
        return String.format("%02ds", seconds);
    }

    private TransactionLimiter.LimitPeriod getPeriodForCooldown(int cooldown) {
        if (cooldown >= 31536000) {
            return TransactionLimiter.LimitPeriod.FOREVER;
        }
        if (cooldown >= 2592000) {
            return TransactionLimiter.LimitPeriod.MONTHLY;
        }
        if (cooldown >= 604800) {
            return TransactionLimiter.LimitPeriod.WEEKLY;
        }
        if (cooldown >= 86400) {
            return TransactionLimiter.LimitPeriod.DAILY;
        }
        return TransactionLimiter.LimitPeriod.NONE;
    }

    public String setPlaceholders(Player player, String identifier) {
        return PlaceholderAPI.setPlaceholders((Player)player, (String)identifier);
    }
}

