/*
 * Decompiled with CFR 0.152.
 */
package fr.tylwen.satyria.dynashop.listener;

import fr.tylwen.satyria.dynashop.DynaShopPlugin;
import fr.tylwen.satyria.dynashop.config.DataConfig;
import fr.tylwen.satyria.dynashop.data.ItemPriceData;
import fr.tylwen.satyria.dynashop.data.ShopConfigManager;
import fr.tylwen.satyria.dynashop.data.cache.LimitCacheEntry;
import fr.tylwen.satyria.dynashop.data.param.DynaShopType;
import fr.tylwen.satyria.dynashop.price.DynamicPrice;
import fr.tylwen.satyria.dynashop.price.PriceRecipe;
import fr.tylwen.satyria.dynashop.system.chart.PriceHistory;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.brcdev.shopgui.ShopGuiPlusApi;
import net.brcdev.shopgui.event.ShopPostTransactionEvent;
import net.brcdev.shopgui.event.ShopPreTransactionEvent;
import net.brcdev.shopgui.exception.player.PlayerDataNotLoadedException;
import net.brcdev.shopgui.modifier.PriceModifierActionType;
import net.brcdev.shopgui.shop.ShopManager;
import net.brcdev.shopgui.shop.ShopTransactionResult;
import net.brcdev.shopgui.shop.item.ShopItem;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class DynaShopListener
implements Listener {
    private final DynaShopPlugin plugin;
    private final PriceRecipe priceRecipe;
    private final DataConfig dataConfig;
    private final ShopConfigManager shopConfigManager;

    public DynaShopListener(DynaShopPlugin plugin) {
        this.plugin = plugin;
        this.priceRecipe = new PriceRecipe(plugin);
        this.dataConfig = new DataConfig((FileConfiguration)plugin.getConfigMain());
        this.shopConfigManager = plugin.getShopConfigManager();
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onShopPreTransaction(ShopPreTransactionEvent event) throws PlayerDataNotLoadedException {
        boolean isBuy;
        Player player = event.getPlayer();
        ShopItem item = event.getShopItem();
        int amount = event.getAmount();
        String shopID = item.getShop().getId();
        String itemID = item.getId();
        ItemStack itemStack = item.getItem();
        boolean bl = isBuy = event.getShopAction() == ShopManager.ShopAction.BUY;
        if (this.checkTransactionLimits(player, shopID, itemID, isBuy, amount, event)) {
            return;
        }
        if (!this.shopConfigManager.getItemValue(shopID, itemID, "typeDynaShop", String.class).isPresent()) {
            return;
        }
        DynamicPrice price = this.getOrLoadPriceInternal(null, shopID, itemID, itemStack, new HashSet<String>(), new HashMap<String, DynamicPrice>(), false);
        if (price == null) {
            return;
        }
        DynaShopType typeDynaShop = price.getDynaShopType();
        if (this.checkStockLimits(event, typeDynaShop, price, shopID, itemID, amount)) {
            return;
        }
        if (this.checkRecipeStockLimits(event, typeDynaShop, shopID, itemID, amount)) {
            return;
        }
        this.recordPriceForHistory(shopID, itemID, price, isBuy, amount);
        this.applyPriceModifiers(event, price, player, item);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onShopPostTransaction(ShopPostTransactionEvent event) {
        if (event.getResult().getResult() != ShopTransactionResult.ShopTransactionResultType.SUCCESS) {
            return;
        }
        Player player = event.getResult().getPlayer();
        ShopItem item = event.getResult().getShopItem();
        int amount = event.getResult().getAmount();
        String shopID = item.getShop().getId();
        String itemID = item.getId();
        ItemStack itemStack = item.getItem().clone();
        ShopManager.ShopAction action = event.getResult().getShopAction();
        double resultPrice = event.getResult().getPrice();
        boolean isBuy = action == ShopManager.ShopAction.BUY;
        this.applyTaxes(player, resultPrice, shopID, itemID, isBuy);
        this.plugin.invalidatePriceCache(shopID, itemID, player);
        DynaShopType typeDynaShop = this.shopConfigManager.resolveTypeDynaShop(shopID, itemID, isBuy);
        this.handleRecipeTypeItems(shopID, itemID, typeDynaShop);
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> this.processTransactionAsync(shopID, itemID, itemStack, amount, action));
        this.updateStorageData(player, shopID, itemID, isBuy, amount);
    }

    private boolean checkTransactionLimits(Player player, String shopID, String itemID, boolean isBuy, int amount, ShopPreTransactionEvent event) {
        boolean canPerform;
        if (this.plugin.getShopConfigManager().hasSection(shopID, itemID, "limit") && !(canPerform = this.plugin.getTransactionLimiter().canPerformTransactionSync(player, shopID, itemID, isBuy, amount))) {
            this.handleLimitExceeded(player, shopID, itemID, isBuy, event);
            return true;
        }
        return false;
    }

    private boolean checkStockLimits(ShopPreTransactionEvent event, DynaShopType typeDynaShop, DynamicPrice price, String shopID, String itemID, int amount) {
        String[] parts;
        String linkedItemRef;
        ShopManager.ShopAction action = event.getShopAction();
        boolean isBuy = action == ShopManager.ShopAction.BUY;
        boolean isSell = action == ShopManager.ShopAction.SELL || action == ShopManager.ShopAction.SELL_ALL;
        String effectiveShopID = shopID;
        String effectiveItemID = itemID;
        DynaShopType effectiveType = typeDynaShop;
        if (typeDynaShop == DynaShopType.LINK && (linkedItemRef = (String)this.shopConfigManager.getItemValue(shopID, itemID, "link", String.class).orElse(null)) != null && linkedItemRef.contains(":") && (parts = linkedItemRef.split(":")).length == 2) {
            effectiveShopID = parts[0];
            effectiveItemID = parts[1];
            effectiveType = this.shopConfigManager.getTypeDynaShop(effectiveShopID, effectiveItemID);
        }
        if (effectiveType != DynaShopType.STOCK && effectiveType != DynaShopType.STATIC_STOCK) {
            return false;
        }
        boolean limitExceeded = false;
        String message = null;
        if (isBuy && !this.plugin.getPriceStock().canBuy(effectiveShopID, effectiveItemID, amount)) {
            limitExceeded = true;
            message = this.plugin.getLangConfig().getMsgOutOfStock();
        } else if (isSell && !this.plugin.getPriceStock().canSell(effectiveShopID, effectiveItemID, amount)) {
            limitExceeded = true;
            message = this.plugin.getLangConfig().getMsgFullStock();
        }
        if (limitExceeded) {
            event.setCancelled(true);
            Player player = event.getPlayer();
            if (player != null && message != null) {
                player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)message));
            }
            return true;
        }
        return false;
    }

    private boolean checkRecipeStockLimits(ShopPreTransactionEvent event, DynaShopType typeDynaShop, String shopID, String itemID, int amount) {
        if (typeDynaShop == DynaShopType.RECIPE) {
            int stockAmount = this.priceRecipe.calculateStock(shopID, itemID, new ArrayList<String>());
            int maxStock = this.priceRecipe.calculateMaxStock(shopID, itemID, new ArrayList<String>());
            if (maxStock > 0) {
                if (event.getShopAction() == ShopManager.ShopAction.BUY && stockAmount < amount) {
                    event.setCancelled(true);
                    if (event.getPlayer() != null) {
                        event.getPlayer().sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.getLangConfig().getMsgOutOfStock()));
                    }
                    return true;
                }
                if ((event.getShopAction() == ShopManager.ShopAction.SELL || event.getShopAction() == ShopManager.ShopAction.SELL_ALL) && stockAmount >= maxStock) {
                    event.setCancelled(true);
                    if (event.getPlayer() != null) {
                        event.getPlayer().sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.getLangConfig().getMsgFullStock()));
                    }
                    return true;
                }
            }
        }
        return false;
    }

    private void applyTaxes(Player player, double price, String shopID, String itemID, boolean isBuy) {
        if (this.plugin.getTaxService() != null && this.plugin.getTaxService().isEnabled()) {
            if (isBuy) {
                this.plugin.getTaxService().applyBuyTax(player, price, shopID, itemID);
            } else {
                this.plugin.getTaxService().applySellTax(player, price, shopID, itemID);
            }
        }
    }

    private void handleRecipeTypeItems(String shopID, String itemID, DynaShopType typeDynaShop) {
        if (typeDynaShop == DynaShopType.RECIPE) {
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> this.invalidateRecipeIngredients(shopID, itemID));
        }
    }

    private void updateStorageData(Player player, String shopID, String itemID, boolean isBuy, int amount) {
        Integer stock;
        DynamicPrice updatedPrice = this.plugin.getPriceCache().getIfPresent(shopID + ":" + itemID);
        if (updatedPrice != null) {
            this.plugin.getStorageManager().savePrice(shopID, itemID, updatedPrice.getBuyPrice(), updatedPrice.getSellPrice(), updatedPrice.getStock());
        }
        if ((stock = this.plugin.getStockCache().getIfPresent(shopID + ":" + itemID)) != null && stock >= 0) {
            this.plugin.getStorageManager().saveStock(shopID, itemID, stock);
        }
        if (this.plugin.getShopConfigManager().hasSection(shopID, itemID, "limit")) {
            this.plugin.getTransactionLimiter().queueTransaction(player, shopID, itemID, isBuy, amount);
        }
    }

    private void processTransactionAsync(String shopID, String itemID, ItemStack itemStack, int amount, ShopManager.ShopAction action) {
        if (!this.shopConfigManager.getItemValue(shopID, itemID, "typeDynaShop", String.class).isPresent()) {
            return;
        }
        DynamicPrice price = this.getOrLoadPriceInternal(null, shopID, itemID, itemStack, new HashSet<String>(), new HashMap<String, DynamicPrice>(), false);
        if (price == null) {
            return;
        }
        DynaShopType typeDynaShop = price.getDynaShopType();
        DynaShopType buyTypeDynaShop = price.getBuyTypeDynaShop();
        DynaShopType sellTypeDynaShop = price.getSellTypeDynaShop();
        if (buyTypeDynaShop == DynaShopType.NONE || buyTypeDynaShop == DynaShopType.UNKNOWN) {
            buyTypeDynaShop = typeDynaShop;
        }
        if (sellTypeDynaShop == DynaShopType.NONE || sellTypeDynaShop == DynaShopType.UNKNOWN) {
            sellTypeDynaShop = typeDynaShop;
        }
        this.handlePriceChanges(action, shopID, itemID, price, typeDynaShop, buyTypeDynaShop, sellTypeDynaShop, amount, itemStack);
        if (sellTypeDynaShop != DynaShopType.RECIPE || buyTypeDynaShop != DynaShopType.RECIPE) {
            this.plugin.getBatchDatabaseUpdater().queueUpdate(shopID, itemID, price, true);
        }
    }

    private void handlePriceChanges(ShopManager.ShopAction action, String shopID, String itemID, DynamicPrice price, DynaShopType typeDynaShop, DynaShopType buyTypeDynaShop, DynaShopType sellTypeDynaShop, int amount, ItemStack itemStack) {
        if (action == ShopManager.ShopAction.BUY) {
            if (buyTypeDynaShop == DynaShopType.STOCK || buyTypeDynaShop == DynaShopType.STATIC_STOCK) {
                this.handleStockPrice(price, shopID, itemID, action, amount);
            }
        } else if (!(action != ShopManager.ShopAction.SELL && action != ShopManager.ShopAction.SELL_ALL || sellTypeDynaShop != DynaShopType.STOCK && sellTypeDynaShop != DynaShopType.STATIC_STOCK)) {
            this.handleStockPrice(price, shopID, itemID, action, amount);
        }
        if (buyTypeDynaShop == DynaShopType.DYNAMIC) {
            this.handleDynamicPrice(price, action, amount);
        } else if (buyTypeDynaShop == DynaShopType.RECIPE) {
            this.handleRecipePrice(shopID, itemID, amount, action);
        } else if (buyTypeDynaShop == DynaShopType.LINK) {
            this.handleLinkedPrice(shopID, itemID, itemStack, action, amount);
        }
        if (sellTypeDynaShop == DynaShopType.DYNAMIC) {
            this.handleDynamicPrice(price, action, amount);
        } else if (sellTypeDynaShop == DynaShopType.RECIPE) {
            this.handleRecipePrice(shopID, itemID, amount, action);
        } else if (sellTypeDynaShop == DynaShopType.LINK) {
            this.handleLinkedPrice(shopID, itemID, itemStack, action, amount);
        }
    }

    private void applyPriceModifiers(ShopPreTransactionEvent event, DynamicPrice price, Player player, ShopItem item) throws PlayerDataNotLoadedException {
        if (event.getShopAction() == ShopManager.ShopAction.BUY) {
            double basePrice = price.getBuyPriceForAmount(event.getAmount());
            double playerBuyModifier = ShopGuiPlusApi.getPriceModifier((Player)player, (ShopItem)item, (PriceModifierActionType)PriceModifierActionType.BUY).getModifier();
            event.setPrice(basePrice * playerBuyModifier);
        } else if (event.getShopAction() == ShopManager.ShopAction.SELL || event.getShopAction() == ShopManager.ShopAction.SELL_ALL) {
            double basePrice = price.getSellPriceForAmount(event.getAmount());
            double playerSellModifier = ShopGuiPlusApi.getPriceModifier((Player)player, (ShopItem)item, (PriceModifierActionType)PriceModifierActionType.SELL).getModifier();
            event.setPrice(basePrice * playerSellModifier);
        }
    }

    private void handleDynamicPrice(DynamicPrice price, ShopManager.ShopAction action, int amount) {
        if (action == ShopManager.ShopAction.BUY) {
            price.applyGrowth(amount);
        } else if (action == ShopManager.ShopAction.SELL || action == ShopManager.ShopAction.SELL_ALL) {
            price.applyDecay(amount);
        }
    }

    private void handleRecipePrice(String shopID, String itemID, int amount, ShopManager.ShopAction action) {
        boolean isGrowth = action == ShopManager.ShopAction.BUY;
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> this.applyGrowthOrDecayToIngredients(shopID, itemID, amount, isGrowth, new HashSet<String>(), new HashMap<String, DynamicPrice>(), 0));
    }

    private void handleStockPrice(DynamicPrice price, String shopID, String itemID, ShopManager.ShopAction action, int amount) {
        if (action == ShopManager.ShopAction.BUY) {
            this.plugin.getPriceStock().processBuyTransaction(shopID, itemID, amount);
        } else if (action == ShopManager.ShopAction.SELL || action == ShopManager.ShopAction.SELL_ALL) {
            this.plugin.getPriceStock().processSellTransaction(shopID, itemID, amount);
        }
        double newBuyPrice = this.plugin.getPriceStock().calculatePrice(shopID, itemID, "buyPrice");
        double newSellPrice = this.plugin.getPriceStock().calculatePrice(shopID, itemID, "sellPrice");
        price.setBuyPrice(newBuyPrice);
        price.setSellPrice(newSellPrice);
        price.setStock(this.plugin.getStorageManager().getStock(shopID, itemID).orElse(0));
    }

    private void handleLinkedPrice(String shopID, String itemID, ItemStack itemStack, ShopManager.ShopAction action, int amount) {
        String linkedItemRef = this.shopConfigManager.getItemValue(shopID, itemID, "link", String.class).orElse(null);
        if (linkedItemRef != null && linkedItemRef.contains(":")) {
            String[] parts = linkedItemRef.split(":");
            if (parts.length == 2) {
                String linkedShopID = parts[0];
                String linkedItemID = parts[1];
                this.processLinkedItem(linkedShopID, linkedItemID, itemStack, action, amount, shopID, itemID);
            } else {
                this.plugin.getLogger().warning("Format de lien invalide pour " + shopID + ":" + itemID + ": " + linkedItemRef);
            }
        } else {
            this.plugin.getLogger().warning("Pas de r\u00e9f\u00e9rence de lien trouv\u00e9e pour " + shopID + ":" + itemID);
        }
    }

    private void processLinkedItem(String linkedShopID, String linkedItemID, ItemStack itemStack, ShopManager.ShopAction action, int amount, String originalShopID, String originalItemID) {
        DynamicPrice linkedPrice = this.getOrLoadPriceInternal(null, linkedShopID, linkedItemID, itemStack, new HashSet<String>(), new HashMap<String, DynamicPrice>(), false);
        if (linkedPrice != null) {
            DynaShopType linkedType = linkedPrice.getDynaShopType();
            DynaShopType buyTypeDynaShop = linkedPrice.getBuyTypeDynaShop();
            DynaShopType sellTypeDynaShop = linkedPrice.getSellTypeDynaShop();
            if (buyTypeDynaShop == DynaShopType.NONE || buyTypeDynaShop == DynaShopType.UNKNOWN) {
                buyTypeDynaShop = linkedType;
            }
            if (sellTypeDynaShop == DynaShopType.NONE || sellTypeDynaShop == DynaShopType.UNKNOWN) {
                sellTypeDynaShop = linkedType;
            }
            this.processLinkedItemTypes(linkedShopID, linkedItemID, linkedPrice, linkedType, buyTypeDynaShop, sellTypeDynaShop, action, amount, itemStack);
            this.copyLinkedPriceToMainItem(linkedShopID, linkedItemID, linkedPrice, originalShopID, originalItemID);
            if (linkedType == DynaShopType.STOCK || linkedType == DynaShopType.STATIC_STOCK) {
                this.plugin.getStorageManager().saveStock(originalShopID, originalItemID, linkedPrice.getStock());
            }
        }
    }

    private void processLinkedItemTypes(String linkedShopID, String linkedItemID, DynamicPrice linkedPrice, DynaShopType linkedType, DynaShopType buyTypeDynaShop, DynaShopType sellTypeDynaShop, ShopManager.ShopAction action, int amount, ItemStack itemStack) {
        this.handlePriceChanges(action, linkedShopID, linkedItemID, linkedPrice, linkedType, buyTypeDynaShop, sellTypeDynaShop, amount, itemStack);
        if (linkedType != DynaShopType.RECIPE) {
            this.plugin.getBatchDatabaseUpdater().queueUpdate(linkedShopID, linkedItemID, linkedPrice, true);
        }
    }

    private void copyLinkedPriceToMainItem(String linkedShopID, String linkedItemID, DynamicPrice linkedPrice, String shopID, String itemID) {
        DynamicPrice copyForMainItem = new DynamicPrice(linkedPrice.getBuyPrice(), linkedPrice.getSellPrice(), linkedPrice.getMinBuyPrice(), linkedPrice.getMaxBuyPrice(), linkedPrice.getMinSellPrice(), linkedPrice.getMaxSellPrice(), linkedPrice.getGrowthBuy(), linkedPrice.getDecayBuy(), linkedPrice.getGrowthSell(), linkedPrice.getDecaySell(), linkedPrice.getStock(), linkedPrice.getMinStock(), linkedPrice.getMaxStock(), linkedPrice.getStockBuyModifier(), linkedPrice.getStockSellModifier());
        copyForMainItem.setDynaShopType(DynaShopType.LINK);
        copyForMainItem.setBuyTypeDynaShop(linkedPrice.getBuyTypeDynaShop());
        copyForMainItem.setSellTypeDynaShop(linkedPrice.getSellTypeDynaShop());
        this.plugin.getStorageManager().savePrice(shopID, itemID, copyForMainItem.getBuyPrice(), copyForMainItem.getSellPrice(), copyForMainItem.getStock());
        this.plugin.invalidatePriceCache(linkedShopID, linkedItemID, null);
        this.plugin.invalidatePriceCache(shopID, itemID, null);
    }

    private void invalidateRecipeIngredients(String shopId, String itemId) {
        List<ItemStack> ingredients = this.plugin.getPriceRecipe().getIngredients(shopId, itemId);
        for (ItemStack ingredient : ingredients) {
            PriceRecipe.FoundItem foundItem = this.plugin.getPriceRecipe().findItemInShops(shopId, ingredient);
            if (!foundItem.isFound()) continue;
            this.plugin.invalidatePriceCache(foundItem.getShopID(), foundItem.getItemID(), null);
        }
    }

    private void applyGrowthOrDecayToIngredients(String shopID, String itemID, int amount, boolean isGrowth, Set<String> visitedItems, Map<String, DynamicPrice> lastResults, int depth) {
        if (depth > 10) {
            return;
        }
        String itemKey = shopID + ":" + itemID;
        if (visitedItems.contains(itemKey)) {
            DynamicPrice last = lastResults.get(itemKey);
            if (last != null) {
                return;
            }
            this.plugin.getLogger().warning("Cycle d\u00e9tect\u00e9 pour " + itemKey + " (lien ou recette) !");
            return;
        }
        visitedItems.add(itemKey);
        List<ItemStack> ingredients = this.plugin.getPriceRecipe().getIngredients(shopID, itemID);
        if (ingredients.isEmpty()) {
            return;
        }
        for (ItemStack ingredient : ingredients) {
            PriceRecipe.FoundItem foundItem;
            if (ingredient == null || ingredient.getType() == Material.AIR || !(foundItem = this.plugin.getPriceRecipe().findItemInShops(shopID, ingredient)).isFound()) continue;
            this.processRecipeIngredient(foundItem.getShopID(), foundItem.getItemID(), ingredient, ingredient.getAmount() * amount, isGrowth, visitedItems, lastResults, depth);
        }
    }

    private void processRecipeIngredient(String ingredientShopID, String ingredientID, ItemStack ingredient, int ingredientQuantity, boolean isGrowth, Set<String> visitedItems, Map<String, DynamicPrice> lastResults, int depth) {
        DynamicPrice ingredientPrice = this.getOrLoadPriceInternal(null, ingredientShopID, ingredientID, ingredient, new HashSet<String>(visitedItems), lastResults, false);
        if (ingredientPrice == null) {
            return;
        }
        DynaShopType ingredientType = ingredientPrice.getDynaShopType();
        DynaShopType buyTypeDynaShop = ingredientPrice.getBuyTypeDynaShop();
        DynaShopType sellTypeDynaShop = ingredientPrice.getSellTypeDynaShop();
        if (buyTypeDynaShop == DynaShopType.NONE || buyTypeDynaShop == DynaShopType.UNKNOWN) {
            buyTypeDynaShop = ingredientType;
        }
        if (sellTypeDynaShop == DynaShopType.NONE || sellTypeDynaShop == DynaShopType.UNKNOWN) {
            sellTypeDynaShop = ingredientType;
        }
        if (isGrowth) {
            this.processGrowthIngredient(ingredientShopID, ingredientID, ingredient, ingredientPrice, buyTypeDynaShop, ingredientType, ingredientQuantity, visitedItems, lastResults, depth);
        } else {
            this.processDecayIngredient(ingredientShopID, ingredientID, ingredient, ingredientPrice, sellTypeDynaShop, ingredientType, ingredientQuantity, visitedItems, lastResults, depth);
        }
    }

    private void processGrowthIngredient(String shopID, String itemID, ItemStack itemStack, DynamicPrice price, DynaShopType buyType, DynaShopType ingredientType, int quantity, Set<String> visitedItems, Map<String, DynamicPrice> lastResults, int depth) {
        switch (buyType) {
            case RECIPE: {
                this.applyGrowthOrDecayToIngredients(shopID, itemID, quantity, true, visitedItems, lastResults, depth + 1);
                break;
            }
            case LINK: {
                this.handleLinkedPrice(shopID, itemID, itemStack, ShopManager.ShopAction.BUY, quantity);
                break;
            }
            case STOCK: 
            case STATIC_STOCK: {
                this.processIngredient(shopID, itemID, price, ingredientType, quantity, true);
                this.plugin.getBatchDatabaseUpdater().queueUpdate(shopID, itemID, price, true);
                break;
            }
            default: {
                this.processIngredient(shopID, itemID, price, ingredientType, quantity, true);
                this.plugin.getBatchDatabaseUpdater().queueUpdate(shopID, itemID, price, true);
            }
        }
    }

    private void processDecayIngredient(String shopID, String itemID, ItemStack itemStack, DynamicPrice price, DynaShopType sellType, DynaShopType ingredientType, int quantity, Set<String> visitedItems, Map<String, DynamicPrice> lastResults, int depth) {
        switch (sellType) {
            case RECIPE: {
                this.applyGrowthOrDecayToIngredients(shopID, itemID, quantity, false, visitedItems, lastResults, depth + 1);
                break;
            }
            case LINK: {
                this.handleLinkedPrice(shopID, itemID, itemStack, ShopManager.ShopAction.SELL, quantity);
                break;
            }
            case STOCK: 
            case STATIC_STOCK: {
                this.processIngredient(shopID, itemID, price, ingredientType, quantity, false);
                this.plugin.getBatchDatabaseUpdater().queueUpdate(shopID, itemID, price, true);
                break;
            }
            default: {
                this.processIngredient(shopID, itemID, price, ingredientType, quantity, false);
                this.plugin.getBatchDatabaseUpdater().queueUpdate(shopID, itemID, price, true);
            }
        }
    }

    private void processIngredient(String shopID, String itemID, DynamicPrice price, DynaShopType type, int quantity, boolean isGrowth) {
        if (type == DynaShopType.STOCK || type == DynaShopType.STATIC_STOCK) {
            if (isGrowth) {
                this.plugin.getPriceStock().processBuyTransaction(shopID, itemID, quantity);
            } else {
                this.plugin.getPriceStock().processSellTransaction(shopID, itemID, quantity);
            }
            this.updatePriceFromStock(shopID, itemID, price);
        } else if (isGrowth) {
            price.applyGrowth(quantity);
        } else {
            price.applyDecay(quantity);
        }
    }

    private void updatePriceFromStock(String shopID, String itemID, DynamicPrice price) {
        double newBuyPrice = this.plugin.getPriceStock().calculatePrice(shopID, itemID, "buyPrice");
        double newSellPrice = this.plugin.getPriceStock().calculatePrice(shopID, itemID, "sellPrice");
        price.setBuyPrice(newBuyPrice);
        price.setSellPrice(newSellPrice);
        price.setStock(this.plugin.getStorageManager().getStock(shopID, itemID).orElse(0));
    }

    public DynamicPrice getOrLoadPrice(Player player, String shopID, String itemID, ItemStack itemStack, Set<String> visited, Map<String, DynamicPrice> lastResults) {
        return this.getOrLoadPriceInternal(player, shopID, itemID, itemStack, visited, lastResults, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DynamicPrice getOrLoadPriceInternal(Player player, String shopID, String itemID, ItemStack itemStack, Set<String> visited, Map<String, DynamicPrice> lastResults, boolean bypassCache) {
        String key = shopID + ":" + itemID;
        if (visited.contains(key)) {
            DynamicPrice last = lastResults.get(key);
            if (last != null) {
                return last;
            }
            this.plugin.getLogger().warning("Cycle d\u00e9tect\u00e9 pour " + key + " (lien ou recette) !");
            return null;
        }
        visited.add(key);
        try {
            DynamicPrice price;
            Object cacheKey;
            if (!bypassCache) {
                cacheKey = shopID + ":" + itemID + (String)(player != null ? ":" + player.getUniqueId().toString() : "");
                price = this.plugin.getPriceCache().get((String)cacheKey, () -> {
                    DynamicPrice p = this.loadPriceFromSourceInternal(player, shopID, itemID, itemStack, visited, lastResults);
                    if (p != null && player != null && p.getDynaShopType() != DynaShopType.LINK) {
                        p.applyShopGuiPlusModifiers(player, shopID, itemID);
                    }
                    return p;
                });
            } else {
                price = this.loadPriceFromSourceInternal(player, shopID, itemID, itemStack, visited, lastResults);
                if (price != null && player != null && price.getDynaShopType() != DynaShopType.LINK) {
                    price.applyShopGuiPlusModifiers(player, shopID, itemID);
                }
            }
            if (price != null) {
                lastResults.put(key, price);
            }
            cacheKey = price;
            return cacheKey;
        }
        catch (Exception e) {
            DynamicPrice last = lastResults.get(key);
            if (last != null) {
                DynamicPrice dynamicPrice = last;
                return dynamicPrice;
            }
            this.plugin.getLogger().warning("Erreur lors du calcul du prix pour " + key + " : " + e.getMessage());
            DynamicPrice dynamicPrice = null;
            return dynamicPrice;
        }
        finally {
            visited.remove(key);
        }
    }

    private DynamicPrice loadPriceFromSourceInternal(Player player, String shopID, String itemID, ItemStack itemStack, Set<String> visited, Map<String, DynamicPrice> lastResults) {
        DynaShopType typeDynaShop = this.shopConfigManager.getTypeDynaShop(shopID, itemID);
        DynaShopType buyTypeDynaShop = this.shopConfigManager.getTypeDynaShop(shopID, itemID, "buy");
        DynaShopType sellTypeDynaShop = this.shopConfigManager.getTypeDynaShop(shopID, itemID, "sell");
        if (buyTypeDynaShop == DynaShopType.NONE || buyTypeDynaShop == DynaShopType.UNKNOWN) {
            buyTypeDynaShop = typeDynaShop;
        }
        if (sellTypeDynaShop == DynaShopType.NONE || sellTypeDynaShop == DynaShopType.UNKNOWN) {
            sellTypeDynaShop = typeDynaShop;
        }
        PriceParams params = new PriceParams();
        this.loadBuyPrices(player, shopID, itemID, buyTypeDynaShop, visited, lastResults, params);
        this.loadSellPrices(player, shopID, itemID, sellTypeDynaShop, visited, lastResults, params);
        DynamicPrice price = new DynamicPrice(params.buyPrice, params.sellPrice, params.minBuy, params.maxBuy, params.minSell, params.maxSell, params.growthBuy, params.decayBuy, params.growthSell, params.decaySell, params.stock, params.minStock, params.maxStock, params.stockBuyModifier, params.stockSellModifier);
        price.setDynaShopType(typeDynaShop);
        price.setBuyTypeDynaShop(buyTypeDynaShop);
        price.setSellTypeDynaShop(sellTypeDynaShop);
        this.applyEnchantmentModifiers(shopID, itemID, itemStack, price);
        price.applyInflation(shopID, itemID);
        return price;
    }

    private void loadBuyPrices(Player player, String shopID, String itemID, DynaShopType buyTypeDynaShop, Set<String> visited, Map<String, DynamicPrice> lastResults, PriceParams params) {
        switch (buyTypeDynaShop) {
            case RECIPE: {
                DynamicPrice recipePrice = this.plugin.getPriceRecipe().createRecipePrice(shopID, itemID, visited, lastResults);
                params.buyPrice = recipePrice.getBuyPrice();
                params.minBuy = recipePrice.getMinBuyPrice();
                params.maxBuy = recipePrice.getMaxBuyPrice();
                params.growthBuy = recipePrice.getGrowthBuy();
                params.decayBuy = recipePrice.getDecayBuy();
                params.stock = recipePrice.getStock();
                params.minStock = recipePrice.getMinStock();
                params.maxStock = recipePrice.getMaxStock();
                break;
            }
            case STOCK: {
                DynamicPrice stockPrice = this.plugin.getPriceStock().createStockPrice(shopID, itemID);
                params.buyPrice = stockPrice.getBuyPrice();
                params.minBuy = stockPrice.getMinBuyPrice();
                params.maxBuy = stockPrice.getMaxBuyPrice();
                params.stock = stockPrice.getStock();
                params.minStock = stockPrice.getMinStock();
                params.maxStock = stockPrice.getMaxStock();
                break;
            }
            case STATIC_STOCK: {
                DynamicPrice staticStockPrice = this.plugin.getPriceStock().createStaticStockPrice(shopID, itemID);
                params.buyPrice = staticStockPrice.getBuyPrice();
                params.minBuy = staticStockPrice.getMinBuyPrice();
                params.maxBuy = staticStockPrice.getMaxBuyPrice();
                params.stock = staticStockPrice.getStock();
                params.minStock = staticStockPrice.getMinStock();
                params.maxStock = staticStockPrice.getMaxStock();
                break;
            }
            case LINK: {
                this.loadLinkedBuyPrices(player, shopID, itemID, visited, lastResults, params);
                break;
            }
            default: {
                this.loadDefaultBuyPrices(player, shopID, itemID, visited, lastResults, params);
            }
        }
    }

    private void loadSellPrices(Player player, String shopID, String itemID, DynaShopType sellTypeDynaShop, Set<String> visited, Map<String, DynamicPrice> lastResults, PriceParams params) {
        switch (sellTypeDynaShop) {
            case RECIPE: {
                DynamicPrice recipePrice = this.plugin.getPriceRecipe().createRecipePrice(shopID, itemID, visited, lastResults);
                params.sellPrice = recipePrice.getSellPrice();
                params.minSell = recipePrice.getMinSellPrice();
                params.maxSell = recipePrice.getMaxSellPrice();
                params.growthSell = recipePrice.getGrowthSell();
                params.decaySell = recipePrice.getDecaySell();
                params.stock = recipePrice.getStock();
                params.minStock = recipePrice.getMinStock();
                params.maxStock = recipePrice.getMaxStock();
                break;
            }
            case STOCK: {
                DynamicPrice stockPrice = this.plugin.getPriceStock().createStockPrice(shopID, itemID);
                params.sellPrice = stockPrice.getSellPrice();
                params.minSell = stockPrice.getMinSellPrice();
                params.maxSell = stockPrice.getMaxSellPrice();
                params.stock = stockPrice.getStock();
                params.minStock = stockPrice.getMinStock();
                params.maxStock = stockPrice.getMaxStock();
                break;
            }
            case STATIC_STOCK: {
                DynamicPrice staticStockPrice = this.plugin.getPriceStock().createStaticStockPrice(shopID, itemID);
                params.sellPrice = staticStockPrice.getSellPrice();
                params.minSell = staticStockPrice.getMinSellPrice();
                params.maxSell = staticStockPrice.getMaxSellPrice();
                params.stock = staticStockPrice.getStock();
                params.minStock = staticStockPrice.getMinStock();
                params.maxStock = staticStockPrice.getMaxStock();
                break;
            }
            case LINK: {
                this.loadLinkedSellPrices(player, shopID, itemID, visited, lastResults, params);
                break;
            }
            default: {
                this.loadDefaultSellPrices(player, shopID, itemID, visited, lastResults, params);
            }
        }
    }

    private void loadLinkedBuyPrices(Player player, String shopID, String itemID, Set<String> visited, Map<String, DynamicPrice> lastResults, PriceParams params) {
        String linkedItemRef = this.shopConfigManager.getItemValue(shopID, itemID, "link", String.class).orElse(null);
        if (linkedItemRef != null && linkedItemRef.contains(":")) {
            ItemStack linkedItemStack;
            String linkedItemID;
            String linkedShopID;
            DynamicPrice linkedPrice;
            String[] parts = linkedItemRef.split(":");
            if (parts.length == 2 && (linkedPrice = this.getOrLoadPriceInternal(player, linkedShopID = parts[0], linkedItemID = parts[1], linkedItemStack = ShopGuiPlusApi.getShop((String)linkedShopID).getShopItem(linkedItemID).getItem(), visited, lastResults, true)) != null) {
                params.buyPrice = linkedPrice.getBuyPrice();
                params.minBuy = linkedPrice.getMinBuyPrice();
                params.maxBuy = linkedPrice.getMaxBuyPrice();
                params.growthBuy = linkedPrice.getGrowthBuy();
                params.decayBuy = linkedPrice.getDecayBuy();
                params.stock = linkedPrice.getStock();
                params.minStock = linkedPrice.getMinStock();
                params.maxStock = linkedPrice.getMaxStock();
            }
        } else if (linkedItemRef != null && !linkedItemRef.contains(":")) {
            String linkedShopID = shopID;
            String linkedItemID = linkedItemRef;
            ItemStack linkedItemStack = ShopGuiPlusApi.getShop((String)linkedShopID).getShopItem(linkedItemID).getItem();
            DynamicPrice linkedPrice = this.getOrLoadPriceInternal(player, linkedShopID, linkedItemID, linkedItemStack, visited, lastResults, true);
            if (linkedPrice != null) {
                params.buyPrice = linkedPrice.getBuyPrice();
                params.minBuy = linkedPrice.getMinBuyPrice();
                params.maxBuy = linkedPrice.getMaxBuyPrice();
                params.growthBuy = linkedPrice.getGrowthBuy();
                params.decayBuy = linkedPrice.getDecayBuy();
                params.stock = linkedPrice.getStock();
                params.minStock = linkedPrice.getMinStock();
                params.maxStock = linkedPrice.getMaxStock();
            }
        } else {
            this.plugin.getLogger().warning("Item " + itemID + " in shop " + shopID + " is linked but no linked item found.");
        }
    }

    private void loadLinkedSellPrices(Player player, String shopID, String itemID, Set<String> visited, Map<String, DynamicPrice> lastResults, PriceParams params) {
        String linkedItemRef = this.shopConfigManager.getItemValue(shopID, itemID, "link", String.class).orElse(null);
        if (linkedItemRef != null && linkedItemRef.contains(":")) {
            ItemStack linkedItemStack;
            String linkedItemID;
            String linkedShopID;
            DynamicPrice linkedPrice;
            String[] parts = linkedItemRef.split(":");
            if (parts.length == 2 && (linkedPrice = this.getOrLoadPriceInternal(player, linkedShopID = parts[0], linkedItemID = parts[1], linkedItemStack = ShopGuiPlusApi.getShop((String)linkedShopID).getShopItem(linkedItemID).getItem(), visited, lastResults, false)) != null) {
                params.sellPrice = linkedPrice.getSellPrice();
                params.minSell = linkedPrice.getMinSellPrice();
                params.maxSell = linkedPrice.getMaxSellPrice();
                params.growthSell = linkedPrice.getGrowthSell();
                params.decaySell = linkedPrice.getDecaySell();
                params.stock = linkedPrice.getStock();
                params.minStock = linkedPrice.getMinStock();
                params.maxStock = linkedPrice.getMaxStock();
            }
        } else if (linkedItemRef != null && !linkedItemRef.contains(":")) {
            String linkedShopID = shopID;
            String linkedItemID = linkedItemRef;
            ItemStack linkedItemStack = ShopGuiPlusApi.getShop((String)linkedShopID).getShopItem(linkedItemID).getItem();
            DynamicPrice linkedPrice = this.getOrLoadPriceInternal(player, linkedShopID, linkedItemID, linkedItemStack, visited, lastResults, false);
            if (linkedPrice != null) {
                params.sellPrice = linkedPrice.getSellPrice();
                params.minSell = linkedPrice.getMinSellPrice();
                params.maxSell = linkedPrice.getMaxSellPrice();
                params.growthSell = linkedPrice.getGrowthSell();
                params.decaySell = linkedPrice.getDecaySell();
                params.stock = linkedPrice.getStock();
                params.minStock = linkedPrice.getMinStock();
                params.maxStock = linkedPrice.getMaxStock();
            }
        } else {
            this.plugin.getLogger().warning("Item " + itemID + " in shop " + shopID + " is linked but no linked item found.");
        }
    }

    private void loadDefaultBuyPrices(Player player, String shopID, String itemID, Set<String> visited, Map<String, DynamicPrice> lastResults, PriceParams params) {
        Optional<DynamicPrice> priceFromDatabase = this.plugin.getStorageManager().getPrices(shopID, itemID);
        ItemPriceData priceData = this.shopConfigManager.getItemAllValues(shopID, itemID);
        params.buyPrice = priceFromDatabase.map(DynamicPrice::getBuyPrice).orElse(priceData.buyPrice.orElse(-1.0));
        params.minBuy = priceData.minBuy.orElse(params.buyPrice);
        params.maxBuy = priceData.maxBuy.orElse(params.buyPrice);
        this.handleLinkedMinMaxBuy(player, shopID, priceData, visited, lastResults, params);
        params.growthBuy = priceData.growthBuy.orElseGet(() -> {
            boolean hasBuyDynamic = this.shopConfigManager.hasSection(shopID, itemID, "buyDynamic");
            return hasBuyDynamic ? this.plugin.getDataConfig().getBuyGrowthRate() : 1.0;
        });
        params.decayBuy = priceData.decayBuy.orElseGet(() -> {
            boolean hasBuyDynamic = this.shopConfigManager.hasSection(shopID, itemID, "buyDynamic");
            return hasBuyDynamic ? this.plugin.getDataConfig().getBuyDecayRate() : 1.0;
        });
        params.stock = priceFromDatabase.map(DynamicPrice::getStock).orElse(priceData.stock.orElse(0));
        params.minStock = priceData.minStock.orElseGet(() -> {
            boolean hasStock = this.shopConfigManager.hasSection(shopID, itemID, "stock");
            return hasStock ? this.plugin.getDataConfig().getStockMin() : 0;
        });
        params.maxStock = priceData.maxStock.orElseGet(() -> {
            boolean hasStock = this.shopConfigManager.hasSection(shopID, itemID, "stock");
            return hasStock ? this.plugin.getDataConfig().getStockMax() : Integer.MAX_VALUE;
        });
        params.stockBuyModifier = priceData.stockBuyModifier.orElseGet(() -> {
            boolean hasStock = this.shopConfigManager.hasSection(shopID, itemID, "stock");
            return hasStock ? this.plugin.getDataConfig().getStockBuyModifier() : 1.0;
        });
    }

    private void loadDefaultSellPrices(Player player, String shopID, String itemID, Set<String> visited, Map<String, DynamicPrice> lastResults, PriceParams params) {
        Optional<DynamicPrice> priceFromDatabase = this.plugin.getStorageManager().getPrices(shopID, itemID);
        ItemPriceData priceData = this.shopConfigManager.getItemAllValues(shopID, itemID);
        params.sellPrice = priceFromDatabase.map(DynamicPrice::getSellPrice).orElse(priceData.sellPrice.orElse(-1.0));
        params.minSell = priceData.minSell.orElse(params.sellPrice);
        params.maxSell = priceData.maxSell.orElse(params.sellPrice);
        this.handleLinkedMinMaxSell(player, shopID, priceData, visited, lastResults, params);
        params.growthSell = priceData.growthSell.orElseGet(() -> {
            boolean hasSellDynamic = this.shopConfigManager.hasSection(shopID, itemID, "sellDynamic");
            return hasSellDynamic ? this.plugin.getDataConfig().getSellGrowthRate() : 1.0;
        });
        params.decaySell = priceData.decaySell.orElseGet(() -> {
            boolean hasSellDynamic = this.shopConfigManager.hasSection(shopID, itemID, "sellDynamic");
            return hasSellDynamic ? this.plugin.getDataConfig().getSellDecayRate() : 1.0;
        });
        params.stockSellModifier = priceData.stockSellModifier.orElseGet(() -> {
            boolean hasStock = this.shopConfigManager.hasSection(shopID, itemID, "stock");
            return hasStock ? this.plugin.getDataConfig().getStockSellModifier() : 1.0;
        });
    }

    private void handleLinkedMinMaxBuy(Player player, String shopID, ItemPriceData priceData, Set<String> visited, Map<String, DynamicPrice> lastResults, PriceParams params) {
        double linkedMax;
        double linkedMin;
        ItemStack linkedItemStack;
        String linkItem;
        String linkShop;
        DynamicPrice linkedPrice;
        ItemStack linkedItemStack2;
        String linkItem2;
        String linkShop2;
        DynamicPrice linkedPrice2;
        String[] parts;
        if (priceData.minBuyLink.isPresent() && priceData.minBuyLink.get().contains(":")) {
            double linkedMin2;
            parts = priceData.minBuyLink.get().split(":");
            if (parts.length == 2 && (linkedPrice2 = this.getOrLoadPriceInternal(player, linkShop2 = parts[0], linkItem2 = parts[1], linkedItemStack2 = ShopGuiPlusApi.getShop((String)linkShop2).getShopItem(linkItem2).getItem(), visited, lastResults, true)) != null && (linkedMin2 = linkedPrice2.getMinBuyPrice()) > 0.0) {
                params.minBuy = Math.max(params.minBuy, linkedMin2);
            }
        } else if (priceData.minBuyLink.isPresent() && !priceData.minBuyLink.get().contains(":") && (linkedPrice = this.getOrLoadPriceInternal(player, linkShop = shopID, linkItem = priceData.minBuyLink.get(), linkedItemStack = ShopGuiPlusApi.getShop((String)linkShop).getShopItem(linkItem).getItem(), visited, lastResults, true)) != null && (linkedMin = linkedPrice.getMinBuyPrice()) > 0.0) {
            params.minBuy = Math.max(params.minBuy, linkedMin);
        }
        if (priceData.maxBuyLink.isPresent() && priceData.maxBuyLink.get().contains(":")) {
            double linkedMax2;
            parts = priceData.maxBuyLink.get().split(":");
            if (parts.length == 2 && (linkedPrice2 = this.getOrLoadPriceInternal(player, linkShop2 = parts[0], linkItem2 = parts[1], linkedItemStack2 = ShopGuiPlusApi.getShop((String)linkShop2).getShopItem(linkItem2).getItem(), visited, lastResults, true)) != null && (linkedMax2 = linkedPrice2.getMaxBuyPrice()) > 0.0) {
                params.maxBuy = Math.min(params.maxBuy, linkedMax2);
            }
        } else if (priceData.maxBuyLink.isPresent() && !priceData.maxBuyLink.get().contains(":") && (linkedPrice = this.getOrLoadPriceInternal(player, linkShop = shopID, linkItem = priceData.maxBuyLink.get(), linkedItemStack = ShopGuiPlusApi.getShop((String)linkShop).getShopItem(linkItem).getItem(), visited, lastResults, true)) != null && (linkedMax = linkedPrice.getMaxBuyPrice()) > 0.0) {
            params.maxBuy = Math.min(params.maxBuy, linkedMax);
        }
    }

    private void handleLinkedMinMaxSell(Player player, String shopID, ItemPriceData priceData, Set<String> visited, Map<String, DynamicPrice> lastResults, PriceParams params) {
        double linkedMax;
        double linkedMin;
        ItemStack linkedItemStack;
        String linkItem;
        String linkShop;
        DynamicPrice linkedPrice;
        ItemStack linkedItemStack2;
        String linkItem2;
        String linkShop2;
        DynamicPrice linkedPrice2;
        String[] parts;
        if (priceData.minSellLink.isPresent() && priceData.minSellLink.get().contains(":")) {
            double linkedMin2;
            parts = priceData.minSellLink.get().split(":");
            if (parts.length == 2 && (linkedPrice2 = this.getOrLoadPriceInternal(player, linkShop2 = parts[0], linkItem2 = parts[1], linkedItemStack2 = ShopGuiPlusApi.getShop((String)linkShop2).getShopItem(linkItem2).getItem(), visited, lastResults, false)) != null && (linkedMin2 = linkedPrice2.getMinSellPrice()) > 0.0) {
                params.minSell = Math.max(params.minSell, linkedMin2);
            }
        } else if (priceData.minSellLink.isPresent() && !priceData.minSellLink.get().contains(":") && (linkedPrice = this.getOrLoadPriceInternal(player, linkShop = shopID, linkItem = priceData.minSellLink.get(), linkedItemStack = ShopGuiPlusApi.getShop((String)linkShop).getShopItem(linkItem).getItem(), visited, lastResults, false)) != null && (linkedMin = linkedPrice.getMinSellPrice()) > 0.0) {
            params.minSell = Math.max(params.minSell, linkedMin);
        }
        if (priceData.maxSellLink.isPresent() && priceData.maxSellLink.get().contains(":")) {
            double linkedMax2;
            parts = priceData.maxSellLink.get().split(":");
            if (parts.length == 2 && (linkedPrice2 = this.getOrLoadPriceInternal(player, linkShop2 = parts[0], linkItem2 = parts[1], linkedItemStack2 = ShopGuiPlusApi.getShop((String)linkShop2).getShopItem(linkItem2).getItem(), visited, lastResults, false)) != null && (linkedMax2 = linkedPrice2.getMaxSellPrice()) > 0.0) {
                params.maxSell = Math.min(params.maxSell, linkedMax2);
            }
        } else if (priceData.maxSellLink.isPresent() && !priceData.maxSellLink.get().contains(":") && (linkedPrice = this.getOrLoadPriceInternal(player, linkShop = shopID, linkItem = priceData.maxSellLink.get(), linkedItemStack = ShopGuiPlusApi.getShop((String)linkShop).getShopItem(linkItem).getItem(), visited, lastResults, false)) != null && (linkedMax = linkedPrice.getMaxSellPrice()) > 0.0) {
            params.maxSell = Math.min(params.maxSell, linkedMax);
        }
    }

    private void applyEnchantmentModifiers(String shopID, String itemID, ItemStack itemStack, DynamicPrice price) {
        double enchantmentModifier;
        boolean enchantmentEnabled = this.shopConfigManager.getItemValue(shopID, itemID, "dynaShop.enchantment", Boolean.class).orElse(false);
        if (enchantmentEnabled && itemStack != null && itemStack.getType() != Material.AIR && (enchantmentModifier = this.plugin.getPriceRecipe().getEnchantMultiplier(itemStack)) != 1.0) {
            price.setBuyPrice(price.getBuyPrice() * enchantmentModifier);
            price.setSellPrice(price.getSellPrice() * enchantmentModifier);
            price.setMinBuyPrice(price.getMinBuyPrice() * enchantmentModifier);
            price.setMaxBuyPrice(price.getMaxBuyPrice() * enchantmentModifier);
            price.setMinSellPrice(price.getMinSellPrice() * enchantmentModifier);
            price.setMaxSellPrice(price.getMaxSellPrice() * enchantmentModifier);
        }
    }

    public void recordPriceForHistory(String shopId, String itemId, DynamicPrice price, boolean isBuy, double amount) {
        int INTERVAL_MINUTES = this.plugin.getConfigMain().getInt("history.save-interval", 15);
        LocalDateTime now = LocalDateTime.now();
        PriceHistory.PriceDataPoint newPoint = new PriceHistory.PriceDataPoint(now, price.getBuyPrice(), price.getBuyPrice(), price.getBuyPrice(), price.getBuyPrice(), price.getSellPrice(), price.getSellPrice(), price.getSellPrice(), price.getSellPrice(), amount);
        this.plugin.getStorageManager().savePriceDataPoint(shopId, itemId, newPoint, INTERVAL_MINUTES);
    }

    private void handleLimitExceeded(Player player, String shopID, String itemID, boolean isBuy, ShopPreTransactionEvent event) {
        event.setCancelled(true);
        LimitCacheEntry limit = this.plugin.getTransactionLimiter().getTransactionLimit(player, shopID, itemID, isBuy);
        if (limit != null) {
            int remaining = limit.remaining;
            long nextAvailable = limit.nextAvailable;
            String message = remaining > 0 ? (isBuy ? this.plugin.getLangConfig().getMsgLimitCannotBuy().replace("%limit%", String.valueOf(remaining)) : this.plugin.getLangConfig().getMsgLimitCannotSell().replace("%limit%", String.valueOf(remaining))) : (nextAvailable > 0L ? this.plugin.getLangConfig().getMsgLimitReached().replace("%time%", this.formatTime(nextAvailable / 1000L)) : this.plugin.getLangConfig().getMsgLimit());
            player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)message));
            Sound errorSound = Sound.valueOf((String)this.plugin.getConfigMain().getString("limit.sound", "ENTITY_VILLAGER_NO"));
            player.playSound(player.getLocation(), errorSound, 1.0f, 1.0f);
        }
    }

    private String formatTime(long millisRemaining) {
        Duration duration = Duration.ofSeconds(millisRemaining);
        long years = duration.toDays() / 365L;
        long months = duration.toDays() % 365L / 30L;
        long days = duration.toDaysPart() % 7L;
        long hours = duration.toHoursPart();
        long minutes = duration.toMinutesPart();
        long seconds = duration.toSecondsPart();
        StringBuilder timeFormatted = new StringBuilder();
        if (years > 0L) {
            timeFormatted.append(years).append(" years");
        }
        if (months > 0L) {
            timeFormatted.append(" ").append(months).append(" months");
        }
        if (days > 0L) {
            timeFormatted.append(" ").append(days).append(" days");
        }
        if (hours > 0L) {
            timeFormatted.append(" ").append(hours).append(" h");
        }
        if (minutes > 0L) {
            timeFormatted.append(" ").append(minutes).append(" min");
        }
        if (seconds > 0L) {
            timeFormatted.append(" ").append(seconds).append(" sec");
        }
        return timeFormatted.toString();
    }

    private static class PriceParams {
        public double buyPrice = -1.0;
        public double sellPrice = -1.0;
        public double minBuy = -1.0;
        public double maxBuy = -1.0;
        public double minSell = -1.0;
        public double maxSell = -1.0;
        public double growthBuy = 1.0;
        public double decayBuy = 1.0;
        public double growthSell = 1.0;
        public double decaySell = 1.0;
        public int stock = 0;
        public int minStock = 0;
        public int maxStock = 0;
        public double stockBuyModifier = 1.0;
        public double stockSellModifier = 1.0;

        private PriceParams() {
        }
    }
}

