/*
 * Decompiled with CFR 0.152.
 */
package fr.tylwen.satyria.dynashop.listener;

import fr.tylwen.satyria.dynashop.DynaShopPlugin;
import fr.tylwen.satyria.dynashop.data.cache.LimitCacheEntry;
import fr.tylwen.satyria.dynashop.data.param.DynaShopType;
import fr.tylwen.satyria.dynashop.price.DynamicPrice;
import fr.tylwen.satyria.dynashop.system.TransactionLimiter;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.clip.placeholderapi.PlaceholderAPI;
import net.brcdev.shopgui.ShopGuiPlusApi;
import net.brcdev.shopgui.exception.player.PlayerDataNotLoadedException;
import net.brcdev.shopgui.modifier.PriceModifierActionType;
import net.brcdev.shopgui.shop.Shop;
import net.brcdev.shopgui.shop.item.ShopItem;
import net.brcdev.shopgui.shop.item.ShopItemType;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class ShopItemPlaceholderListener
implements Listener {
    private static final int CLEANUP_INTERVAL = 6000;
    private static final int BATCH_SIZE = 5;
    private final DynaShopPlugin plugin;
    private final long guiRefreshDefaultItems;
    private final long guiRefreshCriticalItems;
    private final boolean forceRefresh;
    private final Map<UUID, AbstractMap.SimpleEntry<String, String>> openShopMap = new ConcurrentHashMap<UUID, AbstractMap.SimpleEntry<String, String>>();
    private final Map<UUID, AmountSelectionInfo> amountSelectionMenus = new ConcurrentHashMap<UUID, AmountSelectionInfo>();
    private final Map<UUID, AbstractMap.SimpleEntry<String, String>> lastShopMap = new ConcurrentHashMap<UUID, AbstractMap.SimpleEntry<String, String>>();
    private final Map<UUID, Long> pendingBulkMenuOpens = new ConcurrentHashMap<UUID, Long>();
    private final Map<UUID, BukkitTask> playerRefreshBukkitTasks = new ConcurrentHashMap<UUID, BukkitTask>();
    private final Map<UUID, BukkitTask> playerSelectionRefreshBukkitTasks = new ConcurrentHashMap<UUID, BukkitTask>();
    private final Map<UUID, UUID> playerRefreshTasks = new ConcurrentHashMap<UUID, UUID>();
    private final Map<UUID, UUID> playerSelectionRefreshTasks = new ConcurrentHashMap<UUID, UUID>();

    public ShopItemPlaceholderListener(DynaShopPlugin plugin) {
        this.plugin = plugin;
        this.guiRefreshDefaultItems = plugin.getConfig().getLong("gui-refresh.default-items", 1000L);
        this.guiRefreshCriticalItems = plugin.getConfig().getLong("gui-refresh.critical-items", 300L);
        this.forceRefresh = plugin.isRealTimeMode();
        plugin.getServer().getScheduler().runTaskTimer((Plugin)plugin, this::cleanupMaps, 6000L, 6000L);
    }

    private void cleanupMaps() {
        Iterator<UUID> iterator = this.openShopMap.keySet().iterator();
        while (iterator.hasNext()) {
            BukkitTask selectionTask;
            UUID uuid = iterator.next();
            if (this.plugin.getServer().getPlayer(uuid) != null) continue;
            iterator.remove();
            this.lastShopMap.remove(uuid);
            this.amountSelectionMenus.remove(uuid);
            this.playerRefreshTasks.remove(uuid);
            this.playerSelectionRefreshTasks.remove(uuid);
            BukkitTask task = this.playerRefreshBukkitTasks.remove(uuid);
            if (task != null) {
                task.cancel();
            }
            if ((selectionTask = this.playerSelectionRefreshBukkitTasks.remove(uuid)) != null) {
                selectionTask.cancel();
            }
            this.pendingBulkMenuOpens.remove(uuid);
        }
        this.pendingBulkMenuOpens.clear();
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onInventoryOpen(InventoryOpenEvent event) {
        if (!(event.getPlayer() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getPlayer();
        InventoryView view = event.getView();
        String fullShopId = this.determineShopId(view);
        if (fullShopId == null) {
            return;
        }
        if (fullShopId.equals("AMOUNT_SELECTION") || fullShopId.equals("AMOUNT_SELECTION_BULK")) {
            AmountSelectionInfo info;
            AbstractMap.SimpleEntry<String, String> shopInfo = this.openShopMap.get(player.getUniqueId());
            if (shopInfo == null && (shopInfo = this.lastShopMap.get(player.getUniqueId())) != null) {
                this.openShopMap.put(player.getUniqueId(), shopInfo);
            }
            if ((info = this.extractAmountSelectionInfo(view, fullShopId)) == null) {
                return;
            }
            this.amountSelectionMenus.put(player.getUniqueId(), info);
            HashMap<Integer, List<String>> originalLores = new HashMap<Integer, List<String>>();
            for (Map.Entry<Integer, Integer> entry : info.getSlotValues().entrySet()) {
                int slot = entry.getKey();
                ItemStack item = view.getTopInventory().getItem(slot);
                if (item == null || !item.hasItemMeta() || !item.getItemMeta().hasLore()) continue;
                ItemMeta meta = item.getItemMeta();
                List lore = meta.getLore();
                originalLores.put(slot, new ArrayList(lore));
                List<String> tempLore = this.preProcessPlaceholders(lore);
                meta.setLore(tempLore);
                item.setItemMeta(meta);
            }
            this.updateAmountSelectionInventory(player, view, info, originalLores);
            this.startContinuousAmountSelectionRefresh(player, info, originalLores, fullShopId);
            return;
        }
        this.openShopMap.put(player.getUniqueId(), new AbstractMap.SimpleEntry<String, Object>(fullShopId, null));
        String shopId = fullShopId;
        int page = 1;
        if (fullShopId.contains("#")) {
            String[] parts = fullShopId.split("#");
            shopId = parts[0];
            try {
                page = Integer.parseInt(parts[1]);
            }
            catch (NumberFormatException e) {
                page = 1;
            }
        }
        this.openShopMap.put(player.getUniqueId(), new AbstractMap.SimpleEntry<String, Object>(shopId, null));
        HashMap<Integer, List<String>> originalLores = new HashMap<Integer, List<String>>();
        for (int slot = 0; slot < view.getTopInventory().getSize(); ++slot) {
            ItemMeta meta;
            List lore;
            ItemStack item = view.getTopInventory().getItem(slot);
            if (item == null || !item.hasItemMeta() || !item.getItemMeta().hasLore() || !this.containsDynaShopPlaceholder(lore = (meta = item.getItemMeta()).getLore())) continue;
            originalLores.put(slot, new ArrayList(lore));
            List<String> tempLore = this.preProcessPlaceholders(lore);
            meta.setLore(tempLore);
            item.setItemMeta(meta);
        }
        this.updateShopInventory(player, view, shopId, page, originalLores);
        this.startContinuousRefresh(player, view, shopId, page, originalLores);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onInventoryClick(InventoryClickEvent event) {
        block15: {
            if (!(event.getWhoClicked() instanceof Player)) {
                return;
            }
            Player player = (Player)event.getWhoClicked();
            if (event.getClickedInventory() != event.getView().getTopInventory()) {
                return;
            }
            ItemStack clickedItem = event.getCurrentItem();
            if (clickedItem == null || clickedItem.getType() == Material.AIR) {
                return;
            }
            int slot = event.getSlot();
            try {
                Shop shop;
                String shopId;
                String menuType = this.determineShopId(event.getView());
                if (menuType != null && menuType.equals("AMOUNT_SELECTION")) {
                    if (this.isQuantityButton(slot)) {
                        int centerSlot = ShopGuiPlusApi.getPlugin().getConfigMain().getConfig().getInt("amountSelectionGUI.itemSlot", 22);
                        ItemStack centerItem = event.getView().getTopInventory().getItem(centerSlot);
                        Map<Integer, List<String>> originalLores = this.extractOriginalLores(event.getView(), player);
                        AmountSelectionInfo newInfo = new AmountSelectionInfo(this.amountSelectionMenus.get(player.getUniqueId()).getShopId(), this.amountSelectionMenus.get(player.getUniqueId()).getItemId(), centerItem, this.amountSelectionMenus.get(player.getUniqueId()).isBuying(), menuType, this.amountSelectionMenus.get(player.getUniqueId()).getSlotValues());
                        this.updateAmountSelectionInventory(player, event.getView(), newInfo, originalLores);
                    } else if (this.isBulkButton(slot)) {
                        this.pendingBulkMenuOpens.put(player.getUniqueId(), System.currentTimeMillis());
                    }
                    return;
                }
                if (menuType != null && menuType.equals("AMOUNT_SELECTION_BULK")) {
                    return;
                }
                if (menuType == null) break block15;
                String baseShopId = shopId = menuType;
                int page = 1;
                if (shopId.contains("#")) {
                    String[] parts = shopId.split("#");
                    baseShopId = parts[0];
                    try {
                        page = Integer.parseInt(parts[1]);
                    }
                    catch (NumberFormatException e) {
                        page = 1;
                    }
                }
                if ((shop = ShopGuiPlusApi.getPlugin().getShopManager().getShopById(baseShopId)) == null) {
                    return;
                }
                ShopItem shopItem = shop.getShopItem(page, slot);
                if (shopItem == null || shopItem.getType() == ShopItemType.DUMMY) {
                    return;
                }
                this.openShopMap.put(player.getUniqueId(), new AbstractMap.SimpleEntry<String, String>(shopId, shopItem.getId()));
                this.lastShopMap.put(player.getUniqueId(), new AbstractMap.SimpleEntry<String, String>(shopId, shopItem.getId()));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        String menuType;
        String shopId;
        if (!(event.getPlayer() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getPlayer();
        UUID playerId = player.getUniqueId();
        AbstractMap.SimpleEntry<String, String> currentShop = this.openShopMap.get(playerId);
        String string = shopId = currentShop != null ? currentShop.getKey() : null;
        if (currentShop != null && currentShop.getKey() != null) {
            this.lastShopMap.put(playerId, new AbstractMap.SimpleEntry<String, String>(currentShop.getKey(), currentShop.getValue()));
        }
        boolean isSelectionMenu = (menuType = this.determineShopId(event.getView())) != null && (menuType.equals("AMOUNT_SELECTION") || menuType.equals("AMOUNT_SELECTION_BULK"));
        this.cancelRefreshTasks(playerId);
        if (!isSelectionMenu) {
            this.scheduleCleanup(player, playerId, shopId);
        } else {
            BukkitTask t = this.playerRefreshBukkitTasks.remove(playerId);
            if (t != null) {
                t.cancel();
            }
            this.playerRefreshTasks.remove(playerId);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onSelectionMenuClose(InventoryCloseEvent event) {
        if (!(event.getPlayer() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getPlayer();
        UUID playerId = player.getUniqueId();
        String menuType = this.determineShopId(event.getView());
        if (menuType != null && (menuType.equals("AMOUNT_SELECTION") || menuType.equals("AMOUNT_SELECTION_BULK"))) {
            AbstractMap.SimpleEntry<String, String> lastShop;
            if (this.pendingBulkMenuOpens.containsKey(playerId)) {
                long timestamp = this.pendingBulkMenuOpens.get(playerId);
                if (System.currentTimeMillis() - timestamp < 500L) {
                    this.pendingBulkMenuOpens.remove(playerId);
                    return;
                }
                this.pendingBulkMenuOpens.remove(playerId);
            }
            if ((lastShop = this.lastShopMap.get(player.getUniqueId())) != null && lastShop.getKey() != null && lastShop.getKey().contains("#")) {
                this.reopenShopAtPage(player, lastShop);
            }
        }
    }

    private boolean containsDynaShopPlaceholder(List<String> lore) {
        if (lore == null || lore.isEmpty()) {
            return false;
        }
        for (String line : lore) {
            if (line == null || line.indexOf("%dynashop_current_") < 0) continue;
            return true;
        }
        return false;
    }

    private List<String> replacePlaceholders(List<String> lore, Map<String, String> prices, Player player) {
        ArrayList<String> newLore = new ArrayList<String>();
        for (String line : lore) {
            boolean hideSellPriceForUnsellable;
            if (!line.contains("%dynashop_")) {
                if (line.contains("%") && this.canUsePlaceholderAPI()) {
                    try {
                        line = PlaceholderAPI.setPlaceholders((Player)player, (String)line);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                newLore.add(line);
                continue;
            }
            boolean skipLine = false;
            boolean hideBuyPriceForUnbuyable = ShopGuiPlusApi.getPlugin().getConfigMain().getConfig().getBoolean("hideBuyPriceForUnbuyable", true);
            if (this.shouldSkipLine(line, prices, hideBuyPriceForUnbuyable, hideSellPriceForUnsellable = ShopGuiPlusApi.getPlugin().getConfigMain().getConfig().getBoolean("hideSellPriceForUnsellable", true))) {
                skipLine = true;
            }
            if (skipLine) continue;
            if ((line = this.replaceDynaShopPlaceholders(line, prices)).contains("%") && this.canUsePlaceholderAPI()) {
                try {
                    line = PlaceholderAPI.setPlaceholders((Player)player, (String)line);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            newLore.add(line);
        }
        return newLore;
    }

    private boolean shouldSkipLine(String line, Map<String, String> prices, boolean hideBuyPriceForUnbuyable, boolean hideSellPriceForUnsellable) {
        if ((line.contains("%dynashop_current_buyPrice%") || line.contains("%dynashop_current_buy%")) && hideBuyPriceForUnbuyable && (prices.get("real_buy").equals("-1") || prices.get("buy").equals("N/A") || prices.get("buy").equals("0.0") || prices.get("buy").equals("-1"))) {
            return true;
        }
        if ((line.contains("%dynashop_current_sellPrice%") || line.contains("%dynashop_current_sell%")) && hideSellPriceForUnsellable && (prices.get("real_sell").equals("-1") || prices.get("sell").equals("N/A") || prices.get("sell").equals("0.0") || prices.get("sell").equals("-1"))) {
            return true;
        }
        if ((line.contains("%dynashop_current_stock%") || line.contains("%dynashop_current_maxstock%") || line.contains("%dynashop_current_stock_ratio%") || line.contains("%dynashop_current_colored_stock_ratio%")) && (!Boolean.parseBoolean(prices.get("is_stock_mode")) && !Boolean.parseBoolean(prices.get("is_static_stock_mode")) || prices.get("stock").equals("N/A"))) {
            return true;
        }
        if (line.contains("%dynashop_current_buy_limit%") && prices.get("buy_limit").equals("\u221e") || line.contains("%dynashop_current_sell_limit%") && prices.get("sell_limit").equals("\u221e") || line.contains("%dynashop_current_buy_reset_time%") && prices.get("buy_reset_time").equals("\u221e") || line.contains("%dynashop_current_sell_reset_time%") && prices.get("sell_reset_time").equals("\u221e")) {
            return true;
        }
        if (line.contains("%dynashop_current_buy_limit_status%") && (prices.get("buy_reset_time").equals("\u221e") || prices.get("buy_limit").equals("\u221e")) || line.contains("%dynashop_current_sell_limit_status%") && (prices.get("sell_reset_time").equals("\u221e") || prices.get("sell_limit").equals("\u221e"))) {
            return true;
        }
        return line.contains("%dynashop_current_buy_modifier%") && prices.get("buy_modifier").equals("100%") || line.contains("%dynashop_current_sell_modifier%") && prices.get("sell_modifier").equals("100%");
    }

    private String replaceDynaShopPlaceholders(String line, Map<String, String> prices) {
        if ((line = line.replace("%dynashop_current_buyPrice%", prices.get("buy")).replace("%dynashop_current_sellPrice%", prices.get("sell")).replace("%dynashop_current_buyMinPrice%", prices.get("buy_min")).replace("%dynashop_current_buyMaxPrice%", prices.get("buy_max")).replace("%dynashop_current_sellMinPrice%", prices.get("sell_min")).replace("%dynashop_current_sellMaxPrice%", prices.get("sell_max")).replace("%dynashop_current_buy%", prices.get("base_buy")).replace("%dynashop_current_sell%", prices.get("base_sell")).replace("%dynashop_current_stock%", prices.get("stock")).replace("%dynashop_current_maxstock%", prices.get("stock_max")).replace("%dynashop_current_stock_ratio%", prices.get("base_stock")).replace("%dynashop_current_colored_stock_ratio%", prices.get("colored_stock_ratio")).replace("%dynashop_current_buy_limit%", prices.get("buy_limit")).replace("%dynashop_current_sell_limit%", prices.get("sell_limit")).replace("%dynashop_current_buy_reset_time%", prices.get("buy_reset_time")).replace("%dynashop_current_sell_reset_time%", prices.get("sell_reset_time")).replace("%dynashop_current_buy_modifier%", prices.getOrDefault("buy_modifier", "100%")).replace("%dynashop_current_sell_modifier%", prices.getOrDefault("sell_modifier", "100%"))).contains("%dynashop_current_buy_limit_status%")) {
            line = prices.get("buy_limit_reached").equals("true") ? line.replace("%dynashop_current_buy_limit_status%", ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.getLangConfig().getPlaceholderLimitBuyReached().replace("%time%", prices.get("buy_reset_time")))) : line.replace("%dynashop_current_buy_limit_status%", ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.getLangConfig().getPlaceholderLimitRemaining().replace("%limit%", prices.get("buy_limit"))));
        }
        if (line.contains("%dynashop_current_sell_limit_status%")) {
            line = prices.get("sell_limit_reached").equals("true") ? line.replace("%dynashop_current_sell_limit_status%", ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.getLangConfig().getPlaceholderLimitSellReached().replace("%time%", prices.get("sell_reset_time")))) : line.replace("%dynashop_current_sell_limit_status%", ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.getLangConfig().getPlaceholderLimitRemaining().replace("%limit%", prices.get("sell_limit"))));
        }
        return line;
    }

    private boolean canUsePlaceholderAPI() {
        return this.plugin.getServer().getPluginManager().getPlugin("PlaceholderAPI") != null;
    }

    private List<String> preProcessPlaceholders(List<String> lore) {
        ArrayList<String> processed = new ArrayList<String>();
        for (String line : lore) {
            if (line.contains("%dynashop_current_")) {
                String tempLine = line.replace("%dynashop_current_buyPrice%", "Loading...").replace("%dynashop_current_sellPrice%", "Loading...").replace("%dynashop_current_buyMinPrice%", "...").replace("%dynashop_current_buyMaxPrice%", "...").replace("%dynashop_current_sellMinPrice%", "...").replace("%dynashop_current_sellMaxPrice%", "...").replace("%dynashop_current_buy%", "Loading...").replace("%dynashop_current_sell%", "Loading...").replace("%dynashop_current_stock%", "Loading...").replace("%dynashop_current_maxstock%", "Loading...").replace("%dynashop_current_stock_ratio%", "Loading...").replace("%dynashop_current_colored_stock_ratio%", "Loading...").replace("%dynashop_current_buy_limit%", "Loading...").replace("%dynashop_current_sell_limit%", "Loading...").replace("%dynashop_current_buy_reset_time%", "Loading...").replace("%dynashop_current_sell_reset_time%", "Loading...").replace("%dynashop_current_buy_limit_status%", "Loading...").replace("%dynashop_current_sell_limit_status%", "Loading...").replace("%dynashop_current_buy_modifier%", "Loading...").replace("%dynashop_current_sell_modifier%", "Loading...");
                processed.add(tempLine);
                continue;
            }
            processed.add(line);
        }
        return processed;
    }

    private String determineShopId(InventoryView view) {
        if (view == null) {
            return null;
        }
        String title = view.getTitle();
        if (this.isAmountSelectionMenu(title)) {
            return "AMOUNT_SELECTION";
        }
        if (this.isBulkSelectionMenu(title)) {
            return "AMOUNT_SELECTION_BULK";
        }
        return this.findShopIdFromTitle(title);
    }

    private boolean isAmountSelectionMenu(String title) {
        String buyName = ShopGuiPlusApi.getPlugin().getConfigLang().getConfig().getString("DIALOG.AMOUNTSELECTION.BUY.NAME");
        String sellName = ShopGuiPlusApi.getPlugin().getConfigLang().getConfig().getString("DIALOG.AMOUNTSELECTION.SELL.NAME");
        return title.contains(ChatColor.translateAlternateColorCodes((char)'&', (String)buyName.replace("%item%", ""))) || title.contains(ChatColor.translateAlternateColorCodes((char)'&', (String)sellName.replace("%item%", "")));
    }

    private boolean isBulkSelectionMenu(String title) {
        String bulkBuyName = ShopGuiPlusApi.getPlugin().getConfigLang().getConfig().getString("DIALOG.AMOUNTSELECTION.BULKBUY.NAME");
        String bulkSellName = ShopGuiPlusApi.getPlugin().getConfigLang().getConfig().getString("DIALOG.AMOUNTSELECTION.BULKSELL.NAME");
        return title.contains(ChatColor.translateAlternateColorCodes((char)'&', (String)bulkBuyName.replace("%item%", ""))) || title.contains(ChatColor.translateAlternateColorCodes((char)'&', (String)bulkSellName.replace("%item%", "")));
    }

    private String findShopIdFromTitle(String title) {
        try {
            for (Shop shop : ShopGuiPlusApi.getPlugin().getShopManager().getShops()) {
                String cleanTitle;
                String shopNameTemplate = ChatColor.stripColor((String)ChatColor.translateAlternateColorCodes((char)'&', (String)shop.getName())).trim();
                String[] parts = shopNameTemplate.split("%page%", -1);
                StringBuilder regexBuilder = new StringBuilder();
                regexBuilder.append(".*");
                for (int i = 0; i < parts.length; ++i) {
                    regexBuilder.append(Pattern.quote(parts[i]));
                    if (i >= parts.length - 1) continue;
                    regexBuilder.append("(\\d+)");
                }
                regexBuilder.append(".*");
                Pattern pattern = Pattern.compile(regexBuilder.toString(), 2);
                Matcher matcher = pattern.matcher(cleanTitle = ChatColor.stripColor((String)title).trim());
                if (!matcher.matches()) continue;
                if (shop.getName().contains("%page%") && matcher.groupCount() >= 1) {
                    int page = 1;
                    try {
                        page = Integer.parseInt(matcher.group(1));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    return shop.getId() + "#" + page;
                }
                return shop.getId();
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Error retrieving shop via API: " + e.getMessage());
        }
        return null;
    }

    private boolean isQuantityButton(int slot) {
        return slot == ShopGuiPlusApi.getPlugin().getConfigMain().getConfig().getInt("amountSelectionGUI.buttons.set1.slot") || slot == ShopGuiPlusApi.getPlugin().getConfigMain().getConfig().getInt("amountSelectionGUI.buttons.remove10.slot") || slot == ShopGuiPlusApi.getPlugin().getConfigMain().getConfig().getInt("amountSelectionGUI.buttons.remove1.slot") || slot == ShopGuiPlusApi.getPlugin().getConfigMain().getConfig().getInt("amountSelectionGUI.buttons.add1.slot") || slot == ShopGuiPlusApi.getPlugin().getConfigMain().getConfig().getInt("amountSelectionGUI.buttons.add10.slot") || slot == ShopGuiPlusApi.getPlugin().getConfigMain().getConfig().getInt("amountSelectionGUI.buttons.set16.slot") || slot == ShopGuiPlusApi.getPlugin().getConfigMain().getConfig().getInt("amountSelectionGUI.buttons.set64.slot");
    }

    private boolean isBulkButton(int slot) {
        return slot == ShopGuiPlusApi.getPlugin().getConfigMain().getConfig().getInt("amountSelectionGUI.buttons.buyMore.slot") || slot == ShopGuiPlusApi.getPlugin().getConfigMain().getConfig().getInt("amountSelectionGUI.buttons.sellMore.slot");
    }

    private Map<Integer, List<String>> extractOriginalLores(InventoryView view, Player player) {
        HashMap<Integer, List<String>> originalLores = new HashMap<Integer, List<String>>();
        AmountSelectionInfo info = this.amountSelectionMenus.get(player.getUniqueId());
        if (info == null) {
            return originalLores;
        }
        for (Map.Entry<Integer, Integer> entry : info.getSlotValues().entrySet()) {
            int slot = entry.getKey();
            ItemStack item = view.getTopInventory().getItem(slot);
            if (item == null || !item.hasItemMeta() || !item.getItemMeta().hasLore()) continue;
            ItemMeta meta = item.getItemMeta();
            List lore = meta.getLore();
            originalLores.put(slot, new ArrayList(lore));
            List<String> tempLore = this.preProcessPlaceholders(lore);
            meta.setLore(tempLore);
            item.setItemMeta(meta);
        }
        return originalLores;
    }

    private void cancelRefreshTasks(UUID playerId) {
        BukkitTask t1 = this.playerRefreshBukkitTasks.remove(playerId);
        if (t1 != null) {
            t1.cancel();
        }
        this.playerRefreshTasks.remove(playerId);
        BukkitTask t2 = this.playerSelectionRefreshBukkitTasks.remove(playerId);
        if (t2 != null) {
            t2.cancel();
        }
        this.playerSelectionRefreshTasks.remove(playerId);
    }

    private void scheduleCleanup(Player player, UUID playerId, String shopId) {
        this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            if (!player.isOnline()) {
                return;
            }
            String newMenuType = player.isOnline() ? this.determineShopId(player.getOpenInventory()) : null;
            boolean isNewSelectionMenu = newMenuType != null && (newMenuType.equals("AMOUNT_SELECTION") || newMenuType.equals("AMOUNT_SELECTION_BULK"));
            boolean isChangingPage = false;
            if (newMenuType != null && shopId != null) {
                String baseNewShop = newMenuType.contains("#") ? newMenuType.split("#")[0] : newMenuType;
                String baseOldShop = shopId.contains("#") ? shopId.split("#")[0] : shopId;
                boolean bl = isChangingPage = baseNewShop.equals(baseOldShop) && newMenuType.contains("#");
            }
            if (!isNewSelectionMenu && !isChangingPage) {
                this.openShopMap.remove(playerId);
                this.amountSelectionMenus.remove(playerId);
            } else if (isChangingPage) {
                AbstractMap.SimpleEntry<String, String> currentShop = this.openShopMap.get(playerId);
                String itemId = currentShop != null ? currentShop.getValue() : null;
                this.openShopMap.put(playerId, new AbstractMap.SimpleEntry<String, String>(newMenuType, itemId));
                this.lastShopMap.put(playerId, new AbstractMap.SimpleEntry<String, String>(newMenuType, itemId));
            }
        }, 10L);
    }

    private void reopenShopAtPage(Player player, AbstractMap.SimpleEntry<String, String> lastShop) {
        String[] parts = lastShop.getKey().split("#");
        String shopId = parts[0];
        int page = 1;
        try {
            page = Integer.parseInt(parts[1]);
        }
        catch (NumberFormatException e) {
            page = 1;
        }
        int finalPage = page;
        if (finalPage > 1) {
            this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                Shop shop;
                String currentMenuType;
                if (player.isOnline() && ((currentMenuType = this.determineShopId(player.getOpenInventory())) == null || !currentMenuType.equals("AMOUNT_SELECTION") && !currentMenuType.equals("AMOUNT_SELECTION_BULK")) && (shop = ShopGuiPlusApi.getPlugin().getShopManager().getShopById(shopId)) != null) {
                    try {
                        ShopGuiPlusApi.openShop((Player)player, (String)shopId, (int)finalPage);
                    }
                    catch (PlayerDataNotLoadedException playerDataNotLoadedException) {
                        // empty catch block
                    }
                }
            }, 2L);
        }
    }

    private void startContinuousRefresh(Player player, InventoryView view, String shopId, int page, Map<Integer, List<String>> originalLores) {
        BukkitTask oldTask = this.playerRefreshBukkitTasks.remove(player.getUniqueId());
        if (oldTask != null) {
            oldTask.cancel();
        }
        UUID refreshId = UUID.randomUUID();
        this.playerRefreshTasks.put(player.getUniqueId(), refreshId);
        long refreshInterval = this.plugin.isRealTimeMode() ? this.guiRefreshCriticalItems : this.guiRefreshDefaultItems;
        BukkitTask task = this.plugin.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)this.plugin, () -> {
            if (!player.isOnline() || player.getOpenInventory() == null || this.playerRefreshTasks.get(player.getUniqueId()) != refreshId) {
                BukkitTask t = this.playerRefreshBukkitTasks.remove(player.getUniqueId());
                if (t != null) {
                    t.cancel();
                }
                this.playerRefreshTasks.remove(player.getUniqueId());
                return;
            }
            this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> {
                if (player.isOnline() && player.getOpenInventory() != null) {
                    this.updateShopInventory(player, view, shopId, page, originalLores);
                }
            });
        }, 0L, refreshInterval / 50L);
        this.playerRefreshBukkitTasks.put(player.getUniqueId(), task);
    }

    private void startContinuousAmountSelectionRefresh(Player player, AmountSelectionInfo info, Map<Integer, List<String>> originalLores, String menuType) {
        BukkitTask oldTask = this.playerSelectionRefreshBukkitTasks.remove(player.getUniqueId());
        if (oldTask != null) {
            oldTask.cancel();
        }
        UUID refreshId = UUID.randomUUID();
        this.playerSelectionRefreshTasks.put(player.getUniqueId(), refreshId);
        int[] lastCenterQuantity = new int[]{info.getItemStack().getAmount()};
        boolean isCriticalItem = this.plugin.getConfigMain().getStringList("critical-items").contains(info.getShopId() + ":" + info.getItemId());
        long refreshInterval = isCriticalItem ? this.guiRefreshCriticalItems : this.guiRefreshDefaultItems;
        BukkitTask task = this.plugin.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)this.plugin, () -> {
            if (!player.isOnline() || player.getOpenInventory() == null || this.playerSelectionRefreshTasks.get(player.getUniqueId()) != refreshId) {
                BukkitTask t = this.playerSelectionRefreshBukkitTasks.remove(player.getUniqueId());
                if (t != null) {
                    t.cancel();
                }
                this.playerSelectionRefreshTasks.remove(player.getUniqueId());
                return;
            }
            this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> {
                if (player.isOnline() && player.getOpenInventory() != null) {
                    if (menuType.equals("AMOUNT_SELECTION")) {
                        this.updateAmountSelectionIfChanged(player, info, originalLores, lastCenterQuantity);
                    } else {
                        this.updateAmountSelectionInventory(player, player.getOpenInventory(), info, originalLores);
                    }
                }
            });
        }, 0L, refreshInterval / 50L);
        this.playerSelectionRefreshBukkitTasks.put(player.getUniqueId(), task);
    }

    private void updateAmountSelectionIfChanged(Player player, AmountSelectionInfo info, Map<Integer, List<String>> originalLores, int[] lastCenterQuantity) {
        ItemStack currentItem;
        int inventorySize;
        int centerSlot = ShopGuiPlusApi.getPlugin().getConfigMain().getConfig().getInt("amountSelectionGUI.itemSlot", 22);
        if (centerSlot >= (inventorySize = player.getOpenInventory().getTopInventory().getSize())) {
            centerSlot = Math.min(inventorySize - 1, 13);
        }
        if ((currentItem = player.getOpenInventory().getTopInventory().getItem(centerSlot)) != null && currentItem.getAmount() != lastCenterQuantity[0]) {
            lastCenterQuantity[0] = currentItem.getAmount();
            AmountSelectionInfo newInfo = new AmountSelectionInfo(info.getShopId(), info.getItemId(), currentItem, info.isBuying(), "AMOUNT_SELECTION", info.getSlotValues());
            this.updateAmountSelectionInventory(player, player.getOpenInventory(), newInfo, originalLores);
        }
    }

    private Map<String, String> getCachedPlaceholders(Player player, String shopId, String itemId, ItemStack itemStack, int quantity, boolean forceRefresh) {
        String cacheKey = player != null ? shopId + ":" + itemId + ":" + quantity + ":" + player.getUniqueId().toString() : shopId + ":" + itemId + ":" + quantity;
        String baseShopId = shopId;
        if (shopId != null && shopId.contains("#")) {
            String[] parts = shopId.split("#");
            baseShopId = parts[0];
        }
        String finalBaseShopId = baseShopId;
        List criticalItems = this.plugin.getConfigMain().getStringList("critical-items");
        boolean isCriticalItem = criticalItems.contains(baseShopId + ":" + itemId);
        boolean bl = forceRefresh = forceRefresh || isCriticalItem;
        if (forceRefresh) {
            this.plugin.getDisplayPriceCache().invalidate(cacheKey);
        }
        HashSet visited = new HashSet();
        HashMap lastResults = new HashMap();
        return this.plugin.getDisplayPriceCache().get(cacheKey, () -> this.computePrices(player, finalBaseShopId, itemId, itemStack, quantity, visited, lastResults));
    }

    private Map<String, String> getCachedPlaceholders(Player player, String shopId, String itemId, ItemStack itemStack, boolean forceRefresh) {
        return this.getCachedPlaceholders(player, shopId, itemId, itemStack, 1, forceRefresh);
    }

    private Map<String, String> computePrices(Player player, String shopId, String itemId, ItemStack itemStack, int quantity, Set<String> visited, Map<String, DynamicPrice> lastResults) {
        String[] parts;
        String linkedItemRef;
        HashMap<String, String> prices = new HashMap<String, String>();
        DynaShopType generalType = this.plugin.getShopConfigManager().getTypeDynaShop(shopId, itemId);
        DynaShopType buyType = this.plugin.getShopConfigManager().getTypeDynaShop(shopId, itemId, "buy");
        DynaShopType sellType = this.plugin.getShopConfigManager().getTypeDynaShop(shopId, itemId, "sell");
        if (buyType == DynaShopType.NONE || buyType == DynaShopType.UNKNOWN) {
            buyType = generalType;
        }
        if (sellType == DynaShopType.NONE || sellType == DynaShopType.UNKNOWN) {
            sellType = generalType;
        }
        if (this.plugin.getShopConfigManager().getItemValue(shopId, itemId, "buyPrice", Double.class).orElse(-1.0) < 0.0) {
            prices.put("real_buy", "-1");
        } else {
            prices.put("real_buy", String.valueOf(this.plugin.getShopConfigManager().getItemValue(shopId, itemId, "buyPrice", Double.class).orElse(0.0)));
        }
        if (this.plugin.getShopConfigManager().getItemValue(shopId, itemId, "sellPrice", Double.class).orElse(-1.0) < 0.0) {
            prices.put("real_sell", "-1");
        } else {
            prices.put("real_sell", String.valueOf(this.plugin.getShopConfigManager().getItemValue(shopId, itemId, "sellPrice", Double.class).orElse(0.0)));
        }
        DynamicPrice price = this.plugin.getDynaShopListener().getOrLoadPrice(player, shopId, itemId, itemStack, visited, lastResults);
        if (price != null) {
            this.fillBasicPrices(prices, price, quantity);
        }
        this.fillModifierInfo(prices, player, shopId, itemId);
        boolean isStockMode = buyType == DynaShopType.STOCK || sellType == DynaShopType.STOCK || generalType == DynaShopType.STOCK;
        boolean isStaticStockMode = buyType == DynaShopType.STATIC_STOCK || sellType == DynaShopType.STATIC_STOCK || generalType == DynaShopType.STATIC_STOCK;
        boolean isRecipeMode = buyType == DynaShopType.RECIPE || sellType == DynaShopType.RECIPE || generalType == DynaShopType.RECIPE;
        boolean isLinkMode = buyType == DynaShopType.LINK || sellType == DynaShopType.LINK || generalType == DynaShopType.LINK;
        boolean linkedToStock = false;
        boolean linkedToStaticStock = false;
        String linkedShopId = null;
        String linkedItemId = null;
        if (isLinkMode && (linkedItemRef = (String)this.plugin.getShopConfigManager().getItemValue(shopId, itemId, "link", String.class).orElse(null)) != null && linkedItemRef.contains(":") && (parts = linkedItemRef.split(":")).length == 2) {
            linkedShopId = parts[0];
            linkedItemId = parts[1];
            DynaShopType linkedType = this.plugin.getShopConfigManager().getTypeDynaShop(linkedShopId, linkedItemId);
            linkedToStock = linkedType == DynaShopType.STOCK;
            boolean bl = linkedToStaticStock = linkedType == DynaShopType.STATIC_STOCK;
        }
        if (isRecipeMode) {
            boolean hasMaxStock;
            boolean bl = hasMaxStock = this.plugin.getPriceRecipe().calculateMaxStock(shopId, itemId, new ArrayList<String>()) > 0;
            if (hasMaxStock) {
                isStockMode = true;
            }
        }
        prices.put("is_stock_mode", String.valueOf(isStockMode || linkedToStock));
        prices.put("is_static_stock_mode", String.valueOf(isStaticStockMode || linkedToStaticStock));
        prices.put("is_recipe_mode", String.valueOf(isRecipeMode));
        prices.put("is_link_mode", String.valueOf(isLinkMode));
        if (isStockMode || isStaticStockMode || linkedToStock || linkedToStaticStock) {
            if ((linkedToStock || linkedToStaticStock) && linkedShopId != null && linkedItemId != null) {
                this.fillStockInfo(prices, price, linkedShopId, linkedItemId);
            } else {
                this.fillStockInfo(prices, price, shopId, itemId);
            }
        } else {
            prices.put("stock", "N/A");
            prices.put("stock_max", "N/A");
            prices.put("base_stock", "N/A");
            prices.put("colored_stock_ratio", "N/A");
        }
        if (player != null) {
            this.fillLimitInfo(prices, player, shopId, itemId);
        }
        this.formatDisplayPrices(prices, shopId);
        return prices;
    }

    private void fillBasicPrices(Map<String, String> prices, DynamicPrice price, int quantity) {
        if (price.getBuyPrice() < 0.0) {
            prices.put("buy", "N/A");
        } else {
            prices.put("buy", this.plugin.getPriceFormatter().formatPrice(price.getBuyPrice() * (double)quantity));
        }
        if (price.getSellPrice() < 0.0) {
            prices.put("sell", "N/A");
        } else {
            prices.put("sell", this.plugin.getPriceFormatter().formatPrice(price.getSellPrice() * (double)quantity));
        }
        if (price.getMinBuyPrice() < 0.0) {
            prices.put("buy_min", "N/A");
        } else {
            prices.put("buy_min", this.plugin.getPriceFormatter().formatPrice(price.getMinBuyPrice() * (double)quantity));
        }
        if (price.getMaxBuyPrice() < 0.0) {
            prices.put("buy_max", "N/A");
        } else {
            prices.put("buy_max", this.plugin.getPriceFormatter().formatPrice(price.getMaxBuyPrice() * (double)quantity));
        }
        if (price.getMinSellPrice() < 0.0) {
            prices.put("sell_min", "N/A");
        } else {
            prices.put("sell_min", this.plugin.getPriceFormatter().formatPrice(price.getMinSellPrice() * (double)quantity));
        }
        if (price.getMaxSellPrice() < 0.0) {
            prices.put("sell_max", "N/A");
        } else {
            prices.put("sell_max", this.plugin.getPriceFormatter().formatPrice(price.getMaxSellPrice() * (double)quantity));
        }
    }

    private void fillStockInfo(Map<String, String> prices, DynamicPrice price, String shopId, String itemId) {
        String fMaxStock;
        String maxStock;
        String fCurrentStock;
        String currentStock;
        String[] parts;
        String linkedItemRef;
        DynaShopType type = this.plugin.getShopConfigManager().getTypeDynaShop(shopId, itemId);
        if (type == DynaShopType.LINK && (linkedItemRef = (String)this.plugin.getShopConfigManager().getItemValue(shopId, itemId, "link", String.class).orElse(null)) != null && linkedItemRef.contains(":") && (parts = linkedItemRef.split(":")).length == 2) {
            this.fillStockInfo(prices, null, parts[0], parts[1]);
            return;
        }
        if (price != null) {
            if (price.getStock() < 0) {
                currentStock = "N/A";
                fCurrentStock = "N/A";
            } else {
                currentStock = String.valueOf(price.getStock());
                fCurrentStock = this.plugin.getPriceFormatter().formatStock(price.getStock());
            }
            if (price.getMaxStock() < 0) {
                maxStock = "N/A";
                fMaxStock = "N/A";
            } else {
                maxStock = String.valueOf(price.getMaxStock());
                fMaxStock = this.plugin.getPriceFormatter().formatStock(price.getMaxStock());
            }
        } else {
            currentStock = this.plugin.getPriceFormatter().getStockByType(shopId, itemId, "stock");
            fCurrentStock = currentStock.equals("N/A") || currentStock.equals("-1") ? "N/A" : this.plugin.getPriceFormatter().formatStock(Integer.parseInt(currentStock));
            maxStock = this.plugin.getPriceFormatter().getStockByType(shopId, itemId, "stock_max");
            fMaxStock = maxStock.equals("N/A") || maxStock.equals("-1") ? "N/A" : this.plugin.getPriceFormatter().formatStock(Integer.parseInt(maxStock));
        }
        prices.put("stock", fCurrentStock);
        prices.put("stock_max", fMaxStock);
        if (currentStock.equals("N/A") || currentStock.equals("-1") || currentStock.equals("0")) {
            prices.put("base_stock", ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.getLangConfig().getPlaceholderOutOfStock()));
            prices.put("colored_stock_ratio", ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.getLangConfig().getPlaceholderOutOfStock()));
        } else {
            prices.put("base_stock", String.format("%s/%s", fCurrentStock, fMaxStock));
            try {
                int current = Integer.parseInt(currentStock);
                int max = Integer.parseInt(maxStock);
                if (max <= 0) {
                    prices.put("colored_stock_ratio", ChatColor.translateAlternateColorCodes((char)'&', (String)String.format("&7%s", fCurrentStock)));
                } else {
                    String colorCode = (double)current < (double)max * 0.1 ? "&4" : ((double)current < (double)max * 0.25 ? "&c" : ((double)current < (double)max * 0.5 ? "&e" : "&a"));
                    prices.put("colored_stock_ratio", ChatColor.translateAlternateColorCodes((char)'&', (String)String.format("%s%s&7/%s", colorCode, fCurrentStock, fMaxStock)));
                }
            }
            catch (NumberFormatException e) {
                prices.put("colored_stock_ratio", ChatColor.translateAlternateColorCodes((char)'&', (String)String.format("&7%s/%s", fCurrentStock, fMaxStock)));
            }
        }
    }

    private void fillLimitInfo(Map<String, String> prices, Player player, String shopId, String itemId) {
        block11: {
            block10: {
                LimitCacheEntry buyLimit = this.plugin.getTransactionLimiter().getTransactionLimit(player, shopId, itemId, true);
                if (buyLimit != null && buyLimit.getLimit() > 0) {
                    try {
                        prices.put("buy_limit", String.valueOf(buyLimit.remaining));
                        prices.put("buy_reset_time", this.formatTimeRemaining(buyLimit.nextAvailable, buyLimit));
                        if (buyLimit.remaining <= 0) {
                            prices.put("buy_limit_reached", "true");
                            break block10;
                        }
                        prices.put("buy_limit_reached", "false");
                    }
                    catch (Exception e) {
                        prices.put("buy_limit", "N/A");
                        prices.put("buy_reset_time", "N/A");
                        prices.put("buy_limit_reached", "false");
                    }
                } else {
                    prices.put("buy_limit", "\u221e");
                    prices.put("buy_reset_time", "\u221e");
                    prices.put("buy_limit_reached", "false");
                }
            }
            LimitCacheEntry sellLimit = this.plugin.getTransactionLimiter().getTransactionLimit(player, shopId, itemId, false);
            if (sellLimit != null && sellLimit.getLimit() > 0) {
                try {
                    prices.put("sell_limit", String.valueOf(sellLimit.remaining));
                    prices.put("sell_reset_time", this.formatTimeRemaining(sellLimit.nextAvailable, sellLimit));
                    if (sellLimit.remaining <= 0) {
                        prices.put("sell_limit_reached", "true");
                        break block11;
                    }
                    prices.put("sell_limit_reached", "false");
                }
                catch (Exception e) {
                    prices.put("sell_limit", "N/A");
                    prices.put("sell_reset_time", "N/A");
                    prices.put("sell_limit_reached", "false");
                }
            } else {
                prices.put("sell_limit", "\u221e");
                prices.put("sell_reset_time", "\u221e");
                prices.put("sell_limit_reached", "false");
            }
        }
    }

    private void fillModifierInfo(Map<String, String> prices, Player player, String shopId, String itemId) {
        double buyModifier = 1.0;
        double sellModifier = 1.0;
        try {
            ShopItem shopItem;
            Shop shop = ShopGuiPlusApi.getShop((String)shopId);
            if (shop != null && (shopItem = shop.getShopItem(itemId)) != null && player != null) {
                buyModifier = ShopGuiPlusApi.getPriceModifier((Player)player, (ShopItem)shopItem, (PriceModifierActionType)PriceModifierActionType.BUY).getModifier();
                sellModifier = ShopGuiPlusApi.getPriceModifier((Player)player, (ShopItem)shopItem, (PriceModifierActionType)PriceModifierActionType.SELL).getModifier();
            }
        }
        catch (Exception shop) {
            // empty catch block
        }
        Object buyModStr = "";
        if (Math.abs(buyModifier - 1.0) > 0.001) {
            double percent = (buyModifier - 1.0) * 100.0;
            buyModStr = percent > 0.0 ? "&4+" + String.format("%.0f", percent) + "% " : "&2" + String.format("%.0f", percent) + "% ";
        }
        Object sellModStr = "";
        if (Math.abs(sellModifier - 1.0) > 0.001) {
            double percent = (sellModifier - 1.0) * 100.0;
            sellModStr = percent > 0.0 ? "&2+" + String.format("%.0f", percent) + "% " : "&4" + String.format("%.0f", percent) + "% ";
        }
        prices.put("buy_modifier", ChatColor.translateAlternateColorCodes((char)'&', (String)buyModStr));
        prices.put("sell_modifier", ChatColor.translateAlternateColorCodes((char)'&', (String)sellModStr));
    }

    private void formatDisplayPrices(Map<String, String> prices, String shopId) {
        String currencyPrefix = "";
        String currencySuffix = " $";
        try {
            currencyPrefix = ShopGuiPlusApi.getPlugin().getEconomyManager().getEconomyProvider(ShopGuiPlusApi.getShop((String)shopId).getEconomyType()).getCurrencyPrefix();
            currencySuffix = ShopGuiPlusApi.getPlugin().getEconomyManager().getEconomyProvider(ShopGuiPlusApi.getShop((String)shopId).getEconomyType()).getCurrencySuffix();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (prices.get("buy") == null || prices.get("buy").equals("N/A") || prices.get("buy").equals("0.0") || prices.get("buy").equals("-1")) {
            prices.put("base_buy", "N/A");
        } else if (!(prices.get("buy_min").equals("N/A") || prices.get("buy_max").equals("N/A") || prices.get("buy_min").equals(prices.get("buy")) && prices.get("buy_max").equals(prices.get("buy")))) {
            prices.put("base_buy", String.format(currencyPrefix + "%s" + currencySuffix + " \u00a77(%s - %s) ", prices.get("buy"), prices.get("buy_min"), prices.get("buy_max")));
        } else {
            prices.put("base_buy", currencyPrefix + prices.get("buy") + currencySuffix);
        }
        if (prices.get("sell") == null || prices.get("sell").equals("N/A") || prices.get("sell").equals("0.0") || prices.get("sell").equals("-1")) {
            prices.put("base_sell", "N/A");
        } else if (!(prices.get("sell_min").equals("N/A") || prices.get("sell_max").equals("N/A") || prices.get("sell_min").equals(prices.get("sell")) && prices.get("sell_max").equals(prices.get("sell")))) {
            prices.put("base_sell", String.format(currencyPrefix + "%s" + currencySuffix + " \u00a77(%s - %s) ", prices.get("sell"), prices.get("sell_min"), prices.get("sell_max")));
        } else {
            prices.put("base_sell", currencyPrefix + prices.get("sell") + currencySuffix);
        }
    }

    private void updateShopInventory(Player player, InventoryView view, String shopId, int page, Map<Integer, List<String>> originalLores) {
        if (view == null || view.getTopInventory() == null) {
            return;
        }
        try {
            String finalShopId = shopId;
            if (finalShopId == null) {
                return;
            }
            ArrayList<Integer> slotsToUpdate = new ArrayList<Integer>(originalLores.keySet());
            for (int i = 0; i < slotsToUpdate.size(); i += 5) {
                int startIdx = i;
                int endIdx = Math.min(i + 5, slotsToUpdate.size());
                this.plugin.getServer().getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
                    HashMap<Integer, ItemStack> updatedItems = new HashMap<Integer, ItemStack>();
                    for (int j = startIdx; j < endIdx; ++j) {
                        int slot = (Integer)slotsToUpdate.get(j);
                        try {
                            String itemId;
                            ShopItem shopItem;
                            Shop shop;
                            List originalLore;
                            ItemStack item = view.getTopInventory().getItem(slot);
                            if (item == null || !item.hasItemMeta() || (originalLore = (List)originalLores.get(slot)) == null || !this.containsDynaShopPlaceholder(originalLore) || (shop = ShopGuiPlusApi.getPlugin().getShopManager().getShopById(finalShopId)) == null || (shopItem = shop.getShopItem(page, slot)) == null || (itemId = shopItem.getId()) == null) continue;
                            Map<String, String> itemPrices = this.getCachedPlaceholders(player, finalShopId, itemId, item, false);
                            List<String> newLore = this.replacePlaceholders(originalLore, itemPrices, player);
                            ItemMeta meta = item.getItemMeta();
                            meta.setLore(newLore);
                            item.setItemMeta(meta);
                            updatedItems.put(slot, item.clone());
                            continue;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (!updatedItems.isEmpty()) {
                        this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> {
                            if (player.isOnline() && player.getOpenInventory().equals(view)) {
                                for (Map.Entry entry : updatedItems.entrySet()) {
                                    view.getTopInventory().setItem(((Integer)entry.getKey()).intValue(), (ItemStack)entry.getValue());
                                }
                                player.updateInventory();
                            }
                        });
                    }
                });
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Error updating inventory: " + e.getMessage());
        }
    }

    private void updateAmountSelectionInventory(Player player, InventoryView view, AmountSelectionInfo info, Map<Integer, List<String>> originalLores) {
        if (view == null || view.getTopInventory() == null) {
            return;
        }
        try {
            ArrayList<Integer> slotsToUpdate = new ArrayList<Integer>(originalLores.keySet());
            for (int i = 0; i < slotsToUpdate.size(); i += 5) {
                int startIdx = i;
                int endIdx = Math.min(i + 5, slotsToUpdate.size());
                this.plugin.getServer().getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
                    HashMap<Integer, ItemStack> updatedItems = new HashMap<Integer, ItemStack>();
                    for (int j = startIdx; j < endIdx; ++j) {
                        int slot = (Integer)slotsToUpdate.get(j);
                        try {
                            int quantity;
                            ItemStack button = view.getTopInventory().getItem(slot);
                            if (button == null || !button.hasItemMeta() || !button.getItemMeta().hasLore()) continue;
                            if (info.getMenuType().equals("AMOUNT_SELECTION") && button.getItemMeta().hasDisplayName() && slot == ShopGuiPlusApi.getPlugin().getConfigMain().getConfig().getInt("amountSelectionGUI.buttons.sellAll.slot")) {
                                quantity = 0;
                                for (ItemStack item : player.getInventory().getContents()) {
                                    if (item == null || item.getType() != info.getItemStack().getType() || !this.plugin.getPriceRecipe().customCompare(item, info.getItemStack())) continue;
                                    quantity += item.getAmount();
                                }
                            } else if (info.getMenuType().equals("AMOUNT_SELECTION_BULK")) {
                                int stackValue = info.getValueForSlot(slot);
                                quantity = stackValue * button.getMaxStackSize();
                            } else {
                                quantity = info.getItemStack().getAmount();
                            }
                            List originalLore = (List)originalLores.get(slot);
                            if (originalLore == null || !this.containsDynaShopPlaceholder(originalLore)) continue;
                            Map<String, String> prices = this.getCachedPlaceholders(player, info.getShopId(), info.getItemId(), info.getItemStack(), quantity, false);
                            List<String> newLore = this.replacePlaceholders(originalLore, prices, player);
                            ItemMeta meta = button.getItemMeta();
                            meta.setLore(newLore);
                            button.setItemMeta(meta);
                            updatedItems.put(slot, button.clone());
                            continue;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (!updatedItems.isEmpty()) {
                        this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> {
                            if (player.isOnline() && player.getOpenInventory().equals(view)) {
                                for (Map.Entry entry : updatedItems.entrySet()) {
                                    view.getTopInventory().setItem(((Integer)entry.getKey()).intValue(), (ItemStack)entry.getValue());
                                }
                                player.updateInventory();
                            }
                        });
                    }
                });
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Error updating amount selection inventory: " + e.getMessage());
        }
    }

    public String getCurrentShopId(Player player) {
        AbstractMap.SimpleEntry<String, String> shopData = this.openShopMap.get(player.getUniqueId());
        return shopData == null ? null : shopData.getKey();
    }

    public String getCurrentItemId(Player player) {
        AbstractMap.SimpleEntry<String, String> shopData = this.openShopMap.get(player.getUniqueId());
        return shopData == null ? null : shopData.getValue();
    }

    private AmountSelectionInfo extractAmountSelectionInfo(InventoryView view, String menuType) {
        ItemStack centerItem;
        int inventorySize;
        int centerSlot;
        FileConfiguration configMain = ShopGuiPlusApi.getPlugin().getConfigMain().getConfig();
        FileConfiguration configLang = ShopGuiPlusApi.getPlugin().getConfigLang().getConfig();
        String title = view.getTitle();
        String buyName = configLang.getString("DIALOG.AMOUNTSELECTION.BUY.NAME");
        String bulkBuyName = configLang.getString("DIALOG.AMOUNTSELECTION.BULKBUY.NAME");
        String translatedBuyName = ChatColor.translateAlternateColorCodes((char)'&', (String)buyName.replace("%item%", ""));
        String translatedBulkBuyName = ChatColor.translateAlternateColorCodes((char)'&', (String)bulkBuyName.replace("%item%", ""));
        boolean isBuying = title.contains(translatedBuyName) || title.contains(translatedBulkBuyName);
        HashMap<Integer, Integer> slotValues = new HashMap<Integer, Integer>();
        if (menuType.equals("AMOUNT_SELECTION_BULK")) {
            String buttonPrefix = isBuying ? "amountSelectionGUIBulkBuy.buttons.buy" : "amountSelectionGUIBulkSell.buttons.sell";
            centerSlot = configMain.getInt(buttonPrefix + "1.slot", 0);
            for (int i = 1; i <= 9; ++i) {
                String slotPath = buttonPrefix + i + ".slot";
                if (!configMain.contains(slotPath)) continue;
                int slot = configMain.getInt(slotPath);
                int value = configMain.getInt(buttonPrefix + i + ".value", 1);
                slotValues.put(slot, value);
            }
        } else {
            centerSlot = configMain.getInt("amountSelectionGUI.itemSlot", 22);
            slotValues.put(centerSlot, 0);
            int sellAllSlot = configMain.getInt("amountSelectionGUI.buttons.sellAll.slot", -1);
            if (sellAllSlot >= 0) {
                slotValues.put(sellAllSlot, 1);
            }
            for (String button : new String[]{"set1", "remove10", "remove1", "add1", "add10", "set16", "set64"}) {
                int slot = configMain.getInt("amountSelectionGUI.buttons." + button + ".slot", -1);
                if (slot < 0) continue;
                slotValues.put(slot, 0);
            }
        }
        if (centerSlot >= (inventorySize = view.getTopInventory().getSize())) {
            centerSlot = Math.min(inventorySize - 1, 22);
        }
        if ((centerItem = view.getTopInventory().getItem(centerSlot)) == null) {
            return null;
        }
        Player player = (Player)view.getPlayer();
        AbstractMap.SimpleEntry<String, String> shopInfo = this.openShopMap.get(player.getUniqueId());
        if (shopInfo == null) {
            shopInfo = this.lastShopMap.get(player.getUniqueId());
        }
        if (shopInfo == null) {
            return null;
        }
        return new AmountSelectionInfo(shopInfo.getKey(), shopInfo.getValue(), centerItem.clone(), isBuying, menuType, slotValues);
    }

    private String formatTimeRemaining(long millisRemaining, LimitCacheEntry limit) {
        if (millisRemaining <= 0L) {
            return "\u221e";
        }
        TransactionLimiter.LimitPeriod period = limit.getPeriodEquivalent();
        if (period != TransactionLimiter.LimitPeriod.NONE) {
            LocalDateTime resetTime = LocalDateTime.now().plus(millisRemaining, ChronoUnit.MILLIS);
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("dd.MM.yyyy HH:mm:ss");
            return resetTime.format(formatter);
        }
        long secondsRemaining = millisRemaining / 1000L;
        long hours = secondsRemaining / 3600L;
        long minutes = secondsRemaining % 3600L / 60L;
        long seconds = secondsRemaining % 60L;
        if (hours > 0L) {
            return String.format("%02dh %02dm %02ds", hours, minutes, seconds);
        }
        if (minutes > 0L) {
            return String.format("%02dm %02ds", minutes, seconds);
        }
        return String.format("%02ds", seconds);
    }

    public void shutdown() {
        for (BukkitTask task : this.playerRefreshBukkitTasks.values()) {
            if (task == null) continue;
            task.cancel();
        }
        for (BukkitTask task : this.playerSelectionRefreshBukkitTasks.values()) {
            if (task == null) continue;
            task.cancel();
        }
        this.playerRefreshTasks.clear();
        this.playerRefreshBukkitTasks.clear();
        this.playerSelectionRefreshTasks.clear();
        this.playerSelectionRefreshBukkitTasks.clear();
        this.openShopMap.clear();
        this.lastShopMap.clear();
        this.amountSelectionMenus.clear();
        this.pendingBulkMenuOpens.clear();
    }

    private static class AmountSelectionInfo {
        private final String shopId;
        private final String itemId;
        private final ItemStack itemStack;
        private final boolean isBuying;
        private final String menuType;
        private final Map<Integer, Integer> slotValues;

        public AmountSelectionInfo(String shopId, String itemId, ItemStack itemStack, boolean isBuying, String menuType, Map<Integer, Integer> slotValues) {
            this.shopId = shopId;
            this.itemId = itemId;
            this.itemStack = itemStack.clone();
            this.isBuying = isBuying;
            this.menuType = menuType;
            this.slotValues = slotValues != null ? new HashMap<Integer, Integer>(slotValues) : new HashMap();
        }

        public String getShopId() {
            return this.shopId;
        }

        public String getItemId() {
            return this.itemId;
        }

        public ItemStack getItemStack() {
            return this.itemStack;
        }

        public boolean isBuying() {
            return this.isBuying;
        }

        public String getMenuType() {
            return this.menuType;
        }

        public Map<Integer, Integer> getSlotValues() {
            return this.slotValues;
        }

        public int getValueForSlot(int slot) {
            return this.slotValues.getOrDefault(slot, 1);
        }
    }
}

