/*
 * Decompiled with CFR 0.152.
 */
package fr.tylwen.satyria.dynashop.price;

import fr.tylwen.satyria.dynashop.DynaShopPlugin;
import fr.tylwen.satyria.dynashop.data.param.DynaShopType;
import fr.tylwen.satyria.dynashop.system.InflationManager;
import net.brcdev.shopgui.ShopGuiPlusApi;
import net.brcdev.shopgui.modifier.PriceModifier;
import net.brcdev.shopgui.modifier.PriceModifierActionType;
import net.brcdev.shopgui.shop.Shop;
import net.brcdev.shopgui.shop.item.ShopItem;
import org.bukkit.entity.Player;

public class DynamicPrice
implements Cloneable {
    private double buyPrice;
    private double sellPrice;
    private double minBuy;
    private double maxBuy;
    private double minSell;
    private double maxSell;
    private double growthBuy;
    private double decayBuy;
    private double growthSell;
    private double decaySell;
    static final double MIN_MARGIN = 0.01;
    private int stock;
    private final int minStock;
    private final int maxStock;
    private final double stockBuyModifier;
    private final double stockSellModifier;
    private DynaShopType typeDynaShop;
    private DynaShopType buyTypeDynaShop;
    private DynaShopType sellTypeDynaShop;

    public DynamicPrice(double buyPrice, double sellPrice, double minBuy, double maxBuy, double minSell, double maxSell, double growthBuy, double decayBuy, double growthSell, double decaySell, int stock, int minStock, int maxStock, double stockBuyModifier, double stockSellModifier) {
        if (minBuy > 0.0 && maxBuy > 0.0 && minBuy > maxBuy) {
            throw new IllegalArgumentException("minBuy ne peut pas \u00eatre sup\u00e9rieur \u00e0 maxBuy");
        }
        if (minSell > 0.0 && maxSell > 0.0 && minSell > maxSell) {
            throw new IllegalArgumentException("minSell ne peut pas \u00eatre sup\u00e9rieur \u00e0 maxSell");
        }
        if (growthBuy <= 0.0 || decayBuy <= 0.0 || growthSell <= 0.0 || decaySell <= 0.0) {
            throw new IllegalArgumentException("Les facteurs de croissance et de d\u00e9croissance doivent \u00eatre positifs");
        }
        if (minStock > maxStock) {
            throw new IllegalArgumentException("minStock (" + minStock + ") ne peut pas \u00eatre sup\u00e9rieur \u00e0 maxStock (" + maxStock + ")");
        }
        this.buyPrice = buyPrice;
        this.sellPrice = sellPrice;
        if (this.buyPrice > 0.0) {
            this.buyPrice = Math.max(minBuy, Math.min(buyPrice, maxBuy));
        }
        if (this.sellPrice > 0.0) {
            this.sellPrice = Math.max(minSell, Math.min(sellPrice, maxSell));
        }
        if (this.buyPrice > 0.0 && this.sellPrice > 0.0) {
            if (this.buyPrice < this.sellPrice + 0.01) {
                this.buyPrice = this.sellPrice + 0.01;
            }
            if (this.sellPrice > this.buyPrice - 0.01) {
                this.sellPrice = this.buyPrice - 0.01;
            }
        }
        this.minBuy = minBuy;
        this.maxBuy = maxBuy;
        this.minSell = minSell;
        this.maxSell = maxSell;
        this.growthBuy = growthBuy;
        this.decayBuy = decayBuy;
        this.growthSell = growthSell;
        this.decaySell = decaySell;
        this.stock = stock;
        this.minStock = minStock;
        this.maxStock = maxStock;
        this.stockBuyModifier = stockBuyModifier;
        this.stockSellModifier = stockSellModifier;
        this.typeDynaShop = DynaShopType.UNKNOWN;
        this.buyTypeDynaShop = DynaShopType.UNKNOWN;
        this.sellTypeDynaShop = DynaShopType.UNKNOWN;
    }

    public DynamicPrice(double buyPrice, double sellPrice) {
        this(buyPrice, sellPrice, 0.0, Double.MAX_VALUE, 0.0, Double.MAX_VALUE, 1.0, 1.0, 1.0, 1.0, 0, 0, Integer.MAX_VALUE, 1.0, 1.0);
    }

    public DynamicPrice(double buyPrice, double sellPrice, int stock) {
        this(buyPrice, sellPrice, 0.0, Double.MAX_VALUE, 0.0, Double.MAX_VALUE, 1.0, 1.0, 1.0, 1.0, stock, 0, Integer.MAX_VALUE, 1.0, 1.0);
    }

    public DynamicPrice clone() {
        try {
            return (DynamicPrice)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Erreur lors du clonage de DynamicPrice", e);
        }
    }

    public void applyDecay(int amount) {
        if (this.buyPrice > 0.0) {
            this.buyPrice = Math.max(this.minBuy, Math.min(this.buyPrice * Math.pow(this.decayBuy, amount), this.maxBuy));
        }
        if (this.sellPrice > 0.0) {
            this.sellPrice = Math.min(this.maxSell, Math.max(this.sellPrice * Math.pow(this.decaySell, amount), this.minSell));
        }
        if (this.buyPrice > 0.0 && this.sellPrice > 0.0) {
            if (this.sellPrice > this.buyPrice - 0.01) {
                this.sellPrice = this.buyPrice - 0.01;
            }
            if (this.buyPrice < this.sellPrice + 0.01) {
                this.buyPrice = this.sellPrice + 0.01;
            }
        }
    }

    public void applyGrowth(int amount) {
        if (this.buyPrice > 0.0) {
            this.buyPrice = Math.min(this.maxBuy, Math.max(this.buyPrice * Math.pow(this.growthBuy, amount), this.minBuy));
        }
        if (this.sellPrice > 0.0) {
            this.sellPrice = Math.max(this.minSell, Math.min(this.sellPrice * Math.pow(this.growthSell, amount), this.maxSell));
        }
        if (this.buyPrice > 0.0 && this.sellPrice > 0.0) {
            if (this.buyPrice < this.sellPrice + 0.01) {
                this.buyPrice = this.sellPrice + 0.01;
            }
            if (this.sellPrice > this.buyPrice - 0.01) {
                this.sellPrice = this.buyPrice - 0.01;
            }
        }
    }

    public void applyBuyPriceChanges() {
        if (this.buyPrice > 0.0) {
            this.buyPrice *= DynaShopPlugin.getInstance().getDataConfig().getPriceDecrease();
            this.buyPrice = Math.max(this.minBuy, Math.min(this.buyPrice, this.maxBuy));
        }
    }

    public void applySellPriceChanges() {
        if (this.sellPrice > 0.0) {
            this.sellPrice *= DynaShopPlugin.getInstance().getDataConfig().getPriceIncrease();
            this.sellPrice = Math.max(this.minSell, Math.min(this.sellPrice, this.maxSell));
        }
    }

    public void setBuyPrice(double buyPrice) {
        this.buyPrice = Math.max(this.minBuy, Math.min(buyPrice, this.maxBuy));
    }

    public void setSellPrice(double sellPrice) {
        this.sellPrice = Math.max(this.minSell, Math.min(sellPrice, this.maxSell));
    }

    public void setMinBuyPrice(double minBuy) {
        this.minBuy = minBuy;
    }

    public void setMaxBuyPrice(double maxBuy) {
        this.maxBuy = maxBuy;
    }

    public void setMinSellPrice(double minSell) {
        this.minSell = minSell;
    }

    public void setMaxSellPrice(double maxSell) {
        this.maxSell = maxSell;
    }

    public void setGrowthBuy(double growthBuy) {
        if (growthBuy <= 0.0) {
            throw new IllegalArgumentException("Le facteur de croissance d'achat doit \u00eatre positif");
        }
        this.growthBuy = growthBuy;
    }

    public void setDecayBuy(double decayBuy) {
        if (decayBuy <= 0.0) {
            throw new IllegalArgumentException("Le facteur de d\u00e9croissance d'achat doit \u00eatre positif");
        }
        this.decayBuy = decayBuy;
    }

    public void setGrowthSell(double growthSell) {
        if (growthSell <= 0.0) {
            throw new IllegalArgumentException("Le facteur de croissance de vente doit \u00eatre positif");
        }
        this.growthSell = growthSell;
    }

    public void setDecaySell(double decaySell) {
        if (decaySell <= 0.0) {
            throw new IllegalArgumentException("Le facteur de d\u00e9croissance de vente doit \u00eatre positif");
        }
        this.decaySell = decaySell;
    }

    public double getBuyPrice() {
        return this.buyPrice;
    }

    public double getBuyPriceForAmount(int amount) {
        return this.buyPrice * (double)amount;
    }

    public double getSellPrice() {
        return this.sellPrice;
    }

    public double getSellPriceForAmount(int amount) {
        return this.sellPrice * (double)amount;
    }

    public double getMinBuyPrice() {
        return this.minBuy;
    }

    public double getMaxBuyPrice() {
        return this.maxBuy;
    }

    public double getMinSellPrice() {
        return this.minSell;
    }

    public double getMaxSellPrice() {
        return this.maxSell;
    }

    public double getGrowthBuy() {
        return this.growthBuy;
    }

    public double getDecayBuy() {
        return this.decayBuy;
    }

    public double getGrowthSell() {
        return this.growthSell;
    }

    public double getDecaySell() {
        return this.decaySell;
    }

    public boolean isValid() {
        return this.buyPrice >= this.minBuy && this.buyPrice <= this.maxBuy && this.sellPrice >= this.minSell && this.sellPrice <= this.maxSell;
    }

    public int getStock() {
        return this.stock;
    }

    public void setStock(int stock) {
        this.stock = stock;
    }

    public void incrementStock(int amount) {
        this.stock = Math.min(this.stock + amount, this.maxStock);
    }

    public void decrementStock(int amount) {
        this.stock = Math.max(this.stock - amount, this.minStock);
    }

    public int getMinStock() {
        return this.minStock;
    }

    public int getMaxStock() {
        return this.maxStock;
    }

    public double getStockBuyModifier() {
        return this.stockBuyModifier;
    }

    public double getStockSellModifier() {
        return this.stockSellModifier;
    }

    public void adjustPricesBasedOnStock() {
        double stockRatio = Math.max(0.0, Math.min(1.0, (double)(this.stock - this.minStock) / (double)(this.maxStock - this.minStock)));
        if (this.buyPrice > 0.0) {
            this.buyPrice = this.maxBuy - (this.maxBuy - this.minBuy) * stockRatio * this.stockBuyModifier;
        }
        if (this.sellPrice > 0.0) {
            this.sellPrice = this.maxSell - (this.maxSell - this.minSell) * stockRatio * this.stockSellModifier;
        }
        if (this.buyPrice > 0.0 && this.sellPrice > 0.0) {
            if (this.buyPrice < this.sellPrice + 0.01) {
                this.buyPrice = this.sellPrice + 0.01;
            }
            if (this.sellPrice > this.buyPrice - 0.01) {
                this.sellPrice = this.buyPrice - 0.01;
            }
        }
    }

    public void increaseStock(int amount) {
        this.incrementStock(amount);
        this.adjustPricesBasedOnStock();
    }

    public void decreaseStock(int amount) {
        this.decrementStock(amount);
        this.adjustPricesBasedOnStock();
    }

    public DynamicPrice applyModifiers(double buyModifier, double sellModifier) {
        if (this.buyPrice > 0.0) {
            this.buyPrice *= buyModifier;
            this.minBuy *= buyModifier;
            this.maxBuy *= buyModifier;
        }
        if (this.sellPrice > 0.0) {
            this.sellPrice *= sellModifier;
            this.minSell *= sellModifier;
            this.maxSell *= sellModifier;
        }
        return this;
    }

    public DynamicPrice applyShopGuiPlusModifiers(Player player, String shopID, String itemID) {
        try {
            Shop shop = ShopGuiPlusApi.getShop((String)shopID);
            if (shop == null) {
                return this;
            }
            ShopItem shopItem = shop.getShopItem(itemID);
            if (shopItem == null) {
                return this;
            }
            PriceModifier buyModifier = ShopGuiPlusApi.getPriceModifier((Player)player, (ShopItem)shopItem, (PriceModifierActionType)PriceModifierActionType.BUY);
            PriceModifier sellModifier = ShopGuiPlusApi.getPriceModifier((Player)player, (ShopItem)shopItem, (PriceModifierActionType)PriceModifierActionType.SELL);
            if (buyModifier.getModifier() == 1.0 && sellModifier.getModifier() == 1.0) {
                return this;
            }
            this.applyModifiers(buyModifier.getModifier(), sellModifier.getModifier());
        }
        catch (Exception e) {
            DynaShopPlugin.getInstance().getLogger().warning("Error applying price modifiers: " + e.getMessage());
        }
        return this;
    }

    public DynaShopType getDynaShopType() {
        return this.typeDynaShop;
    }

    public void setDynaShopType(DynaShopType typeDynaShop) {
        this.typeDynaShop = typeDynaShop;
    }

    public DynaShopType getBuyTypeDynaShop() {
        if (this.buyTypeDynaShop == DynaShopType.UNKNOWN) {
            return this.typeDynaShop != null ? this.typeDynaShop : DynaShopType.NONE;
        }
        return this.buyTypeDynaShop;
    }

    public DynaShopType getSellTypeDynaShop() {
        if (this.sellTypeDynaShop == DynaShopType.UNKNOWN) {
            return this.typeDynaShop != null ? this.typeDynaShop : DynaShopType.NONE;
        }
        return this.sellTypeDynaShop;
    }

    public void setBuyTypeDynaShop(DynaShopType type) {
        this.buyTypeDynaShop = type;
    }

    public void setSellTypeDynaShop(DynaShopType type) {
        this.sellTypeDynaShop = type;
    }

    public DynamicPrice applyInflation(String shopID, String itemID) {
        InflationManager inflationManager = DynaShopPlugin.getInstance().getInflationManager();
        if (inflationManager != null && inflationManager.isEnabled()) {
            if (this.buyPrice > 0.0) {
                this.buyPrice = inflationManager.applyInflationToPrice(shopID, itemID, this.buyPrice);
                this.minBuy = inflationManager.applyInflationToPrice(shopID, itemID, this.minBuy);
                this.maxBuy = inflationManager.applyInflationToPrice(shopID, itemID, this.maxBuy);
            }
            if (this.sellPrice > 0.0) {
                this.sellPrice = inflationManager.applyInflationToPrice(shopID, itemID, this.sellPrice);
                this.minSell = inflationManager.applyInflationToPrice(shopID, itemID, this.minSell);
                this.maxSell = inflationManager.applyInflationToPrice(shopID, itemID, this.maxSell);
            }
        }
        return this;
    }
}

