/*
 * Decompiled with CFR 0.152.
 */
package fr.tylwen.satyria.dynashop.price;

import fr.tylwen.satyria.dynashop.DynaShopPlugin;
import fr.tylwen.satyria.dynashop.data.cache.CacheManager;
import fr.tylwen.satyria.dynashop.data.param.DynaShopType;
import fr.tylwen.satyria.dynashop.data.param.RecipeType;
import fr.tylwen.satyria.dynashop.price.DynamicPrice;
import fr.tylwen.satyria.dynashop.utils.PrioritizedRunnable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import net.brcdev.shopgui.ShopGuiPlusApi;
import net.brcdev.shopgui.shop.Shop;
import net.brcdev.shopgui.shop.item.ShopItem;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Consumer;

public class PriceRecipe {
    private final DynaShopPlugin plugin;
    private final FileConfiguration config;
    private final ExecutorService highPriorityExecutor;
    private final Map<String, Integer> itemAccessCounter = new ConcurrentHashMap<String, Integer>();
    private final List<String> popularItems = new ArrayList<String>();
    private static final int POPULAR_THRESHOLD = 10;
    private final ExecutorService recipeExecutor;
    private final CacheManager<String, List<ItemStack>> recipeCache;
    private final Map<String, Map<Integer, Double>> enchantMultipliers = new HashMap<String, Map<Integer, Double>>();

    public PriceRecipe(DynaShopPlugin plugin) {
        this.plugin = plugin;
        this.config = plugin.getConfig();
        this.recipeCache = plugin.getRecipeCache();
        ThreadFactory recipeThreadFactory = r -> {
            Thread thread = new Thread(r, "Recipe-Calculator");
            thread.setDaemon(true);
            return thread;
        };
        this.recipeExecutor = new ThreadPoolExecutor(2, 4, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), recipeThreadFactory, new ThreadPoolExecutor.CallerRunsPolicy());
        ThreadFactory priorityThreadFactory = r -> {
            Thread thread = new Thread(r, "High-Priority-Calculator");
            thread.setDaemon(true);
            thread.setPriority(10);
            return thread;
        };
        this.highPriorityExecutor = new ThreadPoolExecutor(1, 2, 60L, TimeUnit.SECONDS, new PriorityBlockingQueue<Runnable>(10, Comparator.comparing(r -> ((PrioritizedRunnable)r).getPriority())), priorityThreadFactory);
        this.loadEnchantMultipliers();
        this.loadPopularItems();
    }

    public RecipeCalculationResult calculateRecipeValues(String shopID, String itemID, Set<String> visitedItems, Map<String, DynamicPrice> lastResults) {
        int finalStock;
        double finalMaxSellPrice;
        List<ItemStack> ingredients = this.getIngredients(shopID, itemID);
        ingredients = this.consolidateIngredients(ingredients);
        double basePrice = 0.0;
        double baseSellPrice = 0.0;
        double baseMinBuyPrice = 0.0;
        double baseMaxBuyPrice = 0.0;
        double baseMinSellPrice = 0.0;
        double baseMaxSellPrice = 0.0;
        int minAvailableStock = Integer.MAX_VALUE;
        int totalMinStock = 0;
        int totalMaxStock = 0;
        boolean allBuyPricesNegative = true;
        boolean allSellPricesNegative = true;
        for (ItemStack ingredient : ingredients) {
            if (ingredient == null || ingredient.getType() == Material.AIR) {
                this.plugin.getLogger().warning("Ingr\u00e9dient null ou vide : " + String.valueOf(ingredient));
                continue;
            }
            FoundItem foundItem = this.findItemInShops(shopID, ingredient);
            if (!foundItem.isFound()) {
                this.plugin.getLogger().warning("Missing ID or ShopID for ingredient " + String.valueOf(ingredient));
                continue;
            }
            String ingredientID = foundItem.getItemID();
            String ingredientShopID = foundItem.getShopID();
            DynamicPrice ingredientPrice = null;
            ingredientPrice = this.plugin.getDynaShopListener().getOrLoadPriceInternal(null, ingredientShopID, ingredientID, ingredient, visitedItems, lastResults, false);
            if (ingredientPrice == null) {
                this.plugin.getLogger().warning("Price not found for ingredient " + ingredientID + " in shop " + ingredientShopID);
                continue;
            }
            double ingredientBuyPrice = ingredientPrice.getBuyPrice();
            double ingredientSellPrice = ingredientPrice.getSellPrice();
            double ingredientMinBuyPrice = ingredientPrice.getMinBuyPrice();
            double ingredientMaxBuyPrice = ingredientPrice.getMaxBuyPrice();
            double ingredientMinSellPrice = ingredientPrice.getMinSellPrice();
            double ingredientMaxSellPrice = ingredientPrice.getMaxSellPrice();
            int ingredientStock = ingredientPrice.getStock();
            int ingredientMinStock = ingredientPrice.getMinStock();
            int ingredientMaxStock = ingredientPrice.getMaxStock();
            int amount = ingredient.getAmount();
            if (ingredientBuyPrice >= 0.0) {
                basePrice += ingredientBuyPrice * (double)amount;
                baseMinBuyPrice += ingredientMinBuyPrice * (double)amount;
                baseMaxBuyPrice += ingredientMaxBuyPrice * (double)amount;
                allBuyPricesNegative = false;
            }
            if (ingredientSellPrice >= 0.0) {
                baseSellPrice += ingredientSellPrice * (double)amount;
                baseMinSellPrice += ingredientMinSellPrice * (double)amount;
                baseMaxSellPrice += ingredientMaxSellPrice * (double)amount;
                allSellPricesNegative = false;
            }
            int availableForCrafting = ingredientStock / amount;
            minAvailableStock = Math.min(minAvailableStock, availableForCrafting);
            int minAvailableForCrafting = ingredientMinStock / amount;
            totalMinStock += minAvailableForCrafting;
            int maxAvailableForCrafting = ingredientMaxStock / amount;
            totalMaxStock += maxAvailableForCrafting;
            if (minAvailableStock != 0) continue;
            break;
        }
        int outputAmount = this.getRecipeOutputAmount(shopID, itemID);
        double modifier = this.getRecipeModifier(shopID, itemID);
        double finalBuyPrice = allBuyPricesNegative ? -1.0 : basePrice * modifier / (double)outputAmount;
        double finalSellPrice = allSellPricesNegative ? -1.0 : baseSellPrice * modifier / (double)outputAmount;
        double finalMinBuyPrice = allBuyPricesNegative ? -1.0 : baseMinBuyPrice * modifier / (double)outputAmount;
        double finalMaxBuyPrice = allBuyPricesNegative ? -1.0 : baseMaxBuyPrice * modifier / (double)outputAmount;
        double finalMinSellPrice = allSellPricesNegative ? -1.0 : baseMinSellPrice * modifier / (double)outputAmount;
        double d = finalMaxSellPrice = allSellPricesNegative ? -1.0 : baseMaxSellPrice * modifier / (double)outputAmount;
        if (finalBuyPrice >= 0.0 && finalSellPrice >= 0.0 && finalSellPrice > finalBuyPrice - 0.01) {
            finalSellPrice = finalBuyPrice - 0.01;
        }
        if (finalBuyPrice >= 0.0) {
            finalBuyPrice = Math.max(finalMinBuyPrice, Math.min(finalBuyPrice, finalMaxBuyPrice));
        }
        if (finalSellPrice >= 0.0) {
            finalSellPrice = Math.max(finalMinSellPrice, Math.min(finalSellPrice, finalMaxSellPrice));
        }
        int n = finalStock = minAvailableStock == Integer.MAX_VALUE ? 0 : minAvailableStock * outputAmount;
        if (minAvailableStock == Integer.MAX_VALUE) {
            totalMinStock = 0;
            totalMaxStock = 0;
        }
        if (totalMaxStock < totalMinStock) {
            totalMaxStock = totalMinStock;
        }
        CacheManager<String, Double> priceCache = this.plugin.getCalculatedPriceCache();
        CacheManager<String, Integer> stockCache = this.plugin.getStockCache();
        priceCache.put(shopID + ":" + itemID + ":buyPrice", finalBuyPrice);
        priceCache.put(shopID + ":" + itemID + ":sellPrice", finalSellPrice);
        priceCache.put(shopID + ":" + itemID + ":buyDynamic.min", finalMinBuyPrice);
        priceCache.put(shopID + ":" + itemID + ":buyDynamic.max", finalMaxBuyPrice);
        priceCache.put(shopID + ":" + itemID + ":sellDynamic.min", finalMinSellPrice);
        priceCache.put(shopID + ":" + itemID + ":sellDynamic.max", finalMaxSellPrice);
        stockCache.put(shopID + ":" + itemID + ":stock", finalStock);
        stockCache.put(shopID + ":" + itemID + ":minstock", totalMinStock);
        stockCache.put(shopID + ":" + itemID + ":maxstock", totalMaxStock);
        return new RecipeCalculationResult(this, finalBuyPrice, finalSellPrice, finalMinBuyPrice, finalMaxBuyPrice, finalMinSellPrice, finalMaxSellPrice, finalStock, totalMinStock, totalMaxStock);
    }

    public DynamicPrice createRecipePrice(String shopID, String itemID, Set<String> visitedItems, Map<String, DynamicPrice> lastResults) {
        RecipeCalculationResult result = this.calculateRecipeValues(shopID, itemID, visitedItems, lastResults);
        DynamicPrice recipePrice = new DynamicPrice(result.getBuyPrice(), result.getSellPrice(), result.getMinBuyPrice(), result.getMaxBuyPrice(), result.getMinSellPrice(), result.getMaxSellPrice(), 1.0, 1.0, 1.0, 1.0, result.getStock(), result.getMinStock(), result.getMaxStock(), 1.0, 1.0);
        recipePrice.setDynaShopType(DynaShopType.RECIPE);
        return recipePrice;
    }

    public void calculateRecipeValuesAsync(String shopID, String itemID, ItemStack item, Consumer<RecipeCalculationResult> callback) {
        int priority = this.isPopularItem(shopID, itemID) ? 10 : 1;
        ExecutorService executor = priority > 5 ? this.highPriorityExecutor : this.recipeExecutor;
        Runnable calculationTask = () -> {
            try {
                RecipeCalculationResult result = this.calculateRecipeValues(shopID, itemID, new HashSet<String>(), new HashMap<String, DynamicPrice>());
                Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                    try {
                        callback.accept((Object)result);
                    }
                    catch (Exception e) {
                        this.plugin.getLogger().warning("Error in calculation callback: " + e.getMessage());
                    }
                });
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Error calculating values for " + shopID + ":" + itemID + ": " + e.getMessage());
                if (e instanceof IllegalStateException || e.getCause() instanceof IllegalStateException) {
                    Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)this.plugin, () -> this.retryCalculation(shopID, itemID, item, callback), 10L);
                }
                Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> callback.accept((Object)new RecipeCalculationResult(this, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1, -1, -1)));
            }
        };
        if (executor == this.highPriorityExecutor) {
            executor.submit(new PrioritizedRunnable(calculationTask, priority));
        } else {
            executor.submit(calculationTask);
        }
    }

    public void batchCalculateRecipes(List<RecipeRequest> requests, Consumer<Map<String, RecipeCalculationResult>> callback) {
        ConcurrentHashMap results = new ConcurrentHashMap();
        AtomicInteger counter = new AtomicInteger(requests.size());
        for (RecipeRequest request : requests) {
            this.calculateRecipeValuesAsync(request.getShopID(), request.getItemID(), request.getItem(), (Consumer<RecipeCalculationResult>)((Consumer)result -> {
                results.put(request.getShopID() + ":" + request.getItemID(), result);
                if (counter.decrementAndGet() == 0) {
                    callback.accept((Object)results);
                }
            }));
        }
    }

    private void retryCalculation(String shopID, String itemID, ItemStack item, Consumer<RecipeCalculationResult> callback) {
        try {
            RecipeCalculationResult result = this.calculateRecipeValues(shopID, itemID, new HashSet<String>(), new HashMap<String, DynamicPrice>());
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> callback.accept((Object)result));
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Retry failed for " + shopID + ":" + itemID + ": " + e.getMessage());
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> callback.accept((Object)new RecipeCalculationResult(this, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1, -1, -1)));
        }
    }

    public void shutdown() {
        this.recipeExecutor.shutdown();
        this.highPriorityExecutor.shutdown();
        try {
            if (!this.recipeExecutor.awaitTermination(500L, TimeUnit.MILLISECONDS)) {
                this.recipeExecutor.shutdownNow();
            }
            if (!this.highPriorityExecutor.awaitTermination(500L, TimeUnit.MILLISECONDS)) {
                this.highPriorityExecutor.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            this.recipeExecutor.shutdownNow();
            this.highPriorityExecutor.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    public double calculatePrice(String shopID, String itemID, ItemStack item, String typePrice, Set<String> visitedItems) {
        List<ItemStack> ingredients = this.getIngredients(shopID, itemID);
        ingredients = this.consolidateIngredients(ingredients);
        double basePrice = 0.0;
        HashMap<String, DynamicPrice> lastResults = new HashMap<String, DynamicPrice>();
        for (ItemStack ingredient : ingredients) {
            DynamicPrice ingredientPrice;
            if (ingredient == null || ingredient.getType() == Material.AIR || (ingredientPrice = this.getIngredientPrice(shopID, ingredient, visitedItems, lastResults)) == null) continue;
            basePrice += (switch (typePrice) {
                case "buyPrice" -> ingredientPrice.getBuyPrice();
                case "sellPrice" -> ingredientPrice.getSellPrice();
                case "buyDynamic.min" -> ingredientPrice.getMinBuyPrice();
                case "buyDynamic.max" -> ingredientPrice.getMaxBuyPrice();
                case "sellDynamic.min" -> ingredientPrice.getMinSellPrice();
                case "sellDynamic.max" -> ingredientPrice.getMaxSellPrice();
                default -> -1.0;
            }) * (double)ingredient.getAmount();
        }
        int outputAmount = this.getRecipeOutputAmount(shopID, itemID);
        double modifier = this.getRecipeModifier(shopID, itemID);
        return basePrice * modifier / (double)outputAmount;
    }

    public int calculateStock(String shopID, String itemID, List<String> visitedItems) {
        List<ItemStack> ingredients = this.getIngredients(shopID, itemID);
        ingredients = this.consolidateIngredients(ingredients);
        int minAvailableStock = Integer.MAX_VALUE;
        for (ItemStack ingredient : ingredients) {
            int availableForCrafting;
            int ingredientStock;
            if (ingredient == null || ingredient.getType() == Material.AIR) continue;
            ArrayList<String> newVisitedItems = new ArrayList<String>(visitedItems);
            FoundItem foundItem = this.findItemInShops(shopID, ingredient);
            if (!foundItem.isFound()) continue;
            String ingredientID = foundItem.getItemID();
            String ingredientShopID = foundItem.getShopID();
            DynaShopType ingredientType = this.plugin.getShopConfigManager().getTypeDynaShop(ingredientShopID, ingredientID);
            if (ingredientType != DynaShopType.STOCK && ingredientType != DynaShopType.STATIC_STOCK || (ingredientStock = this.getIngredientStock(shopID, ingredient, newVisitedItems)) < 0 || (minAvailableStock = Math.min(minAvailableStock, availableForCrafting = ingredientStock / ingredient.getAmount())) != 0) continue;
            break;
        }
        return minAvailableStock == Integer.MAX_VALUE ? 0 : minAvailableStock;
    }

    public void calculateStockAsync(String shopID, String itemID, Consumer<Integer> callback) {
        CompletableFuture.supplyAsync(() -> {
            try {
                ArrayList<String> visitedItems = new ArrayList<String>();
                return this.calculateStock(shopID, itemID, visitedItems);
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Error calculating stock for " + shopID + ":" + itemID + ": " + e.getMessage());
                return 0;
            }
        }, this.recipeExecutor).thenAcceptAsync(stock -> Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
            try {
                callback.accept(stock);
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Error in stock callback: " + e.getMessage());
            }
        }));
    }

    public int calculateMaxStock(String shopID, String itemID, List<String> visitedItems) {
        List<ItemStack> ingredients = this.getIngredients(shopID, itemID);
        ingredients = this.consolidateIngredients(ingredients);
        int maxStock = 0;
        for (ItemStack ingredient : ingredients) {
            int ingredientMaxStock;
            FoundItem foundItem;
            if (ingredient == null || ingredient.getType() == Material.AIR || !(foundItem = this.findItemInShops(shopID, ingredient)).isFound()) continue;
            String ingredientID = foundItem.getItemID();
            String ingredientShopID = foundItem.getShopID();
            DynaShopType ingredientType = this.plugin.getShopConfigManager().getTypeDynaShop(ingredientShopID, ingredientID);
            if (ingredientType != DynaShopType.STOCK && ingredientType != DynaShopType.STATIC_STOCK || (ingredientMaxStock = this.getIngredientMaxStock(shopID, ingredient, visitedItems)) < 0) continue;
            int availableMaxStock = ingredientMaxStock / ingredient.getAmount();
            maxStock += availableMaxStock;
        }
        return maxStock;
    }

    public void calculatePriceAsync(String shopID, String itemID, ItemStack item, String typePrice, Consumer<Double> callback) {
        boolean isHighPriority = this.isPopularItem(shopID, itemID);
        Supplier<Double> priceCalculator = () -> {
            try {
                HashSet<String> visitedItems = new HashSet<String>();
                return this.calculatePrice(shopID, itemID, item, typePrice, visitedItems);
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Error calculating price for " + shopID + ":" + itemID + ": " + e.getMessage());
                return -1.0;
            }
        };
        ExecutorService executor = isHighPriority ? this.highPriorityExecutor : this.recipeExecutor;
        CompletableFuture.supplyAsync(priceCalculator, executor).thenAcceptAsync(price -> Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
            try {
                callback.accept(price);
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Error in price callback: " + e.getMessage());
            }
        }));
    }

    public List<ItemStack> getIngredients(String shopID, String itemID) {
        String cacheKey = shopID + ":" + itemID;
        List cached = this.recipeCache.get(cacheKey, () -> null);
        if (cached != null) {
            ArrayList<ItemStack> clones = new ArrayList<ItemStack>(cached.size());
            for (ItemStack item : cached) {
                clones.add(item == null ? null : item.clone());
            }
            return clones;
        }
        List<ItemStack> ingredients = new ArrayList<ItemStack>();
        ConfigurationSection recipeSection = this.plugin.getShopConfigManager().getSection(shopID, itemID, "recipe");
        if (recipeSection == null) {
            return ingredients;
        }
        RecipeType typeRecipe = RecipeType.fromString(recipeSection.getString("type", "NONE").toUpperCase());
        ingredients = this.loadIngredientsByType(recipeSection, typeRecipe);
        ArrayList<ItemStack> cacheCopy = new ArrayList<ItemStack>(ingredients.size());
        for (ItemStack item : ingredients) {
            cacheCopy.add(item == null ? null : item.clone());
        }
        this.recipeCache.put(cacheKey, cacheCopy);
        ArrayList<ItemStack> result = new ArrayList<ItemStack>(ingredients.size());
        for (ItemStack item : ingredients) {
            result.add(item == null ? null : item.clone());
        }
        return result;
    }

    private List<ItemStack> loadIngredientsByType(ConfigurationSection recipeSection, RecipeType typeRecipe) {
        switch (typeRecipe) {
            case SHAPED: {
                return this.loadShapedIngredients(recipeSection);
            }
            case SHAPELESS: {
                return this.loadShapelessIngredients(recipeSection);
            }
            case FURNACE: {
                return this.loadFurnaceIngredients(recipeSection);
            }
            case STONECUTTER: {
                return this.loadStonecutterIngredients(recipeSection);
            }
            case SMITHING: {
                return this.loadSmithingIngredients(recipeSection);
            }
        }
        this.plugin.getLogger().warning("Unsupported recipe type: " + String.valueOf((Object)typeRecipe));
        return new ArrayList<ItemStack>();
    }

    private List<ItemStack> loadShapedIngredients(ConfigurationSection recipeSection) {
        ArrayList<ItemStack> ingredients = new ArrayList<ItemStack>();
        Map<Character, Integer> symbolCounts = this.countSymbolsInPattern(recipeSection.getStringList("pattern"));
        List pattern = recipeSection.getStringList("pattern");
        HashSet<Character> patternChars = new HashSet<Character>();
        for (String row : pattern) {
            for (char c : row.toCharArray()) {
                if (c == ' ') continue;
                patternChars.add(Character.valueOf(c));
            }
        }
        ConfigurationSection ingredientsSection = recipeSection.getConfigurationSection("ingredients");
        if (ingredientsSection == null) {
            return ingredients;
        }
        for (Character c : patternChars) {
            if (ingredientsSection.contains(String.valueOf(c))) continue;
            this.plugin.getLogger().warning("Caract\u00e8re manquant dans les ingr\u00e9dients: " + c);
        }
        for (String key : ingredientsSection.getKeys(false)) {
            if (key.length() != 1) {
                this.plugin.getLogger().warning("Invalid ingredient key: " + key);
                continue;
            }
            char symbol = key.charAt(0);
            int occurrences = symbolCounts.getOrDefault(Character.valueOf(symbol), 0);
            if (occurrences == 0) {
                this.plugin.getLogger().warning("Symbol " + symbol + " not used in pattern");
                continue;
            }
            ItemStack ingredient = this.loadIngredientFromSection(ingredientsSection, key);
            if (ingredient == null) continue;
            ingredient.setAmount(ingredient.getAmount() * occurrences);
            ingredients.add(ingredient);
        }
        return ingredients;
    }

    private Map<Character, Integer> countSymbolsInPattern(List<String> pattern) {
        HashMap<Character, Integer> symbolCounts = new HashMap<Character, Integer>();
        for (String row : pattern) {
            for (char c : row.toCharArray()) {
                if (c == ' ') continue;
                symbolCounts.put(Character.valueOf(c), symbolCounts.getOrDefault(Character.valueOf(c), 0) + 1);
            }
        }
        return symbolCounts;
    }

    private List<ItemStack> loadShapelessIngredients(ConfigurationSection recipeSection) {
        ArrayList<ItemStack> ingredients = new ArrayList<ItemStack>();
        if (recipeSection.isList("ingredients")) {
            List list = recipeSection.getList("ingredients");
            for (Object item : list) {
                if (!(item instanceof String)) continue;
                String itemRef = (String)item;
                if (itemRef.contains(":")) {
                    ItemStack ingredient = this.loadShopItem(itemRef);
                    if (ingredient == null) continue;
                    ingredients.add(ingredient);
                    continue;
                }
                Material material = Material.matchMaterial((String)itemRef);
                if (material == null || material == Material.AIR) continue;
                ingredients.add(new ItemStack(material, 1));
            }
            return ingredients;
        }
        ConfigurationSection ingredientsSection = recipeSection.getConfigurationSection("ingredients");
        if (ingredientsSection == null) {
            return ingredients;
        }
        for (String key : ingredientsSection.getKeys(false)) {
            if (key.length() != 1) {
                this.plugin.getLogger().warning("Invalid ingredient key: " + key);
                continue;
            }
            ItemStack ingredient = this.loadIngredientFromSection(ingredientsSection, key);
            if (ingredient == null) continue;
            ingredients.add(ingredient);
        }
        return ingredients;
    }

    private List<ItemStack> loadFurnaceIngredients(ConfigurationSection recipeSection) {
        ArrayList<ItemStack> ingredients = new ArrayList<ItemStack>();
        if (recipeSection.isString("input")) {
            ItemStack ingredient;
            String itemRef = recipeSection.getString("input");
            if (itemRef != null && itemRef.contains(":") && (ingredient = this.loadShopItem(itemRef)) != null) {
                ingredients.add(ingredient);
            }
            return ingredients;
        }
        ConfigurationSection inputSection = recipeSection.getConfigurationSection("input");
        if (inputSection == null) {
            return ingredients;
        }
        ItemStack ingredient = this.loadIngredientFromSection(inputSection);
        if (ingredient != null) {
            ingredients.add(ingredient);
        }
        return ingredients;
    }

    private List<ItemStack> loadStonecutterIngredients(ConfigurationSection recipeSection) {
        ArrayList<ItemStack> ingredients = new ArrayList<ItemStack>();
        if (recipeSection.isString("input")) {
            ItemStack ingredient;
            String itemRef = recipeSection.getString("input");
            if (itemRef != null && itemRef.contains(":") && (ingredient = this.loadShopItem(itemRef)) != null) {
                ingredients.add(ingredient);
            }
            return ingredients;
        }
        ConfigurationSection inputSection = recipeSection.getConfigurationSection("input");
        if (inputSection == null) {
            return ingredients;
        }
        ItemStack ingredient = this.loadIngredientFromSection(inputSection);
        if (ingredient != null) {
            ingredients.add(ingredient);
        }
        return ingredients;
    }

    private List<ItemStack> loadSmithingIngredients(ConfigurationSection recipeSection) {
        String[] keys;
        ArrayList<ItemStack> ingredients = new ArrayList<ItemStack>();
        for (String key : keys = new String[]{"base", "addition", "material"}) {
            ConfigurationSection section;
            ItemStack ingredient;
            if (recipeSection.isString(key)) {
                String itemRef = recipeSection.getString(key);
                if (itemRef == null || !itemRef.contains(":") || (ingredient = this.loadShopItem(itemRef)) == null) continue;
                ingredients.add(ingredient);
                continue;
            }
            if (!recipeSection.isConfigurationSection(key) || (ingredient = this.loadIngredientFromSection(section = recipeSection.getConfigurationSection(key))) == null) continue;
            ingredients.add(ingredient);
        }
        return ingredients;
    }

    private ItemStack loadIngredientFromSection(ConfigurationSection ingredientsSection, String key) {
        if (ingredientsSection == null) {
            return null;
        }
        try {
            String itemRef;
            if (ingredientsSection.isString(key) && (itemRef = ingredientsSection.getString(key)) != null && itemRef.contains(":")) {
                return this.loadShopItem(itemRef);
            }
            ConfigurationSection section = ingredientsSection.getConfigurationSection(key);
            if (section != null) {
                String itemRef2 = section.getString("item");
                if (itemRef2 != null && itemRef2.contains(":")) {
                    return this.loadShopItem(itemRef2);
                }
                return this.loadMaterialItem(section);
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Error loading ingredient " + key + ": " + e.getMessage());
        }
        return null;
    }

    private ItemStack loadIngredientFromSection(ConfigurationSection section) {
        if (section == null) {
            return null;
        }
        try {
            String itemRef = section.getString("item");
            if (itemRef != null && itemRef.contains(":")) {
                return this.loadShopItem(itemRef);
            }
            return this.loadMaterialItem(section);
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Error loading ingredient: " + e.getMessage());
            return null;
        }
    }

    private ItemStack loadShopItem(String itemRef) {
        String itemID;
        String shopID;
        String[] parts = itemRef.split(":");
        int amount = 1;
        if (parts.length == 3) {
            shopID = parts[0];
            itemID = parts[1];
            try {
                amount = Integer.parseInt(parts[2]);
            }
            catch (NumberFormatException e) {
                amount = 1;
            }
        } else if (parts.length == 2) {
            shopID = parts[0];
            itemID = parts[1];
        } else {
            this.plugin.getLogger().warning("Invalid item reference format: " + itemRef);
            return null;
        }
        try {
            ItemStack item = ShopGuiPlusApi.getShop((String)shopID).getShopItem(itemID).getItem();
            if (item != null) {
                item.setAmount(amount);
                return item;
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Error loading ingredient " + itemRef + ": " + e.getMessage());
        }
        return null;
    }

    private ItemStack loadMaterialItem(ConfigurationSection section) {
        Material material = Material.matchMaterial((String)section.getString("material", "AIR"));
        if (material != null && material != Material.AIR) {
            ItemStack item = new ItemStack(material, 1);
            this.plugin.getLogger().info("Ingredient material found: " + String.valueOf(item));
            return item;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DynamicPrice getIngredientPrice(String shopID, ItemStack ingredient, Set<String> visitedItems, Map<String, DynamicPrice> lastResults) {
        FoundItem foundItem = this.findItemInShops(shopID, ingredient);
        if (!foundItem.isFound()) {
            this.plugin.getLogger().warning("Unable to find ingredient " + String.valueOf(ingredient) + " in shop " + shopID);
            return null;
        }
        String ingredientID = foundItem.getItemID();
        String ingredientShopID = foundItem.getShopID();
        String cycleKey = ingredientShopID + ":" + ingredientID;
        if (visitedItems.contains(cycleKey)) {
            DynamicPrice last = lastResults.get(cycleKey);
            if (last != null) {
                return last;
            }
            return null;
        }
        visitedItems.add(cycleKey);
        try {
            DynamicPrice price = this.plugin.getDynaShopListener().getOrLoadPrice(null, ingredientShopID, ingredientID, ingredient, visitedItems, lastResults);
            if (price != null) {
                lastResults.put(cycleKey, price);
            }
            DynamicPrice dynamicPrice = price;
            return dynamicPrice;
        }
        finally {
            visitedItems.remove(cycleKey);
        }
    }

    public List<ItemStack> consolidateIngredients(List<ItemStack> ingredients) {
        HashMap<String, ItemStack> uniqueItems = new HashMap<String, ItemStack>();
        HashMap<String, Integer> amounts = new HashMap<String, Integer>();
        for (ItemStack ingredient : ingredients) {
            if (ingredient == null || ingredient.getType() == Material.AIR) continue;
            String key = this.createItemKey(ingredient);
            amounts.put(key, amounts.getOrDefault(key, 0) + ingredient.getAmount());
            uniqueItems.computeIfAbsent(key, k -> ingredient.clone());
        }
        ArrayList<ItemStack> consolidated = new ArrayList<ItemStack>();
        for (Map.Entry entry : uniqueItems.entrySet()) {
            ItemStack item = (ItemStack)entry.getValue();
            item.setAmount(((Integer)amounts.get(entry.getKey())).intValue());
            consolidated.add(item);
        }
        return consolidated;
    }

    private String createItemKey(ItemStack item) {
        StringBuilder key = new StringBuilder(item.getType().toString());
        FoundItem found = this.findItemInShops(null, item);
        if (found != null && found.isFound()) {
            key.append(":").append(found.getShopID()).append(":").append(found.getItemID());
        }
        if (item.hasItemMeta()) {
            ItemMeta meta = item.getItemMeta();
            if (meta.hasDisplayName()) {
                key.append(":").append(meta.getDisplayName());
            }
            if (meta.hasCustomModelData()) {
                key.append(":").append(meta.getCustomModelData());
            }
        }
        return key.toString();
    }

    private double getRecipeModifier(String shopID, String itemID) {
        Optional<Double> customModifier = this.plugin.getShopConfigManager().getItemValue(shopID, itemID, "recipe.modifier", Double.class);
        if (customModifier.isPresent()) {
            return customModifier.get();
        }
        RecipeType recipeType = this.plugin.getShopConfigManager().getTypeRecipe(shopID, itemID);
        if (recipeType == RecipeType.SHAPED) {
            return this.plugin.getDataConfig().getShapedValue();
        }
        if (recipeType == RecipeType.SHAPELESS) {
            return this.plugin.getDataConfig().getShapelessValue();
        }
        if (recipeType == RecipeType.FURNACE) {
            return this.plugin.getDataConfig().getFurnaceValue();
        }
        if (recipeType == RecipeType.STONECUTTER) {
            return this.plugin.getDataConfig().getStonecutterValue();
        }
        if (recipeType == RecipeType.SMITHING) {
            return this.plugin.getDataConfig().getSmithingValue();
        }
        return 1.0;
    }

    private int getRecipeOutputAmount(String shopID, String itemID) {
        Optional<Integer> output = this.plugin.getShopConfigManager().getItemValue(shopID, itemID, "recipe.output", Integer.class);
        if (output.isPresent()) {
            return Math.max(1, output.get());
        }
        Optional<Integer> outputAmount = this.plugin.getShopConfigManager().getItemValue(shopID, itemID, "recipe.outputAmount", Integer.class);
        if (outputAmount.isPresent()) {
            return Math.max(1, outputAmount.get());
        }
        return 1;
    }

    public int getIngredientStock(String shopID, ItemStack ingredient, List<String> visitedItems) {
        FoundItem foundItem = this.findItemInShops(shopID, ingredient);
        if (!foundItem.isFound()) {
            this.plugin.getLogger().warning("Unable to find ingredient " + String.valueOf(ingredient) + " in shop " + shopID);
            return -1;
        }
        String ingredientID = foundItem.getItemID();
        String ingredientShopID = foundItem.getShopID();
        DynaShopType ingredientType = this.plugin.getShopConfigManager().getTypeDynaShop(ingredientShopID, ingredientID);
        if (ingredientType != DynaShopType.STOCK && ingredientType != DynaShopType.STATIC_STOCK) {
            return -1;
        }
        if (visitedItems.contains(ingredientID)) {
            return 0;
        }
        visitedItems.add(ingredientID);
        Optional<Integer> stockOptional = this.plugin.getStorageManager().getStock(ingredientShopID, ingredientID);
        if (stockOptional.isPresent()) {
            return stockOptional.get();
        }
        return 0;
    }

    public int getIngredientMaxStock(String shopID, ItemStack ingredient, List<String> visitedItems) {
        FoundItem foundItem = this.findItemInShops(shopID, ingredient);
        if (!foundItem.isFound()) {
            this.plugin.getLogger().warning("Unable to find ingredient " + String.valueOf(ingredient) + " in shop " + shopID);
            return -1;
        }
        String ingredientID = foundItem.getItemID();
        String ingredientShopID = foundItem.getShopID();
        DynaShopType ingredientType = this.plugin.getShopConfigManager().getTypeDynaShop(ingredientShopID, ingredientID);
        if (ingredientType != DynaShopType.STOCK && ingredientType != DynaShopType.STATIC_STOCK) {
            return Integer.MAX_VALUE;
        }
        if (visitedItems.contains(ingredientID)) {
            return 0;
        }
        visitedItems.add(ingredientID);
        Optional<Integer> maxStockOptional = this.plugin.getShopConfigManager().getItemValue(ingredientShopID, ingredientID, "stock.max", Integer.class);
        if (maxStockOptional.isPresent()) {
            return maxStockOptional.get();
        }
        return 0;
    }

    public DynaShopType getItemType(String shopID, String itemID) {
        return this.plugin.getShopConfigManager().getTypeDynaShop(shopID, itemID);
    }

    public DynaShopType getIngredientType(String shopID, ItemStack ingredient) {
        FoundItem foundItem = this.findItemInShops(shopID, ingredient);
        if (!foundItem.isFound()) {
            this.plugin.getLogger().warning("Unable to find ingredient " + String.valueOf(ingredient) + " in shop " + shopID);
            return DynaShopType.UNKNOWN;
        }
        String ingredientID = foundItem.getItemID();
        String ingredientShopID = foundItem.getShopID();
        return this.plugin.getShopConfigManager().getTypeDynaShop(ingredientShopID, ingredientID);
    }

    public boolean isPopularItem(String shopID, String itemID) {
        String key = shopID + ":" + itemID;
        if (this.popularItems.contains(key)) {
            return true;
        }
        int accessCount = this.itemAccessCounter.getOrDefault(key, 0);
        this.itemAccessCounter.put(key, accessCount + 1);
        if (accessCount + 1 >= 10 && !this.popularItems.contains(key)) {
            this.popularItems.add(key);
            return true;
        }
        return accessCount >= 10;
    }

    private void loadPopularItems() {
        List configPopularItems = this.config.getStringList("popular-items");
        if (configPopularItems != null && !configPopularItems.isEmpty()) {
            this.popularItems.addAll(configPopularItems);
        }
    }

    public FoundItem findItemInShops(String preferredShopID, ItemStack ingredient) {
        String itemID;
        String shopID;
        block6: {
            shopID = null;
            itemID = null;
            try {
                Shop shop = ShopGuiPlusApi.getShop((String)preferredShopID);
                if (shop != null) {
                    for (ShopItem shopItem : shop.getShopItems()) {
                        if (!this.customCompare(ingredient, shopItem.getItem())) continue;
                        itemID = shopItem.getId();
                        shopID = preferredShopID;
                        break;
                    }
                }
                if (itemID != null) break block6;
                for (Shop otherShop : ShopGuiPlusApi.getPlugin().getShopManager().getShops()) {
                    if (otherShop.getId().equals(preferredShopID)) continue;
                    for (ShopItem item : otherShop.getShopItems()) {
                        if (!this.customCompare(ingredient, item.getItem())) continue;
                        itemID = item.getId();
                        shopID = otherShop.getId();
                        break;
                    }
                    if (itemID == null) continue;
                    break;
                }
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Error searching for ingredient " + String.valueOf(ingredient) + ": " + e.getMessage());
            }
        }
        return new FoundItem(this, shopID, itemID, itemID != null && shopID != null);
    }

    public boolean customCompare(ItemStack item1, ItemStack item2) {
        boolean hasCustomModelData2;
        String name2;
        if (item1.getType() != item2.getType()) {
            return false;
        }
        String name1 = item1.hasItemMeta() && item1.getItemMeta().hasDisplayName() ? item1.getItemMeta().getDisplayName() : "";
        String string = name2 = item2.hasItemMeta() && item2.getItemMeta().hasDisplayName() ? item2.getItemMeta().getDisplayName() : "";
        if (!name1.equals(name2)) {
            return false;
        }
        if (!item1.getEnchantments().equals(item2.getEnchantments())) {
            return false;
        }
        boolean hasCustomModelData1 = item1.hasItemMeta() && item1.getItemMeta().hasCustomModelData();
        boolean bl = hasCustomModelData2 = item2.hasItemMeta() && item2.getItemMeta().hasCustomModelData();
        if (hasCustomModelData1 != hasCustomModelData2) {
            return false;
        }
        return !hasCustomModelData1 || !hasCustomModelData2 || item1.getItemMeta().getCustomModelData() == item2.getItemMeta().getCustomModelData();
    }

    private void loadEnchantMultipliers() {
        if (!this.config.isConfigurationSection("enchant_multipliers")) {
            return;
        }
        ConfigurationSection section = this.config.getConfigurationSection("enchant_multipliers");
        for (String enchantKey : section.getKeys(false)) {
            ConfigurationSection levels = section.getConfigurationSection(enchantKey);
            HashMap<Integer, Double> levelMap = new HashMap<Integer, Double>();
            for (String levelStr : levels.getKeys(false)) {
                double mult = levels.getDouble(levelStr, 1.0);
                levelMap.put(Integer.parseInt(levelStr), mult);
            }
            this.enchantMultipliers.put(enchantKey, levelMap);
        }
    }

    public double getEnchantMultiplier(ItemStack item) {
        if (!item.hasItemMeta() || !item.getItemMeta().hasEnchants()) {
            return 1.0;
        }
        double multiplier = 1.0;
        for (Map.Entry entry : item.getEnchantments().entrySet()) {
            Double mult;
            String enchKey = ((Enchantment)entry.getKey()).getKey().getKey().toUpperCase();
            int level = (Integer)entry.getValue();
            Map<Integer, Double> levelMap = this.enchantMultipliers.get(enchKey);
            if (levelMap == null || (mult = levelMap.get(level)) == null) continue;
            multiplier *= mult.doubleValue();
        }
        return multiplier;
    }

    public class FoundItem {
        private final String shopID;
        private final String itemID;
        private final boolean found;

        public FoundItem(PriceRecipe this$0, String shopID, String itemID, boolean found) {
            this.shopID = shopID;
            this.itemID = itemID;
            this.found = found;
        }

        public String getShopID() {
            return this.shopID;
        }

        public String getItemID() {
            return this.itemID;
        }

        public boolean isFound() {
            return this.found;
        }
    }

    public class RecipeCalculationResult {
        private double buyPrice;
        private double sellPrice;
        private double minBuyPrice;
        private double maxBuyPrice;
        private double minSellPrice;
        private double maxSellPrice;
        private int stock;
        private int minStock;
        private int maxStock;

        public RecipeCalculationResult(PriceRecipe this$0, double buyPrice, double sellPrice, double minBuyPrice, double maxBuyPrice, double minSellPrice, double maxSellPrice, int stock, int minStock, int maxStock) {
            this.buyPrice = buyPrice;
            this.sellPrice = sellPrice;
            this.minBuyPrice = minBuyPrice;
            this.maxBuyPrice = maxBuyPrice;
            this.minSellPrice = minSellPrice;
            this.maxSellPrice = maxSellPrice;
            this.stock = stock;
            this.minStock = minStock;
            this.maxStock = maxStock;
        }

        public double getBuyPrice() {
            return this.buyPrice;
        }

        public double getSellPrice() {
            return this.sellPrice;
        }

        public double getMinBuyPrice() {
            return this.minBuyPrice;
        }

        public double getMaxBuyPrice() {
            return this.maxBuyPrice;
        }

        public double getMinSellPrice() {
            return this.minSellPrice;
        }

        public double getMaxSellPrice() {
            return this.maxSellPrice;
        }

        public int getStock() {
            return this.stock;
        }

        public int getMinStock() {
            return this.minStock;
        }

        public int getMaxStock() {
            return this.maxStock;
        }
    }

    public static class RecipeRequest {
        private final String shopID;
        private final String itemID;
        private final ItemStack item;

        public RecipeRequest(String shopID, String itemID, ItemStack item) {
            this.shopID = shopID;
            this.itemID = itemID;
            this.item = item;
        }

        public String getShopID() {
            return this.shopID;
        }

        public String getItemID() {
            return this.itemID;
        }

        public ItemStack getItem() {
            return this.item;
        }
    }
}

