/*
 * Decompiled with CFR 0.152.
 */
package fr.tylwen.satyria.dynashop.price;

import fr.tylwen.satyria.dynashop.DynaShopPlugin;
import fr.tylwen.satyria.dynashop.config.DataConfig;
import fr.tylwen.satyria.dynashop.data.cache.CacheManager;
import fr.tylwen.satyria.dynashop.data.param.DynaShopType;
import fr.tylwen.satyria.dynashop.price.DynamicPrice;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class PriceStock {
    private final DynaShopPlugin plugin;
    private final DataConfig dataConfig;
    private final CacheManager<String, DynamicPrice> priceCache;
    private static final long CACHE_DURATION = 300000L;
    private final Map<String, Long> cacheTimestamps = new HashMap<String, Long>();

    public PriceStock(DynaShopPlugin plugin) {
        this.plugin = plugin;
        this.dataConfig = plugin.getDataConfig();
        this.priceCache = plugin.getPriceCache();
    }

    public double calculatePrice(String shopID, String itemID, String typePrice) {
        String cacheKey = shopID + ":" + itemID + ":" + typePrice;
        if (this.isCacheValid(cacheKey)) {
            return this.getCachedPrice(cacheKey, typePrice);
        }
        Optional<Integer> stockOptional = this.plugin.getStorageManager().getStock(shopID, itemID);
        int stock = stockOptional.orElse(0);
        int minStock = this.plugin.getShopConfigManager().getItemValue(shopID, itemID, "stock.min", Integer.class).orElse(this.dataConfig.getStockMin());
        int maxStock = this.plugin.getShopConfigManager().getItemValue(shopID, itemID, "stock.max", Integer.class).orElse(this.dataConfig.getStockMax());
        Optional<Double> basePrice = this.getBasePrice(shopID, itemID, typePrice);
        if (basePrice.isEmpty()) {
            return 0.0;
        }
        double minPrice = this.plugin.getShopConfigManager().getItemValue(shopID, itemID, typePrice.replace("Price", "Dynamic.min"), Double.class).orElse(basePrice.get() * 0.5);
        double maxPrice = this.plugin.getShopConfigManager().getItemValue(shopID, itemID, typePrice.replace("Price", "Dynamic.max"), Double.class).orElse(basePrice.get() * 2.0);
        double modifier = this.plugin.getShopConfigManager().getItemValue(shopID, itemID, "stock." + (typePrice.equals("buyPrice") ? "buyModifier" : "sellModifier"), Double.class).orElse(typePrice.equals("buyPrice") ? this.dataConfig.getStockBuyModifier() : this.dataConfig.getStockSellModifier());
        double stockRatio = Math.max(0.0, Math.min(1.0, (double)(stock - minStock) / (double)(maxStock - minStock)));
        double price = maxPrice - (maxPrice - minPrice) * stockRatio * modifier;
        this.cachePrice(cacheKey, price, typePrice);
        return price;
    }

    private Optional<Double> getBasePrice(String shopID, String itemID, String typePrice) {
        if (typePrice.equals("buyPrice")) {
            Optional<Double> price = this.plugin.getStorageManager().getBuyPrice(shopID, itemID);
            if (price.isPresent()) {
                return price;
            }
            return this.plugin.getShopConfigManager().getItemValue(shopID, itemID, "buyPrice", Double.class);
        }
        Optional<Double> price = this.plugin.getStorageManager().getSellPrice(shopID, itemID);
        if (price.isPresent()) {
            return price;
        }
        return this.plugin.getShopConfigManager().getItemValue(shopID, itemID, "sellPrice", Double.class);
    }

    public void processBuyTransaction(String shopID, String itemID, int amount) {
        this.decreaseStock(shopID, itemID, amount);
        DynaShopPlugin.getInstance().invalidatePriceCache(shopID, itemID, null);
    }

    public void processSellTransaction(String shopID, String itemID, int amount) {
        this.increaseStock(shopID, itemID, amount);
        DynaShopPlugin.getInstance().invalidatePriceCache(shopID, itemID, null);
    }

    public void decreaseStock(String shopID, String itemID, int amount) {
        String[] parts;
        String linkedItemRef;
        DynaShopType type = this.plugin.getShopConfigManager().getTypeDynaShop(shopID, itemID);
        if (type == DynaShopType.LINK && (linkedItemRef = (String)this.plugin.getShopConfigManager().getItemValue(shopID, itemID, "link", String.class).orElse(null)) != null && linkedItemRef.contains(":") && (parts = linkedItemRef.split(":")).length == 2) {
            this.decreaseStock(parts[0], parts[1], amount);
            return;
        }
        DynaShopType realType = this.plugin.getShopConfigManager().getRealTypeDynaShop(shopID, itemID, "buy");
        if (realType != DynaShopType.STOCK && realType != DynaShopType.STATIC_STOCK) {
            return;
        }
        Optional<Integer> currentStock = this.plugin.getStorageManager().getStock(shopID, itemID);
        int minStock = this.plugin.getShopConfigManager().getItemValue(shopID, itemID, "stock.min", Integer.class).orElse(this.dataConfig.getStockMin());
        int newStock = Math.max(currentStock.orElse(0) - amount, minStock);
        this.plugin.getStorageManager().saveStock(shopID, itemID, newStock);
        this.updatePricesInDatabase(shopID, itemID);
    }

    public void increaseStock(String shopID, String itemID, int amount) {
        String[] parts;
        String linkedItemRef;
        DynaShopType type = this.plugin.getShopConfigManager().getTypeDynaShop(shopID, itemID);
        if (type == DynaShopType.LINK && (linkedItemRef = (String)this.plugin.getShopConfigManager().getItemValue(shopID, itemID, "link", String.class).orElse(null)) != null && linkedItemRef.contains(":") && (parts = linkedItemRef.split(":")).length == 2) {
            this.increaseStock(parts[0], parts[1], amount);
            return;
        }
        DynaShopType realType = this.plugin.getShopConfigManager().getRealTypeDynaShop(shopID, itemID, "sell");
        if (realType != DynaShopType.STOCK && realType != DynaShopType.STATIC_STOCK) {
            return;
        }
        Optional<Integer> currentStock = this.plugin.getStorageManager().getStock(shopID, itemID);
        int maxStock = this.plugin.getShopConfigManager().getItemValue(shopID, itemID, "stock.max", Integer.class).orElse(this.dataConfig.getStockMax());
        int newStock = Math.min(currentStock.orElse(0) + amount, maxStock);
        this.plugin.getStorageManager().saveStock(shopID, itemID, newStock);
        this.updatePricesInDatabase(shopID, itemID);
    }

    private void updatePricesInDatabase(String shopID, String itemID) {
        double sellPrice;
        double buyPrice = this.calculatePrice(shopID, itemID, "buyPrice");
        if (buyPrice < (sellPrice = this.calculatePrice(shopID, itemID, "sellPrice")) + 0.01) {
            buyPrice = sellPrice + 0.01;
        }
        this.plugin.getBatchDatabaseUpdater().queuePriceUpdate(shopID, itemID, buyPrice, sellPrice);
    }

    public boolean canBuy(String shopID, String itemID, int amount) {
        String[] parts;
        String linkedItemRef;
        DynaShopType realType = this.plugin.getShopConfigManager().getRealTypeDynaShop(shopID, itemID, "buy");
        if (realType != DynaShopType.STOCK && realType != DynaShopType.STATIC_STOCK) {
            return true;
        }
        if (this.plugin.getShopConfigManager().getTypeDynaShop(shopID, itemID) == DynaShopType.LINK && (linkedItemRef = (String)this.plugin.getShopConfigManager().getItemValue(shopID, itemID, "link", String.class).orElse(null)) != null && linkedItemRef.contains(":") && (parts = linkedItemRef.split(":")).length == 2) {
            Optional<Integer> stockOptional = this.plugin.getStorageManager().getStock(parts[0], parts[1]);
            return stockOptional.map(stock -> stock >= amount).orElse(true);
        }
        Optional<Integer> stockOptional = this.plugin.getStorageManager().getStock(shopID, itemID);
        return stockOptional.map(stock -> stock >= amount).orElse(true);
    }

    public boolean canSell(String shopID, String itemID, int amount) {
        String[] parts;
        String linkedItemRef;
        DynaShopType realType = this.plugin.getShopConfigManager().getRealTypeDynaShop(shopID, itemID, "sell");
        if (realType != DynaShopType.STOCK && realType != DynaShopType.STATIC_STOCK) {
            return true;
        }
        if (this.plugin.getShopConfigManager().getTypeDynaShop(shopID, itemID) == DynaShopType.LINK && (linkedItemRef = (String)this.plugin.getShopConfigManager().getItemValue(shopID, itemID, "link", String.class).orElse(null)) != null && linkedItemRef.contains(":") && (parts = linkedItemRef.split(":")).length == 2) {
            Optional<Integer> stockOptional = this.plugin.getStorageManager().getStock(parts[0], parts[1]);
            return stockOptional.map(stock -> stock + amount <= this.plugin.getShopConfigManager().getItemValue(parts[0], parts[1], "stock.max", Integer.class).orElse(this.dataConfig.getStockMax())).orElse(true);
        }
        Optional<Integer> stockOptional = this.plugin.getStorageManager().getStock(shopID, itemID);
        int maxStock = this.plugin.getShopConfigManager().getItemValue(shopID, itemID, "stock.max", Integer.class).orElse(this.dataConfig.getStockMax());
        return stockOptional.map(stock -> stock + amount <= maxStock).orElse(true);
    }

    public DynamicPrice createStockPrice(String shopID, String itemID) {
        double buyPrice = this.calculatePrice(shopID, itemID, "buyPrice");
        double sellPrice = this.calculatePrice(shopID, itemID, "sellPrice");
        Optional<Integer> stockOptional = this.plugin.getStorageManager().getStock(shopID, itemID);
        int stock = stockOptional.orElse(0);
        int minStock = this.plugin.getShopConfigManager().getItemValue(shopID, itemID, "stock.min", Integer.class).orElse(this.dataConfig.getStockMin());
        int maxStock = this.plugin.getShopConfigManager().getItemValue(shopID, itemID, "stock.max", Integer.class).orElse(this.dataConfig.getStockMax());
        double minBuy = this.plugin.getShopConfigManager().getItemValue(shopID, itemID, "buyDynamic.min", Double.class).orElse(buyPrice * 0.5);
        double maxBuy = this.plugin.getShopConfigManager().getItemValue(shopID, itemID, "buyDynamic.max", Double.class).orElse(buyPrice * 2.0);
        double minSell = this.plugin.getShopConfigManager().getItemValue(shopID, itemID, "sellDynamic.min", Double.class).orElse(sellPrice * 0.5);
        double maxSell = this.plugin.getShopConfigManager().getItemValue(shopID, itemID, "sellDynamic.max", Double.class).orElse(sellPrice * 2.0);
        double stockBuyModifier = this.plugin.getShopConfigManager().getItemValue(shopID, itemID, "stock.buyModifier", Double.class).orElse(this.dataConfig.getStockBuyModifier());
        double stockSellModifier = this.plugin.getShopConfigManager().getItemValue(shopID, itemID, "stock.sellModifier", Double.class).orElse(this.dataConfig.getStockSellModifier());
        DynamicPrice price = new DynamicPrice(buyPrice, sellPrice, minBuy, maxBuy, minSell, maxSell, 1.0, 1.0, 1.0, 1.0, stock, minStock, maxStock, stockBuyModifier, stockSellModifier);
        price.setDynaShopType(DynaShopType.STOCK);
        return price;
    }

    public DynamicPrice createStaticStockPrice(String shopID, String itemID) {
        double buyPrice = this.plugin.getShopConfigManager().getItemValue(shopID, itemID, "buyPrice", Double.class).orElse(-1.0);
        double sellPrice = this.plugin.getShopConfigManager().getItemValue(shopID, itemID, "sellPrice", Double.class).orElse(-1.0);
        Optional<Integer> stockOptional = this.plugin.getStorageManager().getStock(shopID, itemID);
        int stock = stockOptional.orElse(0);
        int minStock = this.plugin.getShopConfigManager().getItemValue(shopID, itemID, "stock.min", Integer.class).orElse(this.dataConfig.getStockMin());
        int maxStock = this.plugin.getShopConfigManager().getItemValue(shopID, itemID, "stock.max", Integer.class).orElse(this.dataConfig.getStockMax());
        DynamicPrice price = new DynamicPrice(buyPrice, sellPrice, buyPrice, buyPrice, sellPrice, sellPrice, 1.0, 1.0, 1.0, 1.0, stock, minStock, maxStock, this.dataConfig.getStockBuyModifier(), this.dataConfig.getStockSellModifier());
        price.setDynaShopType(DynaShopType.STATIC_STOCK);
        return price;
    }

    private boolean isCacheValid(String key) {
        return this.cacheTimestamps.containsKey(key) && System.currentTimeMillis() - this.cacheTimestamps.get(key) < 300000L;
    }

    private double getCachedPrice(String key, String typePrice) {
        DynamicPrice cachedPrice = this.priceCache.get(key, () -> null);
        if (cachedPrice == null) {
            return 0.0;
        }
        return typePrice.equals("buyPrice") ? cachedPrice.getBuyPrice() : cachedPrice.getSellPrice();
    }

    private void cachePrice(String key, double price, String typePrice) {
        this.priceCache.get(key, () -> new DynamicPrice(0.0, 0.0));
        DynamicPrice dynamicPrice = this.priceCache.get(key, () -> new DynamicPrice(0.0, 0.0));
        if (typePrice.equals("buyPrice")) {
            dynamicPrice.setBuyPrice(price);
        } else {
            dynamicPrice.setSellPrice(price);
        }
        this.priceCache.put(key, dynamicPrice);
    }
}

