/*
 * Decompiled with CFR 0.152.
 */
package fr.tylwen.satyria.dynashop.system;

import fr.tylwen.satyria.dynashop.DynaShopPlugin;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class InflationManager {
    private final DynaShopPlugin plugin;
    private boolean enabled;
    private double baseRate;
    private double transactionMultiplier;
    private double moneyInflationThreshold;
    private double moneyInflationRate;
    private long lastInflationUpdate;
    private Map<String, Double> categoryInflationRates;
    private Map<String, Double> itemInflationRates;
    private double inflationFactor = 1.0;
    private double deflationRate;
    private BukkitTask inflationTask;
    private final DecimalFormat df = new DecimalFormat("#,##0.00");

    public InflationManager(DynaShopPlugin plugin) {
        this.plugin = plugin;
        this.categoryInflationRates = new HashMap<String, Double>();
        this.itemInflationRates = new HashMap<String, Double>();
        this.loadConfig();
    }

    public void loadConfig() {
        ConfigurationSection inflationConfig = this.plugin.getConfig().getConfigurationSection("inflation");
        if (inflationConfig == null) {
            this.plugin.getLogger().info("No inflation configuration found. Creating default config.");
            this.plugin.getConfig().set("inflation.enabled", (Object)false);
            this.plugin.getConfig().set("inflation.base-rate", (Object)0.5);
            this.plugin.getConfig().set("inflation.transaction-multiplier", (Object)0.001);
            this.plugin.getConfig().set("inflation.money-threshold", (Object)1000000);
            this.plugin.getConfig().set("inflation.money-rate", (Object)0.1);
            this.plugin.getConfig().set("inflation.deflation-rate", (Object)0.05);
            this.plugin.getConfig().set("inflation.update-interval", (Object)24);
            this.plugin.getConfig().set("inflation.max-factor", (Object)5.0);
            this.plugin.saveConfig();
            this.enabled = false;
            this.baseRate = 0.5;
            this.transactionMultiplier = 0.001;
            this.moneyInflationThreshold = 1000000.0;
            this.moneyInflationRate = 0.1;
            this.deflationRate = 0.05;
        } else {
            double rate;
            this.enabled = inflationConfig.getBoolean("enabled", false);
            this.baseRate = inflationConfig.getDouble("base-rate", 0.5);
            this.transactionMultiplier = inflationConfig.getDouble("transaction-multiplier", 0.001);
            this.moneyInflationThreshold = inflationConfig.getDouble("money-threshold", 1000000.0);
            this.moneyInflationRate = inflationConfig.getDouble("money-rate", 0.1);
            this.deflationRate = inflationConfig.getDouble("deflation-rate", 0.05);
            if (inflationConfig.isConfigurationSection("categories")) {
                ConfigurationSection categoriesSection = inflationConfig.getConfigurationSection("categories");
                for (String category : categoriesSection.getKeys(false)) {
                    rate = categoriesSection.getDouble(category, this.baseRate);
                    this.categoryInflationRates.put(category, rate);
                }
            }
            if (inflationConfig.isConfigurationSection("items")) {
                ConfigurationSection itemsSection = inflationConfig.getConfigurationSection("items");
                for (String item : itemsSection.getKeys(false)) {
                    rate = itemsSection.getDouble(item, this.baseRate);
                    this.itemInflationRates.put(item, rate);
                }
            }
            this.inflationFactor = this.plugin.getStorageManager().getInflationFactor();
            if (this.inflationFactor <= 0.0) {
                this.inflationFactor = 1.0;
            }
            this.lastInflationUpdate = this.plugin.getStorageManager().getLastInflationUpdate();
            if (this.lastInflationUpdate <= 0L) {
                this.lastInflationUpdate = System.currentTimeMillis();
                this.plugin.getStorageManager().saveInflationData(this.inflationFactor, this.lastInflationUpdate);
            }
        }
        if (this.enabled) {
            this.startInflationTask();
        } else {
            this.stopInflationTask();
        }
    }

    public void startInflationTask() {
        if (this.inflationTask != null) {
            this.stopInflationTask();
        }
        int updateIntervalHours = this.plugin.getConfig().getInt("inflation.update-interval", 24);
        long ticks = (long)(updateIntervalHours * 60 * 60) * 20L;
        this.inflationTask = this.plugin.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)this.plugin, this::updateInflation, ticks, ticks);
        this.plugin.getLogger().info("Inflation system started with update interval of " + updateIntervalHours + " hours");
    }

    public void stopInflationTask() {
        if (this.inflationTask != null) {
            this.inflationTask.cancel();
            this.inflationTask = null;
        }
    }

    public void updateInflation() {
        if (!this.enabled) {
            return;
        }
        long now = System.currentTimeMillis();
        long elapsedTime = now - this.lastInflationUpdate;
        double elapsedDays = (double)elapsedTime / 8.64E7;
        double timeInflation = 1.0 + this.baseRate / 100.0 * elapsedDays;
        double deflation = 1.0 - this.deflationRate / 100.0 * elapsedDays;
        int transactionCount = 0;
        try {
            Map<String, Object> stats = this.plugin.getTransactionLimiter().getStatistics().get();
            if (stats.containsKey("total_records")) {
                Object value = stats.get("total_records");
                if (value instanceof Integer) {
                    Integer intValue = (Integer)value;
                    transactionCount = intValue;
                } else if (value instanceof Number) {
                    Number numberValue = (Number)value;
                    transactionCount = numberValue.intValue();
                } else if (value != null) {
                    transactionCount = Integer.parseInt(value.toString());
                }
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.WARNING, "Erreur lors de la r\u00e9cup\u00e9ration des statistiques de transactions", e);
        }
        double transactionInflation = 1.0 + (double)transactionCount * this.transactionMultiplier / 100.0;
        double totalMoney = this.getTotalMoneyInEconomy();
        double moneyInflation = 1.0;
        if (totalMoney > this.moneyInflationThreshold) {
            double excessMoney = totalMoney - this.moneyInflationThreshold;
            double excessFactor = excessMoney / this.moneyInflationThreshold;
            moneyInflation = 1.0 + excessFactor * this.moneyInflationRate / 100.0;
        }
        double newInflationFactor = this.inflationFactor * timeInflation * transactionInflation * moneyInflation * deflation;
        double maxFactor = this.plugin.getConfig().getDouble("inflation.max-factor", 5.0);
        newInflationFactor = Math.min(newInflationFactor, maxFactor);
        this.inflationFactor = newInflationFactor = Math.max(newInflationFactor, 0.5);
        this.lastInflationUpdate = now;
        this.plugin.getStorageManager().saveInflationData(this.inflationFactor, this.lastInflationUpdate);
        this.plugin.getLogger().info("Inflation updated: Factor=" + this.df.format(this.inflationFactor) + " (Time=" + this.df.format(timeInflation) + ", Transactions=" + this.df.format(transactionInflation) + ", Money=" + this.df.format(moneyInflation) + ", Deflation=" + this.df.format(deflation) + ")");
    }

    private double getTotalMoneyInEconomy() {
        if (this.plugin.getServer().getPluginManager().getPlugin("Vault") == null) {
            return 0.0;
        }
        try {
            Economy economy = this.plugin.getTaxService().getEconomy();
            double total = 0.0;
            for (OfflinePlayer player : Bukkit.getOfflinePlayers()) {
                if (player == null || !player.hasPlayedBefore()) continue;
                total += economy.getBalance(player);
            }
            return total;
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Erreur lors du calcul de la masse mon\u00e9taire: " + e.getMessage());
            return 0.0;
        }
    }

    public double applyInflationToPrice(String shopId, String itemId, double basePrice) {
        if (!this.enabled || this.inflationFactor <= 0.0) {
            return basePrice;
        }
        String itemKey = shopId + ":" + itemId;
        if (this.itemInflationRates.containsKey(itemKey)) {
            double itemRate = this.itemInflationRates.get(itemKey);
            return basePrice * (this.inflationFactor * itemRate / this.baseRate);
        }
        String category = this.plugin.getShopConfigManager().getItemCategory(shopId, itemId);
        if (category != null && this.categoryInflationRates.containsKey(category)) {
            double categoryRate = this.categoryInflationRates.get(category);
            return basePrice * (this.inflationFactor * categoryRate / this.baseRate);
        }
        return basePrice * this.inflationFactor;
    }

    public double getInflationFactor() {
        return this.inflationFactor;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        if (enabled && this.inflationTask == null) {
            this.startInflationTask();
        } else if (!enabled && this.inflationTask != null) {
            this.stopInflationTask();
        }
        this.plugin.getConfig().set("inflation.enabled", (Object)enabled);
        this.plugin.saveConfig();
    }

    public void resetInflation() {
        this.inflationFactor = 1.0;
        this.lastInflationUpdate = System.currentTimeMillis();
        this.plugin.getStorageManager().saveInflationData(this.inflationFactor, this.lastInflationUpdate);
    }
}

