/*
 * Decompiled with CFR 0.152.
 */
package fr.tylwen.satyria.dynashop.system;

import fr.tylwen.satyria.dynashop.DynaShopPlugin;
import java.util.UUID;
import java.util.logging.Level;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.plugin.RegisteredServiceProvider;

public class TaxService {
    private final DynaShopPlugin plugin;
    private Economy economy;
    private boolean enabled;
    private String taxReceiverName;
    private UUID taxReceiverUUID;
    private double buyTaxRate;
    private double sellTaxRate;
    private boolean logTransactions;
    private String taxMode;

    public TaxService(DynaShopPlugin plugin) {
        this.plugin = plugin;
        this.setupEconomy();
        this.loadConfig();
    }

    private boolean setupEconomy() {
        if (Bukkit.getPluginManager().getPlugin("Vault") == null) {
            this.plugin.getLogger().warning("Vault not found - Tax system will be disabled");
            return false;
        }
        RegisteredServiceProvider rsp = Bukkit.getServicesManager().getRegistration(Economy.class);
        if (rsp == null) {
            this.plugin.getLogger().warning("Economy provider not found - Tax system will be disabled");
            return false;
        }
        this.economy = (Economy)rsp.getProvider();
        return this.economy != null;
    }

    public void loadConfig() {
        ConfigurationSection taxConfig = this.plugin.getConfig().getConfigurationSection("tax");
        if (taxConfig == null) {
            this.plugin.getLogger().info("No tax configuration found. Creating default config.");
            this.plugin.getConfig().set("tax.enabled", (Object)false);
            this.plugin.getConfig().set("tax.mode", (Object)"system");
            this.plugin.getConfig().set("tax.receiver", (Object)"admin");
            this.plugin.getConfig().set("tax.buy-rate", (Object)5.0);
            this.plugin.getConfig().set("tax.sell-rate", (Object)3.0);
            this.plugin.getConfig().set("tax.log-transactions", (Object)true);
            this.plugin.saveConfig();
            this.enabled = false;
            this.taxMode = "system";
            this.taxReceiverName = "admin";
            this.buyTaxRate = 5.0;
            this.sellTaxRate = 3.0;
            this.logTransactions = true;
        } else {
            this.enabled = taxConfig.getBoolean("enabled", false);
            this.taxMode = taxConfig.getString("mode", "system").toLowerCase();
            this.taxReceiverName = taxConfig.getString("receiver", "admin");
            this.buyTaxRate = taxConfig.getDouble("buy-rate", 5.0);
            this.sellTaxRate = taxConfig.getDouble("sell-rate", 3.0);
            this.logTransactions = taxConfig.getBoolean("log-transactions", true);
            if (this.enabled) {
                this.resolveTaxReceiverUUID();
            }
        }
    }

    private void resolveTaxReceiverUUID() {
        OfflinePlayer offlinePlayer;
        String uuidString = this.plugin.getConfig().getString("tax.receiver-uuid");
        if (uuidString != null && !uuidString.isEmpty()) {
            try {
                this.taxReceiverUUID = UUID.fromString(uuidString);
                return;
            }
            catch (IllegalArgumentException e) {
                this.plugin.getLogger().warning("Invalid UUID format in config for tax receiver");
            }
        }
        if ((offlinePlayer = Bukkit.getOfflinePlayer((String)this.taxReceiverName)).hasPlayedBefore()) {
            this.taxReceiverUUID = offlinePlayer.getUniqueId();
            this.plugin.getConfig().set("tax.receiver-uuid", (Object)this.taxReceiverUUID.toString());
            this.plugin.saveConfig();
        } else {
            this.taxMode = "system";
        }
    }

    public double applyBuyTax(Player player, double totalPrice, String shopId, String itemId) {
        if (!this.enabled || this.economy == null) {
            return 0.0;
        }
        double taxAmount = this.calculateTaxAmount(totalPrice, this.buyTaxRate);
        if (taxAmount <= 0.0) {
            return 0.0;
        }
        this.processTaxPayment(player, taxAmount, true, shopId, itemId);
        return taxAmount;
    }

    public double applySellTax(Player player, double totalPrice, String shopId, String itemId) {
        if (!this.enabled || this.economy == null) {
            return 0.0;
        }
        double taxAmount = this.calculateTaxAmount(totalPrice, this.sellTaxRate);
        if (taxAmount <= 0.0) {
            return 0.0;
        }
        this.processTaxPayment(player, taxAmount, false, shopId, itemId);
        return taxAmount;
    }

    private double calculateTaxAmount(double price, double rate) {
        return Math.max(0.0, price * (rate / 100.0));
    }

    private void processTaxPayment(Player player, double taxAmount, boolean isBuy, String shopId, String itemId) {
        if ((taxAmount = (double)Math.round(taxAmount * 100.0) / 100.0) < 0.01) {
            return;
        }
        switch (this.taxMode) {
            case "player": {
                if (this.taxReceiverUUID == null) break;
                OfflinePlayer receiver = Bukkit.getOfflinePlayer((UUID)this.taxReceiverUUID);
                this.economy.depositPlayer(receiver, taxAmount);
                break;
            }
            case "system": {
                this.economy.depositPlayer(this.taxReceiverName, taxAmount);
                break;
            }
        }
        if (this.logTransactions) {
            String transactionType = isBuy ? "buy" : "sell";
            Object destination = "";
            switch (this.taxMode) {
                case "player": {
                    destination = "player " + this.taxReceiverName;
                    break;
                }
                case "system": {
                    destination = "system account " + this.taxReceiverName;
                    break;
                }
                case "remove": {
                    destination = "removed from the economy";
                }
            }
            this.plugin.getLogger().log(Level.INFO, String.format("[TAX] %s paid %.2f tax on %s of %s:%s. Amount %s.", player.getName(), taxAmount, transactionType, shopId, itemId, this.taxMode.equals("remove") ? "removed from the economy" : "paid to " + (String)destination));
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public double getBuyTaxRate() {
        return this.buyTaxRate;
    }

    public double getSellTaxRate() {
        return this.sellTaxRate;
    }

    public String getTaxReceiverName() {
        return this.taxReceiverName;
    }

    public String getTaxMode() {
        return this.taxMode;
    }

    public Economy getEconomy() {
        return this.economy;
    }
}

