/*
 * Decompiled with CFR 0.152.
 */
package fr.tylwen.satyria.dynashop.system.chart;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.configuration.serialization.ConfigurationSerializable;

public class PriceHistory
implements ConfigurationSerializable {
    private final String shopId;
    private final String itemId;
    private final List<PriceDataPoint> dataPoints;
    private final int maxDataPoints;

    public PriceHistory(String shopId, String itemId) {
        this(shopId, itemId, 1000000);
    }

    public int getMaxDataPoints() {
        return this.maxDataPoints;
    }

    public PriceHistory(String shopId, String itemId, int maxDataPoints) {
        this.shopId = shopId;
        this.itemId = itemId;
        this.dataPoints = new ArrayList<PriceDataPoint>();
        this.maxDataPoints = maxDataPoints;
    }

    public void addDataPoint(PriceDataPoint dataPoint) {
        this.dataPoints.add(dataPoint);
        if (this.dataPoints.size() > this.maxDataPoints) {
            this.dataPoints.remove(0);
        }
    }

    public void setDataPoints(List<PriceDataPoint> newDataPoints) {
        this.dataPoints.clear();
        if (newDataPoints != null) {
            this.dataPoints.addAll(newDataPoints);
        }
    }

    public void updateDataPoint(int index, PriceDataPoint dataPoint) {
        if (index < 0 || index >= this.dataPoints.size()) {
            throw new IndexOutOfBoundsException("Index out of bounds for data points list.");
        }
        this.dataPoints.set(index, dataPoint);
    }

    public List<PriceDataPoint> getDataPoints() {
        return new ArrayList<PriceDataPoint>(this.dataPoints);
    }

    public PriceDataPoint getLastPoint() {
        if (this.dataPoints.isEmpty()) {
            throw new IllegalStateException("No data points available in the price history.");
        }
        return this.dataPoints.get(this.dataPoints.size() - 1);
    }

    public String getShopId() {
        return this.shopId;
    }

    public String getItemId() {
        return this.itemId;
    }

    public String getKey() {
        return this.shopId + ":" + this.itemId;
    }

    public Map<String, Object> serialize() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("shopId", this.shopId);
        result.put("itemId", this.itemId);
        result.put("dataPoints", this.dataPoints);
        return result;
    }

    public static PriceHistory deserialize(Map<String, Object> map) {
        String shopId = (String)map.get("shopId");
        String itemId = (String)map.get("itemId");
        PriceHistory history = new PriceHistory(shopId, itemId);
        List dataPoints = (List)map.get("dataPoints");
        if (dataPoints != null) {
            history.dataPoints.addAll(dataPoints);
        }
        return history;
    }

    public static class PriceDataPoint
    implements ConfigurationSerializable {
        private final LocalDateTime timestamp;
        private final double openBuyPrice;
        private final double closeBuyPrice;
        private final double highBuyPrice;
        private final double lowBuyPrice;
        private final double openSellPrice;
        private final double closeSellPrice;
        private final double highSellPrice;
        private final double lowSellPrice;
        private final double volume;

        public PriceDataPoint(LocalDateTime timestamp, double openBuy, double closeBuy, double highBuy, double lowBuy, double openSell, double closeSell, double highSell, double lowSell, double volume) {
            this.timestamp = timestamp;
            this.openBuyPrice = openBuy;
            this.closeBuyPrice = closeBuy;
            this.highBuyPrice = highBuy;
            this.lowBuyPrice = lowBuy;
            this.openSellPrice = openSell;
            this.closeSellPrice = closeSell;
            this.highSellPrice = highSell;
            this.lowSellPrice = lowSell;
            this.volume = volume;
        }

        public LocalDateTime getTimestamp() {
            return this.timestamp;
        }

        public double getOpenBuyPrice() {
            return this.openBuyPrice;
        }

        public double getCloseBuyPrice() {
            return this.closeBuyPrice;
        }

        public double getHighBuyPrice() {
            return this.highBuyPrice;
        }

        public double getLowBuyPrice() {
            return this.lowBuyPrice;
        }

        public double getOpenSellPrice() {
            return this.openSellPrice;
        }

        public double getCloseSellPrice() {
            return this.closeSellPrice;
        }

        public double getHighSellPrice() {
            return this.highSellPrice;
        }

        public double getLowSellPrice() {
            return this.lowSellPrice;
        }

        public double getOpenPrice() {
            return this.openBuyPrice > 0.0 ? this.openBuyPrice : this.openSellPrice;
        }

        public double getClosePrice() {
            return this.closeBuyPrice > 0.0 ? this.closeBuyPrice : this.closeSellPrice;
        }

        public double getHighPrice() {
            return this.highBuyPrice > 0.0 ? this.highBuyPrice : this.highSellPrice;
        }

        public double getLowPrice() {
            return this.lowBuyPrice > 0.0 ? this.lowBuyPrice : this.lowSellPrice;
        }

        public double getVolume() {
            return this.volume;
        }

        public Map<String, Object> serialize() {
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("timestamp", this.timestamp.toString());
            result.put("openBuyPrice", this.openBuyPrice);
            result.put("closeBuyPrice", this.closeBuyPrice);
            result.put("highBuyPrice", this.highBuyPrice);
            result.put("lowBuyPrice", this.lowBuyPrice);
            result.put("openSellPrice", this.openSellPrice);
            result.put("closeSellPrice", this.closeSellPrice);
            result.put("highSellPrice", this.highSellPrice);
            result.put("lowSellPrice", this.lowSellPrice);
            result.put("volume", this.volume);
            return result;
        }

        public static PriceDataPoint deserialize(Map<String, Object> map) {
            return new PriceDataPoint(LocalDateTime.parse((String)map.get("timestamp")), map.containsKey("openBuyPrice") ? ((Double)map.get("openBuyPrice")).doubleValue() : ((Double)map.get("openPrice")).doubleValue(), map.containsKey("closeBuyPrice") ? ((Double)map.get("closeBuyPrice")).doubleValue() : ((Double)map.get("closePrice")).doubleValue(), map.containsKey("highBuyPrice") ? ((Double)map.get("highBuyPrice")).doubleValue() : ((Double)map.get("highPrice")).doubleValue(), map.containsKey("lowBuyPrice") ? ((Double)map.get("lowBuyPrice")).doubleValue() : ((Double)map.get("lowPrice")).doubleValue(), map.containsKey("openSellPrice") ? (Double)map.get("openSellPrice") : 0.0, map.containsKey("closeSellPrice") ? (Double)map.get("closeSellPrice") : 0.0, map.containsKey("highSellPrice") ? (Double)map.get("highSellPrice") : 0.0, map.containsKey("lowSellPrice") ? (Double)map.get("lowSellPrice") : 0.0, map.containsKey("volume") ? (Double)map.get("volume") : 0.0);
        }
    }
}

