/*
 * Decompiled with CFR 0.152.
 */
package fr.tylwen.satyria.dynashop.task;

import fr.tylwen.satyria.dynashop.DynaShopPlugin;
import fr.tylwen.satyria.dynashop.data.param.DynaShopType;
import fr.tylwen.satyria.dynashop.price.DynamicPrice;
import java.lang.invoke.CallSite;
import java.util.HashMap;
import java.util.Map;
import net.brcdev.shopgui.ShopGuiPlusApi;
import net.brcdev.shopgui.exception.shop.ShopsNotLoadedException;
import net.brcdev.shopgui.shop.item.ShopItem;

public class DynamicPricesTask
implements Runnable {
    private final DynaShopPlugin plugin;

    public DynamicPricesTask(DynaShopPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public void run() {
        try {
            if (ShopGuiPlusApi.getPlugin() == null || ShopGuiPlusApi.getPlugin().getShopManager() == null) {
                this.plugin.getLogger().warning("ShopGUIPlus n'est pas encore compl\u00e8tement initialis\u00e9. La t\u00e2che DynamicPricesTask sera ex\u00e9cut\u00e9e la prochaine fois.");
                return;
            }
            try {
                if (ShopGuiPlusApi.getPlugin().getShopManager().getShops().isEmpty()) {
                    this.plugin.getLogger().warning("Les shops de ShopGUIPlus ne sont pas encore charg\u00e9s. La t\u00e2che DynamicPricesTask sera ex\u00e9cut\u00e9e la prochaine fois.");
                    return;
                }
            }
            catch (ShopsNotLoadedException e) {
                this.plugin.getLogger().warning("Les shops de ShopGUIPlus ne sont pas encore charg\u00e9s (exception). La t\u00e2che DynamicPricesTask sera ex\u00e9cut\u00e9e la prochaine fois.");
                return;
            }
            this.plugin.getStorageManager().executeAsync(() -> {
                Map<ShopItem, DynamicPrice> priceMap = this.plugin.getStorageManager().loadAllPrices();
                if (priceMap == null || priceMap.isEmpty()) {
                    return null;
                }
                HashMap<CallSite, DynamicPrice> pricesToUpdate = new HashMap<CallSite, DynamicPrice>();
                for (Map.Entry<ShopItem, DynamicPrice> entry : priceMap.entrySet()) {
                    ShopItem item = entry.getKey();
                    DynamicPrice price = entry.getValue();
                    String shopID = item.getShop().getId();
                    String itemID = item.getId();
                    int stock = entry.getValue().getStock();
                    if (stock > 0) continue;
                    boolean needsUpdate = false;
                    double oldBuyPrice = price.getBuyPrice();
                    double oldSellPrice = price.getSellPrice();
                    if (this.plugin.getShopConfigManager().hasSection(shopID, itemID, "buyDynamic") && this.plugin.getShopConfigManager().getTypeDynaShop(shopID, itemID) == DynaShopType.DYNAMIC && oldBuyPrice > 0.0) {
                        double minBuy = this.plugin.getShopConfigManager().getItemValue(shopID, itemID, "buyDynamic.min", Double.class).orElse(0.0);
                        double maxBuy = this.plugin.getShopConfigManager().getItemValue(shopID, itemID, "buyDynamic.max", Double.class).orElse((Double)Double.MAX_VALUE);
                        price.applyBuyPriceChanges();
                        double newBuyPrice = price.getBuyPrice();
                        if (newBuyPrice < minBuy) {
                            price.setBuyPrice(minBuy);
                        } else if (newBuyPrice > maxBuy) {
                            price.setBuyPrice(maxBuy);
                        }
                        if (Math.abs(oldBuyPrice - price.getBuyPrice()) > 0.001) {
                            needsUpdate = true;
                        }
                    }
                    if (this.plugin.getShopConfigManager().hasSection(shopID, itemID, "sellDynamic") && this.plugin.getShopConfigManager().getTypeDynaShop(shopID, itemID) == DynaShopType.DYNAMIC && oldSellPrice > 0.0) {
                        double minSell = this.plugin.getShopConfigManager().getItemValue(shopID, itemID, "sellDynamic.min", Double.class).orElse(0.0);
                        double maxSell = this.plugin.getShopConfigManager().getItemValue(shopID, itemID, "sellDynamic.max", Double.class).orElse((Double)Double.MAX_VALUE);
                        price.applySellPriceChanges();
                        double newSellPrice = price.getSellPrice();
                        if (newSellPrice < minSell) {
                            price.setSellPrice(minSell);
                        } else if (newSellPrice > maxSell) {
                            price.setSellPrice(maxSell);
                        }
                        if (Math.abs(oldSellPrice - price.getSellPrice()) > 0.001) {
                            needsUpdate = true;
                        }
                    }
                    if (!needsUpdate) continue;
                    pricesToUpdate.put((CallSite)((Object)(shopID + ":" + itemID)), price);
                }
                for (Map.Entry<Object, DynamicPrice> entry : pricesToUpdate.entrySet()) {
                    String[] parts = ((String)entry.getKey()).split(":");
                    String shopID = parts[0];
                    String itemID = parts[1];
                    DynamicPrice price = entry.getValue();
                    this.plugin.getBatchDatabaseUpdater().queueUpdate(shopID, itemID, price, false);
                }
                return null;
            });
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("ERREUR CRITIQUE dans DynamicPricesTask: " + e.getMessage());
            e.printStackTrace();
        }
    }
}

