/*
 * Decompiled with CFR 0.152.
 */
package fr.tylwen.satyria.dynashop.task;

import fr.tylwen.satyria.dynashop.DynaShopPlugin;
import fr.tylwen.satyria.dynashop.config.DataConfig;
import fr.tylwen.satyria.dynashop.price.DynamicPrice;
import fr.tylwen.satyria.dynashop.system.chart.PriceHistory;
import fr.tylwen.satyria.dynashop.task.DynamicPricesTask;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.HashSet;
import net.brcdev.shopgui.ShopGuiPlusApi;
import net.brcdev.shopgui.exception.shop.ShopsNotLoadedException;
import net.brcdev.shopgui.shop.Shop;
import net.brcdev.shopgui.shop.ShopManager;
import net.brcdev.shopgui.shop.item.ShopItem;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class WaitForShopsTask
implements Runnable {
    private final DynaShopPlugin plugin;
    private boolean isTasksInitialized = false;
    private final DataConfig dataConfig;
    private BukkitTask selfTask;

    public WaitForShopsTask(DynaShopPlugin plugin) {
        this.plugin = plugin;
        this.dataConfig = plugin.getDataConfig();
    }

    public void setSelfTask(BukkitTask task) {
        this.selfTask = task;
    }

    @Override
    public void run() {
        try {
            if (ShopGuiPlusApi.getPlugin() == null) {
                this.plugin.getLogger().severe("ShopGUIPlus is not initialized. Try again in 5 seconds...");
                return;
            }
            ShopManager manager = ShopGuiPlusApi.getPlugin().getShopManager();
            if (manager.getShops().isEmpty()) {
                this.plugin.getLogger().info("Shops are not loaded yet. Try again in 5 seconds...");
                return;
            }
            if (!this.isTasksInitialized) {
                this.plugin.getShopConfigManager().initPricesFromShopConfigs();
                this.plugin.getStorageManager().cleanupStockTable();
                this.startDependentTasks();
                this.isTasksInitialized = true;
                this.plugin.getLogger().info("Shops loaded successfully! All dependent tasks have been started.");
                if (this.selfTask != null) {
                    this.selfTask.cancel();
                } else {
                    this.plugin.getLogger().warning("Could not cancel WaitForShopsTask: reference is null");
                }
            }
        }
        catch (ShopsNotLoadedException e) {
            this.plugin.getLogger().info("Shops are not loaded yet. Try again in 5 seconds...");
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Error checking shop status: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private void startDependentTasks() {
        int INTERVAL_MINUTES = this.plugin.getConfigMain().getInt("history.save-interval", 15);
        this.plugin.getLogger().info("Starting DynamicPricesTask...");
        this.plugin.setDynamicPricesTaskId(this.plugin.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)this.plugin, (Runnable)new DynamicPricesTask(this.plugin), 200L, 1200L * (long)this.dataConfig.getDynamicPriceDuration()).getTaskId());
        this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, this.plugin::setupMetrics);
        this.plugin.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)this.plugin, () -> {
            try {
                for (Shop shop : ShopGuiPlusApi.getPlugin().getShopManager().getShops()) {
                    for (ShopItem item : shop.getShopItems()) {
                        try {
                            DynamicPrice price = this.plugin.getDynaShopListener().getOrLoadPrice(null, shop.getId(), item.getId(), item.getItem(), new HashSet<String>(), new HashMap<String, DynamicPrice>());
                            if (price == null) continue;
                            PriceHistory history = this.plugin.getStorageManager().getPriceHistory(shop.getId(), item.getId());
                            LocalDateTime now = LocalDateTime.now();
                            if (!history.getDataPoints().isEmpty() && !history.getDataPoints().get(history.getDataPoints().size() - 1).getTimestamp().plusMinutes(INTERVAL_MINUTES).isBefore(now)) continue;
                            PriceHistory.PriceDataPoint dataPoint = new PriceHistory.PriceDataPoint(now, price.getBuyPrice(), price.getBuyPrice(), price.getBuyPrice(), price.getBuyPrice(), price.getSellPrice(), price.getSellPrice(), price.getSellPrice(), price.getSellPrice(), 0.0);
                            history.addDataPoint(dataPoint);
                            this.plugin.getStorageManager().savePriceDataPoint(shop.getId(), item.getId(), dataPoint, INTERVAL_MINUTES);
                        }
                        catch (Exception e) {
                            this.plugin.getLogger().warning("Erreur lors de l'enregistrement de l'historique pour " + shop.getId() + ":" + item.getId() + ": " + e.getMessage());
                        }
                    }
                }
            }
            catch (ShopsNotLoadedException e) {
                e.printStackTrace();
            }
        }, 6000L, 18000L);
    }
}

